// VirtualRoadAdjust.cpp : implementation file
//

#include "stdafx.h"
#include "T3ED.h"
#include "VirtualRoadAdjust.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVirtualRoadAdjust dialog


CVirtualRoadAdjust::CVirtualRoadAdjust(CWnd* pParent /*=NULL*/)
	: CDialog(CVirtualRoadAdjust::IDD, pParent)
{
	

	//{{AFX_DATA_INIT(CVirtualRoadAdjust)
	m_StartBlock = 0;
	m_EndBlock = 0;
	m_AdjustType = -1;
	m_DisableStartEnd = false;
	m_int_Size_VR_L = 0;
	m_int_Size_VR_R = 0;
	m_bHSMode=FALSE;
	m_nlanes_left = 0;
	m_nlanes_right = 0;
	m_Check_Detect_lanes = FALSE;
	m_Check_Auto_Set_Lane_Bitcoded = FALSE;
	m_Check_Auto_Set_Lane_Polys = FALSE;
	m_Check_Change_VR_Width = FALSE;
	m_Check_Auto_Set_Lane_Width = FALSE;
	m_Check_Man_Set_Num_Lanes = FALSE;
	//}}AFX_DATA_INIT
}


void CVirtualRoadAdjust::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CDialog::OnFinalRelease();
}

void CVirtualRoadAdjust::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVirtualRoadAdjust)
	DDX_Text(pDX, IDC_EDIT1, m_StartBlock);
	DDV_MinMaxInt(pDX, m_StartBlock, 0, 300);
	DDX_Text(pDX, IDC_EDIT2, m_EndBlock);
	DDV_MinMaxInt(pDX, m_EndBlock, 0, 300);
	DDX_Radio(pDX, IDC_RADIO1, m_AdjustType);
	DDX_Text(pDX, IDC_EDIT_SIZE_VRL, m_int_Size_VR_L);
	DDX_Text(pDX, IDC_EDIT_SIZE_VRR, m_int_Size_VR_R);
	DDX_Text(pDX, IDC_EDIT_NUM_LANE_L, m_nlanes_left);
	DDX_Text(pDX, IDC_EDIT_NUM_LANE_R, m_nlanes_right);
	DDX_Check(pDX, IDC_CHECK_DETECT_LANES, m_Check_Detect_lanes);
	DDX_Check(pDX, IDC_CHECK_AUTO_SET_LANE_BITMAP, m_Check_Auto_Set_Lane_Bitcoded);
	DDX_Check(pDX, IDC_CHECK_AUTO_SET_LANE_POLYS, m_Check_Auto_Set_Lane_Polys);
	DDX_Check(pDX, IDC_CHECK_VR_WIDTH, m_Check_Change_VR_Width);
	DDX_Check(pDX, IDC_CHECK_AUTO_SET_LANE_WIDTH, m_Check_Auto_Set_Lane_Width);
	DDX_Check(pDX, IDC_CHECK_MAN_SET_NUM_LANES, m_Check_Man_Set_Num_Lanes);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CVirtualRoadAdjust, CDialog)
	//{{AFX_MSG_MAP(CVirtualRoadAdjust)
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	ON_BN_CLICKED(IDC_CHECK_LANE, OnCheckLane)
	ON_BN_CLICKED(IDC_CHECK_DETECT_LANES, OnCheckDetectLanes)
	ON_BN_CLICKED(IDC_CHECK_VR_WIDTH, OnCheckVrWidth)
	ON_BN_CLICKED(IDC_CHECK_AUTO_SET_LANE_POLYS, OnCheckAutoSetLanePolys)
	ON_BN_CLICKED(IDC_CHECK_MAN_SET_NUM_LANES, OnCheckManSetNumLanes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVirtualRoadAdjust message handlers

void CVirtualRoadAdjust::OnSetfocusEditSize() 
{
	UpdateData(true); //Get other changes
	m_AdjustType=3; //Set to Radio 3 
	UpdateData(false); 	//Show Radio3 selected
}

void CVirtualRoadAdjust::OnChangeEditSize() 
{
	// TODO: Wenn dies ein RICHEDIT-Steuerelement ist, sendet das Steuerelement diese

	// Benachrichtigung nicht, bevor Sie nicht die Funktion CDialog::OnInitDialog()

	// berschreiben und CRichEditCrtl().SetEventMask() aufrufen, wobei

	// eine ODER-Operation mit dem Attribut ENM_CHANGE und der Maske erfolgt.

	
	UpdateData(true); //Get other changes

	
}

BOOL CVirtualRoadAdjust::OnInitDialog() 
{
	CDialog::OnInitDialog();

	UpdateView();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CVirtualRoadAdjust::UpdateView()
{
	CWnd *edit1=GetDlgItem(IDC_EDIT1);
	CWnd *edit2=GetDlgItem(IDC_EDIT2);
	UpdateData(true);

	if (m_DisableStartEnd)
	{
		edit1->EnableWindow(FALSE);
		edit2->EnableWindow(FALSE);
	}

	GetDlgItem(IDC_RADIO1)->EnableWindow(m_Check_Change_VR_Width);
	GetDlgItem(IDC_RADIO2)->EnableWindow(m_Check_Change_VR_Width);
	GetDlgItem(IDC_RADIO3)->EnableWindow(m_Check_Change_VR_Width);
	GetDlgItem(IDC_RADIO4)->EnableWindow(m_Check_Change_VR_Width);

	if ((m_AdjustType==3) && m_Check_Change_VR_Width)
	{
		//GetDlgItem(IDC_CHECK_VR)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SIZE_VRL)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SIZE_VRR)->EnableWindow(TRUE);

	}
	else
	{
		//GetDlgItem(IDC_CHECK_VR)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SIZE_VRL)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SIZE_VRR)->EnableWindow(FALSE);
	}

	if (m_bHSMode)
	{
		GetDlgItem(IDC_CHECK_MAN_SET_NUM_LANES)->EnableWindow(TRUE);

		GetDlgItem(IDC_EDIT_SIZE_LANE_L)->EnableWindow(m_Check_Man_Set_Num_Lanes);
		GetDlgItem(IDC_EDIT_SIZE_LANE_R)->EnableWindow(m_Check_Man_Set_Num_Lanes);

		GetDlgItem(IDC_CHECK_AUTO_SET_LANE_BITMAP)->EnableWindow(m_Check_Detect_lanes);
		GetDlgItem(IDC_CHECK_AUTO_SET_LANE_POLYS)->EnableWindow(m_Check_Detect_lanes);
		GetDlgItem(IDC_CHECK_AUTO_SET_LANE_WIDTH)->EnableWindow(m_Check_Detect_lanes);
	}

	UpdateData(FALSE);
}

void CVirtualRoadAdjust::OnRadio1() 
{
	UpdateView();
}

void CVirtualRoadAdjust::OnRadio2() 
{
	UpdateView();
}

void CVirtualRoadAdjust::OnRadio3() 
{
	UpdateView();
}

void CVirtualRoadAdjust::OnRadio4() 
{
	UpdateView();
}

void CVirtualRoadAdjust::OnOK() 
{
	UpdateData(true);
	if (!m_Check_Change_VR_Width) //No VRoad change
	{
		m_int_Size_VR_L=-1;
		m_int_Size_VR_R=-1;
	}
	if (m_Check_Change_VR_Width&&m_AdjustType!=3)
	{
		m_int_Size_VR_L=-1;
		m_int_Size_VR_R=-1;
	}
	if (!m_Check_Man_Set_Num_Lanes) //No manually setting of nLanes
	{
		m_nlanes_left=-1;
		m_nlanes_right=-1;
	}
	if (m_Check_Man_Set_Num_Lanes && !m_Check_Change_VR_Width)  //If VRoad width should not be changed allow setting number of lanes 
	{
		m_AdjustType=3;

	}
	UpdateData(false);
	
	CDialog::OnOK();
}

void CVirtualRoadAdjust::OnCheckLane() 
{
	UpdateView();
}

//DEL void CVirtualRoadAdjust::OnCheckVr() 
//DEL {
//DEL 	UpdateView();	
//DEL }

void CVirtualRoadAdjust::OnCheckDetectLanes() 
{
	UpdateData(TRUE);
	UpdateView();
}

/*void CVirtualRoadAdjust::OnCheckSetLane() 
{
	UpdateView();	
}*/

void CVirtualRoadAdjust::OnCheckVrWidth() 
{
	UpdateView();
}

void CVirtualRoadAdjust::OnCheckAutoSetLanePolys() 
{
	UpdateData(TRUE);
	if (m_Check_Auto_Set_Lane_Polys) m_Check_Man_Set_Num_Lanes=FALSE;
	UpdateData(FALSE);
	UpdateView();	
}

void CVirtualRoadAdjust::OnCheckManSetNumLanes() 
{
	UpdateData(TRUE);
	if (m_Check_Man_Set_Num_Lanes) m_Check_Auto_Set_Lane_Polys=FALSE;
	UpdateData(FALSE);
	UpdateView();
}
