// VRoadHeightsSpdFileDlg.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "T3ED.h"
#include "T3EDDoc.h"
#include <math.h> 
#include <bitset>
//#include "GridListCtrl.h"
//#include "InPlaceEdit.h"
#include "UnknownData.h"
#include "VRoadHeightsSpdFileDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CVRoadHeightsSpdFileDlg 


CVRoadHeightsSpdFileDlg::CVRoadHeightsSpdFileDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVRoadHeightsSpdFileDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVRoadHeightsSpdFileDlg)
	m_Chk_Heights = FALSE;
	m_Chk_SpdFa = FALSE;
	m_Chk_SpdRa = FALSE;
	m_Chk_VRoad = FALSE;
	m_Chk_PVR = FALSE;
	m_Label_Txt = _T("");
	m_Chk_VRoad_z = FALSE;
	m_Chk_HSExtra = FALSE;
	m_Str_Hint = _T("");
	m_Chk_AI_Lane_Recalc = FALSE;
	//}}AFX_DATA_INIT
	m_pImageList = 0;
	m_pListEdit = 0;
}


void CVRoadHeightsSpdFileDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVRoadHeightsSpdFileDlg)
	DDX_Control(pDX, IDC_LIST, m_GridListCtrl);
	DDX_Check(pDX, IDC_CHECK_HEIGHTS, m_Chk_Heights);
	DDX_Check(pDX, IDC_CHECK_SPDFA, m_Chk_SpdFa);
	DDX_Check(pDX, IDC_CHECK_SPDRA, m_Chk_SpdRa);
	DDX_Check(pDX, IDC_CHECK_VROAD, m_Chk_VRoad);
	DDX_Check(pDX, IDC_CH_PVR, m_Chk_PVR);
	DDX_Text(pDX, IDC_LABEL_TXT, m_Label_Txt);
	DDX_Check(pDX, IDC_CHECK_VRZ, m_Chk_VRoad_z);
	DDX_Check(pDX, IDC_CHECK_HSEXTRA, m_Chk_HSExtra);
	DDX_Text(pDX, IDC_HINT_TXT, m_Str_Hint);
	DDX_Check(pDX, IDC_CHECK_RECAL_AI_LANES, m_Chk_AI_Lane_Recalc);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CVRoadHeightsSpdFileDlg, CDialog)
	//{{AFX_MSG_MAP(CVRoadHeightsSpdFileDlg)
	ON_NOTIFY(LVN_BEGINLABELEDIT, IDC_LIST, OnBeginlabeleditList)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST, OnEndlabeleditList)
	ON_BN_CLICKED(IDC_CHECK_HEIGHTS, OnCheckHeights)
	ON_BN_CLICKED(IDC_CHECK_SPDFA, OnCheckSpdfa)
	ON_BN_CLICKED(IDC_CHECK_SPDRA, OnCheckSpdra)
	ON_BN_CLICKED(IDC_CHECK_VROAD, OnCheckVroad)
	ON_BN_CLICKED(IDC_BT_SWITCH, OnBtSwitchFwBw)
	ON_BN_CLICKED(IDC_BUTTON_HSEXTRA, OnButtonHsextra)
	ON_BN_CLICKED(IDC_CH_PVR, OnChPvr)
	ON_CBN_SELCHANGE(IDC_COMBO_VECTOR_CALC, OnSelchangeComboVectorCalc)
	ON_BN_CLICKED(IDC_CHECK_HSEXTRA, OnCheckHsextra)
	ON_NOTIFY(NM_CLICK, IDC_LIST, OnClickList)
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_LIST, OnColumnclickList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CVRoadHeightsSpdFileDlg 

BOOL CVRoadHeightsSpdFileDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	int i,iActualItem;
	//float fw;
	TCHAR buffer[30];
	std::string str1, str2; 
	CString sBitCStr1, sBitCStr2;  // CString erstellen

	if (!bHSMode) GetDlgItem(IDC_BUTTON_HSEXTRA)->ModifyStyle(WS_VISIBLE,WS_DISABLED); //Disable HS_Extra Button?

	VERIFY(font.CreateFont(
       16,                        // nHeight
       0,                         // nWidth
       0,                         // nEscapement
       0,                         // nOrientation
       FW_NORMAL,                 // nWeight
       FALSE,					  // bItalic
       FALSE,                     // bUnderline
       0,                         // cStrikeOut
       ANSI_CHARSET,              // nCharSet
       OUT_DEFAULT_PRECIS,        // nOutPrecision
       CLIP_DEFAULT_PRECIS,       // nClipPrecision
       DEFAULT_QUALITY,           // nQuality
       DEFAULT_PITCH | FF_SWISS,  // nPitchAndFamily
       _T("Arial"))
    );  

	m_Chk_HSExtra=m_Chk_HSExtra&&bHSMode;
	GetDlgItem(IDC_CHECK_HSEXTRA)->EnableWindow(bHSMode); //Show HS Extra Checkbox?

	
	GetDlgItem(IDC_LIST)->SetFont(&font);

	m_GridListCtrl.SetExtendedStyle(LVS_EX_GRIDLINES);
	m_GridListCtrl.PrepareControl(0);

	LV_ITEM			lvitem;
	LV_COLUMN		lvcolumn;
	CRect rect;
	m_GridListCtrl.GetWindowRect( &rect );


	// Insert columns using the order field
	lvcolumn.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH | LVCF_ORDER;
	lvcolumn.fmt = LVCFMT_LEFT;
	lvcolumn.pszText = "Nr.";
	lvcolumn.iSubItem = VRoad_sItem;
	lvcolumn.iOrder = VRoad_sItem;
	lvcolumn.cx = 40;  
	m_GridListCtrl.InsertColumn(0, &lvcolumn);  

	lvcolumn.pszText = "VRoad X";
	lvcolumn.iSubItem = VRoad_sItem+1;
	lvcolumn.iOrder = VRoad_sItem+1;
	lvcolumn.cx = 100;  
	m_GridListCtrl.InsertColumn(VRoad_sItem+1, &lvcolumn);  

	lvcolumn.pszText = "VRoad Y";
	lvcolumn.iSubItem = VRoad_sItem+2;
	lvcolumn.iOrder = VRoad_sItem+2;
	lvcolumn.cx = 100;  
	m_GridListCtrl.InsertColumn(VRoad_sItem+2, &lvcolumn);  

	lvcolumn.pszText = "VRoad Z";
	lvcolumn.iSubItem = VRoad_sItem+3;
	lvcolumn.iOrder = VRoad_sItem+3;
	lvcolumn.cx = 100;  
	m_GridListCtrl.InsertColumn(VRoad_sItem+3, &lvcolumn);  

	lvcolumn.cx = 75;  
	if (bHSMode)
		lvcolumn.pszText = "VR Left"; //VRoad Left
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	}
	lvcolumn.iSubItem = VRoad_sItem+4;
	lvcolumn.iOrder = VRoad_sItem+4;
	m_GridListCtrl.InsertColumn(VRoad_sItem+4, &lvcolumn);

	lvcolumn.cx = 75;  
	if (bHSMode)
		lvcolumn.pszText = "VR Right"; //VRoad Right
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	}
	lvcolumn.iSubItem = VRoad_sItem+5;
	lvcolumn.iOrder = VRoad_sItem+5;
	m_GridListCtrl.InsertColumn(VRoad_sItem+5, &lvcolumn);

	lvcolumn.cx = 75;  
	if (bHSMode)
		lvcolumn.pszText = "Shortcut to"; //Shortcut VRoad number, if there is none -1. Two number
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	}
	lvcolumn.iSubItem = VRoad_sItem+6;
	lvcolumn.iOrder = VRoad_sItem+6;
	m_GridListCtrl.InsertColumn(VRoad_sItem+6, &lvcolumn);

	lvcolumn.cx = 75; 
	if (bHSMode)
		lvcolumn.pszText = "L-Lane Polys"; //Lane Polys  Left
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	}
	lvcolumn.iSubItem = VRoad_sItem+7;
	lvcolumn.iOrder = VRoad_sItem+7;
	m_GridListCtrl.InsertColumn(VRoad_sItem+7, &lvcolumn);

	lvcolumn.cx = 75;  
	if (bHSMode)
		lvcolumn.pszText = "R-Lane Polys"; //Lane Polys  Right
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	}
	lvcolumn.iSubItem = VRoad_sItem+8;
	lvcolumn.iOrder = VRoad_sItem+8;
	m_GridListCtrl.InsertColumn(VRoad_sItem+8, &lvcolumn);


	lvcolumn.cx = 75; 
	if (bHSMode)
		lvcolumn.pszText = "Width L-Polys"; //Width Left Polys
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	}
	lvcolumn.iSubItem = VRoad_sItem+9;
	lvcolumn.iOrder = VRoad_sItem+9;
	m_GridListCtrl.InsertColumn(VRoad_sItem+9, &lvcolumn);

	lvcolumn.cx = 75;
	if (bHSMode)
		lvcolumn.pszText = "Width R-Polys"; //Width Right Polys
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	} 
	lvcolumn.iSubItem = VRoad_sItem+10;
	lvcolumn.iOrder = VRoad_sItem+10;
	m_GridListCtrl.InsertColumn(VRoad_sItem+10, &lvcolumn);

	// HS Extra -----------------------------
	lvcolumn.cx = 150;
	if (bHSMode)
		lvcolumn.pszText = "Passable Lanes"; //view on lanes for AI described in bits
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	} 
	lvcolumn.iSubItem = HSExtra_sItem;
	lvcolumn.iOrder = HSExtra_sItem;
	m_GridListCtrl.InsertColumn(HSExtra_sItem, &lvcolumn);

	lvcolumn.cx = 75;
	if (bHSMode)
		lvcolumn.pszText = "2 Unknown Bytes"; //2 Unknown Bytes
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	} 
	lvcolumn.iSubItem = HSExtra_sItem+1;
	lvcolumn.iOrder = HSExtra_sItem+1;
	m_GridListCtrl.InsertColumn(HSExtra_sItem+1, &lvcolumn);

	lvcolumn.cx = 75;
	if (bHSMode)
		lvcolumn.pszText = "Chrome/Weather"; //Chrome Effect Left / Right from VRoad
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	} 
	lvcolumn.iSubItem = HSExtra_sItem+2;
	lvcolumn.iOrder = HSExtra_sItem+2;
	m_GridListCtrl.InsertColumn(HSExtra_sItem+2, &lvcolumn);

		lvcolumn.cx = 75;
	if (bHSMode)
		lvcolumn.pszText = "Hall Effect"; //Hall Effect Left / Right from VRoad
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	} 
	lvcolumn.iSubItem = HSExtra_sItem+3;
	lvcolumn.iOrder = HSExtra_sItem+3;
	m_GridListCtrl.InsertColumn(HSExtra_sItem+3, &lvcolumn);
	// HS Extra -----------------------------


	lvcolumn.pszText = "Heights.sim";
	lvcolumn.iSubItem = heights_sItem;
	lvcolumn.iOrder = heights_sItem;
	lvcolumn.cx = 100;  
	m_GridListCtrl.InsertColumn(heights_sItem, &lvcolumn);

	lvcolumn.pszText = "spdFA Speed";
	lvcolumn.iSubItem = spdFA_sItem;
	lvcolumn.iOrder = spdFA_sItem;
	lvcolumn.cx = 100;  
	m_GridListCtrl.InsertColumn(spdFA_sItem, &lvcolumn);

	lvcolumn.pszText = "spdFA AI lane selection";
	lvcolumn.iSubItem = spdFA_sItem+1;
	lvcolumn.iOrder = spdFA_sItem+1;
	lvcolumn.cx = 100;  
	m_GridListCtrl.InsertColumn(spdFA_sItem+1, &lvcolumn);

	lvcolumn.cx = 100;
	if (bHSMode)
		lvcolumn.pszText = "spdFA float"; //for HS Speedfile
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	}
	lvcolumn.iSubItem = spdFA_sItem+2;
	lvcolumn.iOrder = spdFA_sItem+2;
	m_GridListCtrl.InsertColumn(spdFA_sItem+2, &lvcolumn);

	lvcolumn.pszText = "spdRA Speed";
	lvcolumn.iSubItem = spdRA_sItem;
	lvcolumn.iOrder = spdRA_sItem;
	lvcolumn.cx = 100;  
	m_GridListCtrl.InsertColumn(spdRA_sItem, &lvcolumn);

	lvcolumn.pszText = "spdRA AI lane selection";
	lvcolumn.iSubItem = spdRA_sItem+1;
	lvcolumn.iOrder = spdRA_sItem+1;
	lvcolumn.cx = 100;  
	m_GridListCtrl.InsertColumn(spdRA_sItem+1, &lvcolumn);

	lvcolumn.cx = 100; 
	if (bHSMode)
		lvcolumn.pszText = "spdRA float"; //for HS Speedfile
	else
	{
		lvcolumn.pszText = "not used"; //not available in NFS3
		lvcolumn.cx = 0;  
	}
	lvcolumn.iSubItem = spdRA_sItem+2;
	lvcolumn.iOrder = spdRA_sItem+2;
	m_GridListCtrl.InsertColumn(spdRA_sItem+2, &lvcolumn);


	lvitem.mask=LVIF_TEXT;
	for (i=0;i<m_nPositions;i++)
	{
		lvitem.mask = LVIF_TEXT; //Prepare first colum
		lvitem.iItem=i;
		lvitem.iSubItem=0;
		//sprintf(buffer, "%d.", i);
		sprintf(buffer, "%d.", VRoadNumbers[i]);
		lvitem.pszText = buffer;
		iActualItem=m_GridListCtrl.InsertItem(&lvitem); //Finally add the column

		lvitem.mask = LVIF_TEXT; //Prepare second colum, add vroad x values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+1;
		sprintf(buffer, "%f", (float)m_colvrdata[i].refPt.x/65536);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 3rd colum, add vroad y values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+2;
		sprintf(buffer, "%f", (float)m_colvrdata[i].refPt.y/65536);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 4th colum, add vroad z values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+3;
		sprintf(buffer, "%f", (float)m_colvrdata[i].refPt.z/65536);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 5th colum, add VRoad Left Edge
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+4;
		sprintf(buffer, "%d", (int) m_colvrdata[i].leftWall/10000);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 6th colum, add VRoad Right Edge
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+5;
		sprintf(buffer, "%d", (int) m_colvrdata[i].rightWall/10000);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);
		
		lvitem.mask = LVIF_TEXT; //Prepare 7th colum, add shortcut numbers
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+6;
		sprintf(buffer, "%d,%d", (int) hs_extra[i].ShortcutToVRoad[0], hs_extra[i].ShortcutToVRoad[1]);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);
		
		lvitem.mask = LVIF_TEXT; //Prepare 8th colum, add Left lane polys
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+7;
		//sprintf(buffer, "%d", (long) hs_extra[i*7 + 3]);
		sprintf(buffer, "%d", (long) hs_extra[i].nLeftLanePolys);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 9th colum, add Right lane polys
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+8;
		//sprintf(buffer, "%d", (long) hs_extra[i*7 + 4]);
		sprintf(buffer, "%d", (long) hs_extra[i].nRightLanePolys);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 10th colum, add Width Left lane polys
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+9;
		//memcpy(&fw, &hs_extra[i*7 + 0], sizeof(float));
		//sprintf(buffer, "%d", (int) fw);
		sprintf(buffer, "%f", hs_extra[i].WidthLeftLane);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 11th colum, add Width Right lane polys
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=VRoad_sItem+10;
		//memcpy(&fw, &hs_extra[i*7 + 1], sizeof(float));
		//sprintf(buffer, "%d", (int) fw);
		sprintf(buffer, "%f", hs_extra[i].WidthRightLane);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);
	// HS Extra -----------------------------
		lvitem.mask = LVIF_TEXT; //Prepare LanesRightPassable, LanesLeftPassable colum
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=HSExtra_sItem;
		str1 = std::bitset<8>(hs_extra[i].LanesLeftPassable).to_string();
		str2 = std::bitset<8>(hs_extra[i].LanesRightPassable).to_string();

		sBitCStr1 = str1.c_str(); //String in CString umwandeln
		sBitCStr2 = str2.c_str(); //String in CString umwandeln

		sprintf(buffer, "%s * %s", sBitCStr1, sBitCStr2);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare Unknowdata 2,3
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=HSExtra_sItem+1;
		sprintf(buffer, "%d,%d", (int) hs_extra[i].Unknown2[0], hs_extra[i].Unknown2[1]);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare HSExtra ChromeEffect colum
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=HSExtra_sItem+2;
		sprintf(buffer, "%d,%d", (int) hs_extra[i].ChromeEffect[0], (int) hs_extra[i].ChromeEffect[1]);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare HSExtra HallEffect colum
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=HSExtra_sItem+3;
		sprintf(buffer, "%d,%d", (int) hs_extra[i].HallEffect[0], (int) hs_extra[i].HallEffect[1]);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);
	// HS Extra -----------------------------

		lvitem.mask = LVIF_TEXT; //Prepare 12th colum, add heights.sim values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=heights_sItem;
		sprintf(buffer, "%f", (float)m_heightsdata[i].heights);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 13th colum, add spdFA.bin speed values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=spdFA_sItem;
		sprintf(buffer, "%d", (int)spdFAdata[i].Speedvalue);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 14th colum, add spdFA.bin Lane selection values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=spdFA_sItem+1;
		sprintf(buffer, "%d", (int)spdFAdata[i].AI_Lane);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 15th colum, add spdFA.bin float values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=spdFA_sItem+2;
		sprintf(buffer, "%f", (float)spdFAdata[i].AI_Float);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 16th colum, add spdRA.bin speed values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=spdRA_sItem;
		sprintf(buffer, "%d", (int)spdRAdata[i].Speedvalue);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 17th colum, add spdRA.bin Lane selection values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=spdRA_sItem+1;
		sprintf(buffer, "%d", (int)spdRAdata[i].AI_Lane);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //Prepare 18th colum, add spdRA.bin float values
		lvitem.iItem=iActualItem;
		lvitem.iSubItem=spdRA_sItem+2;
		sprintf(buffer, "%f", (float)spdRAdata[i].AI_Float);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

	}
	((CComboBox*)GetDlgItem(IDC_COMBO_VECTOR_CALC))->SetCurSel(m_Combo_Vector_Calc);  //Set current Vector Calc Selection
	
	OnCheckVroad();
	OnCheckHsextra();
	OnCheckHeights();
	OnCheckSpdfa();
	OnCheckSpdra();
	if (!bHSMode) 
		HideFloat();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CVRoadHeightsSpdFileDlg::OnBeginlabeleditList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	CString str = pDispInfo->item.pszText;
	int item = pDispInfo->item.iItem;
	int subitem = pDispInfo->item.iSubItem;

	// Construct and create the custom multiline edit control.
	// We could just as well have used a combobox, checkbox, 
	// rich text control, etc.
	m_pListEdit = new CInPlaceEdit( item, subitem, str );
	// Start with a small rectangle.  We'll change it later.
	CRect  rect( 0,0,1,1 );
	DWORD dwStyle = ES_LEFT;
	dwStyle |= WS_BORDER|WS_CHILD|WS_VISIBLE|ES_MULTILINE|ES_AUTOVSCROLL;
	m_pListEdit->Create( dwStyle, rect, &m_GridListCtrl, 103 );
	// Have the Grid position and size the custom edit control
	m_GridListCtrl.PositionControl( m_pListEdit, item, subitem );
	// Have the edit box size itself to its content.
	m_pListEdit->CalculateSize();
	// Return TRUE so that the list control will hnadle NOT edit label itself. 
	*pResult = 1;
}

void CVRoadHeightsSpdFileDlg::OnEndlabeleditList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	// TODO: Add your control notification handler code here
	int item = pDispInfo->item.iItem;
	int subitem = pDispInfo->item.iSubItem;
	// This is coming from the grid list control notification.
	if( m_pListEdit )
		{
		CString str;
		if( pDispInfo->item.pszText )
			m_GridListCtrl.SetItemText( item, subitem, pDispInfo->item.pszText );
		delete m_pListEdit;
		m_pListEdit = 0;
		}
	*pResult = 0;
}

void CVRoadHeightsSpdFileDlg::OnOK() 
{
	int i,iw, iw2;
	CString sStr;
	float fw;
	//std::string str1, str2; 
	CString sBitCStr, sBitCStr1, sBitCStr2;  // CString erstellen


	for (i=0;i<m_nPositions;i++) //Read the changed values and write them back
	{
		//Read Values from GridList
		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+1), "%f",&fw)==1)
			m_colvrdata[i].refPt.x=(int) Runden(65536 * fw); //VRoad.x is valid
		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+2), "%f",&fw)==1)
			m_colvrdata[i].refPt.y=(int) Runden(65536 * fw); //VRoad.Y is valid
		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+3), "%f",&fw)==1)
			m_colvrdata[i].refPt.z=(int) Runden(65536 * fw); //VRoad.Z is valid

		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+4), "%f",&fw)==1)
			m_colvrdata[i].leftWall=(long) fw * 10000; //VRoad Left Edge
		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+5), "%f",&fw)==1)
			m_colvrdata[i].rightWall=(long) fw * 10000; //VRoad Right Edge

		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+6), "%d,%d",&iw, &iw2)==2)
		{
			hs_extra[i].ShortcutToVRoad[0]=(short) iw; //Shortcut1 to VRoad Point
			hs_extra[i].ShortcutToVRoad[1]=(short) iw2; //Shortcut2 to VRoad Point
		}

		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+7), "%d",&iw)==1)
			hs_extra[i].nLeftLanePolys=(long) iw; //Left lane polys is valid
		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+8), "%d",&iw)==1)
			hs_extra[i].nRightLanePolys=(long) iw; //Right lane polys is valid


		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+9), "%f",&fw)==1) //Width Left lane polys is valid
			hs_extra[i].WidthLeftLane=(float) fw;
		if (sscanf(m_GridListCtrl.GetItemText(i,VRoad_sItem+10), "%f",&fw)==1) //Width Right lane polys is valid
			hs_extra[i].WidthRightLane=(float) fw;
	// HS Extra -----------------------------
		sBitCStr=m_GridListCtrl.GetItemText(i,HSExtra_sItem+0);  //Write back view on lanes for AI described in bits.
		if (sBitCStr.GetLength()==19)
		{
			bool ok=true;
			sBitCStr1=sBitCStr.Mid(0,8);
			sBitCStr2=sBitCStr.Mid(11,8);
			int j;
			for (j=0;j<sBitCStr1.GetLength();j++) //Check if there are only 0 & 1 
				if ((sBitCStr1.Mid(j,1)!="0")&&(sBitCStr1.Mid(j,1)!="1"))
					ok=false;
			for (j=0;j<sBitCStr2.GetLength();j++) //Check if there are only 0 & 1 
				if ((sBitCStr2.Mid(j,1)!="0")&&(sBitCStr2.Mid(j,1)!="1"))
					ok=false;

			if (ok)
			{
				std::string str1(sBitCStr1); //Convert CString to string
				std::string str2(sBitCStr2); //Convert CString to string
				unsigned long n1 = std::bitset<8>(str1).to_ulong();  //convert to number
				unsigned long n2 = std::bitset<8>(str2).to_ulong();  //convert to number

				hs_extra[i].LanesLeftPassable= (char) n1;
				hs_extra[i].LanesRightPassable= (char) n2;

			}
		}
		if (sscanf(m_GridListCtrl.GetItemText(i,HSExtra_sItem+1), "%d,%d",&iw, &iw2)==2) //Unknowdata 2,3
		{
			hs_extra[i].Unknown2[0]=(short) iw; //Unknown2 
			hs_extra[i].Unknown2[1]=(short) iw2; //Unknown2 
		}

		if (sscanf(m_GridListCtrl.GetItemText(i,HSExtra_sItem+2), "%d,%d",&iw, &iw2)==2) //ChromeEffect
		{
			hs_extra[i].ChromeEffect[0]=(short) iw; //ChromeEffect Left
			hs_extra[i].ChromeEffect[1]=(short) iw2; //ChromeEffect Right
		}
				if (sscanf(m_GridListCtrl.GetItemText(i,HSExtra_sItem+3), "%d,%d",&iw, &iw2)==2) //HallEffect
		{
			hs_extra[i].HallEffect[0]=(short) iw; //HallEffect Left
			hs_extra[i].HallEffect[1]=(short) iw2; //HallEffect Right
		}


	// HS Extra -----------------------------

		if (sscanf(m_GridListCtrl.GetItemText(i,heights_sItem), "%f",&fw)==1)
			m_heightsdata[i].heights=fw; //heights is valid
		if (sscanf(m_GridListCtrl.GetItemText(i,spdFA_sItem), "%d",&iw)==1)
			spdFAdata[i].Speedvalue=iw; //spdFA is valid
		if (sscanf(m_GridListCtrl.GetItemText(i,spdFA_sItem+1), "%d",&iw)==1)
			spdFAdata[i].AI_Lane=iw; //spdFA is valid
		if (sscanf(m_GridListCtrl.GetItemText(i,spdFA_sItem+2), "%f",&fw)==1)
			spdFAdata[i].AI_Float=fw; //spdFA is valid
		if (sscanf(m_GridListCtrl.GetItemText(i,spdRA_sItem), "%d",&iw)==1)
			spdRAdata[i].Speedvalue=iw; //spdRA is valid
		if (sscanf(m_GridListCtrl.GetItemText(i,spdRA_sItem+1), "%d",&iw)==1)
			spdRAdata[i].AI_Lane=iw; //spdRA is valid
		if (sscanf(m_GridListCtrl.GetItemText(i,spdRA_sItem+2), "%f",&fw)==1)
			spdRAdata[i].AI_Float=fw; //spdRA is valid

	}
	
	CDialog::OnOK();
}

double CVRoadHeightsSpdFileDlg::Runden(double x)
{
	return (x >= 0) ? floor(x+0.5) : ceil(x-0.5);
}

void CVRoadHeightsSpdFileDlg::OnCheckHeights() 
{
	UpdateData(TRUE);
	if (m_Chk_Heights)
		m_GridListCtrl.SetColumnWidth(heights_sItem,100);
	else
		m_GridListCtrl.SetColumnWidth(heights_sItem,0);
	UpdateData(FALSE);	
}

void CVRoadHeightsSpdFileDlg::OnCheckSpdfa() 
{
	UpdateData(TRUE);
	if (m_Chk_SpdFa)
	{
		m_GridListCtrl.SetColumnWidth(spdFA_sItem,100);
		m_GridListCtrl.SetColumnWidth(spdFA_sItem+1,100);
		if (bHSMode) m_GridListCtrl.SetColumnWidth(spdFA_sItem+2,100);
	}
	else
	{
		m_GridListCtrl.SetColumnWidth(spdFA_sItem,0);
		m_GridListCtrl.SetColumnWidth(spdFA_sItem+1,0);
		m_GridListCtrl.SetColumnWidth(spdFA_sItem+2,0);
	}
	UpdateData(FALSE);	
}

void CVRoadHeightsSpdFileDlg::OnCheckSpdra() 
{
	UpdateData(TRUE);
	if (m_Chk_SpdRa)
	{
		m_GridListCtrl.SetColumnWidth(spdRA_sItem,100);
		m_GridListCtrl.SetColumnWidth(spdRA_sItem+1,100);
		if (bHSMode) m_GridListCtrl.SetColumnWidth(spdRA_sItem+2,100);
	}
	else
	{
		m_GridListCtrl.SetColumnWidth(spdRA_sItem,0);
		m_GridListCtrl.SetColumnWidth(spdRA_sItem+1,0);
		m_GridListCtrl.SetColumnWidth(spdRA_sItem+2,0);
	}
	UpdateData(FALSE);	
}

void CVRoadHeightsSpdFileDlg::OnCheckVroad() 
{
	int i;
	UpdateData(TRUE);
	if (m_Chk_VRoad)
	{
		m_GridListCtrl.SetColumnWidth(VRoad_sItem+1,100);
		m_GridListCtrl.SetColumnWidth(VRoad_sItem+2,100);
		m_GridListCtrl.SetColumnWidth(VRoad_sItem+3,100);
		if (bHSMode)
		{
			m_GridListCtrl.SetColumnWidth(VRoad_sItem+4,75);
			m_GridListCtrl.SetColumnWidth(VRoad_sItem+5,75);

			m_GridListCtrl.SetColumnWidth(VRoad_sItem+6,75);

			m_GridListCtrl.SetColumnWidth(VRoad_sItem+7,75);
			m_GridListCtrl.SetColumnWidth(VRoad_sItem+8,75);

			m_GridListCtrl.SetColumnWidth(VRoad_sItem+9,75);
			m_GridListCtrl.SetColumnWidth(VRoad_sItem+10,75);
		}

	}
	else
	{
		for (i=1;i<11;i++)
			m_GridListCtrl.SetColumnWidth(VRoad_sItem+i,0);
	}
	UpdateData(FALSE);
}

void CVRoadHeightsSpdFileDlg::OnCheckHsextra() 
{
	UpdateData(TRUE);
	if (m_Chk_HSExtra)
	{
		m_GridListCtrl.SetColumnWidth(HSExtra_sItem,150);
		m_GridListCtrl.SetColumnWidth(HSExtra_sItem+1,75);
		m_GridListCtrl.SetColumnWidth(HSExtra_sItem+2,75);
		m_GridListCtrl.SetColumnWidth(HSExtra_sItem+3,75);
	}
	else
	{
		m_GridListCtrl.SetColumnWidth(HSExtra_sItem,0);
		m_GridListCtrl.SetColumnWidth(HSExtra_sItem+1,0);
		m_GridListCtrl.SetColumnWidth(HSExtra_sItem+2,0);
		m_GridListCtrl.SetColumnWidth(HSExtra_sItem+3,0);
	}

	UpdateData(FALSE);
}

void CVRoadHeightsSpdFileDlg::HideFloat()
{
	UpdateData(TRUE);
	m_GridListCtrl.SetColumnWidth(spdFA_sItem+2,0);
	m_GridListCtrl.SetColumnWidth(spdRA_sItem+2,0);
	UpdateData(FALSE);
}

void CVRoadHeightsSpdFileDlg::OnBtSwitchFwBw() 
{
	int i;
	struct COLVROAD *backup_colvrdata;
	struct HEIGHTSSIM *backup_heightsdata;
	struct SPDFILE *b_spdFAdata;
	struct SPDFILE *b_spdRAdata;

	backup_colvrdata=(struct COLVROAD *)malloc(m_nPositions*sizeof(struct COLVROAD));
	backup_heightsdata=(struct HEIGHTSSIM *)malloc(m_nPositions*sizeof(struct HEIGHTSSIM));
	b_spdFAdata=(struct SPDFILE *)malloc(m_nPositions*sizeof(struct SPDFILE));
	b_spdRAdata=(struct SPDFILE *)malloc(m_nPositions*sizeof(struct SPDFILE));


	for (i=0;i<m_nPositions;i++) {  //Backup
		backup_colvrdata[i]=m_colvrdata[i];
		backup_heightsdata[i]=m_heightsdata[i];
		b_spdFAdata[i]=spdFAdata[i];
		b_spdRAdata[i]=spdRAdata[i];
	}


	for (i=0;i<m_nPositions;i++) { //switch order of data
		m_colvrdata[i]=backup_colvrdata[m_nPositions -i -1];
		m_heightsdata[i]=backup_heightsdata[m_nPositions -i -1];
		spdFAdata[i]=b_spdRAdata[m_nPositions -i -1];   //Direction has changed!
		spdRAdata[i]=b_spdFAdata[m_nPositions -i -1];
	}


	dofree(backup_colvrdata);
	dofree(backup_heightsdata);
	dofree(b_spdFAdata);
	dofree(b_spdRAdata);
	UpdateView();

}

void CVRoadHeightsSpdFileDlg::UpdateView()
{
	int i;
	TCHAR buffer[30];

	LV_ITEM			lvitem;
	//LV_COLUMN		lvcolumn;
	CRect rect;
	m_GridListCtrl.GetWindowRect( &rect );
	CString sBitCStr1, sBitCStr2;  // CString create
	std::string str1, str2; //String create


	lvitem.mask=LVIF_TEXT;
	for (i=0;i<m_nPositions;i++)
	{
		lvitem.mask = LVIF_TEXT; //update vroad x values
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+1;
		sprintf(buffer, "%f", (float)m_colvrdata[i].refPt.x/65536);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update vroad y values
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+2;
		sprintf(buffer, "%f", (float)m_colvrdata[i].refPt.y/65536);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update vroad z values
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+3;
		sprintf(buffer, "%f", (float)m_colvrdata[i].refPt.z/65536);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);


		lvitem.mask = LVIF_TEXT; //update VRoad Left Edge
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+4;
		sprintf(buffer, "%d", (int) m_colvrdata[i].leftWall/10000);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update VRoad Right Edge
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+5;
		sprintf(buffer, "%d", (int) m_colvrdata[i].rightWall/10000);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update  VRoad Flags
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+6;
		sprintf(buffer, "%d,%d", (int) hs_extra[i].ShortcutToVRoad[0], hs_extra[i].ShortcutToVRoad[1]);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update Left lane polys
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+7;
		sprintf(buffer, "%d", (long) hs_extra[i].nLeftLanePolys);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update Right lane polys
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+8;
		sprintf(buffer, "%d", (long) hs_extra[i].nRightLanePolys);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update Width Left lane polys
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+9;
		sprintf(buffer, "%f", hs_extra[i].WidthLeftLane);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update Width Right lane polys
		lvitem.iItem=i;
		lvitem.iSubItem=VRoad_sItem+10;
		sprintf(buffer, "%f", hs_extra[i].WidthRightLane);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);


	// HS Extra -----------------------------
		lvitem.mask = LVIF_TEXT; //update LanesRightPassable, LanesLeftPassable colum
		lvitem.iItem=i;
		lvitem.iSubItem=HSExtra_sItem;
		str1 = std::bitset<8>(hs_extra[i].LanesLeftPassable).to_string();
		str2 = std::bitset<8>(hs_extra[i].LanesRightPassable).to_string();

		sBitCStr1 = str1.c_str(); //String in CString umwandeln
		sBitCStr2 = str2.c_str(); //String in CString umwandeln

		sprintf(buffer, "%s * %s", sBitCStr1, sBitCStr2);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update Prepare Unknowndata 2,3
		lvitem.iItem=i;
		lvitem.iSubItem=HSExtra_sItem+1;
		sprintf(buffer, "%d,%d", (int) hs_extra[i].Unknown2[0], hs_extra[i].Unknown2[1]);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update HSExtra ChromeEffect colum
		lvitem.iItem=i;
		lvitem.iSubItem=HSExtra_sItem+2;
		sprintf(buffer, "%d,%d", (int) hs_extra[i].ChromeEffect[0], (int) hs_extra[i].ChromeEffect[1]);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update HSExtra HallEffect colum
		lvitem.iItem=i;
		lvitem.iSubItem=HSExtra_sItem+3;
		sprintf(buffer, "%d,%d", (int) hs_extra[i].HallEffect[0], (int) hs_extra[i].HallEffect[1]);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

	// HS Extra -----------------------------




		lvitem.mask = LVIF_TEXT; //update heights.sim values
		lvitem.iItem=i;
		lvitem.iSubItem=heights_sItem;
		sprintf(buffer, "%f", (float)m_heightsdata[i].heights);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update spdFA.bin speed values
		lvitem.iItem=i;
		lvitem.iSubItem=spdFA_sItem;
		sprintf(buffer, "%d", (int)spdFAdata[i].Speedvalue);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update spdFA.bin best prejection values
		lvitem.iItem=i;
		lvitem.iSubItem=spdFA_sItem+1;
		sprintf(buffer, "%d", (int)spdFAdata[i].AI_Lane);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update spdFA.bin turn values
		lvitem.iItem=i;
		lvitem.iSubItem=spdFA_sItem+2;
		sprintf(buffer, "%f", (float)spdFAdata[i].AI_Float);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update spdRA.bin speed values
		lvitem.iItem=i;
		lvitem.iSubItem=spdRA_sItem;
		sprintf(buffer, "%d", (int)spdRAdata[i].Speedvalue);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update spdRA.bin best prejection values
		lvitem.iItem=i;
		lvitem.iSubItem=spdRA_sItem+1;
		sprintf(buffer, "%d", (int)spdRAdata[i].AI_Lane);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		lvitem.mask = LVIF_TEXT; //update spdRA.bin turn values
		lvitem.iItem=i;
		lvitem.iSubItem=spdRA_sItem+2;
		sprintf(buffer, "%f", (float)spdRAdata[i].AI_Float);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

	}

}

void CVRoadHeightsSpdFileDlg::OnButtonHsextra() 
{
	int i;

	CString sStr = "Each VRoad point has 8 bytes of unknown HS_Extra data.";
	CUnknownData UnknownData; // Create dialog

	UnknownData.m_nBytes=8 * m_nPositions;
	UnknownData.m_sTitle=sStr;

	UnknownData.data=(unsigned char *)malloc(UnknownData.m_nBytes);

	for (i=0;i<m_nPositions;i++)
	{
		//memcpy(&UnknownData.data[i*12], &hs_extra[i].ShortcutToVRoad, 2 * sizeof(short));
		memcpy(&UnknownData.data[i*8], &hs_extra[i].LanesRightPassable, 8 * sizeof(char));
	}

	if (UnknownData.DoModal()==IDOK)
	{
		for (i=0;i<m_nPositions;i++)
		{
			//memcpy(&hs_extra[i].ShortcutToVRoad, &UnknownData.data[i*12], 2 * sizeof(short));
			memcpy(&hs_extra[i].LanesRightPassable, &UnknownData.data[i*8], 8 * sizeof(char));
		}
	}
	dofree(UnknownData.data);


}

void CVRoadHeightsSpdFileDlg::OnChPvr() 
{
	UpdateData(TRUE);
	CComboBox *pCbVector_Calc = (CComboBox*) GetDlgItem(IDC_COMBO_VECTOR_CALC);
	
	if (m_Chk_PVR)
		pCbVector_Calc->EnableWindow(TRUE);
		//pCbVector_Calc
	else
		pCbVector_Calc->EnableWindow(FALSE);
	UpdateData(FALSE);
}

void CVRoadHeightsSpdFileDlg::OnSelchangeComboVectorCalc() 
{
	UpdateData(TRUE);
	CComboBox *pCombo_Vector_Calc = (CComboBox*) GetDlgItem(IDC_COMBO_VECTOR_CALC);
	m_Combo_Vector_Calc=pCombo_Vector_Calc->GetCurSel();

}



void CVRoadHeightsSpdFileDlg::OnClickList(NMHDR* pNMHDR, LRESULT* pResult) 
{

	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	ShowHint(pDispInfo->item.iItem);

	*pResult = 0;
}

void CVRoadHeightsSpdFileDlg::ShowHint(int column)
{
	switch(column)
	{
		case 0: //Byte
			m_Str_Hint="Here you can change the data of the virtual road and the heights.sim, spdFA.bin and spdRA.bin files";break;
		case 1:
			m_Str_Hint="X position of the virtual road point,";break;
		case 2:
			m_Str_Hint="Y position of the virtual road point,";break;
		case 3:
			m_Str_Hint="Z position of the virtual road point,";break;
		case 4:
			m_Str_Hint="Left edge of the virtual road. (Measured from VRoad point.) Can also be changed via 'Edit Tools -> Adjust virtual road'.";break;
		case 5:
			m_Str_Hint="Right edge of the virtual road. (Measured from VRoad point.) Can also be changed via 'Edit Tools -> Adjust virtual road'.";break;
		case 6:
			m_Str_Hint="Shortcut from this VRoad point to others. Two VRoad point numbers can be specified. If there is no shortcut then enter -1,-1.";break;
		case 7:
			m_Str_Hint="Number of lanes to the left of the VRoad point";break;
		case 8:
			m_Str_Hint="Number of lanes to the right of the VRoad point";break;			
		case 9:
			m_Str_Hint="Width of the lanes to the left of the VRoad point. Common numbers are 3,4 or 5.";break;
		case 10:
			m_Str_Hint="Width of the lanes to the right of the VRoad point. Common numbers are 3,4 or 5.";break;
		case 11:
			m_Str_Hint="View of lanes used by opponents described in bits. '1' corresponds to a passable lane, '0' to a blocked one. '*' is the VRoad point. Exactly eight numbers must be specified for left and right.";break;	
		case 12:
			m_Str_Hint="Two unknown bytes. Most of the time both are 0.";break;
		case 13:
			m_Str_Hint="'Chrome Effect' on cars left and right from VRoad point. With 0, there's no chrome. Use 2 for low chrome on always dry road, weather has no effect on this. 4 - normal chrome depends on weather effects on or off.";break;
		case 14:
			m_Str_Hint="Hall effect left an right from VRoad, Set them to 3 or 4 for hall effect. 0 to disable hall effect. 6 is used in the underwater tunnel of aquatica.";break;
		case 15:
			m_Str_Hint="Value in the 'heights.sim' file for this VRoad point.";break;
		case 16:
			m_Str_Hint="Maximum speed of opponents in the forward direction.";break;
		case 17:
			m_Str_Hint="Sets the opponents' preferred lane in the forward direction. 96 stands for left of the VRoad point 112 for right. Numbers must be divisible by 16.";break;
		case 18:
			m_Str_Hint="Indicates the points of the ideal line in the forward direction. 'AI lane selection' has a higher priority.";break;
		case 19:
			m_Str_Hint="Maximum speed of opponents in the backward direction.";break;
		case 20:
			m_Str_Hint="Sets the opponents' preferred lane in the backward direction. 96 stands for left of the VRoad point 112 for right. Numbers must be divisible by 16.";break;
		case 21:
			m_Str_Hint="Indicates the points of the ideal line in the backward direction. 'AI lane selection' has a higher priority.";break;
	}
	UpdateData(FALSE);
}

void CVRoadHeightsSpdFileDlg::OnColumnclickList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	ShowHint(pDispInfo->item.iItem);

	*pResult = 0;
}
