// UnknownData.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "t3ed.h"
// #include "T3EDDoc.h"
// #include "T3EDView.h"
#include <math.h> 
#include <bitset>
#include "UnknownData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CUnknownData 


CUnknownData::CUnknownData(CWnd* pParent /*=NULL*/)
	: CDialog(CUnknownData::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUnknownData)
	m_nBytes = 0;
	m_sTitle = _T("");
	m_nSelected = 0;
	m_Byte = 0;
	m_Short = 0;
	m_Long = 0;
	m_Float = 0.0f;
	m_FloatPT_X = 0.0f;
	m_FloatPT_Y = 0.0f;
	m_FloatPT_Z = 0.0f;
	m_f_IntPT_X = 0.0f;
	m_f_IntPT_Y = 0.0f;
	m_f_IntPT_Z = 0.0f;
	m_type = -1;
	m_edit_data = _T("");
	m_sByteAsBits = _T("");
	m_sSelected = _T("");
	//}}AFX_DATA_INIT
}


void CUnknownData::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUnknownData)
	DDX_Control(pDX, IDC_LIST, m_GridListCtrl);
	DDX_Text(pDX, IDC_EDIT_BYTES, m_nBytes);
	DDX_Text(pDX, IDC_LBL_TITLE, m_sTitle);
	DDX_Text(pDX, IDC_EDIT_SELECTED, m_nSelected);
	DDX_Text(pDX, IDC_EDIT_CHAR, m_Byte);
	DDX_Text(pDX, IDC_EDIT_SHORT, m_Short);
	DDV_MinMaxInt(pDX, m_Short, -32768, 32767);
	DDX_Text(pDX, IDC_EDIT_LONG, m_Long);
	DDX_Text(pDX, IDC_EDIT_FLOAT, m_Float);
	DDX_Text(pDX, IDC_EDIT_FLOATPT_X, m_FloatPT_X);
	DDX_Text(pDX, IDC_EDIT_FLOATPT_Y, m_FloatPT_Y);
	DDX_Text(pDX, IDC_EDIT_FLOATPT_Z, m_FloatPT_Z);
	DDX_Text(pDX, IDC_EDIT_INTPT_X, m_f_IntPT_X);
	DDX_Text(pDX, IDC_EDIT_INTPT_Y, m_f_IntPT_Y);
	DDX_Text(pDX, IDC_EDIT_INTPT_Z, m_f_IntPT_Z);
	DDX_CBIndex(pDX, IDC_COMBO_TYPE, m_type);
	DDX_Text(pDX, IDC_EDIT_DATA, m_edit_data);
	DDX_Text(pDX, IDC_EDIT_BITS, m_sByteAsBits);
	DDX_Text(pDX, IDC_EDIT_SELECTED_HEX, m_sSelected);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CUnknownData, CDialog)
	//{{AFX_MSG_MAP(CUnknownData)
	ON_NOTIFY(NM_CLICK, IDC_LIST, OnClickList)
	ON_NOTIFY(LVN_BEGINLABELEDIT, IDC_LIST, OnBeginlabeleditList)
	ON_EN_KILLFOCUS(IDC_EDIT_CHAR, OnKillfocusEditChar)
	ON_EN_KILLFOCUS(IDC_EDIT_SHORT, OnKillfocusEditShort)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST, OnEndlabeleditList)
	ON_EN_KILLFOCUS(IDC_EDIT_LONG, OnKillfocusEditLong)
	ON_EN_KILLFOCUS(IDC_EDIT_FLOAT, OnKillfocusEditFloat)
	ON_EN_KILLFOCUS(IDC_EDIT_FLOATPT_X, OnKillfocusEditFloatptX)
	ON_EN_KILLFOCUS(IDC_EDIT_FLOATPT_Y, OnKillfocusEditFloatptY)
	ON_EN_KILLFOCUS(IDC_EDIT_FLOATPT_Z, OnKillfocusEditFloatptZ)
	ON_EN_KILLFOCUS(IDC_EDIT_INTPT_X, OnKillfocusEditIntptX)
	ON_EN_KILLFOCUS(IDC_EDIT_INTPT_Y, OnKillfocusEditIntptY)
	ON_EN_KILLFOCUS(IDC_EDIT_INTPT_Z, OnKillfocusEditIntptZ)
	ON_CBN_SELCHANGE(IDC_COMBO_TYPE, OnSelchangeComboType)
	ON_EN_KILLFOCUS(IDC_EDIT_BITS, OnKillfocusEditBits)
	ON_BN_CLICKED(IDC_DEBUG, OnDebug)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CUnknownData 

BOOL CUnknownData::OnInitDialog() 
{
	CDialog::OnInitDialog();
	#ifdef _DEBUG
		GetDlgItem(IDC_DEBUG)->ShowWindow(TRUE);
	#endif	
	
	// TODO: Zustzliche Initialisierung hier einfgen
	data=(unsigned char *)realloc(data, m_nBytes + 12); //Get more memory, if last byte was selected

	m_type=0;
	CComboBox *pCbType = (CComboBox*) GetDlgItem(IDC_COMBO_TYPE);
	pCbType->SetCurSel(m_type);

	//CString sStr;
	int i;
	//float fw;
	TCHAR buffer[30];

	VERIFY(font.CreateFont(
       16,                        // nHeight
       0,                         // nWidth
       0,                         // nEscapement
       0,                         // nOrientation
       FW_NORMAL,                 // nWeight
       FALSE,					  // bItalic
       FALSE,                     // bUnderline
       0,                         // cStrikeOut
       ANSI_CHARSET,              // nCharSet
       OUT_DEFAULT_PRECIS,        // nOutPrecision
       CLIP_DEFAULT_PRECIS,       // nClipPrecision
       DEFAULT_QUALITY,           // nQuality
       DEFAULT_PITCH | FF_SWISS,  // nPitchAndFamily
       _T("Arial"))
    );  
	
	GetDlgItem(IDC_LIST)->SetFont(&font);

	m_GridListCtrl.SetExtendedStyle(LVS_EX_GRIDLINES);
	m_GridListCtrl.PrepareControl(0);

	//LV_ITEM			lvitem;
	LV_COLUMN		lvcolumn;
	CRect rect;
	m_GridListCtrl.GetWindowRect( &rect );

	// Insert columns using the order field
	lvcolumn.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH | LVCF_ORDER;
	lvcolumn.fmt = LVCFMT_LEFT;
	lvcolumn.pszText = "-";
	lvcolumn.iSubItem = 0;
	lvcolumn.iOrder = 0;
	lvcolumn.cx = 60;  
	m_GridListCtrl.InsertColumn(0, &lvcolumn);  

	for (i=0;i<16;i++)
	{
		//sprintf(buffer, "_%d", i);
		sprintf(buffer, "%01X", i);
		lvcolumn.pszText = buffer;
		lvcolumn.iSubItem = 1 + i;
		lvcolumn.iOrder = 1 + i;
		lvcolumn.cx = 40;  
		m_GridListCtrl.InsertColumn(1 + i, &lvcolumn); 
	}
	GridSel.column=1;GridSel.row=0;GridSel.nSelByte=0;
	ShowData();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CUnknownData::ShowData(bool update)
{
	int i=0, zeile=0, spalte=0, iActualItem;
	LV_ITEM	lvitem;
	TCHAR buffer[30];
	
	lvitem.mask=LVIF_TEXT;

	if (!update)
	for (i=0;i<(int) m_nBytes;i++)
	{
		if (spalte==0)
		{
			lvitem.mask = LVIF_TEXT; //Prepare first colum
			lvitem.iItem=zeile;
			lvitem.iSubItem=spalte;
			sprintf(buffer, "%04X_", zeile);
			lvitem.pszText = buffer;
			iActualItem=m_GridListCtrl.InsertItem(&lvitem); //Finally add the column
			spalte++;
		}


			lvitem.mask = LVIF_TEXT; //Show Data
			lvitem.iItem=zeile;
			lvitem.iSubItem=spalte;
			sprintf(buffer, "%02X", data[i]);
			lvitem.pszText = buffer;
			m_GridListCtrl.SetItem(&lvitem);

		spalte++;
		if (spalte>16) //New row
		{
			spalte=0;zeile++;
		}
	}

	zeile=0; spalte=1;
	if (update)
	for (i=0;i<(int) m_nBytes;i++)
	{

		lvitem.mask = LVIF_TEXT; //Show Data
		lvitem.iItem=zeile;
		lvitem.iSubItem=spalte;
		sprintf(buffer, "%02X", data[i]);
		lvitem.pszText = buffer;
		m_GridListCtrl.SetItem(&lvitem);

		spalte++;
		if (spalte>16) //New row
		{
			spalte=1;zeile++;
		}
	}
	ShowSelected();
}

void CUnknownData::OnClickList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen

	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	GridSel.column = pDispInfo->item.iItem;
	if (GridSel.column == 0) GridSel.column = 1;
	GridSel.row = pDispInfo->item.mask; //Why mask???, but it works.
	GridSel.nSelByte=(GridSel.column -1) + GridSel.row*16;
	*pResult = 0;
	ShowSelected();
}

void CUnknownData::OnBeginlabeleditList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;

	CString str = pDispInfo->item.pszText;
	int item = pDispInfo->item.iItem;
	int subitem = pDispInfo->item.iSubItem;
	if (subitem==0) return;
	GridSel.column = subitem;
	GridSel.row = item;
	GridSel.nSelByte=(GridSel.column -1) + GridSel.row*16;
	if (GridSel.nSelByte>=m_nBytes) return;
	else ShowSelected();
	// Construct and create the custom multiline edit control.
	// We could just as well have used a combobox, checkbox, 
	// rich text control, etc.
	m_pListEdit = new CInPlaceEdit( item, subitem, str );
	// Start with a small rectangle.  We'll change it later.
	CRect  rect( 0,0,1,1 );
	DWORD dwStyle = ES_LEFT;
	dwStyle |= WS_BORDER|WS_CHILD|WS_VISIBLE|ES_MULTILINE|ES_AUTOVSCROLL;
	m_pListEdit->Create( dwStyle, rect, &m_GridListCtrl, 103 );
	// Have the Grid position and size the custom edit control
	m_GridListCtrl.PositionControl( m_pListEdit, item, subitem );
	// Have the edit box size itself to its content.
	m_pListEdit->CalculateSize();
	// Return TRUE so that the list control will hnadle NOT edit label itself. 
	*pResult = 1;
}

void CUnknownData::OnEndlabeleditList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	char cw;
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	// TODO: Add your control notification handler code here
	int item = pDispInfo->item.iItem;
	int subitem = pDispInfo->item.iSubItem;
	if (subitem==0) return;
	// This is coming from the grid list control notification.
	if( m_pListEdit )
		{
		CString str;
		if( pDispInfo->item.pszText )
			m_GridListCtrl.SetItemText( item, subitem, pDispInfo->item.pszText );
		delete m_pListEdit;
		m_pListEdit = 0;
		}
	*pResult = 0;
	GridSel.column = subitem;
	GridSel.row = item;
	GridSel.nSelByte=(GridSel.column -1) + GridSel.row*16;
	if (sscanf(m_GridListCtrl.GetItemText(GridSel.row,GridSel.column), "%02X",&cw)==1)
		data[GridSel.nSelByte]=cw;
	ShowSelected();
}

void CUnknownData::ShowSelected()
{
	unsigned int i, n;
	float floatP;
	long intP;
	//CString sSelByte="";

	UpdateData(TRUE);
	m_nSelected = GridSel.nSelByte;
	m_sSelected.Format("0x%04X", m_nSelected);

	memcpy(&m_Byte, &data[GridSel.nSelByte], sizeof(BYTE));
	std::string str = std::bitset<8>(m_Byte).to_string(); //Get bit string
	m_sByteAsBits = str.c_str(); //String in CString umwandeln

	memcpy(&m_Short, &data[GridSel.nSelByte], sizeof(short));
	memcpy(&m_Long, &data[GridSel.nSelByte], sizeof(long));

	memcpy(&floatP, &data[GridSel.nSelByte], sizeof(float)); //Maybe data contains no real float number
	if (IsRealFloat(floatP)) //Is Number?
	{
		memcpy(&m_Float, &data[GridSel.nSelByte], sizeof(float));
		memcpy(&m_FloatPT_X, &data[GridSel.nSelByte], sizeof(float));
		GetDlgItem(IDC_EDIT_FLOAT)->EnableWindow(TRUE); 
		GetDlgItem(IDC_EDIT_FLOATPT_X)->EnableWindow(TRUE); 

	}
	else
	{
		m_Float=0;
		m_FloatPT_X=0;
		GetDlgItem(IDC_EDIT_FLOAT)->EnableWindow(FALSE); 
		GetDlgItem(IDC_EDIT_FLOATPT_X)->EnableWindow(FALSE); 
	}

	memcpy(&floatP, &data[GridSel.nSelByte + 4], sizeof(float)); //Maybe data contains no real float number
	if (IsRealFloat(floatP)) //Is Number?
	{
		memcpy(&m_FloatPT_Y, &data[GridSel.nSelByte + 4], sizeof(float));
		GetDlgItem(IDC_EDIT_FLOATPT_Y)->EnableWindow(TRUE); 

	}
	else
	{
		m_FloatPT_Y=0;
		GetDlgItem(IDC_EDIT_FLOATPT_Y)->EnableWindow(FALSE);
	}

	memcpy(&floatP, &data[GridSel.nSelByte + 8], sizeof(float)); //Maybe data contains no real float number
	if (IsRealFloat(floatP)) //Is Number?
	{
		memcpy(&m_FloatPT_Z, &data[GridSel.nSelByte + 8], sizeof(float));
		GetDlgItem(IDC_EDIT_FLOATPT_Z)->EnableWindow(TRUE); 
	}
	else
	{
		m_FloatPT_Z=0;
		GetDlgItem(IDC_EDIT_FLOATPT_Z)->EnableWindow(FALSE);
	}

	memcpy(&intP, &data[GridSel.nSelByte], sizeof(long));
	m_f_IntPT_X=(float) (intP) / 65536 ;
	memcpy(&intP, &data[GridSel.nSelByte + 4], sizeof(long));
	m_f_IntPT_Y=(float) (intP) / 65536;
	memcpy(&intP, &data[GridSel.nSelByte + 8], sizeof(long));
	m_f_IntPT_Z=(float) (intP) / 65536;

	//Fill ddit text field
	CString sStr="", sValue="", sNumber="" ;
	switch(m_type)
	{
	case 0: //Byte
		n=0;
		for (i=GridSel.nSelByte; i<m_nBytes; i++)
		{
			//sValue.Format("%04X='%03d'", i, data[i]);
			n++;
			if (n==1) //First entry
				sValue.Format("%04X: '%03d'", i, data[i]);
			else 
				if (n==16)
				{n=0;sValue.Format(", '%03d'\r\n", data[i]);}
				else
					sValue.Format(", '%03d'", data[i]);
			sStr=sStr + sValue;
		}
		break;

	case 1: //Short integer
		short sdata;
		n=0;
		for (i=GridSel.nSelByte; i<m_nBytes; i=i+sizeof(short))
		{
			memcpy(&sdata, &data[i], sizeof(short));
			n++;
			if (n==1) //First entry
				sValue.Format("%04X: '%d'", i, sdata);
			else 
				if (n==8)
				{n=0;sValue.Format(", '%d'\r\n", sdata);}
				else
					sValue.Format(", '%d'", sdata);
			sStr=sStr + sValue;
		}
		break;
	case 2: //Unsigned short integer
		unsigned short usdata;
		n=0;
		for (i=GridSel.nSelByte; i<m_nBytes; i=i+sizeof(short))
		{
			memcpy(&usdata, &data[i], sizeof(short));
			n++;
			if (n==1) //First entry
				sValue.Format("%04X: '%d'", i, usdata);
			else 
				if (n==8)
				{n=0;sValue.Format(", '%d'\r\n", usdata);}
				else
					sValue.Format(", '%d'", usdata);
			sStr=sStr + sValue;
		}
		break;
	case 3: //long integer
		long ldata;
		n=0;
		for (i=GridSel.nSelByte; i<m_nBytes; i=i+sizeof(long))
		{
			memcpy(&ldata, &data[i], sizeof(long));
			n++;
			if (n==1) //First entry
				sValue.Format("%04X: '%d'", i, ldata);
			else 
				if (n==4)
				{n=0;sValue.Format(", '%d'\r\n", ldata);}
				else
					sValue.Format(", '%d'", ldata);
			sStr=sStr + sValue;
		}
		break;
	case 4: //float numbers?
		float fdata;
		n=0;
		for (i=GridSel.nSelByte; i<m_nBytes; i=i+sizeof(float))
		{
			memcpy(&fdata, &data[i], sizeof(float));
			if (IsRealFloat(fdata)) //Is Number?
				sNumber.Format("'%f'", fdata);
			else
				sNumber="No Float";

			n++;
			if (n==1) //First entry
				{sValue.Format("%04X: ", i);sValue+=sNumber;}
			else 
				if (n==4)
				{n=0;sValue=", " + sNumber + "\r\n";}
				else
					sValue=", " + sNumber;
			sStr=sStr + sValue;
		}
		break;
	}
	m_edit_data=sStr;

	UpdateData(FALSE);
}

void CUnknownData::OnKillfocusEditChar() 
{
	UpdateData(TRUE);
	memcpy(&data[GridSel.nSelByte], &m_Byte, sizeof(BYTE));
	ShowData(true);
}

void CUnknownData::OnKillfocusEditShort() 
{
	UpdateData(TRUE);
	memcpy(&data[GridSel.nSelByte], &m_Short, sizeof(short));
	ShowData(true);	
}


void CUnknownData::OnKillfocusEditLong() 
{
	UpdateData(TRUE);
	memcpy(&data[GridSel.nSelByte], &m_Long, sizeof(long));
	ShowData(true);	
}

void CUnknownData::OnKillfocusEditFloat() 
{
	UpdateData(TRUE);
	memcpy(&data[GridSel.nSelByte], &m_Float, sizeof(float));
	ShowData(true);	
}

void CUnknownData::OnKillfocusEditFloatptX() 
{
	UpdateData(TRUE);
	memcpy(&data[GridSel.nSelByte], &m_FloatPT_X, sizeof(float));
	ShowData(true);		
}

void CUnknownData::OnKillfocusEditFloatptY() 
{
	UpdateData(TRUE);
	memcpy(&data[GridSel.nSelByte + 4], &m_FloatPT_Y, sizeof(float));
	ShowData(true);	
}

void CUnknownData::OnKillfocusEditFloatptZ() 
{
	UpdateData(TRUE);
	memcpy(&data[GridSel.nSelByte + 8], &m_FloatPT_Z, sizeof(float));
	ShowData(true);	
}

void CUnknownData::OnKillfocusEditIntptX() 
{
	long IntP;

	UpdateData(TRUE);

	IntP=(long) (m_f_IntPT_X*65536);
	memcpy(&data[GridSel.nSelByte], &IntP, sizeof(long));

	ShowData(true);	
}

void CUnknownData::OnKillfocusEditIntptY() 
{
	long IntP;

	UpdateData(TRUE);

	IntP=(long) (m_f_IntPT_Y*65536);
	memcpy(&data[GridSel.nSelByte + 4], &IntP, sizeof(long));

	ShowData(true);	
}

void CUnknownData::OnKillfocusEditIntptZ() 
{
	long IntP;

	UpdateData(TRUE);

	IntP=(long) (m_f_IntPT_Z*65536);
	memcpy(&data[GridSel.nSelByte + 8], &IntP, sizeof(long));

	ShowData(true);	
}

bool CUnknownData::IsRealFloat(float f)
{

	CString sStr;
	sStr.Format("%f", f);

	return !((sStr=="-1.#QNAN0")|(sStr=="1.#QNAN0"));

}

void CUnknownData::OnSelchangeComboType() 
{
	UpdateData(TRUE);
	CComboBox *pCbType = (CComboBox*) GetDlgItem(IDC_COMBO_TYPE);
	pCbType->SetCurSel(m_type);
	ShowSelected();

}

void CUnknownData::OnKillfocusEditBits() 
{

	int i;

	UpdateData(TRUE);

	for (i=0;i<m_sByteAsBits.GetLength();i++) //Check if there are only 0 & 1 
		if ((m_sByteAsBits.Mid(i,1)!="0")&&(m_sByteAsBits.Mid(i,1)!="1"))
			return;

	std::string str2(m_sByteAsBits); //Convert CString to string

	unsigned long n = std::bitset<8>(str2).to_ulong();  //convert to number
	m_Byte = n;
	memcpy(&data[GridSel.nSelByte], &m_Byte, sizeof(BYTE));
	ShowData(true);
	
}

void CUnknownData::OnDebug() 
{
	#ifdef _DEBUG // Code only for Debug mode
	int maxBytes, pos;
	CString sStr; 
	

	maxBytes=m_nBytes-m_nSelected;

	/*struct POSITIONDATA posData;  // positions along track. Is used to indicate which track polygons are attached to a given node (VRoad Point).
	if (sizeof(struct POSITIONDATA) <= maxBytes)
		memcpy(&posData, &data[GridSel.nSelByte], sizeof(struct POSITIONDATA));
	*/
	struct MCO_POLYVROADDATA hspvrdata;
	if (sizeof(struct MCO_POLYVROADDATA) <= maxBytes)
		memcpy(&hspvrdata, &data[GridSel.nSelByte], sizeof(struct MCO_POLYVROADDATA));
//Trackblock Data
	struct REFXOBJ rxobj;
		if (sizeof(struct REFXOBJ) <= maxBytes)
		memcpy(&rxobj, &data[GridSel.nSelByte], sizeof(struct REFXOBJ));

	struct MCO_REFPOLYOBJ refpolyobj;
		if (sizeof(struct MCO_REFPOLYOBJ) <= maxBytes)
		memcpy(&refpolyobj, &data[GridSel.nSelByte], sizeof(struct MCO_REFPOLYOBJ));

	struct POLYGONDATA polyData; //(size : 13 bytes)
		if (sizeof(struct POLYGONDATA) <= maxBytes)
		memcpy(&polyData, &data[GridSel.nSelByte], sizeof(struct POLYGONDATA));

	//struct TRKBLOCK *t;
	int i, j,k, nVert=183; //Boval block 0
	//CT3EDDoc* pDoc = GetDocument();
	//nVert=pDoc->trk[i].nVertices;
	bool ok=true;
	for (i=0;i < (maxBytes-sizeof(struct POLYGONDATA)); i++)
	{
		memcpy(&polyData, &data[GridSel.nSelByte + i], sizeof(struct POLYGONDATA));
		ok=true;
		for (j=0;j<4;j++)
		{
			if ((polyData.vertex[j]<0) | (polyData.vertex[j]>=nVert)) ok=false;
			for (k=0;k<4;k++)
				if ((j!=k)&&(polyData.vertex[j]==polyData.vertex[k])) ok=false;
			//if (polyData.texanimdata==0) ok=false;
		}

		if (ok==true)
		{
			pos=m_nSelected + i;
			sStr.Format("Position > %d <", pos);
			//AfxMessageBox(sStr);
		}
	}



	#endif
}
