// TextureProps_NFS3.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "T3ED.h"
#include "TextureProps_NFS3.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CTextureProps_NFS3 


CTextureProps_NFS3::CTextureProps_NFS3(CWnd* pParent /*=NULL*/)
	: CDialog(CTextureProps_NFS3::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTextureProps_NFS3)
	m_int_texanimdata = 0;
	m_int_unknown2 = 0;
	m_bool_twosided = (m_int_texanimdata&0x16)>>4;
	m_bool_ani = FALSE;
	m_int_duration = 0;
	m_int_animlength = 0;
	//}}AFX_DATA_INIT
}


void CTextureProps_NFS3::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTextureProps_NFS3)
	DDX_Text(pDX, IDC_EDIT_TEXANIMDATA, m_int_texanimdata);
	DDV_MinMaxUInt(pDX, m_int_texanimdata, 0, 255);
	DDX_Text(pDX, IDC_EDIT_UN2, m_int_unknown2);
	DDV_MinMaxUInt(pDX, m_int_unknown2, 0, 255);
	DDX_Check(pDX, IDC_CHECK_DBL, m_bool_twosided);
	DDX_Check(pDX, IDC_CHECK_ANI, m_bool_ani);
	DDX_Text(pDX, IDC_ANIMDURATION, m_int_duration);
	DDV_MinMaxUInt(pDX, m_int_duration, 1, 31);
	DDX_Text(pDX, IDC_ANIMLENGTH, m_int_animlength);
	DDV_MinMaxUInt(pDX, m_int_animlength, 2, 7);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTextureProps_NFS3, CDialog)
	//{{AFX_MSG_MAP(CTextureProps_NFS3)
	ON_EN_KILLFOCUS(IDC_EDIT_TEXANIMDATA, OnKillfocusEditTexanimdata)
	ON_BN_CLICKED(IDC_CHECK_DBL, OnCheckDbl)
	ON_BN_CLICKED(IDC_CHECK_ANI, OnCheckAni)
	ON_EN_KILLFOCUS(IDC_ANIMLENGTH, OnKillfocusAnimlength)
	ON_EN_KILLFOCUS(IDC_ANIMDURATION, OnKillfocusAnimduration)
	ON_EN_KILLFOCUS(IDC_EDIT_UN2, OnKillfocusEditUn2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CTextureProps_NFS3 


BOOL CTextureProps_NFS3::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_bool_twosided=((m_int_texanimdata & 0x10)>>4);
	CButton* pChkDbl = (CButton*) GetDlgItem(IDC_CHECK_DBL);
	pChkDbl->SetCheck(m_bool_twosided);

	m_bool_ani=((m_int_texanimdata & 0x4)>>2);
	CButton* pChkAni = (CButton*) GetDlgItem(IDC_CHECK_ANI);
	pChkAni->SetCheck(m_bool_ani);

	m_int_animlength=(m_int_unknown2 & 0x07);
	m_int_duration=((m_int_unknown2 & 0xF8)>>3);
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CTextureProps_NFS3::OnKillfocusEditTexanimdata() 
{

	UpdateData(TRUE); //Get new value for m_int_texanimdata

	CButton* pChkDbl = (CButton*) GetDlgItem(IDC_CHECK_DBL);
	m_bool_twosided=(m_int_texanimdata & 0x10)>>4; //Get bit 4 
	pChkDbl->SetCheck(m_bool_twosided);  //Set Checkbox

	m_bool_ani=((m_int_texanimdata & 0x4)>>2);
	CButton* pChkAni = (CButton*) GetDlgItem(IDC_CHECK_ANI);
	pChkAni->SetCheck(m_bool_ani);
}

void CTextureProps_NFS3::OnCheckDbl() 
{
	UpdateData(TRUE); //Get new value for m_bool_twosided

	m_int_texanimdata &= 0xEF; //Clear bit 4
	m_int_texanimdata += ((m_bool_twosided)<<4); //Set bit 4 if twosided is checked

	UpdateData(FALSE);
}

void CTextureProps_NFS3::OnCheckAni() 
{
	UpdateData(TRUE); //Get new value for m_bool_ani
	m_int_texanimdata &= 0xFB; //Clear bit 2
	m_int_texanimdata += ((m_bool_ani)<<2); //Set bit 2 if twosided is checked
	UpdateData(FALSE);
}

void CTextureProps_NFS3::OnKillfocusAnimlength() 
{
	UpdateData(TRUE); //Get new value for m_int_animlength
	m_int_unknown2 &= 0xF8; //Clear bits 0-2
	m_int_unknown2 +=m_int_animlength;
	UpdateData(FALSE);
}

void CTextureProps_NFS3::OnKillfocusAnimduration() 
{
	UpdateData(TRUE); //Get new value for m_int_duration
	m_int_unknown2 &= 0x07; //Clear bits 3-7
	m_int_unknown2 +=(m_int_duration<<3); //add duration
	UpdateData(FALSE); //show new value
}

void CTextureProps_NFS3::OnKillfocusEditUn2() 
{
	UpdateData(TRUE); //Get new value for m_int_unknown2
	m_int_animlength=(m_int_unknown2 & 0x07);
	m_int_duration=((m_int_unknown2 & 0xF8)>>3);
	UpdateData(FALSE);
}
