// TextureChoice.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "t3ed.h"
#include "T3EDDoc.h"
#include "TextureChoice.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CTextureChoice 


CTextureChoice::CTextureChoice(CWnd* pParent /*=NULL*/)
	: CDialog(CTextureChoice::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTextureChoice)
	//}}AFX_DATA_INIT
	m_pImageList = NULL;
	m_minSize = CSize(0, 0);
	m_btnGap = -1;
}

CTextureChoice::~CTextureChoice()
{
	if (m_pImageList) delete m_pImageList;
}


void CTextureChoice::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTextureChoice)
	DDX_Control(pDX, IDC_LIST_CTRL1, m_ListCtrl1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTextureChoice, CDialog)
	//{{AFX_MSG_MAP(CTextureChoice)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_CTRL1, OnDblclkListCtrl1)
	ON_WM_SIZE()
	ON_WM_GETMINMAXINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen f�r Nachrichten CTextureChoice 

BOOL CTextureChoice::OnInitDialog() 
{
	CDialog::OnInitDialog();

	HICON hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	SetIcon(hIcon, TRUE);		// Set big icon
	SetIcon(hIcon, FALSE);		// Set small icon

	CRect rect;
	GetWindowRect(&rect);
	m_minSize = rect.Size();

	ShowTextures();
	
	if (m_ListCtrl1.GetSafeHwnd() && ::GetFocus() == m_ListCtrl1.GetSafeHwnd())
		return FALSE;

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zur�ckgeben
}

void CTextureChoice::ShowTextures()
{
	int i;
	if (pBitmaps == NULL) return;
	m_ListCtrl1.DeleteAllItems();

	// Erzeuge ein monochromes Bitmap (1 Bit pro Pixel)
	CBitmap blackbitmap;
	blackbitmap.CreateBitmap(64, 64, 1, 1, NULL);

	if (m_pImageList) delete m_pImageList;
	m_pImageList = new CImageList();
	m_pImageList->Create(64, 64, ILC_COLOR24, 0, 1);

	for (i = 0; i < nQfsEntries; i++)
	{
		HBITMAP hBmp = pBitmaps[i];
		if (hBmp)
		{
			CBitmap* pBitmap = CBitmap::FromHandle(hBmp);

			// Alyways scale the bitmap to 64x64
			CClientDC dc(this);
			CDC memDC, srcDC;
			memDC.CreateCompatibleDC(&dc);
			srcDC.CreateCompatibleDC(&dc);
			CBitmap newBmp;
			newBmp.CreateCompatibleBitmap(&dc, 64, 64);
			CBitmap* pOldMem = memDC.SelectObject(&newBmp);
			CBitmap* pOldSrc = srcDC.SelectObject(pBitmap);
			BITMAP bm;
			pBitmap->GetBitmap(&bm);
			memDC.StretchBlt(0, 0, 64, 64, &srcDC, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY);
			memDC.SelectObject(pOldMem);
			srcDC.SelectObject(pOldSrc);

			if (m_pImageList->Add(&newBmp, (CBitmap*)NULL) == -1) //Can't be added?
				m_pImageList->Add(&blackbitmap, (CBitmap*)NULL); //Add a blank bitmap instead

		}
	}

	m_ListCtrl1.SetImageList(m_pImageList, LVSIL_NORMAL);
	//m_ListCtrl1.DeleteAllItems();

	for (i = 0; i < nQfsEntries; i++)
	{
		HBITMAP hBmp = pBitmaps[i];
		if (hBmp)
		{
			BITMAP bm;
			::GetObject(hBmp, sizeof(BITMAP), &bm);
			
			CString str;
			str.Format("%04d %d x %d", i, bm.bmWidth, bm.bmHeight);
			m_ListCtrl1.InsertItem(i, str, i);
		}
	}
	
	if (m_nBmp >= 0 && m_nBmp < nQfsEntries)
	{
		m_ListCtrl1.SetItemState(m_nBmp, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
		m_ListCtrl1.EnsureVisible(m_nBmp, FALSE);
		m_ListCtrl1.SetFocus();
	}
}

void CTextureChoice::OnDblclkListCtrl1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	if (pNMListView->iItem != -1)
	{
		m_nBmp = pNMListView->iItem;
		OnOK();
	}

	*pResult = 0;
}

void CTextureChoice::OnOK() 
{
	POSITION pos = m_ListCtrl1.GetFirstSelectedItemPosition();
	if (pos != NULL)
	{
		m_nBmp = m_ListCtrl1.GetNextSelectedItem(pos);
	}
	
	CDialog::OnOK();
}

void CTextureChoice::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	if (nType == SIZE_MINIMIZED) return;

	if (m_ListCtrl1.GetSafeHwnd())
	{
		CWnd* pOK = GetDlgItem(IDOK);
		CWnd* pCancel = GetDlgItem(IDCANCEL);

		if (pOK && pCancel)
		{
			CRect rectOK;
			CRect rectCancel;
			pOK->GetWindowRect(&rectOK);
			pCancel->GetWindowRect(&rectCancel);
			int btnW_OK = rectOK.Width();
			int btnH_OK = rectOK.Height();
			int btnW_Cancel = rectCancel.Width();
			int btnH_Cancel = rectCancel.Height();
			int margin = 7;

			if (m_btnGap == -1)
			{
				if (rectOK.left < rectCancel.left)
					m_btnGap = rectCancel.left - rectOK.right;
				else
					m_btnGap = rectOK.left - rectCancel.right;
				if (m_btnGap < 0) m_btnGap = 7;
			}

			// Buttons centered horizontally
			int totalBtnWidth = btnW_OK + m_btnGap + btnW_Cancel;
			int startX = (cx - totalBtnWidth) / 2;
			int yBtn = cy - margin - btnH_OK;

			pOK->MoveWindow(startX, yBtn, btnW_OK, btnH_OK);
			pCancel->MoveWindow(startX + btnW_OK + m_btnGap, yBtn, btnW_Cancel, btnH_Cancel);

			// List Control
			CRect rectList;
			m_ListCtrl1.GetWindowRect(&rectList);
			ScreenToClient(&rectList);

			int listW = cx - rectList.left - margin;
			int listH = yBtn - margin - rectList.top;

			if (listW > 0 && listH > 0)
			{
				m_ListCtrl1.MoveWindow(rectList.left, rectList.top, listW, listH);
				m_ListCtrl1.Arrange(LVA_DEFAULT);
			}
		}
	}
}

void CTextureChoice::OnGetMinMaxInfo(MINMAXINFO* lpMMI)
{
	if (m_minSize.cx > 0 && m_minSize.cy > 0)
	{
		lpMMI->ptMinTrackSize.x = m_minSize.cx;
		lpMMI->ptMinTrackSize.y = m_minSize.cy;
	}
	CDialog::OnGetMinMaxInfo(lpMMI);
}
