// T3EDView.cpp : implementation of the CT3EDView class
//
// Modified by Hoo, 8/16/1999 (Total: 5 items)
// Hoo's D3D View functions added by Nappe1, (2/11/2001)

#include "stdafx.h"
#include "T3ED.h"
#include <math.h>
#include <afxdlgs.h> //Open File

#include "T3EDDoc.h"
#include "T3EDView.h"
#include "smooth.h"
#include "NewobjDlg.h"
#include "ClearAll.h"
#include "PolyFlag.h"
#include <windows.h>
#include "BlockProps.h"
#include "SoundLightProps.h"
#include "LodGenProgress.h"
#include "VirtualRoadAdjust.h"
#include "Vectors.h"
#include "RayTraceDlg.h"
#include "LodStartEnd.h"
#include "ExpandDlg.h"
#include "RotateDlg.h"
#include "BlockPaste.h"
#include "PolyProperties.h"
#include "ExtraObjProps.h"
#include "ExpandBlock.h"
#include "MoveTo.h"
#include "BlockProp.h"
#include "FrdFileDlg.h"
#include "GridListCtrl.h"
#include "InPlaceEdit.h"
#include "VRoadHeightsSpdFileDlg.h"
#include "FindPolygonDlg.h"
#include "SetVisiDlg.h"
#include "InputDlg.h"
#include "PointPropsDlg.h"
#include "ExprandTrack.h"
#include "VRoadPaste.h"
#include "CameraProps.h"
#include "PolyShade.h"

#define SCROLLSZ 5000

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CT3EDView

IMPLEMENT_DYNCREATE(CT3EDView, CView)

BEGIN_MESSAGE_MAP(CT3EDView, CView)
	//{{AFX_MSG_MAP(CT3EDView)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_COMMAND(ID_VIEW_FULLRES, OnViewFullres)
	ON_COMMAND(ID_VIEW_HALFRES, OnViewHalfres)
	ON_COMMAND(ID_VIEW_LOWRES, OnViewLowres)
	ON_COMMAND(ID_VIEW_ZOOMIN, OnViewZoomin)
	ON_COMMAND(ID_VIEW_ZOOMOUT, OnViewZoomout)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FULLRES, OnUpdateViewFullres)
	ON_UPDATE_COMMAND_UI(ID_VIEW_HALFRES, OnUpdateViewHalfres)
	ON_UPDATE_COMMAND_UI(ID_VIEW_LOWRES, OnUpdateViewLowres)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOMIN, OnUpdateViewZoomin)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOMOUT, OnUpdateViewZoomout)
	ON_COMMAND(ID_VIEW_ROTATE, OnViewRotateMode)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ROTATE, OnUpdateViewRotateMode)
	ON_COMMAND(ID_VIEW_HEIGHT, OnViewTranslMode)
	ON_UPDATE_COMMAND_UI(ID_VIEW_HEIGHT, OnUpdateViewTranslMode)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
	ON_WM_KEYDOWN()
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWHIDEOBJECTS, OnUpdateViewShowhideobjects)
	ON_COMMAND(ID_VIEW_SHOWHIDEOBJECTS, OnViewShowhideobjects)
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_MODE_BLOCK, OnModeBlock)
	ON_UPDATE_COMMAND_UI(ID_MODE_BLOCK, OnUpdateModeBlock)
	ON_COMMAND(ID_MODE_EXTPOINT, OnModeExtpoint)
	ON_UPDATE_COMMAND_UI(ID_MODE_EXTPOINT, OnUpdateModeExtpoint)
	ON_COMMAND(ID_MODE_POINT, OnModePoint)
	ON_UPDATE_COMMAND_UI(ID_MODE_POINT, OnUpdateModePoint)
	ON_COMMAND(ID_MODE_OBJECT, OnModeObject)
	ON_UPDATE_COMMAND_UI(ID_MODE_OBJECT, OnUpdateModeObject)
	ON_COMMAND(ID_MODE_POLYGON, OnModePolygon)
	ON_UPDATE_COMMAND_UI(ID_MODE_POLYGON, OnUpdateModePolygon)
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	ON_COMMAND(ID_VIEW_RECENTER, OnViewRecenter)
	ON_UPDATE_COMMAND_UI(ID_VIEW_RECENTER, OnUpdateViewRecenter)
	ON_COMMAND(ID_VIEW_SHOWLANES, OnViewShowlanes)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWLANES, OnUpdateViewShowlanes)
	ON_COMMAND(ID_VIEW_SHOWTRACK, OnViewShowTrack)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWTRACK, OnUpdateViewShowTrack)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_MOVEXY, OnUpdateToolsMovexy)
	ON_COMMAND(ID_TOOLS_MOVEXY, OnToolsMovexy)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_MOVEZ, OnUpdateToolsMovez)
	ON_COMMAND(ID_TOOLS_MOVEZ, OnToolsMovez)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO, OnUpdateEditUndo)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_UPDATE_COMMAND_UI(ID_MODE_SMOOTHING, OnUpdateModeSmoothing)
	ON_COMMAND(ID_MODE_SMOOTHING, OnModeSmoothing)
	ON_UPDATE_COMMAND_UI(ID_EDITMODES_EXTRASMOOTHING, OnUpdateEditmodesExtrasmoothing)
	ON_COMMAND(ID_EDITMODES_EXTRASMOOTHING, OnEditmodesExtrasmoothing)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_DELETE, OnUpdateToolsDelete)
	ON_COMMAND(ID_TOOLS_DELETE, OnToolsDelete)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_DUPLICATE, OnUpdateToolsDuplicate)
	ON_COMMAND(ID_TOOLS_DUPLICATE, OnToolsDuplicate)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_TEXTURE, OnUpdateToolsTexture)
	ON_COMMAND(ID_TOOLS_TEXTURE, OnToolsTexture)
	ON_COMMAND(ID_TOOLS_POLYFLAG, OnToolsPolyflag)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_POLYFLAG, OnUpdateToolsPolyflag)
	ON_COMMAND(ID_Tools_Neighbours, OnToolsTrackBlockProps)
	ON_COMMAND(ID_TOOLS_MERGE, OnToolsMerge)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_MERGE, OnUpdateToolsMerge)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_TOOLS_ADJUSTWIDTH, OnToolsAdjustwidth)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_ADJUSTWIDTH, OnUpdateToolsAdjustwidth)
	ON_COMMAND(ID_TOOLS_CLEARALL, OnToolsClearall)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_CLEARALL, OnUpdateToolsClearall)
	ON_COMMAND(ID_VIEW_VROAD, OnViewVroad)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VROAD, OnUpdateViewVroad)
	ON_COMMAND(ID_EXPORT_VIS, OnExportVis)
	ON_COMMAND(ID_IMPORT_VIS, OnImportVis)
	ON_COMMAND(ID_COPY_Z, OnCopyZ)
	ON_COMMAND(ID_COPY_Zl, OnCOPYZl)
	ON_COMMAND(ID_Paste_Zh, OnPasteZh)
	ON_COMMAND(ID_PASTE_Zl, OnPASTEZl)
	ON_COMMAND(ID_EXPORT_TRKVERTICES, OnExportTrkvertices)
	ON_COMMAND(ID_TOOLS_PROPERTIES, OnToolsProperties)
	ON_COMMAND(ID_COPY_MODE, OnCopyMode)
	ON_COMMAND(ID_VIEW_EDITBLOCK, OnViewEditblock)
	ON_UPDATE_COMMAND_UI(ID_VIEW_EDITBLOCK, OnUpdateViewEditblock)
	ON_COMMAND(ID_VIEW_POLYFLAG, OnViewPolyflag)
	ON_UPDATE_COMMAND_UI(ID_VIEW_POLYFLAG, OnUpdateViewPolyflag)
	ON_COMMAND(ID_TOOLS_LODGEN, OnToolsLodgen)
	ON_COMMAND(ID_VIRTUALROADMASK, OnVirtualroadmask)
	ON_COMMAND(ID_VIRTUALROADEDGEMASK, OnVirtualroadedgemask)
	ON_UPDATE_COMMAND_UI(ID_VIRTUALROADMASK, OnUpdateVirtualroadmask)
	ON_UPDATE_COMMAND_UI(ID_VIRTUALROADEDGEMASK, OnUpdateVirtualroadedgemask)
	ON_COMMAND(ID_NONPASSABLEPOLYGONMASK, OnNonpassablepolygonmask)
	ON_UPDATE_COMMAND_UI(ID_NONPASSABLEPOLYGONMASK, OnUpdateNonpassablepolygonmask)
	ON_COMMAND(ID_MODE_VROADEDIT, OnModeVroadedit)
	ON_UPDATE_COMMAND_UI(ID_MODE_VROADEDIT, OnUpdateModeVroadedit)
	ON_COMMAND(ID_EXPORT_TEXTURE, OnExportTexture)
	ON_COMMAND(ID_IMPORT_TEXTURE, OnImportTexture)
	ON_COMMAND(ID_VIRROADBITMAP, OnVirroadbitmap)
	ON_UPDATE_COMMAND_UI(ID_VIRROADBITMAP, OnUpdateVirroadbitmap)
	ON_WM_MOUSEWHEEL()
	ON_COMMAND(ID_TOOLS_SHADOWRAYTRACER, OnToolsShadowraytracer)
	ON_COMMAND(ID_PASTE_XY, OnPasteXY)
	ON_COMMAND(ID_EDIT_PASTE_NORMAL, OnEditPasteNormal)
	ON_COMMAND(ID_EDIT_PASTE_SHADER, OnEditPasteShader)
	ON_COMMAND(ID_EDIT_PASTE_AVERAGE, OnEditPasteAverage)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_NORMAL, OnUpdateEditPasteNormal)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_SHADER, OnUpdateEditPasteShader)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_AVERAGE, OnUpdateEditPasteAverage)
	ON_UPDATE_COMMAND_UI(ID_COPY_Z, OnUpdateCopyZ)
	ON_UPDATE_COMMAND_UI(ID_Paste_Zh, OnUpdatePasteZh)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_XY, OnUpdateEditPasteXy)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_EXPAND, OnUpdateToolsExpand)
	ON_COMMAND(ID_TOOLS_EXPAND, OnToolsExpand)
	ON_UPDATE_COMMAND_UI(ID_EDITMODES_AUTOOBJMEMBER, OnUpdateEditmodesAutoobjmember)
	ON_COMMAND(ID_EDITMODES_AUTOOBJMEMBER, OnEditmodesAutoobjmember)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_ROTATE, OnUpdateToolsRotate)
	ON_COMMAND(ID_TOOLS_ROTATE, OnToolsRotate)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO_KEEP_VR, OnUpdateEditUndoKeepVr)
	ON_COMMAND(ID_EDIT_UNDO_KEEP_VR, OnEditUndoKeepVr)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_MOVETO, OnUpdateToolsMoveto)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_PROPERTIES, OnUpdateToolsProperties)
	ON_UPDATE_COMMAND_UI(ID_Tools_Neighbours, OnUpdateToolsNeighbours)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_SHADOWRAYTRACER, OnUpdateToolsShadowraytracer)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_LODGEN, OnUpdateToolsLodgen)
	ON_UPDATE_COMMAND_UI(ID_EXPORT_VIS, OnUpdateExportVis)
	ON_UPDATE_COMMAND_UI(ID_EXPORT_TRKVERTICES, OnUpdateExportTrkvertices)
	ON_UPDATE_COMMAND_UI(ID_EXPORT_TEXTURE, OnUpdateExportTexture)
	ON_UPDATE_COMMAND_UI(ID_IMPORT_VIS, OnUpdateImportVis)
	ON_UPDATE_COMMAND_UI(ID_IMPORT_TEXTURE, OnUpdateImportTexture)
	ON_COMMAND(ID_TOOLS_MOVETO, OnToolsMoveto)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_LINE_XY, OnUpdateEditPasteLineXy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_LINE_XYZ, OnUpdateEditPasteLineXyz)
	ON_COMMAND(ID_EDIT_PASTE_LINE_XYZ, OnEditPasteLineXyz)
	ON_COMMAND(ID_EDIT_PASTE_LINE_XY, OnEditPasteLineXy)
	ON_UPDATE_COMMAND_UI(ID_IMPORT_OBJECT, OnUpdateImportObject)
	ON_COMMAND(ID_IMPORT_OBJECT, OnImportObject)
	ON_UPDATE_COMMAND_UI(ID_EXPORT_OBJECT, OnUpdateExportObject)
	ON_COMMAND(ID_EXPORT_OBJECT, OnExportObject)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_INVERT, OnUpdateToolsInvert)
	ON_COMMAND(ID_TOOLS_INVERT, OnToolsInvert)
	ON_UPDATE_COMMAND_UI(ID_FILE_PROPERTIES, OnUpdateFileProperties)
	ON_COMMAND(ID_FILE_PROPERTIES, OnFileProperties)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_VROAD_HEIGHTS_SPDFILES, OnUpdateToolsVroadHeightsSpdfiles)
	ON_COMMAND(ID_TOOLS_VROAD_HEIGHTS_SPDFILES, OnToolsVroadHeightsSpdfiles)
	ON_COMMAND(ID_EDIT_FIND, OnEditFind)
	ON_UPDATE_COMMAND_UI(ID_EDIT_FIND, OnUpdateEditFind)
	ON_UPDATE_COMMAND_UI(ID_EDIT_MERGE, OnUpdateEditMerge)
	ON_COMMAND(ID_EDIT_MERGE, OnEditMerge)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
	ON_UPDATE_COMMAND_UI(ID_SET_VIS, OnUpdateSetVis)
	ON_COMMAND(ID_SET_VIS, OnSetVis)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VISIBILITY, OnUpdateViewVisibility)
	ON_COMMAND(ID_VIEW_VISIBILITY, OnViewVisibility)
	ON_UPDATE_COMMAND_UI(ID_VIS_FW_INCREASE, OnUpdateVisFwIncrease)
	ON_UPDATE_COMMAND_UI(ID_VIS_FW_DECREASE, OnUpdateVisFwDecrease)
	ON_UPDATE_COMMAND_UI(ID_VIS_BW_INCREASE, OnUpdateVisBwIncrease)
	ON_UPDATE_COMMAND_UI(ID_VIS_BW_DECREASE, OnUpdateVisBwDecrease)
	ON_COMMAND(ID_VIS_BW_INCREASE, OnVisBwIncrease)
	ON_COMMAND(ID_VIS_BW_DECREASE, OnVisBwDecrease)
	ON_COMMAND(ID_VIS_FW_INCREASE, OnVisFwIncrease)
	ON_COMMAND(ID_VIS_FW_DECREASE, OnVisFwDecrease)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOMIN3D, OnUpdateTrViewZoomin3d)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOMOUT3D, OnUpdateTrViewZoomout3d)
	ON_COMMAND(ID_TEST, OnTest)
	ON_UPDATE_COMMAND_UI(ID_EXPORT_TEXTUREBLOCK, OnUpdateExportTextureblock)
	ON_COMMAND(ID_EXPORT_TEXTUREBLOCK, OnExportTextureblock)
	ON_UPDATE_COMMAND_UI(ID_IMPORT_TEXTUREBLOCK, OnUpdateImportTextureblock)
	ON_COMMAND(ID_IMPORT_TEXTUREBLOCK, OnImportTextureblock)
	ON_WM_RBUTTONUP()
	ON_UPDATE_COMMAND_UI(ID_EXPORT_OBJECT_W_ZERO, OnUpdateExportObjectWZero)
	ON_COMMAND(ID_EXPORT_OBJECT_W_ZERO, OnExportObjectWZero)
	ON_UPDATE_COMMAND_UI(ID_ALL_TEXTURES, OnUpdateAllTextures)
	ON_COMMAND(ID_ALL_TEXTURES, OnAllTextures)
	ON_COMMAND(ID_EXPANDWHOLETRACK, OnExpandwholetrack)
	ON_UPDATE_COMMAND_UI(ID_EXPANDWHOLETRACK, OnUpdateExpandwholetrack)
	ON_UPDATE_COMMAND_UI(ID_REMAPOBJECTS, OnUpdateRemapobjects)
	ON_COMMAND(ID_REMAPOBJECTS, OnRemapobjects)
	ON_UPDATE_COMMAND_UI(ID_EXPORT_VR_H_SPD, OnUpdateExportVrHSpd)
	ON_COMMAND(ID_EXPORT_VR_H_SPD, OnExportVrHSpd)
	ON_UPDATE_COMMAND_UI(ID_IMPORT_VR_H_SPD, OnUpdateImportVrHSpd)
	ON_COMMAND(ID_IMPORT_VR_H_SPD, OnImportVrHSpd)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWCAMS, OnUpdateViewShowcams)
	ON_COMMAND(ID_VIEW_SHOWCAMS, OnViewShowcams)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_CAMEDIT, OnUpdateToolsCamedit)
	ON_COMMAND(ID_TOOLS_CAMEDIT, OnToolsCamedit)
	ON_COMMAND(ID_PG_DOWN, OnPgDown)
	ON_COMMAND(ID_PG_DOWN_ALT, OnPgDownAlt)
	ON_COMMAND(ID_PG_UP, OnPgUp)
	ON_COMMAND(ID_PG_UP_ALT, OnPgUpAlt)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_PASTE_Z, OnPasteZ)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_Z, OnUpdateEditPasteZ)
	ON_COMMAND(ID_EDIT_PASTE_Z, OnEditPasteZ)
	ON_UPDATE_COMMAND_UI(IDTOOLSDROP, OnUpdateToolsdrop)
	ON_COMMAND(IDTOOLSDROP, OnToolsdrop)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_DROP, OnUpdateToolsDrop)
	ON_COMMAND(ID_TOOLS_DROP, OnToolsDrop)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_ADD_LIGHT, OnUpdateToolsAddLight)
	ON_COMMAND(ID_TOOLS_ADD_LIGHT, OnToolsAddLight)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_ADD_SOUND, OnUpdateToolsAddSound)
	ON_COMMAND(ID_TOOLS_ADD_SOUND, OnToolsAddSound)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SPD_FW, OnUpdateViewSpdFw)
	ON_COMMAND(ID_VIEW_SPD_FW, OnViewSpdFw)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SPD_BW, OnUpdateViewSpdBw)
	ON_COMMAND(ID_VIEW_SPD_BW, OnViewSpdBw)
	ON_COMMAND(ID_VIEW_POLYVROAD, OnViewPolyvroad)
	ON_UPDATE_COMMAND_UI(ID_VIEW_POLYVROAD, OnUpdateViewPolyvroad)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_ADD_FENCE, OnUpdateToolsAddFence)
	ON_COMMAND(ID_TOOLS_ADD_FENCE, OnToolsAddFence)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_ADD_LANE, OnUpdateToolsAddLane)
	ON_COMMAND(ID_TOOLS_ADD_LANE, OnToolsAddLane)
	ON_COMMAND(ID_SHIFT_S, OnShiftS)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BLOCK_DIRECTION, OnUpdateViewBlockDirection)
	ON_COMMAND(ID_VIEW_BLOCK_DIRECTION, OnViewBlockDirection)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHOWHIDETRACKBLOCKS, OnUpdateViewShowhidetrackblocks)
	ON_COMMAND(ID_VIEW_SHOWHIDETRACKBLOCKS, OnViewShowhidetrackblocks)
	ON_UPDATE_COMMAND_UI(ID_MODE_SEL_FROM_CURRENT_BLOCK_ONLY, OnUpdateModeSelFromCurrentBlockOnly)
	ON_COMMAND(ID_MODE_SEL_FROM_CURRENT_BLOCK_ONLY, OnModeSelFromCurrentBlockOnly)
	ON_COMMAND(ID_SCROLL_LOCK, OnScrollLock)
	//ON_UPDATE_COMMAND_UI(ID_FILE_SPEEDSHIFT, OnUpdateFileSpeedshift)
	//ON_COMMAND(ID_FILE_SPEEDSHIFT, OnFileSpeedshift)
	ON_UPDATE_COMMAND_UI(ID_FILE_SPEEDSHIFT0, OnUpdateFileSpeedshift0)
	ON_COMMAND(ID_FILE_SPEEDSHIFT0, OnFileSpeedshift0)
	ON_UPDATE_COMMAND_UI(ID_FILE_SPEEDSHIFT2, OnUpdateFileSpeedshift2)
	ON_COMMAND(ID_FILE_SPEEDSHIFT2, OnFileSpeedshift2)
	ON_UPDATE_COMMAND_UI(ID_FILE_SPEEDSHIFT4, OnUpdateFileSpeedshift4)
	ON_COMMAND(ID_FILE_SPEEDSHIFT4, OnFileSpeedshift4)
	ON_COMMAND(ID_EDIT_PASTE_XY, OnPasteXY)
	ON_COMMAND(ID_VIEW_ZOOMIN3D, OnViewZoomin3d)
	ON_COMMAND(ID_VIEW_ZOOMOUT3D, OnViewZoomout3d)
	ON_UPDATE_COMMAND_UI(ID_FILE_SPEEDSHIFT6, OnUpdateFileSpeedshift6)
	ON_COMMAND(ID_FILE_SPEEDSHIFT6, OnFileSpeedshift6)
	ON_UPDATE_COMMAND_UI(ID_FILE_SPEEDSHIFT8, OnUpdateFileSpeedshift8)
	ON_COMMAND(ID_FILE_SPEEDSHIFT8, OnFileSpeedshift8)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CT3EDView construction/destruction

CT3EDView::CT3EDView()
{
	darkbluePen=new CPen(PS_SOLID,1,RGB(0,0,127));
	bluePen=new CPen(PS_SOLID,1,RGB(121,112,202));
	thickbluePen=new CPen(PS_SOLID,2,RGB(121,112,202));
	thickblue2Pen=new CPen(PS_SOLID,2,RGB(0,128,128));
	thickdarkyellow=new CPen(PS_SOLID,2,RGB(174,166,0));
	//bluePen=new CPen(PS_SOLID,1,RGB(64,88,127));
	lightbluePen=new CPen(PS_SOLID,1,RGB(218,240,250));
	orangePen=new CPen(PS_SOLID,3,RGB(10,96,40));
	redPen=new CPen(PS_SOLID,1,RGB(255,0,0));
	darkgreenPen=new CPen(PS_SOLID,1,RGB(0,127,0));
	greenPen=new CPen(PS_SOLID,1,RGB(80,239,80));
	lightgreenPen=new CPen(PS_SOLID,1,RGB(201,250,201));
	graybluePen=new CPen(PS_SOLID,1,RGB(150,180,217));
	//green2Pen=new CPen(PS_SOLID,1,RGB(32,192,32));
	//green2Pen=new CPen(PS_SOLID,1,RGB(129,40,166));
	green2Pen=new CPen(PS_SOLID,1,RGB(20,177,186));
	brownPen=new CPen(PS_SOLID,1,RGB(127,127,0));
	thickbrownPen=new CPen(PS_SOLID,2,RGB(127,127,0));
	purplePen=new CPen(PS_SOLID,1,RGB(255,64,255));
	grayPen=new CPen (PS_SOLID,1,RGB(225,225,225));
	gray2Pen=new CPen (PS_SOLID,1,RGB(200,200,200));
	blackPen=new CPen (PS_SOLID,2,RGB(0,0,0));
	red2Pen=new CPen(PS_SOLID,2,RGB(127,0,0));
	darkredpen=new CPen(PS_SOLID,1,RGB(150,0,0));
	//darkyellowpen=new CPen(PS_SOLID,1,RGB(150,0,0));
	//thickdarkyellowpen=new CPen(PS_SOLID,2,RGB(75,47,0));
	thickdarkredpen=new CPen(PS_SOLID,2,RGB(150,0,0));
}

CT3EDView::~CT3EDView()
{
	delete darkbluePen;
	delete bluePen;
	delete thickbluePen;
	delete thickdarkyellow;
	delete lightbluePen;
	delete redPen;
	delete darkgreenPen;
	delete greenPen;;
	delete lightgreenPen;
	delete green2Pen;
	delete brownPen;
	delete thickbrownPen;
	delete purplePen;
	delete orangePen;
	delete grayPen;
	delete gray2Pen;
	delete blackPen;
	delete red2Pen;
	delete darkredpen;
	delete thickdarkredpen;
}

BOOL CT3EDView::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style |= WS_HSCROLL|WS_VSCROLL;
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CT3EDView drawing


inline int round(double d)
{
 int lo = d>0 ? (int)d : (int)d-1, hi = lo+1;
 return (d-lo)<(hi-d) ? lo : hi;
}


inline int CT3EDView::FloatX(struct FLOATPT &p)
{ 
	return (int)((p.x*cosPhi-p.y*sinPhi)/scale)+dxoffs; 
	//return 32;
}

inline int CT3EDView::FloatY(struct FLOATPT &p)
{ 
	return (int)(-(p.y*cosPhi*cosTheta+p.x*sinPhi*cosTheta+
										p.z*sinTheta)/scale)+dyoffs;
	//return 1;
}

inline int CT3EDView::Vec3X(vec3 &p)
{ 
	return (int)((p.x*cosPhi-p.y*sinPhi)/scale)+dxoffs; 
	//return 32;
}

inline int CT3EDView::Vec3Y(vec3 &p)
{ 
	return (int)(-(p.y*cosPhi*cosTheta+p.x*sinPhi*cosTheta+
										p.z*sinTheta)/scale)+dyoffs;
	//return 1;
}

inline int CT3EDView::IntX(struct INTPT &p)
{ 
	return (int)((p.x*cosPhi-p.y*sinPhi)/(65536*scale))+dxoffs;
}

inline int CT3EDView::IntY(struct INTPT &p)
{ 
	return (int)(-(p.y*cosPhi*cosTheta+p.x*sinPhi*cosTheta+
						p.z*sinTheta)/(65536*scale))+dyoffs;
}

inline int CT3EDView::FloatFloatX(struct FLOATPT &p,struct FLOATPT &q)
{ 
	return (int)(((p.x+q.x)*cosPhi-(p.y+q.y)*sinPhi)/scale)+dxoffs; 
}

inline int CT3EDView::FloatFloatY(struct FLOATPT &p,struct FLOATPT &q)
{ 
	return (int)(-((p.y+q.y)*cosPhi*cosTheta+(p.x+q.x)*sinPhi*cosTheta+
									(p.z+q.z)*sinTheta)/scale)+dyoffs;
}

BOOL CT3EDView::MeetsClipRect(struct TRKBLOCK *t,LPRECT r)
{
	int x[4],y[4],zsize,i;

	for (i=0;i<=3;i++) { 
		x[i]=FloatX(t->ptBounding[i]);
		y[i]=FloatY(t->ptBounding[i]);
	}
	zsize=(int)(200*sinTheta/scale);
	if ((x[0]<r->left)&&(x[1]<r->left)&&(x[2]<r->left)&&(x[3]<r->left))
		return FALSE;
	if ((x[0]>r->right)&&(x[1]>r->right)&&(x[2]>r->right)&&(x[3]>r->right))
		return FALSE;
	if ((y[0]<r->top-zsize)&&(y[1]<r->top-zsize)&&(y[2]<r->top-zsize)&&(y[3]<r->top-zsize))
		return FALSE;
	if ((y[0]>r->bottom+zsize)&&(y[1]>r->bottom+zsize)&&(y[2]>r->bottom+zsize)&&(y[3]>r->bottom+zsize))
		return FALSE;
	return TRUE;
}

void CT3EDView::NewSel()
{
	if  (((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL)) | 
		(((selMode==ID_MODE_POINT)|(selMode==ID_MODE_EXTPOINT))&&(refnode!=NULL)))
	{
		CSelData *sel=new CSelData;
		sel->multisel=multisel;
		sel->refblock=refblock;
		sel->refchunk=refchunk;
		sel->refpolyobj=refpolyobj;
		sel->refpolyno=refpolyno;
		sel->isxobj=isxobj;
		if (isxobj) sel->xobjrefnode=xobjrefnode;
		sel->refpoly=refpoly;
		sel->refvertices=refvertices;
		if (refnode==&myrefnode) 
		{
			sel->myrefnode.x=myrefnode.x;
			sel->myrefnode.y=myrefnode.y;
			sel->myrefnode.z=myrefnode.z;
			sel->refnode=&(sel->myrefnode);
		} 
		else sel->refnode=refnode;
		//sel->myrefnode=myrefnode;
		multisel=sel;
	}
}

void CT3EDView::ShowSelectionAt(CDC *pDC,int xx,int yy)
{
	CT3EDDoc* pDoc = GetDocument();
	int j,k,l,num;
	int truedx,truedy;
	LPPOLYGONDATA p;
	struct FLOATPT *v;
	struct OBJPOLYBLOCK *o;
	struct XOBJDATA *x;
	struct INTPT pt;
	CSelData *sel;

	dxoffs=xx-(int)((refnode->x*cosPhi-refnode->y*sinPhi)/scale);
	dyoffs=yy+(int)((refnode->y*cosPhi*cosTheta+
	refnode->x*sinPhi*cosTheta+refnode->z*sinTheta)/scale);
	switch(selMode) {
		case ID_MODE_BLOCK:
			if (refblock<pDoc->nBlocks)
			{
				v=pDoc->trk[refblock].vert;
				p=pDoc->poly[refblock].poly[nDetail];
				num=pDoc->poly[refblock].sz[nDetail];
				for (j=0;j<num;j++,p++) {
					pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
					pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
					pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
					pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				}
			}
			break;
		case ID_MODE_EXTPOINT: // might add an extra circle ?
		case ID_MODE_POINT:
			for (sel=this;sel!=NULL;sel=sel->multisel) {
				j=FloatX(*(sel->refnode)); k=FloatY(*(sel->refnode));
				pDC->MoveTo(j-5,k);
				pDC->LineTo(j+5,k);
				pDC->MoveTo(j,k-5);
				pDC->LineTo(j,k+5);
			}
			break;
		case ID_MODE_POLYGON: 
			for (sel=this;sel!=NULL;sel=sel->multisel) {
				if (sel->refpoly==NULL) break;
				truedx=dxoffs; truedy=dyoffs;
				if (sel->isxobj) {
					/*dxoffs=FloatX(*(sel->refnode));
					dyoffs=FloatY(*(sel->refnode));*/
					dxoffs=FloatX(*(sel->xobjrefnode));
					dyoffs=FloatY(*(sel->xobjrefnode));
				}
				pDC->MoveTo(FloatX(sel->refvertices[sel->refpoly->vertex[0]]),
							FloatY(sel->refvertices[sel->refpoly->vertex[0]]));
				pDC->LineTo(FloatX(sel->refvertices[sel->refpoly->vertex[1]]),
							FloatY(sel->refvertices[sel->refpoly->vertex[1]]));
				pDC->LineTo(FloatX(sel->refvertices[sel->refpoly->vertex[2]]),
							FloatY(sel->refvertices[sel->refpoly->vertex[2]]));
				pDC->LineTo(FloatX(sel->refvertices[sel->refpoly->vertex[3]]),
							FloatY(sel->refvertices[sel->refpoly->vertex[3]]));
				pDC->LineTo(FloatX(sel->refvertices[sel->refpoly->vertex[0]]),
							FloatY(sel->refvertices[sel->refpoly->vertex[0]]));
				dxoffs=truedx; dyoffs=truedy;
			}
			break;
		case ID_MODE_VROADEDIT: 
			for (sel=this;sel!=NULL;sel=sel->multisel)
			{
				if (sel->objno<0) break;
							if (sel->isxobj==IS_AI_POINT) {
				int Speed;
				//JimD: Showing Selection at AI Point
				pt=AI_Intpt(sel->objno);
				if (scale<0.15)  //Show Speed?
				{
					if (ShowFwSPD) 
						Speed=pDoc->spdFAbin[sel->objno].Speedvalue;
					else 
						Speed=pDoc->spdRAbin[sel->objno].Speedvalue;
					pDC->MoveTo(IntX(pt),IntY(pt)+Speed/2);
					pDC->LineTo(IntX(pt),IntY(pt)-Speed/2);
				}

				pDC->MoveTo(IntX(pt)-4,IntY(pt)+4);
				pDC->LineTo(IntX(pt)+4,IntY(pt)-4);
				pDC->MoveTo(IntX(pt)-4,IntY(pt)-4);
				pDC->LineTo(IntX(pt)+4,IntY(pt)+4);

				/*pDC->MoveTo(IntX(pt),IntY(pt)+4);
				pDC->LineTo(IntX(pt),IntY(pt)-4);
				pDC->MoveTo(IntX(pt)-4,IntY(pt));
				pDC->LineTo(IntX(pt)+4,IntY(pt));*/

			} else
			//JimD: Showing Selection at VRoad Source
			if (sel->isxobj==IS_VROAD) {
				//draw refpoInts:
				pt.x=pDoc->col.vroad[sel->objno].refPt.x;
				pt.y=pDoc->col.vroad[sel->objno].refPt.y;
				pt.z=pDoc->col.vroad[sel->objno].refPt.z;
				/*pDC->MoveTo(IntX(pt)-5,IntY(pt)+5);
				pDC->LineTo(IntX(pt)+5,IntY(pt)-5);
				pDC->MoveTo(IntX(pt)-5,IntY(pt)-5);
				pDC->LineTo(IntX(pt)+5,IntY(pt)+5);*/

				pDC->MoveTo(IntX(pt)-8,IntY(pt)+8);
				pDC->LineTo(IntX(pt)+8,IntY(pt)-8);
				pDC->MoveTo(IntX(pt)-8,IntY(pt)-8);
				pDC->LineTo(IntX(pt)+8,IntY(pt)+8);

				pDC->MoveTo(IntX(pt),IntY(pt)+8);
				pDC->LineTo(IntX(pt),IntY(pt)-8);
				pDC->MoveTo(IntX(pt)-8,IntY(pt));
				pDC->LineTo(IntX(pt)+8,IntY(pt));

			} 
			}
			break;
		case ID_MODE_OBJECT: 
		  for (sel=this;sel!=NULL;sel=sel->multisel) {
			if (sel->objno<0) break;
			//Nappe1: Showing Selection at Sound Source
			if (sel->isxobj==IS_SOUNDSRC) {
				j=(int)(1/scale);
				k=IntX(pDoc->trk[sel->refblock].soundsrc[sel->objno].refpoint);
				l=IntY(pDoc->trk[sel->refblock].soundsrc[sel->objno].refpoint);
				pDC->MoveTo(k,l);
				pDC->LineTo(k+j+2,l+j+2);
				pDC->MoveTo(k,l);
				pDC->LineTo(k+j+2,l-j-2);
				pDC->LineTo(k+j+2,l+j+2);

				
				pDC->MoveTo(k,l-j);
				pDC->LineTo(k,l+j);
				pDC->LineTo(k-j,l+j);	
				pDC->LineTo(k-j,l-j);
				pDC->LineTo(k,l-j);
			} else
			//ADDITION ENDS
			if (sel->isxobj==IS_LIGHTSRC) {
				j=(int)(1/scale);
				k=IntX(pDoc->trk[sel->refblock].lightsrc[sel->objno].refpoint);
				l=IntY(pDoc->trk[sel->refblock].lightsrc[sel->objno].refpoint);
				pDC->MoveTo(k-j,l-j);
				pDC->LineTo(k+j+1,l+j+1);
				pDC->MoveTo(k-j,l+j);
				pDC->LineTo(k+j+1,l-j-1);
			} else
			if (sel->isxobj==IS_CAM) {
				j=(int)(1/scale);
				k=FloatX(pDoc->Camfile.pCamData[sel->objno].CamPosition);
				l=FloatY(pDoc->Camfile.pCamData[sel->objno].CamPosition);
				pDC->MoveTo(k-j*2,l);
				pDC->LineTo(k-j*2,l-j*3);
				pDC->LineTo(k+j*2,l-j*3);
				pDC->LineTo(k+j*2,l);
				pDC->LineTo(k-j*2,l);

				pDC->MoveTo(k+j*2,l-j*2);
				pDC->LineTo(k+j*4,l-j*3);
				pDC->LineTo(k+j*4,l);
				pDC->LineTo(k+j*2,l-j);

				pDC->MoveTo(k-j*2,l+j*3);
				pDC->LineTo(k,l);
				pDC->LineTo(k+j*2,l+j*3);
			} else
				if (sel->isxobj==1) { //Show selected Extra Object
				truedx=dxoffs; truedy=dyoffs;
				x=pDoc->xobj[4*sel->refblock+sel->refchunk].obj+sel->objno;
				dxoffs=FloatX(x->ptRef); dyoffs=FloatY(x->ptRef);
				v=x->vert;
				p=x->polyData;
				for (k=0;k<x->nPolygons;k++,p++) {
					pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
					pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
					pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
					pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				}
				if (x->crosstype==3) //Animated object
				{
					/*vec3 v;
					struct FLOATPT pt;
					dxoffs=0; dyoffs=0;
					for (i=0;i<x->nAnimLength;i++)
					{
						v=x->animData[i].pt;
						pt.x=v.x; pt.y=v.y; pt.z=v.z;
						if (i==0) pDC->MoveTo(FloatX(pt),FloatY(pt));
						else pDC->LineTo(FloatX(pt),FloatY(pt));
					}*/
				}
				dxoffs=truedx; dyoffs=truedy;
			} else if (sel->isxobj==0) {
				v=pDoc->trk[sel->refblock].vert;
				o=&(pDoc->poly[sel->refblock].obj[sel->refchunk]);
				p=o->poly[sel->objno];
				num=o->numpoly[sel->objno];
				for (l=0;l<num;l++,p++) {
					pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
					pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
					pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
					pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					// Draw Normals:
					FLOATPT center, QuadN; 
					center.x = (v[p->vertex[0]].x + v[p->vertex[1]].x + v[p->vertex[2]].x + v[p->vertex[3]].x) / 4;
					center.y = (v[p->vertex[0]].y + v[p->vertex[1]].y + v[p->vertex[2]].y + v[p->vertex[3]].y) / 4;
					center.z = (v[p->vertex[0]].z + v[p->vertex[1]].z + v[p->vertex[2]].z + v[p->vertex[3]].z) / 4;
					
					QuadN = pDoc->QuadNormalVectorCalc(v[p->vertex[0]],v[p->vertex[1]],v[p->vertex[2]],v[p->vertex[3]]);
					QuadN.x = QuadN.x+center.x;
					QuadN.y = QuadN.y+center.y;
					QuadN.z = QuadN.z+center.z;

					pDC->MoveTo(FloatX(center),FloatY(center));
					pDC->LineTo(FloatX(QuadN),FloatY(QuadN));

				}
			}
		  }
			break;
	}
}

void CT3EDView::ShowHideCursor()
{
	CDC *dc;

	if (!isDragging) return;
	dc=GetDC();
	dc->SelectObject(redPen);
	dc->SetROP2(R2_NOTXORPEN);
	ShowSelectionAt(dc,dragX,dragY);
	ReleaseDC(dc);
}

void CT3EDView::OnDraw(CDC* pDC)
{
	CT3EDDoc* pDoc = GetDocument();
	RECT rect;
	int i,j,k=0,l,m,num, blk, start, stop, TrackViewBl;
	int truedx,truedy;
	LPPOLYGONDATA p;
	struct FLOATPT *v, fpt;
	struct OBJPOLYBLOCK *o;
	struct XOBJDATA *x;
	struct LIGHTSRC *light;
	vec3 pt0, pt1, pt2, pt3, pt4, ptm, ptd;
	bool ScrollKey=(GetKeyState(VK_SCROLL) & 0x0001);

	HPEN pen;

	//struct INTPT ipt;

	ASSERT_VALID(pDoc);
	if (pDoc->bEmpty) return;

	TrackViewBl=refblock; //Used for based on visibility, because if refblock is global it has no visibility information
	if (TrackViewBl==pDoc->nBlocks)
		TrackViewBl=pDoc->FindNearestBlock(refnode);

	GetClientRect(&rect);
	dxoffs=rect.right/2-offsetx
			  -(int)((refnode->x*cosPhi-refnode->y*sinPhi)/scale);
	dyoffs=rect.bottom/2-offsety+(int)((refnode->y*cosPhi*cosTheta+
				refnode->x*sinPhi*cosTheta+refnode->z*sinTheta)/scale);
	pDC->GetClipBox(&rect);

	// remove the cursor to avoid interference
	if (isDragging) {
		pDC->SetROP2(R2_WHITE);
		ShowSelectionAt(pDC,dragX,dragY);
		pDC->SetROP2(R2_COPYPEN);
	}

	///////////////////////////////////////////////////////////////////////////////////////////
	// Draw passable and driveable road map (by COL XBID15 info)
	///////////////////////////////////////////////////////////////////////////////////////////

	if (DrawVRoadBitMap && bShowTrackBlocks) OnDrawVRoadBitMap(pDC);
	if (DrawBlkDirection) OnDrawBlkDirection(pDC);


// CHECK VROAD
/*	pDC->SelectObject(redPen);
	for (i=0;i<pDoc->nBlocks;i++) {
		if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
		v=pDoc->trk[i].vert;
		p=pDoc->poly[i].poly[4];
		num=pDoc->poly[i].sz[4];
		for (j=0;j<num;j++,p++) {
			struct FLOATPT pt;
			pt.x=(v[p->vertex[0]].x+v[p->vertex[2]].x)/2;
			pt.z=(v[p->vertex[0]].z+v[p->vertex[2]].z)/2;
			pt.y=(v[p->vertex[0]].y+v[p->vertex[2]].y)/2;
			pDC->MoveTo(FloatX(pt),FloatY(pt));
			pt.x+=pDoc->trk[i].vroadData[j].xForw/6000.0;
			pt.z+=pDoc->trk[i].vroadData[j].zForw/6000.0;
			pt.y+=pDoc->trk[i].vroadData[j].yForw/6000.0;
			pDC->LineTo(FloatX(pt),FloatY(pt));
		}
	}
*/
	/*if (bShowObjects) {
		pDC->SelectObject(bluePen);
		for (i=0;i<pDoc->nBlocks;i++) {
			if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
			v=pDoc->trk[i].vert;
			for (j=0;j<4;j++) {
				o=&(pDoc->poly[i].obj[j]);
				if (o->n1==0) continue;
				for (k=0;k<o->nobj;k++) {
					p=o->poly[k];
					num=o->numpoly[k];
					for (l=0;l<num;l++,p++) {
			pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
			pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
			pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
			pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					}
				}
			}
		}
		pDC->SelectObject(greenPen);
		truedx=dxoffs; truedy=dyoffs;
		for (i=0;i<4*pDoc->nBlocks;i++) {
			if (!MeetsClipRect(&(pDoc->trk[i/4]),&rect)) { i=i|3; continue; }
			x=pDoc->xobj[i].obj;
			for (j=0;j<pDoc->xobj[i].nobj;j++,x++) {
				dxoffs=FloatX(x->ptRef); dyoffs=FloatY(x->ptRef);
				v=x->vert;
				p=x->polyData;
				for (k=0;k<x->nPolygons;k++,p++) {
			pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
			pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
			pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
			pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				}
				dxoffs=truedx; dyoffs=truedy;
			}
		}
	}*/

/* a glimpse at the vroad...
	pDC->SelectObject(greenPen);
	for (i=0;i<pDoc->col.vroadHead.nrec;i++) {
		struct INTPT pt;
		pt.x=pDoc->col.vroad[i].refPt.x-pDoc->col.vroad[i].right.x*(pDoc->col.vroad[i].leftWall/128);
		pt.y=pDoc->col.vroad[i].refPt.y-pDoc->col.vroad[i].right.y*(pDoc->col.vroad[i].leftWall/128);
		pt.z=pDoc->col.vroad[i].refPt.z-pDoc->col.vroad[i].right.z*(pDoc->col.vroad[i].leftWall/128);
		pDC->MoveTo(IntX(pt),IntY(pt));
		pt.x=pDoc->col.vroad[i].refPt.x+pDoc->col.vroad[i].right.x*(pDoc->col.vroad[i].rightWall/128);
		pt.y=pDoc->col.vroad[i].refPt.y+pDoc->col.vroad[i].right.y*(pDoc->col.vroad[i].rightWall/128);
		pt.z=pDoc->col.vroad[i].refPt.z+pDoc->col.vroad[i].right.z*(pDoc->col.vroad[i].rightWall/128);
		pDC->LineTo(IntX(pt),IntY(pt));
	}
*/
/* or at the bounding rectangles...
	pDC->SelectObject(brownPen);
	for (i=0;i<pDoc->nBlocks;i++) {
		// pDoc->RecalcBoundingBox(i);
		pDC->MoveTo(FloatX(pDoc->trk[i].ptBounding[0]),FloatY(pDoc->trk[i].ptBounding[0]));
		pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[1]),FloatY(pDoc->trk[i].ptBounding[1]));
		pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[2]),FloatY(pDoc->trk[i].ptBounding[2]));
		pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[3]),FloatY(pDoc->trk[i].ptBounding[3]));
		pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[0]),FloatY(pDoc->trk[i].ptBounding[0]));
	}
	pDC->SelectObject(redPen);
	i=refblock;
	pDC->MoveTo(FloatX(pDoc->trk[i].ptBounding[0]),FloatY(pDoc->trk[i].ptBounding[0]));
	pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[1]),FloatY(pDoc->trk[i].ptBounding[1]));
	pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[2]),FloatY(pDoc->trk[i].ptBounding[2]));
	pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[3]),FloatY(pDoc->trk[i].ptBounding[3]));
	pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[0]),FloatY(pDoc->trk[i].ptBounding[0]));
*/
/* or at the first polyobj chunk refpositions
	pDC->SelectObject(brownPen);
	for (i=0;i<pDoc->nBlocks;i++)
		for (j=0;j<pDoc->trk[i].nPolyobj;j++) {
			pDC->MoveTo(IntX(pDoc->trk[i].polyobj[j]->pt)-5,IntY(pDoc->trk[i].polyobj[j]->pt));
			pDC->LineTo(IntX(pDoc->trk[i].polyobj[j]->pt)+5,IntY(pDoc->trk[i].polyobj[j]->pt));
			pDC->MoveTo(IntX(pDoc->trk[i].polyobj[j]->pt),IntY(pDoc->trk[i].polyobj[j]->pt)-5);
			pDC->LineTo(IntX(pDoc->trk[i].polyobj[j]->pt),IntY(pDoc->trk[i].polyobj[j]->pt)+5);
		}	
*/
	// selection highlighting
	/*GetClientRect(&rect);
	pDC->SelectObject(redPen);
	ShowSelectionAt(pDC,rect.right/2-offsetx,rect.bottom/2-offsety);

	// dragging cursor, using redPen in xor mode
	if (isDragging) {
		pDC->SetROP2(R2_NOTXORPEN);
		ShowSelectionAt(pDC,dragX,dragY);
	}*/















/*OAOAOAOAOAOOAOOAOAOAOAOOAOAOAOAOAOAOAOOAOAOAOAOOAOAOAOAOAOOAOAOAOOAOAOAOAOOAOAOAO */



/*
	CT3EDDoc* pDoc = GetDocument();
	RECT rect;*/
	
	struct POLYVROADDATA *t;
	/*int i,j,k,l,m,num, kk;
	int truedx,truedy;
	LPPOLYGONDATA p;
	struct FLOATPT *v;
	struct OBJPOLYBLOCK *o;
	struct XOBJDATA *x;
	struct LIGHTSRC *light;*/
	struct SOUNDSRC *sound;
	//static CBitmap *G_bitmap; // = NULL;*/
	bool RoadBoundaryFlagShowed;	
	
	
/*
	
	ASSERT_VALID(pDoc);
	if (pDoc->bEmpty) return; */

	
	GetClientRect(&rect);
	dxoffs=rect.right/2-offsetx
			  -(int)((refnode->x*cosPhi-refnode->y*sinPhi)/scale);
	dyoffs=rect.bottom/2-offsety+(int)((refnode->y*cosPhi*cosTheta+
				refnode->x*sinPhi*cosTheta+refnode->z*sinTheta)/scale);
	pDC->GetClipBox(&rect);
	
	// remove the cursor to avoid interference
	if (isDragging) {
		pDC->SetROP2(R2_WHITE);
		ShowSelectionAt(pDC,dragX,dragY);
		pDC->SetROP2(R2_COPYPEN);
	}

	
	if (bShowLanes) {//Draw lanes
		pDC->SelectObject(brownPen);
		for (i=0;i<pDoc->nBlocks;i++) {
			if (ScrollKey && (i!=TrackViewBl)) continue; //Scroll Lock active ? Then show only from current block
			if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
			if ((ShowBasedOnVisi==true)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) continue;
			v=pDoc->trk[i].vert;
			p=pDoc->poly[i].poly[6];
			num=pDoc->poly[i].sz[6];
			for (j=0;j<num;j++,p++) {
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			}
		}
	}

	if (bShowTrackBlocks) {//Draw fences
		pDC->SelectObject(brownPen);
		for (i=0;i<pDoc->nBlocks;i++) {
			if (ScrollKey && (i!=TrackViewBl)) continue; //Scroll Lock active ? Then show only from current block
			if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
			if ((ShowBasedOnVisi==true)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) continue;
			v=pDoc->trk[i].vert;
			p=pDoc->poly[i].poly[nDetail+1];
			num=pDoc->poly[i].sz[nDetail+1];
			for (j=0;j<num;j++,p++) {
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			}
		}
	}	
	/*CDC memDC; 
	if (G_bitmap == NULL)
	{
		G_bitmap = new CBitmap();
		if (G_bitmap->LoadBitmap("IDB_BACKIMAGE"))
		{
			MessageBox("Failed to load bitmap", "ALERT", MB_ICONERROR);
		}	 
	}
	memDC.SelectObject(&G_bitmap);
	memDC.CreateCompatibleDC(pDC); 
	
	//CPoint point(rect.left, rect.top);
	//CSize *cSize = new CSize(rect.right,rect.bottom);
	//point.Offset(100, 100);
	
	pDC->SelectStockObject(BLACK_PEN);
	if (pDC->BitBlt(rect.left,rect.top,150,150,&memDC,0,0,SRCCOPY)==false) 
		MessageBox("tll taas!", "ALERT", MB_ICONERROR);
		
	MessageBox("tll!", "ALERT", MB_ICONERROR);
	//pDC->DrawState(point, *cSize, *G_bitmap, DST_BITMAP, NULL); */

	
	
	 
	for (i=0;i<pDoc->nBlocks;i++) { 

		//Draw hs_ptMin,hs_ptMax when BlkHighlight for selected block
		if ((i==refblock)&&(BlkHighlight==true)&&bShowTrackBlocks)
		{
			if (pDoc->bHSMode)
			{
				pDC->SelectObject(thickbluePen);
				fpt=pDoc->trk[i].hs_ptMax;
				//Draw an "M" for hs_ptMax
				pDC->MoveTo(FloatX(fpt)-5,FloatY(fpt)+5);
				pDC->LineTo(FloatX(fpt)-5,FloatY(fpt)-5);
				pDC->LineTo(FloatX(fpt),FloatY(fpt));
				pDC->LineTo(FloatX(fpt)+5,FloatY(fpt)-5);
				pDC->LineTo(FloatX(fpt)+5,FloatY(fpt)+5);


				pDC->SelectObject(thickblue2Pen);
				fpt=pDoc->trk[i].hs_ptMin;
				//Draw an "M" for hs_ptMin
				pDC->MoveTo(FloatX(fpt)-5,FloatY(fpt)+5);
				pDC->LineTo(FloatX(fpt)-5,FloatY(fpt)-5);
				pDC->LineTo(FloatX(fpt),FloatY(fpt));
				pDC->LineTo(FloatX(fpt)+5,FloatY(fpt)-5);
				pDC->LineTo(FloatX(fpt)+5,FloatY(fpt)+5);
			}

			//Draw the 4 ptBounding
			pDC->SelectObject(thickdarkyellow);
			for (j=0;j<4;j++)
			{
				fpt=pDoc->trk[i].ptBounding[j];
				//Draw an "E" for Edges of ptBounding
				pDC->MoveTo(FloatX(fpt)+5,FloatY(fpt)-5); //Top , right
				pDC->LineTo(FloatX(fpt),FloatY(fpt)-5);   //Top , left
				pDC->LineTo(FloatX(fpt),FloatY(fpt)+5);	  //Down, left
				pDC->LineTo(FloatX(fpt)+5,FloatY(fpt)+5); //Down, right
				pDC->MoveTo(FloatX(fpt),FloatY(fpt));  //Middle Left
				pDC->LineTo(FloatX(fpt)+3,FloatY(fpt)); //Middle, short right

			}
		}

		//Draw Block Polygons
		t=pDoc->trk[i].polyData+j;
		if (!bShowTrackBlocks) continue;
		if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
		v=pDoc->trk[i].vert;
		p=pDoc->poly[i].poly[nDetail];
		num=pDoc->poly[i].sz[nDetail];

		if  ((BlkHighlight==true)&&(i == refblock))
			pDC->SelectObject(blackPen); //Thick black pen
		else
			if (ShowBasedOnVisi==true) //Decide which BlackPen?
				if (pDoc->IsBlockVisibile(TrackViewBl,i))
					pDC->SelectStockObject(BLACK_PEN); //Normal black pen
				else
					pDC->SelectObject(gray2Pen);  //Grey pen for non visible blocks
			else //No based on Visibility
				pDC->SelectStockObject(BLACK_PEN); //Normal black pen

		if (ScrollKey && (i!=TrackViewBl)) pDC->SelectObject(gray2Pen); //Scroll Lock active and not Refblock? Then use Grey pen
		
		for (j=0;j<num;j++,p++) {

			pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
			pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
			
			pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
			pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
		
		}
		v=pDoc->trk[i].vert;
		p=pDoc->poly[i].poly[nDetail];
		num=pDoc->poly[i].sz[nDetail];
		ptd.x=2;ptd.y=2;ptd.z=2; //For vec3 point middle calculation
		//kk=0;
		for (j=0;j<num;j++,p++) {
			if (ScrollKey && (i!=TrackViewBl)) continue; //Scroll Lock active ? Then show only from current block
			if ((ShowBasedOnVisi==true)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) continue;
			t=pDoc->trk[i].polyData+j;
			if (DrawVRB == true)  RoadBoundaryFlagShowed=(bool) ((t->flags & 0x80) != 0); //Nappe1: adding more felxibility to Poly color coding
			if (DrawVRE == true)  RoadBoundaryFlagShowed=(bool) (t->virtualroadedge==true);
			
			//else RoadBoundaryFlagShowed=false;
			//if ((t->flags  & 0x80) && (DrawFlags==true)) {
			if ((DrawNonPass==true) && (DrawFlags==true))
				if ((t->flags&0x0f)%14 == 0)
			{
				pDC->SelectObject(red2Pen);
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]])); 
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			}
			if ((DrawVRB == true) && (DrawFlags==true) && (scale<0.5) && ((t->flags&0x0f)%14!=0)) //JimD: No Left, Right, Forward or Backward Neighbour
			{
				if (!pDoc->IsBlockNeighbor(TrackViewBl,i)&&(ShowBasedOnVisi==false)) continue;

					pt0=v[p->vertex[0]];
					pt1=v[p->vertex[1]];
					pt2=v[p->vertex[2]];
					pt3=v[p->vertex[3]];
					ptm=(pt0 + pt2) / ptd;
					
				if (pDoc->bHSMode && (t->hs_orphan[0]>0))   //No forward neighbour
				{

					pDC->SelectObject(darkgreenPen);
					pt4=(pt0 + pt1) / ptd;
					
					pDC->MoveTo(FloatX(pDoc->Vec3ToFloatpt(ptm)),FloatY(pDoc->Vec3ToFloatpt(ptm)));
					pDC->LineTo(FloatX(pDoc->Vec3ToFloatpt(pt4)),FloatY(pDoc->Vec3ToFloatpt(pt4)));

				}

				if (pDoc->bHSMode && (t->hs_orphan[1]>0))  //No left neighbour
				{

					pDC->SelectObject(darkgreenPen);
					pt4=(pt0 + pt3) / ptd;
					
					pDC->MoveTo(FloatX(pDoc->Vec3ToFloatpt(ptm)),FloatY(pDoc->Vec3ToFloatpt(ptm)));
					pDC->LineTo(FloatX(pDoc->Vec3ToFloatpt(pt4)),FloatY(pDoc->Vec3ToFloatpt(pt4)));

				}
				if (pDoc->bHSMode && (t->hs_orphan[2]>0))  //No back neighbour
				{

					pDC->SelectObject(darkgreenPen);
					pt4=(pt2 + pt3) / ptd;
					
					pDC->MoveTo(FloatX(pDoc->Vec3ToFloatpt(ptm)),FloatY(pDoc->Vec3ToFloatpt(ptm)));
					pDC->LineTo(FloatX(pDoc->Vec3ToFloatpt(pt4)),FloatY(pDoc->Vec3ToFloatpt(pt4)));

				}
				if (pDoc->bHSMode && (t->hs_orphan[3]>0))  //No right neighbour
				{

					pDC->SelectObject(darkgreenPen);
					pt4=(pt1 + pt2) / ptd;
					
					pDC->MoveTo(FloatX(pDoc->Vec3ToFloatpt(ptm)),FloatY(pDoc->Vec3ToFloatpt(ptm)));
					pDC->LineTo(FloatX(pDoc->Vec3ToFloatpt(pt4)),FloatY(pDoc->Vec3ToFloatpt(pt4)));

				}
				if ((t->flags&0x40)!=0) //Xobj Detection
				{
					pt4=(pt0 + pt1) / ptd;
					pt4=(pt4 + ptm) / ptd;
					fpt=pDoc->Vec3ToFloatpt(pt4);
					m=(int)(0.5/scale);

					pDC->SelectObject(red2Pen);
					pDC->MoveTo(FloatX(fpt)+m,FloatY(fpt)-m); //Top , right
					pDC->LineTo(FloatX(fpt),FloatY(fpt)-m);   //Top , left
					pDC->LineTo(FloatX(fpt),FloatY(fpt)+m);	  //Down, left
					pDC->LineTo(FloatX(fpt)+m,FloatY(fpt)+m); //Down, right
					pDC->MoveTo(FloatX(fpt),FloatY(fpt));  //Middle Left
					pDC->LineTo((int) (FloatX(fpt)+m*0.5), FloatY(fpt)); //Middle, short right

				}

			}
			
			if ((RoadBoundaryFlagShowed==true) && (DrawFlags==true)) {
				if (DrawNonPass==true) 
					pDC->SelectObject(red2Pen);
				if (BlkHighlight==true)
					if (i==refblock)
							pDC->SelectObject(orangePen);
					else
							pDC->SelectObject(grayPen);
				else	
					pDC->SelectObject(orangePen);

				/*if (i==177) 
					MessageBox("draw stop");*/
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]])); 
				if (t->hs_orphan[0]!=0)
					pDC->SelectObject(red2Pen);
				else
					pDC->SelectObject(orangePen);
			
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				if (t->hs_orphan[3]!=0)
					pDC->SelectObject(red2Pen);
				else
					pDC->SelectObject(orangePen);
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				/*if (i==177) 
					MessageBox("draw stop");*/
				if (t->hs_orphan[2]!=0)
					pDC->SelectObject(red2Pen);
				else
					pDC->SelectObject(orangePen);
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
				if (t->hs_orphan[1]!=0)
					pDC->SelectObject(red2Pen);
				else
					pDC->SelectObject(orangePen);
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			}
		}
	}
	//DRAW Axis:
	/*struct FLOATPT Axis1;
	Axis1.x=-1000;
	Axis1.y=0;
	Axis1.z=0;
	struct FLOATPT Axis2;
	Axis2.x=1000;
	Axis2.y=0;
	Axis2.z=0;
	

	pDC->SelectObject(red2Pen);
	pDC->MoveTo(FloatX(Axis1),FloatY(Axis1));
	pDC->LineTo(FloatX(Axis2),FloatY(Axis2));
	Axis1.x=0;
	Axis1.y=-1000;
	Axis1.z=0;

	Axis2.x=0;
	Axis2.y=1000;
	Axis2.z=0;
	pDC->SelectObject(orangePen);
	pDC->MoveTo(FloatX(Axis1),FloatY(Axis1));
	pDC->LineTo(FloatX(Axis2),FloatY(Axis2));
	Axis1.x=0;
	Axis1.y=0;
	Axis1.z=-1000;

	Axis2.x=0;
	Axis2.y=0;
	Axis2.z=1000;

	pDC->SelectObject(redPen);
	pDC->MoveTo(FloatX(Axis1),FloatY(Axis1));
	pDC->LineTo(FloatX(Axis2),FloatY(Axis2));*/


// HAVING A LOOK AT POLYGON FLAGS : impassability
/*
	pDC->SelectObject(redPen);
	for (i=0;i<pDoc->nBlocks;i++) {
		if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
		v=pDoc->trk[i].vert;
		p=pDoc->poly[i].poly[nDetail];
		num=pDoc->poly[i].sz[nDetail];
		for (j=0;j<num;j++,p++)
			if ((pDoc->trk[i].polyData[j].unknownFlags&0xF)%14==0) {
			 pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			 pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
			 pDC->MoveTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
			 pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
		}
	}
*/

// CHECK VROAD
	if (DrawPolyVRoad)
	{
		pDC->SelectObject(graybluePen);
		for (i=0;i<pDoc->nBlocks;i++) 
		{
			if (ScrollKey && (i!=TrackViewBl)) continue; //Scroll Lock active ? Then show only from current block
			if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
			if ((ShowBasedOnVisi==true)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) continue;
			if (!pDoc->IsBlockNeighbor(TrackViewBl,i)&&(ShowBasedOnVisi==false)) continue;
			v=pDoc->trk[i].vert;
			p=pDoc->poly[i].poly[4];
			num=pDoc->poly[i].sz[4];
			for (j=0;j<num;j++,p++) {
				struct FLOATPT pt;
				//Center of polygom
				pt.x=(v[p->vertex[0]].x + v[p->vertex[2]].x)/2;
				pt.z=(v[p->vertex[0]].z + v[p->vertex[2]].z)/2;
				pt.y=(v[p->vertex[0]].y + v[p->vertex[2]].y)/2;
				pDC->MoveTo(FloatX(pt),FloatY(pt));
				//Line to Forward Poly VRoad Direction
				pt.x+=pDoc->trk[i].vroadData[j].xForw/(float) 10000.0;
				pt.z+=pDoc->trk[i].vroadData[j].zForw/(float) 10000.0;
				pt.y+=pDoc->trk[i].vroadData[j].yForw/(float) 10000.0;
				pDC->LineTo(FloatX(pt),FloatY(pt));
			}
		}
	}

	if ((bShowCams) && (scale<0.75))//Draw Replay Cameras
	{
		pDC->SelectObject(purplePen);
		m=(int)(1/scale);
		for (i=0;i<pDoc->Camfile.nCams;i++)
		{
			k=FloatX(pDoc->Camfile.pCamData[i].CamPosition);
			l=FloatY(pDoc->Camfile.pCamData[i].CamPosition);

			pDC->MoveTo(k-m*2,l);
			pDC->LineTo(k-m*2,l-m*3);
			pDC->LineTo(k+m*2,l-m*3);
			pDC->LineTo(k+m*2,l);
			pDC->LineTo(k-m*2,l);

			pDC->MoveTo(k+m*2,l-m*2);
			pDC->LineTo(k+m*4,l-m*3);
			pDC->LineTo(k+m*4,l);
			pDC->LineTo(k+m*2,l-m);

			pDC->MoveTo(k-m*2,l+m*3);
			pDC->LineTo(k,l);
			pDC->LineTo(k+m*2,l+m*3);

		}
		if ((isxobj==5)&&(objno>-1))  //Show viewing line of camera
		{
			k=0;
			start=pDoc->Camfile.pCamData[objno].Start;
			stop=pDoc->RealSliceNum(pDoc->Camfile.pCamData[objno].Stop +1);
			//pen = CreatePen(PS_SOLID, 5, RGB(196,0,0));
			pen = CreatePen(PS_SOLID, 5, RGB(106,204,221));
			pDC->SelectObject(pen);
			i=start;
			while (i!=stop)
			{
				if ((k==0)&&(i<pDoc->col.vroadHead.nrec))
				{
					pDC->MoveTo(IntX(pDoc->col.vroad[i].refPt), IntY(pDoc->col.vroad[i].refPt));
					k=1;
				}
				else if ((k==1)&&(i<pDoc->col.vroadHead.nrec))
				{
					pDC->LineTo(IntX(pDoc->col.vroad[i].refPt), IntY(pDoc->col.vroad[i].refPt));
				}
				i++;
				i=pDoc->RealSliceNum(i);
			}
			DeleteObject(pen);
		}
	}

	if (bShowObjects) {
		pDC->SelectObject(brownPen);
		for (i=0;i<pDoc->nBlocks;i++) {
			if (ScrollKey && (i!=TrackViewBl)) continue; //Scroll Lock active ? Then show only from current block
			if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
			if ((ShowBasedOnVisi==true)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) continue; // Don't draw if in "Show Based On Visibility" mode, if not visible
			// show light sources
			light=pDoc->trk[i].lightsrc;
			m=(int)(1/scale);
			pDC->SelectObject(brownPen);
			for (j=0;j<pDoc->trk[i].nLightsrc;j++,light++) {
				k=IntX(light->refpoint);
				l=IntY(light->refpoint);
				pDC->MoveTo(k-m,l-m);
				pDC->LineTo(k+m+1,l+m+1);
				pDC->MoveTo(k-m,l+m);
				pDC->LineTo(k+m+1,l-m-1);
			}
				// Nappe1: show sound sources
			pDC->SelectObject(purplePen);
			sound=pDoc->trk[i].soundsrc;
			m=(int)(1/scale);
			for (j=0;j<pDoc->trk[i].nSoundsrc;j++,sound++) {
				k=IntX(sound->refpoint);
				l=IntY(sound->refpoint);
				
				pDC->MoveTo(k,l);
				pDC->LineTo(k+m+2,l+m+2);
				pDC->MoveTo(k,l);
				pDC->LineTo(k+m+2,l-m-2);
				pDC->LineTo(k+m+2,l+m+2);

				
				pDC->MoveTo(k,l-m);
				pDC->LineTo(k,l+m);
				pDC->LineTo(k-m,l+m);	
				pDC->LineTo(k-m,l-m);
				pDC->LineTo(k,l-m);
			}
		}
		//pDC->SelectObject(bluePen);
		for (i=0;i<pDoc->nBlocks;i++) {
			if (ScrollKey && (i!=TrackViewBl)) continue; //Scroll Lock active ? Then show only from current block
			if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
			if (ShowBasedOnVisi==true)
				if (i==refblock)
					pDC->SelectObject(bluePen); // Object color for selected block
				else
					if (pDoc->IsBlockVisibile(TrackViewBl,i))
						pDC->SelectObject(darkbluePen); // Object color for visbile not not selected blocks
					else
						continue; //Don't draw objects on non visible blocks. Old: pDC->SelectObject(lightbluePen);
			else pDC->SelectObject(darkbluePen);

			v=pDoc->trk[i].vert;
			for (j=0;j<4;j++) {
				o=&(pDoc->poly[i].obj[j]);
				if (o->n1==0) continue;
				for (k=0;k<o->nobj;k++) {
					p=o->poly[k];
					num=o->numpoly[k];
					for (l=0;l<num;l++,p++) {
			pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
			pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
			pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
			pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					}
				}
			}
		}
		
		 // Draw XOBJ
		//pDC->SelectObject(greenPen);

		truedx=dxoffs; truedy=dyoffs;
		for (i=0;i<4*pDoc->nBlocks;i++) {
			if (ScrollKey && (int(i/4)!=TrackViewBl)) continue; //Scroll Lock active ? Then show only from current block
			if (ShowBasedOnVisi==true)
			{
				if (!pDoc->IsBlockVisibile(TrackViewBl,int(i/4))) continue; //Based on visibility mode, but not visible block -> don't draw extra objects
				if ((BlkHighlight)&&(int(i/4)==refblock)) //Block highlight and refblock?
					pDC->SelectObject(greenPen); // Color for extra objects on selected block
				else
					pDC->SelectObject(darkgreenPen); //Extra object color for visbile but not selected blocks
			}
			else pDC->SelectObject(darkgreenPen);

			if (!MeetsClipRect(&(pDoc->trk[i/4]),&rect)) { i=i|3; continue; }
			x=pDoc->xobj[i].obj;
			for (j=0;j<pDoc->xobj[i].nobj;j++,x++) {
				dxoffs=FloatX(x->ptRef); dyoffs=FloatY(x->ptRef);
				v=x->vert;
				p=x->polyData;
				for (k=0;k<x->nPolygons;k++,p++) {
			pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
			pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
			pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
			pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
			pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				}
				dxoffs=truedx; dyoffs=truedy;
			}
		}
	}

	// JimD : Draw global xobj
	if (!ScrollKey | (refblock==pDoc->nBlocks))
		for (i=0;i<2;i++) //Two global object chunks!
		{
			pDC->SelectObject(green2Pen);
			struct XOBJBLOCK *xb;
			xb=&(pDoc->xobj[4*pDoc->nBlocks +i]);
			if (xb->nobj>0)
			{
			  truedx=dxoffs; truedy=dyoffs;
			  x=xb->obj;
			  for (j=0;j<xb->nobj;j++,x++) 
			  {
				if (j>0) {
					v=x->vert;
				  }
				dxoffs=truedx; dyoffs=truedy;
				dxoffs=FloatX(x->ptRef); dyoffs=FloatY(x->ptRef);
				v=x->vert;
				p=x->polyData;
				for (k=0;k<x->nPolygons;k++,p++) 
				{
					pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
					pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
					pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
					pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				}
			 }
			dxoffs=truedx; dyoffs=truedy;
			}
		}

// a glimpse at the vroad...
//Nappe1: added option to show virtual road (Denis  originally used this when 
//		  he was beta testing HS File Formats.)
//begin
	if (DrawVRoad==TRUE) 
	{
		int Speed;
		//Get Original dx/dy-offs again
		/*dxoffs=rect.right/2-offsetx
			  -(int)((refnode->x*cosPhi-refnode->y*sinPhi)/scale);
		dyoffs=rect.bottom/2-offsety+(int)((refnode->y*cosPhi*cosTheta+
				refnode->x*sinPhi*cosTheta+refnode->z*sinTheta)/scale);*/
		for (blk=0;blk<pDoc->nBlocks;blk++)
		{
			if (ScrollKey && (blk!=TrackViewBl)) continue; //Scroll Lock active ? Then show only from current block
			if ((ShowBasedOnVisi==true)&&(!pDoc->IsBlockVisibile(TrackViewBl,blk))) continue; // Don't draw if in "Show Based On Visibility" mode, if not visible
			//for (i=0;i<pDoc->col.vroadHead.nrec;i++) {	
			for (i=pDoc->trk[blk].nStartPos;i<(pDoc->trk[blk].nStartPos + pDoc->trk[blk].nPositions);i++) {
				struct INTPT pt, pt2; //, ptl;
				pDC->SelectObject(purplePen);
				pt.x=pDoc->col.vroad[i].refPt.x-pDoc->col.vroad[i].right.x*(pDoc->col.vroad[i].leftWall/128);
				pt.y=pDoc->col.vroad[i].refPt.y-pDoc->col.vroad[i].right.y*(pDoc->col.vroad[i].leftWall/128);
				pt.z=pDoc->col.vroad[i].refPt.z-pDoc->col.vroad[i].right.z*(pDoc->col.vroad[i].leftWall/128);
				pDC->MoveTo(IntX(pt),IntY(pt));
				pt2.x=pDoc->col.vroad[i].refPt.x+pDoc->col.vroad[i].right.x*(pDoc->col.vroad[i].rightWall/128);
				pt2.y=pDoc->col.vroad[i].refPt.y+pDoc->col.vroad[i].right.y*(pDoc->col.vroad[i].rightWall/128);
				pt2.z=pDoc->col.vroad[i].refPt.z+pDoc->col.vroad[i].right.z*(pDoc->col.vroad[i].rightWall/128);
				pDC->LineTo(IntX(pt2),IntY(pt2));
				/*dldata = (float) DL[i]/255.0f;
				

				fakefloatcoord.x=(pt.x) + ((pt2.x-pt.x)  * dldata);
				fakefloatcoord.y=(pt.y) + ((pt2.y-pt.y) * dldata);
				fakefloatcoord.z=(pt.z) + ((pt2.z-pt.z) * dldata);
				
				ptl.x = round(fakefloatcoord.x);
				ptl.y = round(fakefloatcoord.y);
				ptl.z = round(fakefloatcoord.z);
				
				pDC->SelectObject(red2Pen);
				pDC->MoveTo(IntX(ptl)-5,IntY(ptl)+5);
				pDC->LineTo(IntX(ptl)+5,IntY(ptl)-5);
				pDC->MoveTo(IntX(ptl)-5,IntY(ptl)-5);
				pDC->LineTo(IntX(ptl)+5,IntY(ptl)+5);*/

				//draw driving line poInts (right):
				/*pt2.x=pDoc->col.vroad[i].refPt.x-pDoc->col.vroad[i].right.x*(pDoc->col.vroad[i].leftWall/128);
				pt2.y=pDoc->col.vroad[i].refPt.y-pDoc->col.vroad[i].right.y*(pDoc->col.vroad[i].leftWall/128);
				pt2.z=pDoc->col.vroad[i].refPt.z-pDoc->col.vroad[i].right.z*(pDoc->col.vroad[i].leftWall/128);*/
				
				//draw refpoInts:
				pDC->SelectObject(brownPen);
				if ((blk==refblock)&&(BlkHighlight==true))
					pDC->SelectObject(thickbrownPen);

				pt.x=pDoc->col.vroad[i].refPt.x;
				pt.y=pDoc->col.vroad[i].refPt.y;
				pt.z=pDoc->col.vroad[i].refPt.z;
				pDC->MoveTo(IntX(pt)-8,IntY(pt)+8);
				pDC->LineTo(IntX(pt)+8,IntY(pt)-8);
				pDC->MoveTo(IntX(pt)-8,IntY(pt)-8);
				pDC->LineTo(IntX(pt)+8,IntY(pt)+8);

				pDC->MoveTo(IntX(pt),IntY(pt)+8);
				pDC->LineTo(IntX(pt),IntY(pt)-8);
				pDC->MoveTo(IntX(pt)-8,IntY(pt));
				pDC->LineTo(IntX(pt)+8,IntY(pt));

				//draw VRoad refpt + spdfloat = AI Points = bots line
				if (pDoc->spdFALoaded&&pDoc->spdRALoaded)
				{
					pDC->SelectObject(darkredpen);
					if ((blk==refblock)&&(BlkHighlight==true))
					pDC->SelectObject(thickdarkredpen);

					pt=AI_Intpt(i);
					if (scale<0.15)  //Show Speed?
					{
						if (ShowFwSPD) 
							Speed=pDoc->spdFAbin[i].Speedvalue;
						else 
							Speed=pDoc->spdRAbin[i].Speedvalue;
						pDC->MoveTo(IntX(pt),IntY(pt)+Speed/2);
						pDC->LineTo(IntX(pt),IntY(pt)-Speed/2);
					}

					pDC->MoveTo(IntX(pt)-4,IntY(pt)+4);
					pDC->LineTo(IntX(pt)+4,IntY(pt)-4);
					pDC->MoveTo(IntX(pt)-4,IntY(pt)-4);
					pDC->LineTo(IntX(pt)+4,IntY(pt)+4);

					/*pDC->MoveTo(IntX(pt),IntY(pt)+4);
					pDC->LineTo(IntX(pt),IntY(pt)-4);
					pDC->MoveTo(IntX(pt)-4,IntY(pt));
					pDC->LineTo(IntX(pt)+4,IntY(pt));*/

				}
			}
		}
	}
//end
// or at the bounding rectangles...
/*	pDC->SelectObject(brownPen);
	for (i=0;i<pDoc->nBlocks;i++) {
		// pDoc->RecalcBoundingBox(i);
		pDC->MoveTo(FloatX(pDoc->trk[i].ptBounding[0]),FloatY(pDoc->trk[i].ptBounding[0]));
		pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[1]),FloatY(pDoc->trk[i].ptBounding[1]));
		pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[2]),FloatY(pDoc->trk[i].ptBounding[2]));
		pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[3]),FloatY(pDoc->trk[i].ptBounding[3]));
		pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[0]),FloatY(pDoc->trk[i].ptBounding[0]));
	}
	pDC->SelectObject(redPen);
	i=refblock;
	pDC->MoveTo(FloatX(pDoc->trk[i].ptBounding[0]),FloatY(pDoc->trk[i].ptBounding[0]));
	pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[1]),FloatY(pDoc->trk[i].ptBounding[1]));
	pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[2]),FloatY(pDoc->trk[i].ptBounding[2]));
	pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[3]),FloatY(pDoc->trk[i].ptBounding[3]));
	pDC->LineTo(FloatX(pDoc->trk[i].ptBounding[0]),FloatY(pDoc->trk[i].ptBounding[0]));
*/
// or at the first polyobj chunk refpositions
/*	pDC->SelectObject(brownPen);
	for (i=0;i<pDoc->nBlocks;i++)
		for (j=0;j<pDoc->trk[i].nPolyobj;j++) {
			pDC->MoveTo(IntX(pDoc->trk[i].polyobj[j]->pt)-5,IntY(pDoc->trk[i].polyobj[j]->pt));
			pDC->LineTo(IntX(pDoc->trk[i].polyobj[j]->pt)+5,IntY(pDoc->trk[i].polyobj[j]->pt));
			pDC->MoveTo(IntX(pDoc->trk[i].polyobj[j]->pt),IntY(pDoc->trk[i].polyobj[j]->pt)-5);
			pDC->LineTo(IntX(pDoc->trk[i].polyobj[j]->pt),IntY(pDoc->trk[i].polyobj[j]->pt)+5);
		}	
*/
	// selection highlighting
	GetClientRect(&rect);		
	pDC->SelectObject(redPen);
	ShowSelectionAt(pDC,rect.right/2-offsetx,rect.bottom/2-offsety);

	// dragging cursor, using redPen in xor mode
	if (isDragging) {
		pDC->SetROP2(R2_NOTXORPEN);
		ShowSelectionAt(pDC,dragX,dragY);
	}

	//HOO: Main Track View interface (1)
	if (bShowTrack)
	{
		if (!pDoc->qfsView.bIsLoadQfs)
		{
			// Is texture images loaded
			if (pDoc->bCreateScene)
			{
				AfxMessageBox("Track View requires texture.");
				pDoc->TrackView->DestroyWindow();
				pDoc->bCreateScene=FALSE;
				bShowTrack=FALSE;
				return;
			}
			
			if (pDoc->qfsView.LoadQFS() != 0)
			{
				pDoc->qfsView.bIsLoadQfs=FALSE;
			}
			else
			{
				pDoc->qfsView.bIsLoadQfs=TRUE;
				pDoc->qfsView.promptLoad=FALSE;
			}

			if (!pDoc->qfsView.bIsLoadQfs)
			{
				bShowTrack=FALSE;
				return;
			}
		}
		if (!pDoc->bCreateScene)
		{
			//Initialize Track View
			if (!pDoc->TrackView->Init(GetParent(), &(pDoc->qfsView), pDoc->texture, pDoc->bHSMode))
			{
				bShowTrack=FALSE;
				pDoc->bCreateScene=FALSE;
				return;
			}
			pDoc->bCreateScene=TRUE;
			pDoc->bUpdatedScene=FALSE;
			sceneRefBlock = -1;
			pDoc->TrackView->ShowView(bShowTrack);
		}
		if (!pDoc->TrackView->bInitialized)
		{
			bShowTrack=FALSE;
			pDoc->bCreateScene=FALSE;
			return;
		}
		if (!bUpdatedRes || !pDoc->bUpdatedScene || refblock != sceneRefBlock)
		{
			// Create and update 3 blocks or more
			bUpdatedRes = TRUE;
			pDoc->bUpdatedScene=TRUE;
			m=0;
			if (ShowBasedOnVisi==true) //Show track based on visibility is enabled
			{
				TrackViewDrawBlock(pDoc->nBlocks,m);m++; //Show global objects
				TrackViewDrawBlock(TrackViewBl,m);m++; //Show selected block
				i=1;
				do 
				{
					if (pDoc->IsBlockVisibile(TrackViewBl,RealBlockNum(TrackViewBl+i))) // Is this block visible ? Then draw in preview
					{
						TrackViewDrawBlock(RealBlockNum(TrackViewBl+i),m);m++; //Show selected block
					}
					if (pDoc->IsBlockVisibile(TrackViewBl,RealBlockNum(TrackViewBl-i))) // Is this block visible ? Then draw in preview
					{
						TrackViewDrawBlock(RealBlockNum(TrackViewBl-i),m);m++; //Show selected block
					}
					i++;
				} while ( (m<29)&&(i<pDoc->nBlocks/2) );

				while ( m < 30 ) 
				{
					pDoc->TrackView->CreateEmptyScene(m);
					m++;
				}
			}
			else
			{	//Standard view
				TrackViewDrawBlock(pDoc->nBlocks,m);m++; //Show global objects
				TrackViewDrawBlock(TrackViewBl,m);m++; //Show selected block
				TrackViewDrawBlock(RealBlockNum(TrackViewBl+1),m);m++; //Show blocks after selected
				TrackViewDrawBlock(RealBlockNum(TrackViewBl+2),m);m++;
				TrackViewDrawBlock(RealBlockNum(TrackViewBl-1),m);m++; //Show blocks before selected
				TrackViewDrawBlock(RealBlockNum(TrackViewBl-2),m);m++;
				while ( m < 30 ) 
				{
					pDoc->TrackView->CreateEmptyScene(m);
					m++;
				}
			}

			sceneRefBlock = refblock;			//
		}
		// Set camera position and orientation
		if ((isxobj==1) && selMode == ID_MODE_OBJECT && objno>=0)
		{
			x = pDoc->xobj[4*refblock+refchunk].obj+objno;
			pDoc->TrackView->UpdateScene(theta, phi, 
				(int) (x->ptRef.x + 0.5*x->vert[x->polyData->vertex[0]].x
				+ 0.5*x->vert[x->polyData->vertex[2]].x),
				(int) (x->ptRef.y + 0.5*x->vert[x->polyData->vertex[0]].y
				+ 0.5*x->vert[x->polyData->vertex[2]].y),
				(int) (x->ptRef.z + 0.5*x->vert[x->polyData->vertex[0]].z
				+ 0.5*x->vert[x->polyData->vertex[2]].z),
				300.00 * scale * scale3d + 10);
		}
		else
		{
			if (selMode == ID_MODE_POLYGON && refpoly!=NULL && isxobj)
			{
				pDoc->TrackView->UpdateScene(theta, phi,
					(int) (refnode->x + 0.5*refvertices[refpoly->vertex[0]].x
					+ 0.5*refvertices[refpoly->vertex[2]].x),
					(int) (refnode->y + 0.5*refvertices[refpoly->vertex[0]].y
					+ 0.5*refvertices[refpoly->vertex[2]].y),
					(int) (refnode->z + 0.5*refvertices[refpoly->vertex[0]].z
					+ 0.5*refvertices[refpoly->vertex[2]].z), 300.00 * scale  * scale3d + 10);
			}
			else
			{
				pDoc->TrackView->UpdateScene(theta, phi, (int) refnode->x, (int) refnode->y,
					(int) refnode->z, 300.00 * scale  * scale3d + 10);
			}
		}
	}
	//HOO: (1)
}

//HOO: (2)
void CT3EDView::TrackKeyDown(UINT tmsg, BOOL bmode)
{
	CT3EDDoc* pDoc;
	bool phichange = FALSE;
	bool thetachange = FALSE;
	if (!bmode)
	{
		pDoc = GetDocument();
		CleanCursorZone(selMode,FALSE);
		selMode=ID_MODE_BLOCK;
		isTruePoint=FALSE; refpoly=NULL; objno=-1;
		editMode=NULL;
		CleanCursorZone(selMode,TRUE);
	}
	if (tmsg & 2) //left
	{
		if (bmode)
		{
			phi-=5;
			phichange = TRUE;
		}
		else
		{
			refblock = (refblock==0 ? pDoc->nBlocks-1: refblock-1);
			refnode=&(pDoc->trk[refblock].ptCentre);
			UpdateRefBlock();
		}
	}
	if (tmsg & 1)
	{
		if (bmode)
		{
			phi+=5;
			phichange = TRUE;
		}
		else
		{
			refblock = (refblock==pDoc->nBlocks-1 ? 0 : refblock+1);
			refnode=&(pDoc->trk[refblock].ptCentre);
			UpdateRefBlock();
		}
	}
	if (tmsg & 4) //up
	{
		if (bmode)
		{
			theta-=5;
			thetachange = TRUE;
		}
	}
	if (tmsg & 8)
	{
		if (bmode)
		{
			theta+=5;
			thetachange = TRUE;
		}
	}
	if (thetachange)
	{
		if (theta<0) theta=0;
		if (theta>90) theta=90;
		cosTheta=(float)cos(theta*3.14159265359/180.0);
		sinTheta=(float)sin(theta*3.14159265359/180.0);
		SetScrollPos(SB_VERT,theta,TRUE);
	}
	if (phichange)
	{
		if (phi<-180) phi+=360;
		if (phi>180) phi-=360;
		cosPhi=(float)cos(phi*3.14159265359/180.0);
		sinPhi=-(float)sin(phi*3.14159265359/180.0);
		SetScrollPos(SB_HORZ,phi,TRUE);
	}
	if (thetachange || phichange || !bmode)
	{
		InvalidateRect(NULL,TRUE);
		return;
	}
	switch(tmsg)
	{
	case 16:OnViewZoomin(); break;
	case 32:OnViewZoomout(); break;
	}
}
//HOO: (2)

/////////////////////////////////////////////////////////////////////////////
// CT3EDView diagnostics

#ifdef _DEBUG
void CT3EDView::AssertValid() const
{
	CView::AssertValid();
}

void CT3EDView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CT3EDDoc* CT3EDView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CT3EDDoc)));
	return (CT3EDDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CT3EDView message handlers

void CT3EDView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	RECT rect;
	BOOL act=TRUE,scroll=FALSE;
	int oldx;

	if (bScrollRotate) {
		switch(nSBCode) {
			case SB_LEFT: phi=-180; break;
			case SB_LINELEFT: phi-=5; break;
			case SB_LINERIGHT: phi+=5; break;
			case SB_PAGELEFT: phi-=30; break;
			case SB_PAGERIGHT: phi+=30; break;
			case SB_RIGHT: phi=180; break;
			case SB_THUMBPOSITION: phi=nPos; break;
			case SB_THUMBTRACK: phi=nPos; act=FALSE; break;
			default: return;
		}
		if (phi<-180) phi+=360;
		if (phi>180) phi-=360;
		cosPhi=(float)cos(phi*3.14159265359/180.0);
		sinPhi=-(float)sin(phi*3.14159265359/180.0);
		SetScrollPos(SB_HORZ,phi,TRUE);
	} else {
		GetClientRect(&rect);
		oldx=offsetx;
		switch(nSBCode) {
			case SB_LEFT: offsetx=-SCROLLSZ; break;
			case SB_LINELEFT: offsetx-=40; scroll=TRUE; break;
			case SB_LINERIGHT: offsetx+=40; scroll=TRUE; break;
			case SB_PAGELEFT: offsetx-=rect.right/2; scroll=TRUE; break;
			case SB_PAGERIGHT: offsetx+=rect.right/2; scroll=TRUE; break;
			case SB_RIGHT: offsetx=SCROLLSZ; break;
			case SB_THUMBPOSITION: offsetx=nPos; break;
			case SB_THUMBTRACK: offsetx=nPos; act=FALSE; break;
			default: return;
		}
		if (offsetx<-SCROLLSZ) offsetx=-SCROLLSZ;
		if (offsetx>SCROLLSZ) offsetx=SCROLLSZ;
		SetScrollPos(SB_HORZ,offsetx,TRUE);
	}
	if (act) {
		if (scroll) { ScrollWindow(oldx-offsetx,0); UpdateWindow(); }
		else InvalidateRect(NULL,TRUE);
	}
}

void CT3EDView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	RECT rect;
	BOOL act=TRUE,scroll=FALSE;
	int oldy;

	if (bScrollRotate) {
		switch(nSBCode) {
			case SB_TOP: theta=0; break;
			case SB_LINEUP: theta-=5; break;
			case SB_LINEDOWN: theta+=5; break;
			case SB_PAGEUP: theta-=15; break;
			case SB_PAGEDOWN: theta+=15; break;
			case SB_BOTTOM: theta=90; break;
			case SB_THUMBPOSITION: theta=nPos; break;
			case SB_THUMBTRACK: theta=nPos; act=FALSE; break;
			default: return;
		}
		if (theta<0) theta=0;
		if (theta>90) theta=90;
		cosTheta=(float)cos(theta*3.14159265359/180.0);
		sinTheta=(float)sin(theta*3.14159265359/180.0);
		SetScrollPos(SB_VERT,theta,TRUE);
	} else {
		GetClientRect(&rect);
		oldy=offsety;
		switch(nSBCode) {
			case SB_TOP: offsety=-SCROLLSZ; break;
			case SB_LINEUP: offsety-=40; scroll=TRUE; break;
			case SB_LINEDOWN: offsety+=40; scroll=TRUE; break;
			case SB_PAGEUP: offsety-=rect.bottom/2; scroll=TRUE; break;
			case SB_PAGEDOWN: offsety+=rect.bottom/2; scroll=TRUE; break;
			case SB_BOTTOM: offsety=SCROLLSZ; break;
			case SB_THUMBPOSITION: offsety=nPos; break;
			case SB_THUMBTRACK: offsety=nPos; act=FALSE; break;
			default: return;
		}
		if (offsety<-SCROLLSZ) offsety=-SCROLLSZ;
		if (offsety>SCROLLSZ) offsety=SCROLLSZ;
		SetScrollPos(SB_VERT,offsety,TRUE);
	}
	if (act) {
		if (scroll) { ScrollWindow(0,oldy-offsety); UpdateWindow(); }
		else InvalidateRect(NULL,TRUE);
	}
}

void CT3EDView::OnViewFullres() 
{
	if (nDetail==HIGH_DETAIL) return;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	if ((refpoly!=NULL)&&IsPolyOfDetail(nDetail)) refpoly=NULL;
	nDetail=HIGH_DETAIL;
	if (isTruePoint&&!bShowLanes)
		if (!IsVisibleNode(refblock,refnode)) isTruePoint=FALSE;
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnViewHalfres() 
{
	if (nDetail==MED_DETAIL) return;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	if ((refpoly!=NULL)&&IsPolyOfDetail(nDetail)) refpoly=NULL;
	nDetail=MED_DETAIL;
	if (isTruePoint&&!bShowLanes)
		if (!IsVisibleNode(refblock,refnode)) isTruePoint=FALSE;
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnViewLowres() 
{
	if (nDetail==LOW_DETAIL) return;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	if ((refpoly!=NULL)&&IsPolyOfDetail(nDetail)) refpoly=NULL;
	nDetail=LOW_DETAIL;
	if (isTruePoint&&!bShowLanes)
		if (!IsVisibleNode(refblock,refnode)) isTruePoint=FALSE;
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnViewZoomin() 
{
	OnViewZoominPub();
}
void CT3EDView::OnViewZoominPub()
{
	if (scale<0.005) return;
	scale=scale/(float)1.5;
	offsetx=(int)1.5*offsetx;
	offsety=(int)1.5*offsety;
	if (offsetx<-SCROLLSZ) offsetx=-SCROLLSZ;
	if (offsety<-SCROLLSZ) offsety=-SCROLLSZ;
	if (offsetx>SCROLLSZ) offsetx=SCROLLSZ;
	if (offsety>SCROLLSZ) offsety=SCROLLSZ;
	InvalidateRect(NULL,TRUE);
	if (!bScrollRotate) {
		SetScrollPos(SB_HORZ,offsetx,TRUE);
		SetScrollPos(SB_VERT,offsety,TRUE);
	}
}

void CT3EDView::OnViewZoomout() 
{
	OnViewZoomoutPub();
}

void CT3EDView::OnViewZoomoutPub()
{
	if (scale>5.0) return;
	scale=scale*(float)1.5;
	offsetx=(int)(offsetx/1.5);
	offsety=(int)(offsety/1.5);
	InvalidateRect(NULL,TRUE);
	if (!bScrollRotate) {
		SetScrollPos(SB_HORZ,offsetx,TRUE);
		SetScrollPos(SB_VERT,offsety,TRUE);
	}
}

void CT3EDView::OnViewZoomin3d()
{
	if (!bShowTrack) return; //No 3D view visible
	CT3EDDoc* pDoc = GetDocument();
	if (scale3d<0.001) return;
	scale3d=scale3d/(float)1.25;
	pDoc->TrackView->UpdateScene(theta, phi, (int) refnode->x, (int) refnode->y, (int) refnode->z, 300.00 * scale  * scale3d + 10);

	//InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnViewZoomout3d()
{
	if (!bShowTrack) return; //No 3D view visible
	CT3EDDoc* pDoc = GetDocument();
	if (scale3d>50.0) return;
	scale3d=scale3d*(float)1.25;
	//InvalidateRect(NULL,TRUE);
	pDoc->TrackView->UpdateScene(theta, phi, (int) refnode->x, (int) refnode->y, (int) refnode->z, 300.00 * scale  * scale3d + 10);
}

void CT3EDView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

	DrawVRoadBitMap=false;
	DrawBlkDirection=false;
	ShowBasedOnVisi=false;
	bShowCams=false;
	BlkHighlight=false;
	DrawFlags=false;
	DrawVRoad=false;
	ShowFwSPD=true;
	DrawPolyVRoad=false;

	refblock=0;
	multisel=NULL;
	offsetx=0; offsety=0;
	theta=30; phi=0;
	cosTheta=(float)sqrt(3.0)/2; sinTheta=0.5; cosPhi=1.0; sinPhi=0.0;
	scale=1.0;scale3d=1.0;
	nDetail=HIGH_DETAIL;
	bShowTrackBlocks=TRUE;bShowObjects=TRUE; bShowLanes=TRUE;
	//HOO: Initialize (3)
	bShowTrack=FALSE;
	bUpdatedRes = TRUE;
	//HOO: (3)
	isScrolling=FALSE;
	bScrollRotate=TRUE;
	isEmpty=GetDocument()->bEmpty;
	selMode=ID_MODE_BLOCK;
	isTruePoint=FALSE; refpoly=NULL; objno=-1;
	isDragging=FALSE;
	editMode=NULL;
	smooth2Start=0; smooth2Width=25; // ~half a block
	smooth1Start=12; smooth1Width=20; // over 3 blocks
	extraSmooth=TRUE;

	SetScrollRange(SB_HORZ,-SCROLLSZ,SCROLLSZ,FALSE);
	SetScrollRange(SB_VERT,-SCROLLSZ,SCROLLSZ,FALSE);
	SetScrollPos(SB_HORZ,0,TRUE);
	SetScrollPos(SB_VERT,0,TRUE);
	statusbar=(CStatusBar *)GetParentFrame()->GetMessageBar();
	//statusbar->SetPaneInfo(4, statusbar->GetItemID(4), SBPS_STRETCH, NULL );
	statusbar->SetPaneInfo(4, statusbar->GetItemID(4), SBPS_NORMAL, 70 );
	if (isEmpty) {
		statusbar->SetPaneText(4,"Normal (z)",TRUE);
		statusbar->SetPaneText(1,"No Block",TRUE);
		statusbar->SetPaneText(2,"EMPTY",TRUE);
//		GetParentFrame()->GetMenu()->EnableMenuItem(2,MF_BYPOSITION|MF_GRAYED);
//		GetParentFrame()->GetMenu()->EnableMenuItem(3,MF_BYPOSITION|MF_GRAYED);
	} else {
		statusbar->SetPaneText(1,"Block 0",TRUE);
		statusbar->SetPaneText(2,"TRANSL",TRUE);
//		GetParentFrame()->GetMenu()->EnableMenuItem(2,MF_BYPOSITION|MF_ENABLED);
//		GetParentFrame()->GetMenu()->EnableMenuItem(3,MF_BYPOSITION|MF_ENABLED);
		refnode=&(GetDocument()->trk[refblock].ptCentre);
	}

	if (GetKeyState(VK_SCROLL) & 0x0001) // If scroll key is on
	{
		//toggle the Scroll Lock state
		keybd_event(VK_SCROLL, 0x45, KEYEVENTF_EXTENDEDKEY, 0); // Key down
		keybd_event(VK_SCROLL, 0x45, KEYEVENTF_EXTENDEDKEY | KEYEVENTF_KEYUP, 0); // Key 
	}
}

void CT3EDView::OnUpdateViewFullres(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((nDetail==HIGH_DETAIL)&&!isEmpty);
}

void CT3EDView::OnUpdateViewHalfres(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((nDetail==MED_DETAIL)&&!isEmpty);
}

void CT3EDView::OnUpdateViewLowres(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((nDetail==LOW_DETAIL)&&!isEmpty);
}

void CT3EDView::OnUpdateViewZoomin(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((scale>=0.005)&&!isEmpty);
}

void CT3EDView::OnUpdateViewZoomout(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((scale<=5.0)&&!isEmpty);	
}

void CT3EDView::UpdateRefBlock()
{
	CT3EDDoc *pDoc=GetDocument();
	struct TRKBLOCK *b;
	//CSelData *sel;
	CString s;
	s.Format("Block %d",refblock);
	if (refblock==pDoc->nBlocks) s="Global";
	statusbar->SetPaneText(1,s,TRUE);

	if (((selMode==ID_MODE_OBJECT)|(selMode==ID_MODE_VROADEDIT))&&(objno>-1)) //JimD: Show objects middle
	{
		//for (sel=this;sel!=NULL;sel=sel->multisel) 
		//if ((sel->isxobj==0)||(sel->isxobj==1)) //Only available for objects
			if ((isxobj==0)||(isxobj==1)) //Only available for objects
			{
			  if (pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno)) //Find new min & max of object
			  {
				  s.Format("X:%f Y:%f Z:%f InMemZ:%f", pDoc->MemObjMiddle.x, pDoc->MemObjMiddle.y, pDoc->MemObjMiddle.z, pDoc->memory_Zh );
				  statusbar->SetPaneText(3,s,TRUE);
			  }
			}
			else if ((isxobj==2)|(isxobj==3))
			{
				//Sound & Light sources
				b=&pDoc->trk[refblock];
				
				s="";
				if ((isxobj==3)&&(objno<b->nSoundsrc)) s.Format("X:%f Y:%f Z:%f InMemZ:%f", ((float)b->soundsrc[objno].refpoint.x)/65536, ((float)b->soundsrc[objno].refpoint.y)/65536, ((float)b->soundsrc[objno].refpoint.z)/65536, pDoc->memory_Zh );
				if ((isxobj==2)&&(objno<b->nLightsrc)) s.Format("X:%f Y:%f Z:%f InMemZ:%f", ((float)b->lightsrc[objno].refpoint.x)/65536, ((float)b->lightsrc[objno].refpoint.y)/65536, ((float)b->lightsrc[objno].refpoint.z)/65536, pDoc->memory_Zh );
				statusbar->SetPaneText(3,s,TRUE);
			}
			else if (((isxobj==4)|(isxobj==6))&&(objno < pDoc->col.vroadHead.nrec)) // VRoad
			{
				s="";
				s.Format("X:%f Y:%f Z:%f InMemZ:%f", ((float) pDoc->col.vroad[objno].refPt.x)/65536, ((float) pDoc->col.vroad[objno].refPt.y)/65536, ((float) pDoc->col.vroad[objno].refPt.z)/65536, pDoc->memory_Zh );
				statusbar->SetPaneText(3,s,TRUE);
			}
			else if ((isxobj==5)&&(objno<pDoc->Camfile.nCams)) //ReplayCam
			{
				s.Format("X:%f Y:%f Z:%f InMemZ:%f", pDoc->Camfile.pCamData[objno].CamPosition.x, pDoc->Camfile.pCamData[objno].CamPosition.y, pDoc->Camfile.pCamData[objno].CamPosition.z, pDoc->memory_Zh );
				statusbar->SetPaneText(3,s,TRUE);
			}
	}
}

void CT3EDView::OnViewRotateMode() 
{
	int x,y,i,num,n0,d,d0;
	struct TRKBLOCK *trk0,*trk;
	RECT r;

	bScrollRotate=TRUE;
	statusbar->SetPaneText(2,"ROTATE",TRUE);
	SetScrollRange(SB_HORZ,-180,180,FALSE);
	SetScrollRange(SB_VERT,0,90,FALSE);
	SetScrollPos(SB_HORZ,phi,TRUE);
	SetScrollPos(SB_VERT,theta,TRUE);
	
	// look for a suitable reference point around which to rotate
	GetClientRect(&r);
	if ((offsetx>r.right)||(offsetx<-r.right)||
			(offsety>r.bottom)||(offsety<-r.bottom)) {
		dxoffs=-offsetx
				-(int)((refnode->x*cosPhi-refnode->y*sinPhi)/scale);
		dyoffs=-offsety+(int)((refnode->y*cosPhi*cosTheta+
				refnode->x*sinPhi*cosTheta+refnode->z*sinTheta)/scale);
		trk0=GetDocument()->trk;
		num=GetDocument()->nBlocks;
		n0=-1; d0=1<<30;
		for (i=0,trk=trk0;i<num;i++,trk++) {
			x=FloatX(trk->ptCentre); y=FloatY(trk->ptCentre);
			if (x<0) x=-x; if (y<0) y=-y;
			if ((x<r.right/2)&&(y<r.bottom/2)) {
				d=(x<<16)/r.right+(y<<16)/r.bottom;
				if (d<d0) { d0=d; n0=i; }
			}
		}
		if (n0>=0) {
			trk=trk0+n0;
			x=FloatX(trk->ptCentre); y=FloatY(trk->ptCentre);
			refblock=n0;
			UpdateRefBlock();
			refnode=&(trk->ptCentre);
			isTruePoint=FALSE; refpoly=NULL; objno=-1;
		}
	}

	offsetx=0; offsety=0; // recenter so we don't get lost
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnUpdateViewRotateMode(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(bScrollRotate&&!isEmpty);
}

void CT3EDView::OnViewTranslMode() 
{
	bScrollRotate=FALSE;
	statusbar->SetPaneText(2,"TRANSL",TRUE);
	SetScrollRange(SB_HORZ,-SCROLLSZ,SCROLLSZ,FALSE);
	SetScrollRange(SB_VERT,-SCROLLSZ,SCROLLSZ,FALSE);
	SetScrollPos(SB_HORZ,offsetx,TRUE);
	SetScrollPos(SB_VERT,offsety,TRUE);
}

void CT3EDView::OnUpdateViewTranslMode(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(!bScrollRotate&&!isEmpty);
}

void CT3EDView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateFileSaveAs(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (isDragging) return;
	switch(nChar) {
		case VK_LEFT:  OnHScroll(SB_LINELEFT,0,NULL); break;
		case VK_RIGHT: OnHScroll(SB_LINERIGHT,0,NULL); break;
		case VK_UP:    OnVScroll(SB_LINEUP,0,NULL); break;
		case VK_DOWN:  OnVScroll(SB_LINEDOWN,0,NULL); break;
		default: CView::OnKeyDown(nChar, nRepCnt, nFlags);
	}
}

void CT3EDView::OnUpdateViewShowhideobjects(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
	pCmdUI->SetCheck(bShowObjects&&!isEmpty);
}

void CT3EDView::OnViewShowhideobjects() 
{
	bShowObjects=!bShowObjects;
	if ((multisel!=NULL)&&!bShowObjects) { delete multisel; multisel=NULL; }
	if (!bShowObjects&&(refpoly!=NULL))
		if (!(IsPolyOfDetail(nDetail)||IsPolyOfDetail(6))) refpoly=NULL;
	if (!bShowObjects)
		{
			objno=-1;
			isxobj=0;
			bShowCams=false;
		}


	InvalidateRect(NULL,!bShowObjects);
}

void CT3EDView::OnViewShowlanes() 
{
	bShowLanes=!bShowLanes;
	if ((multisel!=NULL)&&!bShowLanes) { delete multisel; multisel=NULL; }
	if (isTruePoint&&!bShowLanes)
		if (!IsVisibleNode(refblock,refnode)) isTruePoint=FALSE;
	if ((refpoly!=NULL)&&!bShowLanes&&!isxobj&&(refpolyobj<0))
		if ((refchunk==6)||(refchunk&1)) refpoly=NULL;
	InvalidateRect(NULL,!bShowLanes);
}

void CT3EDView::OnUpdateViewShowlanes(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(bShowLanes&&!isEmpty);
}

//HOO: Function to show track (4)
void CT3EDView::OnViewShowTrack()
{
	CT3EDDoc* pDoc = GetDocument();

	bShowTrack=!bShowTrack;
	if (pDoc->bCreateScene)
	{
		pDoc->TrackView->ShowView(bShowTrack);
	}
	InvalidateRect(NULL, TRUE);
}

void CT3EDView::OnUpdateViewShowTrack(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(bShowTrack&&!isEmpty);
}
//HOO: (4)

void CT3EDView::OnUpdateTrViewZoomin3d(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
	pCmdUI->Enable(!isEmpty&&bShowTrack);
}

void CT3EDView::OnUpdateTrViewZoomout3d(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
	pCmdUI->Enable(!isEmpty&&bShowTrack);
}



void CT3EDView::OnModeBlock() 
{
	if (isDragging) return; // safety
	CleanCursorZone(selMode,FALSE);
	selMode=ID_MODE_BLOCK;
	bShowTrackBlocks=true;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	isTruePoint=FALSE; refpoly=NULL; objno=-1;
	editMode=NULL;
	CleanCursorZone(selMode,TRUE);
}

void CT3EDView::OnUpdateModeBlock(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((selMode==ID_MODE_BLOCK)&&!isEmpty);
}

void CT3EDView::OnModeExtpoint() 
{
	if (isDragging) return; // safety
	CleanCursorZone(selMode,FALSE);
	selMode=ID_MODE_EXTPOINT;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	refpoly=NULL; objno=-1;
	editMode=NULL;
	CleanCursorZone(selMode,TRUE);
}

void CT3EDView::OnUpdateModeExtpoint(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((selMode==ID_MODE_EXTPOINT)&&!isEmpty);
}

void CT3EDView::OnModePoint() 
{
	if (isDragging) return; // safety
	CleanCursorZone(selMode,FALSE);
	selMode=ID_MODE_POINT;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	refpoly=NULL; objno=-1;
	editMode=NULL;
	CleanCursorZone(selMode,TRUE);
}

void CT3EDView::OnUpdateModePoint(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((selMode==ID_MODE_POINT)&&!isEmpty);
}

void CT3EDView::OnModeObject() 
{
	if (isDragging) return; // safety
	CleanCursorZone(selMode,FALSE);
	selMode=ID_MODE_OBJECT;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	isTruePoint=FALSE; refpoly=NULL;
	editMode=NULL;
	CleanCursorZone(selMode,TRUE);
}

void CT3EDView::OnUpdateModeObject(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&bShowObjects);
	pCmdUI->SetCheck((selMode==ID_MODE_OBJECT)&&!isEmpty);
}

void CT3EDView::OnModePolygon() 
{
	if (isDragging) return; // safety
	CleanCursorZone(selMode,FALSE);
	selMode=ID_MODE_POLYGON;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	isTruePoint=FALSE; objno=-1;
	editMode=NULL;
	CleanCursorZone(selMode,TRUE);
}

void CT3EDView::OnUpdateModePolygon(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((selMode==ID_MODE_POLYGON)&&!isEmpty);
}

void CT3EDView::CleanCursorZone(int mode,BOOL newstate)
{
	RECT r;
	int x,y,zsize,i;
	struct FLOATPT *t;
	CSelData *sel;

	if (isEmpty) return;
	GetClientRect(&r);
	dxoffs=r.right/2-offsetx
			  -(int)((refnode->x*cosPhi-refnode->y*sinPhi)/scale);
	dyoffs=r.bottom/2-offsety+(int)((refnode->y*cosPhi*cosTheta+
				refnode->x*sinPhi*cosTheta+refnode->z*sinTheta)/scale);

	switch(mode) {
		case ID_MODE_BLOCK: 
		case ID_MODE_POLYGON: 
		case ID_MODE_OBJECT: 
			r.left=1<<30; r.right=-(1<<30);
			r.top=1<<30; r.bottom=-(1<<30);
			for (sel=this;sel!=NULL;sel=sel->multisel) {
				t=GetDocument()->trk[sel->refblock].ptBounding;
				zsize=(int)(200*sinTheta/scale);
				for (i=0;i<=3;i++) { 
					x=FloatX(t[i]);
					y=FloatY(t[i]);
					if (x<=r.left) r.left=x-1;
					if (x>=r.right) r.right=x+1;
					if (y-zsize<=r.top) r.top=y-zsize-1;
					if (y+zsize>=r.bottom) r.bottom=y+zsize+1;
				}
			}
			InvalidateRect(&r,FALSE); 
			break;
		case ID_MODE_EXTPOINT: // may later need to enlarge to circle
		case ID_MODE_POINT: 
			for (sel=this;sel!=NULL;sel=sel->multisel) {
				x=FloatX(*(sel->refnode));
				y=FloatY(*(sel->refnode));
				r.top=y-6; r.bottom=y+6;
				r.left=x-6; r.right=x+6;
				InvalidateRect(&r,!newstate);
			}
			break;
	}
}

void CT3EDView::OnViewRefresh() 
{
	InvalidateRect(NULL,TRUE);	
}

void CT3EDView::OnViewRecenter() 
{
	if ((offsetx==0)&&(offsety==0)) return;
	offsetx=0; offsety=0;
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnUpdateViewRecenter(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
}

BOOL CT3EDView::IsVisibleNode(int block,struct FLOATPT *pt)
{ 
// could be made much simpler using trk.nxxxxxVert !!!
	CT3EDDoc *pDoc=GetDocument();
	struct FLOATPT *v;
	struct OBJPOLYBLOCK *o;
	LPPOLYGONDATA p;
	int i,j,k,n;

	//if (bShowLanes) return TRUE; // anything becomes visible
	if (pt==&myrefnode) return bShowObjects; // an xobj refpoint

	if (bShowTrackBlocks){  //Is the point a trackblock point?
		v=pDoc->trk[block].vert;
		p=pDoc->poly[block].poly[nDetail];
		n=pDoc->poly[block].sz[nDetail];
		for (i=0;i<n;i++,p++) {
			if (pt==v+p->vertex[0]) return TRUE;
			if (pt==v+p->vertex[1]) return TRUE;
			if (pt==v+p->vertex[2]) return TRUE;
			if (pt==v+p->vertex[3]) return TRUE;
		}
		p=pDoc->poly[block].poly[nDetail +1 ]; //Now check the fences
		n=pDoc->poly[block].sz[nDetail +1 ];
		for (i=0;i<n;i++,p++) {
			if (pt==v+p->vertex[0]) return TRUE;
			if (pt==v+p->vertex[1]) return TRUE;
			if (pt==v+p->vertex[2]) return TRUE;
			if (pt==v+p->vertex[3]) return TRUE;
		}
	}
	if (bShowLanes){ //Now check the lanes, always in chunk 6
		v=pDoc->trk[block].vert;
		p=pDoc->poly[block].poly[6];
		n=pDoc->poly[block].sz[6];
		for (i=0;i<n;i++,p++) {
			if (pt==v+p->vertex[0]) return TRUE;
			if (pt==v+p->vertex[1]) return TRUE;
			if (pt==v+p->vertex[2]) return TRUE;
			if (pt==v+p->vertex[3]) return TRUE;
		}
	}


	if (bShowObjects) { ////Is the point a a object point?
		for (j=0;j<4;j++) {
			o=&(pDoc->poly[block].obj[j]);
			if (o->n1==0) continue;
			for (k=0;k<o->nobj;k++) {
				p=o->poly[k];
				n=o->numpoly[k];
				for (i=0;i<n;i++,p++) {
					if (pt==v+p->vertex[0]) return TRUE;
					if (pt==v+p->vertex[1]) return TRUE;
					if (pt==v+p->vertex[2]) return TRUE;
					if (pt==v+p->vertex[3]) return TRUE;
				}
			}
		}
	}
	return FALSE;
}

BOOL CT3EDView::IsPolyOfDetail(int detail)
{
	if (refpoly==NULL) return FALSE;
	if (isxobj) return FALSE;
	if (refpolyobj>=0) return FALSE;
	return ((refchunk&6)==detail); // detail or detail+1
}

void CT3EDView::OnUpdateToolsMovexy(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(editMode==ID_TOOLS_MOVEXY);
}

void CT3EDView::OnToolsMovexy() 
{
	if (isDragging) return; // safety
	if (editMode==ID_TOOLS_MOVEXY) editMode=NULL;
	else editMode=ID_TOOLS_MOVEXY;
}

void CT3EDView::OnUpdateToolsMovez(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(editMode==ID_TOOLS_MOVEZ);
}

void CT3EDView::OnToolsMovez() 
{
	if (isDragging) return; // safety
	if (editMode==ID_TOOLS_MOVEZ) editMode=NULL;
	else editMode=ID_TOOLS_MOVEZ;
}

void CT3EDView::OnMouseMove(UINT nFlags, CPoint point) 
{
	RECT rect;

	if (!(nFlags&MK_LBUTTON)) return;
	if (delayMouseMove) { delayMouseMove=FALSE; return; }
	if ((editMode!=ID_TOOLS_MOVEXY)&&(editMode!=ID_TOOLS_MOVEZ)) return;
	if (isDragging) ShowHideCursor(); // hide cursor
	else {
		// check if dragging is allowed
		if (selMode==ID_MODE_BLOCK) 
			if ((extraSmooth?1:smooth1Start)+2*smooth1Width
				>=GetDocument()->col.vroadHead.nrec-20) return;
		if (selMode==ID_MODE_POINT)
			if (!isTruePoint) return;
		if (selMode==ID_MODE_OBJECT)
			if ((!bShowObjects)||(objno<0)) return;
		if (selMode==ID_MODE_VROADEDIT)
			if (objno<0) return;
		if (selMode==ID_MODE_POLYGON)
			if (refpoly==NULL) return;
		isDragging=TRUE;
		SetCapture();
	}
	GetClientRect(&rect);
	if ((point.x<0)||(point.y<0)||(point.x>rect.right)||(point.y>rect.bottom)) 
		{ ReleaseCapture(); isDragging=FALSE; return; }
	dragX=point.x; dragY=point.y;
	if (editMode==ID_TOOLS_MOVEZ) dragX=rect.right/2-offsetx;
	if (((editMode==ID_TOOLS_MOVEZ)&&(theta==0))||
		((editMode==ID_TOOLS_MOVEXY)&&(theta==90)))
		dragY=rect.bottom/2-offsety;
	ShowHideCursor();
}

void CT3EDView::OnLButtonDown(UINT nFlags, CPoint point) 
{	
	int i,j,k,l,m,n,x,y,dist,dist0=1<<30,x0,y0,TrackViewBl;  //l0  still used for number of seleted point
	RECT rect;
	BOOL needErase=FALSE, AltKey=FALSE;
	CT3EDDoc *pDoc=GetDocument();
	struct FLOATPT *pt,mypt; //,tmppt;
	struct XOBJDATA *xx;
	LPPOLYGONDATA p;
	struct OBJPOLYBLOCK *o;
	struct LIGHTSRC *light;
	struct SOUNDSRC *sound;
	POINT ptnew;
	CString s,sStr="";
	struct SELINFO FSel;  //Used to store the best match found
	memset(&FSel, 0, sizeof(struct SELINFO)); //Clear all
	vec3 sPt, ePt, cPt, step;
	float fDist, fi;
	bool ScrollKey=(GetKeyState(VK_SCROLL) & 0x0001);

	if (isEmpty) return;
	if (GetAsyncKeyState(VK_MENU) & 0x8000) AltKey=TRUE;

	TrackViewBl=refblock; //Use nearest block if refblock is global
	if (TrackViewBl==pDoc->nBlocks)
		TrackViewBl=pDoc->FindNearestBlock(refnode);

	GetClientRect(&rect);
	dxoffs=rect.right/2-offsetx
			  -(int)((refnode->x*cosPhi-refnode->y*sinPhi)/scale);
	dyoffs=rect.bottom/2-offsety+(int)((refnode->y*cosPhi*cosTheta+
				refnode->x*sinPhi*cosTheta+refnode->z*sinTheta)/scale);

	rect.left=point.x-10; rect.right=point.x+10;
	rect.top=point.y-10; rect.bottom=point.y+10;

	CleanCursorZone(selMode,FALSE);
	switch(selMode) 
	{
//------------------------------------------------			
			case ID_MODE_VROADEDIT://JimD: Select VRoad Points, Altkey == Select AI Points
			sStr="";
			//FSel.refblock=-1; dist0=1<<30;
			FSel.refblock=-1; dist0=50;
			if (DrawVRoad==TRUE)
			{
				struct INTPT ipt;
				for (k=0;k<pDoc->col.vroadHead.nrec;k++)
				{
					if ((AltKey==TRUE)&&pDoc->spdFALoaded&&pDoc->spdRALoaded) //AI Points
					{
						ipt=AI_Intpt(k);
						x=IntX(ipt);
						y=IntY(ipt);
					}
					else //VRoad Point
					{
						x=IntX(pDoc->col.vroad[k].refPt);
						y=IntY(pDoc->col.vroad[k].refPt);
					}

					dist=((x>point.x)?(x-point.x):(point.x-x))
						+((y>point.y)?(y-point.y):(point.y-y));
					if (dist<dist0) 
					{
						FSel.refblock=0;
						for (m=0;m<pDoc->nBlocks;m++)
							if ((k>=pDoc->trk[m].nStartPos)&&(k<=(pDoc->trk[m].nStartPos+pDoc->trk[m].nPositions)))
								FSel.refblock=m;
						FSel.refchunk=0; FSel.objno=k;
						dist0=dist;
						if (AltKey==FALSE)
							FSel.isxobj=4; //VRoad == Extra Object Type 4 !
						else 
							FSel.isxobj=6; //AI Points == Extra Object Type 6 !
					}
				}
			}

			if (FSel.refblock<0) return;
			if (!IsNewSelection(FSel)) return; //Point alreay selected? -> return

			if ((nFlags&(MK_CONTROL|MK_SHIFT)) && (objno>=0)) {
				CSelData *sel=new CSelData;
				sel->multisel=multisel;
				sel->refblock=refblock;
				sel->isxobj=isxobj;
				sel->refchunk=refchunk;
				sel->objno=objno;
				if (refnode==&myrefnode) {
					sel->myrefnode.x=myrefnode.x;
					sel->myrefnode.y=myrefnode.y;
					sel->myrefnode.z=myrefnode.z;
					sel->refnode=&(sel->myrefnode);
				} 
				else sel->refnode=refnode;
				multisel=sel;
			} else {
				if (multisel!=NULL)
				{ delete multisel; multisel=NULL; }
			}
			refblock=FSel.refblock;
			isxobj=FSel.isxobj;
			refchunk=FSel.refchunk;
			objno=FSel.objno;
			
			if (FSel.isxobj==4) 
			{  //VRoad object selected
				pt=&myrefnode;
				myrefnode.x=((float)pDoc->col.vroad[FSel.objno].refPt.x)/65536;
				myrefnode.y=((float)pDoc->col.vroad[FSel.objno].refPt.y)/65536;
				myrefnode.z=((float)pDoc->col.vroad[FSel.objno].refPt.z)/65536;
				sStr.Format("Virtual Road object %d from block %d selected", objno ,refblock);				
			}
			if (FSel.isxobj==6) 
			{  //AI Point object selected
				int Speed;
				struct INTPT ipt;
				pt=&myrefnode;

				ipt=AI_Intpt(objno);
				myrefnode.x=((float)ipt.x)/65536;
				myrefnode.y=((float)ipt.y)/65536;
				myrefnode.z=((float)ipt.z)/65536;
				if (ShowFwSPD) 
				{
					Speed=pDoc->spdFAbin[objno].Speedvalue;
					sStr.Format("Forward AI Point object %d from block %d selected. Speed is %d,", objno ,refblock,Speed);
				}
				else 
				{
					Speed=pDoc->spdRAbin[objno].Speedvalue;
					sStr.Format("Backward AI Point object %d from block %d selected.Speed is %d,", objno ,refblock,Speed);
				}
			}
			x0=FloatX(*pt); y0=FloatY(*pt);
			refnode=pt;

			if (sStr!="") statusbar->SetPaneText(0,sStr,TRUE);
			break;
//------------------------------------------------
		case ID_MODE_BLOCK:
			//FSel.refblock=-1; dist0=1<<30;
			FSel.refblock=-1; dist0=200;
			for (i=0;i<pDoc->nBlocks;i++) {
				x=FloatX(pDoc->trk[i].ptCentre);
				y=FloatY(pDoc->trk[i].ptCentre);
				dist=(x>point.x)?(x-point.x):(point.x-x);
				dist+=(y>point.y)?(y-point.y):(point.y-y);
				//if ((dist<dist0) { FSel.refblock=i; x0=x; y0=y; dist0=dist; }

				if ((dist<dist0)&&((!ShowBasedOnVisi)|(ShowBasedOnVisi&&(pDoc->IsBlockVisibile(TrackViewBl,i)))))
					{ FSel.refblock=i; x0=x; y0=y; dist0=dist; }
			}
			if (FSel.refblock==-1) return;
			if (!MeetsClipRect(&(pDoc->trk[FSel.refblock]),&rect)) return;
			if (refblock==FSel.refblock) return;
			refblock=FSel.refblock;
			refnode=&(pDoc->trk[FSel.refblock].ptCentre);
			s.Format("X:%f Y:%f Z:%f InMemZ:%f", refnode->x, refnode->y, refnode->z, pDoc->memory_Zh );
			statusbar->SetPaneText(3,s,TRUE);
			if (ShowBasedOnVisi)
				sStr.Format("Block %d selected. Right mouse click to set visibility. Control & Right mouse click to toggle visibility.",refblock);
			else
				sStr.Format("Block %d selected.",refblock);
			statusbar->SetPaneText(0,sStr,TRUE);
			break;
//------------------------------------------------
		case ID_MODE_POINT:
		case ID_MODE_EXTPOINT:
			
			SelectPoint(point, &FSel);
			if (FSel.refnode==NULL) return;
			if ( (!IsNewSelection(FSel)) && ((nFlags&(MK_SHIFT)) | (nFlags&(MK_CONTROL)) )) return; //Point alreay selected? -> return
			
			if (nFlags&(MK_SHIFT)) //Select a line of points!
			{
				CPoint nPoint;
				sPt=refnode; //Last selected point
				ePt=FSel.refnode;  //New selected point
				if (FSel.isxobj==1)  //New selected point is xobj point!
				{
					ePt.x=FSel.coreref->x+FSel.refnode->x;
					ePt.z=FSel.coreref->z+FSel.refnode->z;
					ePt.y=FSel.coreref->y+FSel.refnode->y;
				}
				fDist=pDoc->DistVec3(sPt, ePt);
				if (fDist<1) return;
				step=ePt-sPt;
				step*=((float)0.5/fDist);
				cPt=sPt;
				for (fi=0.5;fi<fDist;fi+=0.5)
				{
					cPt+=step;
					nPoint.x=Vec3X(cPt);
					nPoint.y=Vec3Y(cPt);
					SelectPoint(nPoint, &FSel);
					if (FSel.refnode==NULL) continue;
					if (!IsNewSelection(FSel)) continue;
					NewSel();
					memcpy(&mypt,refnode,12);
					if (!FSel.isxobj) 
						{
						refnode=FSel.refnode;
						s.Format("X:%f Y:%f Z:%f InMemZ:%f", refnode->x, refnode->y, refnode->z, pDoc->memory_Zh );
						sStr.Format("Point %d selected. (Block %d)",FSel.nPt, FSel.refblock);
						}
					else if (FSel.isxobj==1) { // chose a xobj
						refnode=&myrefnode;
						myrefnode.x=FSel.coreref->x+FSel.refnode->x;
						myrefnode.z=FSel.coreref->z+FSel.refnode->z;
						myrefnode.y=FSel.coreref->y+FSel.refnode->y;
						s.Format("X:%f Y:%f Z:%f InMemZ:%f",myrefnode.x, myrefnode.y, myrefnode.z, pDoc->memory_Zh );
						sStr.Format("Point %d from extra object %d selected. (Block %d, Chunk %d)",FSel.nPt, FSel.objno, FSel.refblock, FSel.refchunk);
					}
				}
			}
			else
			{
				if ((nFlags&(MK_CONTROL))
					&& (editMode!=ID_TOOLS_MERGE) && ((selMode==ID_MODE_POINT)|(selMode==ID_MODE_EXTPOINT)))
				{
					NewSel();
				} 
				else 
				{
					if (multisel!=NULL)
					{ delete multisel; multisel=NULL; }
				}
				memcpy(&mypt,refnode,12);
				if (!FSel.isxobj) 
					{
					refnode=FSel.refnode;
					s.Format("X:%f Y:%f Z:%f InMemZ:%f", refnode->x, refnode->y, refnode->z, pDoc->memory_Zh );
					sStr.Format("Point %d selected. (Block %d)",FSel.nPt, FSel.refblock);
					}
				else if (FSel.isxobj==1) { // chose a xobj
					refnode=&myrefnode;
					myrefnode.x=FSel.coreref->x+FSel.refnode->x;
					myrefnode.z=FSel.coreref->z+FSel.refnode->z;
					myrefnode.y=FSel.coreref->y+FSel.refnode->y;
					s.Format("X:%f Y:%f Z:%f InMemZ:%f",myrefnode.x, myrefnode.y, myrefnode.z, pDoc->memory_Zh );
					sStr.Format("Point %d from extra object %d selected. (Block %d, Chunk %d)",FSel.nPt, FSel.objno, FSel.refblock, FSel.refchunk);
				}
			}
			
			if (multisel!=NULL) //Show distance between first an last point
			{
				CSelData *sel;
				CString String2;
				FLOATPT p1,p2;
				float dist;
				int counter=0;	
				//get start & end point values
				sel=this;
				p1.x=sel->refnode->x;
				p1.y=sel->refnode->y;
				p1.z=sel->refnode->z;
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					p2.x=sel->refnode->x;
					p2.y=sel->refnode->y;
					p2.z=sel->refnode->z;
					counter++;
				}
				dist=pDoc->DistFloatPt(&p1, &p2);
				pDoc->LastDistance.x=p1.x - p2.x;pDoc->LastDistance.y=p1.y - p2.y;pDoc->LastDistance.z=p1.z - p2.z;
				String2.Format(" | %d points selected. Distance between first an last point is %f",counter, dist);
				sStr+=String2;
			}

			// merge vertices command
			if ((editMode==ID_TOOLS_MERGE)&&(nFlags&MK_CONTROL)) {
				pDoc->PrepareNewUndo(&mypt,refblock,offsetx,offsety);
				pDoc->MergePoint(refnode,&mypt);
				refnode=&myrefnode;
				memcpy(refnode,&mypt,12);
				InvalidateRect(NULL,TRUE);
				isTruePoint=TRUE;
				return;
			}
			refblock=FSel.refblock;
			isTruePoint=TRUE;
			if (sStr!="") statusbar->SetPaneText(0,sStr,TRUE);
			statusbar->SetPaneText(3,s,TRUE);
			break;
//------------------------------------------------
		case ID_MODE_POLYGON:
			sStr="";
			SelectPolygon(point, &FSel);
			FSel.refnode=&FSel.myrefnode;
			if (FSel.refpoly==NULL) return;
			if (!IsNewSelection(FSel)&&(nFlags&(MK_CONTROL|MK_SHIFT))) return; //Polygon alreay selected? -> return

			if (nFlags&(MK_SHIFT)) //Select a line of polygons!
			{
				CPoint nPoint;
				sPt=refnode; //Last selected point
				ePt=FSel.refnode;  //New selected point
				fDist=pDoc->DistVec3(sPt, ePt);
				if (fDist<1) return;
				step=ePt-sPt;
				step*=((float)0.5/fDist);
				cPt=sPt;
				for (fi=0.5;fi<fDist;fi+=0.5)
				{
					cPt+=step;
					nPoint.x=Vec3X(cPt);
					nPoint.y=Vec3Y(cPt);
					SelectPolygon(nPoint, &FSel);
					if (FSel.refpoly==NULL) continue;
					if (!IsNewSelection(FSel)) continue;
					NewSel();
					refblock=FSel.refblock;
					refchunk=FSel.refchunk;
					refpolyobj=FSel.objno;
					refpolyno=FSel.refpolyno;
					isxobj=FSel.isxobj;
					if (isxobj) xobjrefnode=FSel.coreref;
					refpoly=FSel.refpoly;
					refvertices=FSel.refvertices;
					x0=FloatX(*FSel.refnode); y0=FloatY(*FSel.refnode);
					myrefnode=FSel.myrefnode;
					refnode=&myrefnode;
				}
			}
			else
			{
				if (nFlags&(MK_CONTROL)) //Add new polygon to selection?
				{
					NewSel();
				} else {
					if (multisel!=NULL)
					{ delete multisel; multisel=NULL; }
				}
				refblock=FSel.refblock;
				refchunk=FSel.refchunk;
				refpolyobj=FSel.objno;
				refpolyno=FSel.refpolyno;
				isxobj=FSel.isxobj;
				if (isxobj) xobjrefnode=FSel.coreref;
				refpoly=FSel.refpoly;
				refvertices=FSel.refvertices;
				x0=FloatX(*FSel.refnode); y0=FloatY(*FSel.refnode);
				myrefnode=FSel.myrefnode;
				refnode=&myrefnode;
			}
			if (FSel.trackkpoly)
				sStr.Format("Trackpolygon %d from block %d & chunk %d selected.",refpolyno, refblock, refchunk);
			else 
				if (isxobj)
					sStr.Format("Polygon %d from extra object %d (Block %d / chunk %d) selected.",refpolyno, refpolyobj, refblock, refchunk );
				else
					sStr.Format("Polygon %d from object %d (Block %d / chunk %d) selected.",refpolyno, refpolyobj, refblock, refchunk );

			if (sStr!="") statusbar->SetPaneText(0,sStr,TRUE);
			break;
//------------------------------------------------
		case ID_MODE_OBJECT:
			if (!bShowObjects) return;
			sStr="";
			//FSel.refblock=-1; dist0=1<<30;
			FSel.refblock=-1; dist0=50;

			for (i=0;i<pDoc->nBlocks;i++) 
			{
				if (ScrollKey && (i!=refblock)) continue; //Scroll Lock active ? Then select only from current block
				if (!MeetsClipRect(&(pDoc->trk[i]),&rect)&&(nFlags!=5)) continue;
				if ((ShowBasedOnVisi)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) continue;
				pt=pDoc->trk[i].vert;
				for (j=0;j<4;j++) {
					o=&(pDoc->poly[i].obj[j]);
					if (o->n1==0) continue;
					for (k=0;k<o->nobj;k++) {
						p=o->poly[k];
						n=o->numpoly[k];
						for (l=0;l<n;l++,p++) {
							x=(FloatX(pt[p->vertex[0]])+FloatX(pt[p->vertex[1]])
							  +FloatX(pt[p->vertex[2]])+FloatX(pt[p->vertex[3]]))/4;
							y=(FloatY(pt[p->vertex[0]])+FloatY(pt[p->vertex[1]])
							  +FloatY(pt[p->vertex[2]])+FloatY(pt[p->vertex[3]]))/4;
							dist=((x>point.x)?(x-point.x):(point.x-x))
								+((y>point.y)?(y-point.y):(point.y-y));
							if (dist<dist0) {
								FSel.refblock=i; FSel.refchunk=j; FSel.objno=k;
								dist0=dist; FSel.isxobj=0;
							}
						}
					}
				}
				
				for (k=0,light=pDoc->trk[i].lightsrc;k<pDoc->trk[i].nLightsrc;k++,light++)
				{
					//MessageBox("tll!", "ALERT", MB_ICONERROR);
					x=IntX(light->refpoint);
					y=IntY(light->refpoint);
					dist=((x>point.x)?(x-point.x):(point.x-x))
						+((y>point.y)?(y-point.y):(point.y-y));
					if (dist<dist0) {
						FSel.refblock=i; FSel.refchunk=0; FSel.objno=k;
						dist0=dist;
						FSel.isxobj=2;
					//MessageBox("tll!", "ALERT", MB_ICONERROR);
					}
				}
				
				//Nappe1: Selecting sound sources:
				for (k=0,sound=pDoc->trk[i].soundsrc;k<pDoc->trk[i].nSoundsrc;k++,sound++)
				{
					x=IntX(sound->refpoint);
					y=IntY(sound->refpoint);
					dist=((x>point.x)?(x-point.x):(point.x-x))
						+((y>point.y)?(y-point.y):(point.y-y));
					if (dist<dist0) {
						FSel.refblock=i; FSel.refchunk=0; FSel.objno=k;
						dist0=dist;
						FSel.isxobj=3;
					}
				}
				// Nappe1: ADDITION ENDS 
			
			}

			//Extra objects & 2 Global object chunks
			for (i=0;i<(2 + 4*pDoc->nBlocks);i++) 
			{
				if (ScrollKey && (int(i/4)!=refblock)) continue; //Scroll Lock active ? Then select only from current block
				if ((i!=4*pDoc->nBlocks)&&(i!=1+4*pDoc->nBlocks)&&(!MeetsClipRect(&(pDoc->trk[i/4]),&rect))) { i=i|3; continue; }
				if ((ShowBasedOnVisi)&&(int(i/4)!=pDoc->nBlocks)&&(!pDoc->IsBlockVisibile(TrackViewBl,int(i/4)))) continue;
				xx=pDoc->xobj[i].obj;
				for (j=0;j<pDoc->xobj[i].nobj;j++,xx++) {
					pt=xx->vert;
					p=xx->polyData;
					for (k=0;k<xx->nPolygons;k++,p++) {
						x=(FloatFloatX(pt[p->vertex[0]],xx->ptRef)+FloatFloatX(pt[p->vertex[1]],xx->ptRef)
						  +FloatFloatX(pt[p->vertex[2]],xx->ptRef)+FloatFloatX(pt[p->vertex[3]],xx->ptRef))/4;
						y=(FloatFloatY(pt[p->vertex[0]],xx->ptRef)+FloatFloatY(pt[p->vertex[1]],xx->ptRef)
						  +FloatFloatY(pt[p->vertex[2]],xx->ptRef)+FloatFloatY(pt[p->vertex[3]],xx->ptRef))/4;
						dist=((x>point.x)?(x-point.x):(point.x-x))
							+((y>point.y)?(y-point.y):(point.y-y));
						if (dist<dist0) {
							FSel.refblock=i/4; FSel.refchunk=i%4; FSel.objno=j;
							dist0=dist; FSel.isxobj=1;
						}
					}
				}
			}
			if (bShowCams) //Select Replay Camera ?
				for (i=0;i<pDoc->Camfile.nCams;i++)
				{
					x=FloatX(pDoc->Camfile.pCamData[i].CamPosition);
					y=FloatY(pDoc->Camfile.pCamData[i].CamPosition);
					dist=((x>point.x)?(x-point.x):(point.x-x))
						+((y>point.y)?(y-point.y):(point.y-y));
					if (dist<dist0) {
						FSel.refblock=0; FSel.refchunk=0; FSel.objno=i;
						dist0=dist;
						FSel.isxobj=5;
					}
			}

			if (FSel.refblock<0) return;
			if (!IsNewSelection(FSel)) return; //Object alreay selected? -> return

			if ((nFlags&(MK_CONTROL|MK_SHIFT)) && (objno>=0)) {
				CSelData *sel=new CSelData;
				sel->multisel=multisel;
				sel->refblock=refblock;
				sel->isxobj=isxobj;
				sel->refchunk=refchunk;
				sel->objno=objno;
				if (refnode==&myrefnode) {
					sel->myrefnode.x=myrefnode.x;
					sel->myrefnode.y=myrefnode.y;
					sel->myrefnode.z=myrefnode.z;
					sel->refnode=&(sel->myrefnode);
				} 
				else sel->refnode=refnode;
				multisel=sel;
			} else {
				if (multisel!=NULL)
				{ delete multisel; multisel=NULL; }
			}
			refblock=FSel.refblock;
			isxobj=FSel.isxobj;
			refchunk=FSel.refchunk;
			objno=FSel.objno;
 
			if (FSel.isxobj==5) {  //Replay Camera
				pt=&pDoc->Camfile.pCamData[objno].CamPosition;
				refblock=pDoc->FindNearestBlock(pt);
				sStr.Format("Replay Camera %d selected", (objno + 1));	//+1 to Show same number as Nappe's CamEdit tool
			}

			if (FSel.isxobj==3) { //Sound object
				pt=&myrefnode;
				myrefnode.x=((float)pDoc->trk[FSel.refblock].soundsrc[FSel.objno].refpoint.x)/65536;
				myrefnode.y=((float)pDoc->trk[FSel.refblock].soundsrc[FSel.objno].refpoint.y)/65536;
				myrefnode.z=((float)pDoc->trk[FSel.refblock].soundsrc[FSel.objno].refpoint.z)/65536;
				sStr.Format("Sound object %d from block %d selected", objno ,refblock);
				
			}
			else if (FSel.isxobj==2) { //Light object
				pt=&myrefnode;
				myrefnode.x=((float)pDoc->trk[FSel.refblock].lightsrc[FSel.objno].refpoint.x)/65536;
				myrefnode.y=((float)pDoc->trk[FSel.refblock].lightsrc[FSel.objno].refpoint.y)/65536;
				myrefnode.z=((float)pDoc->trk[FSel.refblock].lightsrc[FSel.objno].refpoint.z)/65536;
				sStr.Format("Light object %d from block %d selected", objno ,refblock);
			}

			else if (FSel.isxobj==1) 
				if (refblock==pDoc->nBlocks) //Global object ?
				{
					pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
					pt=&pDoc->MemObjMiddle;
					sStr.Format("Global object %d selected", objno);
				}
				else
				{
					pt=&(pDoc->xobj[4*FSel.refblock+FSel.refchunk].obj[FSel.objno].ptRef);
					sStr.Format("Extra object %d from block %d and chunk %d selected", objno ,refblock, refchunk);
				}
				else if (FSel.isxobj==0) {
					pt=pDoc->trk[FSel.refblock].vert	+pDoc->poly[FSel.refblock].obj[FSel.refchunk].poly[FSel.objno]->vertex[0]; //JimD 
					sStr.Format("Polygon object %d from block %d and chunk %d selected", objno ,refblock, refchunk);
				}


			x0=FloatX(*pt); y0=FloatY(*pt);
			refnode=pt;
			
			// merge vertices command
			if ((editMode==ID_TOOLS_MERGE)&&(nFlags&MK_CONTROL)) 
			{
				OnToolsMergeObject();
				return;
			}
			if (sStr!="") statusbar->SetPaneText(0,sStr,TRUE);
			break;
	}

	GetClientRect(&rect);
	if (bScrollRotate) {
		offsetx=0; 
		offsety=0; 
		needErase=TRUE;
		ptnew.x=rect.right/2; ptnew.y=rect.bottom/2;
		ClientToScreen(&ptnew);
		if ((editMode==ID_TOOLS_MOVEXY)||(editMode==ID_TOOLS_MOVEZ))
			SetCursorPos(ptnew.x,ptnew.y);
	}
	else {	// x0,y0 == coordinates of new refnode
		offsetx=-(x0-rect.right/2); 
		offsety=-(y0-rect.bottom/2);
		if (offsetx<-rect.right/2+40)
			{ offsetx+=rect.right/2; needErase=TRUE; }
		if (offsetx>rect.right/2-40)
			{ offsetx-=rect.right/2; needErase=TRUE; }
		if (offsety<-rect.bottom/2+40)
			{ offsety+=rect.bottom/2; needErase=TRUE; }
		if (offsety>rect.bottom/2-40)
			{ offsety-=rect.bottom/2; needErase=TRUE; }
		SetScrollPos(SB_HORZ,offsetx,TRUE);
		SetScrollPos(SB_VERT,offsety,TRUE);
	}
	if (needErase) InvalidateRect(NULL,TRUE);
	else CleanCursorZone(selMode,TRUE);
	UpdateRefBlock();
	delayMouseMove=TRUE;
}

void CT3EDView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	float dx,dy,dz,dz2=0,a,b;
	RECT rect;
	CT3EDDoc *pDoc=GetDocument();
	int newblk,i,orgno,newno,orgblk;
	struct FLOATPT pt,*newpt;
	CSelData *sel,*sel2;
	CString s;
	BOOL oldbAOM, AltKey=FALSE;

	if (pDoc->MoveToPoint.DestPointSet==TRUE) isDragging=TRUE; //Manually entered move distance ?
	if (!isDragging) return;
	if (GetAsyncKeyState(VK_MENU) & 0x8000) AltKey=TRUE;

	GetClientRect(&rect);
	ShowHideCursor();
	isDragging=FALSE;
	ReleaseCapture();
	dragX=point.x; dragY=point.y;
	if (editMode==ID_TOOLS_MOVEZ) dragX=rect.right/2-offsetx;
	if (((editMode==ID_TOOLS_MOVEZ)&&(theta==0))||
		((editMode==ID_TOOLS_MOVEXY)&&(theta==90)))
		dragY=rect.bottom/2-offsety;

	dx=0; dy=0; dz=0;
	if ((editMode==ID_TOOLS_MOVEZ)&&(theta!=0))
		dz=(rect.bottom/2-offsety-dragY)*scale/sinTheta;
	if (editMode==ID_TOOLS_MOVEXY) {
		a=(dragX-rect.right/2+offsetx)*scale;
		if (theta==90) b=0;
		else b=(rect.bottom/2-offsety-dragY)*scale/cosTheta;
		dx=a*cosPhi+b*sinPhi;
		dy=-a*sinPhi+b*cosPhi;
	}
	if (pDoc->MoveToPoint.DestPointSet==TRUE) //Distance manually set
	{
		dx=pDoc->MoveToPoint.DestPt.x;
		dy=pDoc->MoveToPoint.DestPt.y;
		dz=pDoc->MoveToPoint.DestPt.z;
		pDoc->MoveToPoint.DestPointSet=FALSE;
		if (pDoc->settings.MoveTo_no_smooth) nFlags=MK_CONTROL;
	}

	// proceed with move depending on what we want
	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	pDoc->LastMove.x=dx;pDoc->LastMove.y=dy;pDoc->LastMove.z=dz;
	switch(selMode) {
		case ID_MODE_BLOCK: 
			if ((MK_CONTROL&&nFlags)==1) //Control pressed ?
				{ 
				pDoc->MoveBlockSimple(refblock,dx,dy,dz);
				//pDoc->MoveBlocks(refblock,dx,dy,dz,smooth1Start,smooth1Width,2);
				}
			else //No Control, then regular move
				pDoc->MoveBlocks(refblock,dx,dy,dz,smooth1Start,smooth1Width,extraSmooth);
			s.Format("X:%f Y:%f Z:%f InMemZ:%f", refnode->x, refnode->y, refnode->z, pDoc->memory_Zh );
			statusbar->SetPaneText(3,s,TRUE);
			break;
		case ID_MODE_POINT:
			for (sel=this;sel!=NULL;sel=sel->multisel)
				memcpy(sel->origpos,sel->refnode,12);
			for (sel=this;sel!=NULL;sel=sel->multisel)
				if (fabs(sel->refnode->x-sel->origpos->x)+
					fabs(sel->refnode->y-sel->origpos->y)+
					fabs(sel->refnode->z-sel->origpos->z) < 1E-3)
						pDoc->MovePointBy(sel->refnode,dx,dy,dz);
			break;
			pDoc->MovePointBy(refnode,dx,dy,dz);
			break;
		case ID_MODE_EXTPOINT:
			pDoc->ExtMovePointBy(refnode,dx,dy,dz,(float)smooth2Start,(float)smooth2Width);
			break;
		case ID_MODE_OBJECT:
			for (sel=this;sel!=NULL;sel=sel->multisel)
				sel->origflag=TRUE;
			for (sel=this;sel!=NULL;sel=sel->multisel) 
				
			if (sel->origflag)
			{
				orgblk=sel->refblock;
				orgno=sel->objno;
				oldbAOM=pDoc->bAutoObjMem;
				if (orgblk==pDoc->nBlocks) //No block change for global objects
					pDoc->bAutoObjMem=false;
				newblk=pDoc->MoveObjectBy(orgblk,sel->isxobj,sel->refchunk,orgno,dx,dy,dz, AltKey, ShowFwSPD);
				if (!(sel->isxobj>3)) //Not for VRoad & Camera objects
				{
					pDoc->bAutoObjMem=oldbAOM;
					for (sel2=this;sel2!=NULL;sel2=sel2->multisel)
						if ((sel2->refblock==orgblk)&&
							(sel2->isxobj==sel->isxobj)&&
							(sel2->refchunk==sel->refchunk)&&
							(sel2->objno==orgno))
								sel2->origflag=FALSE;
					if (newblk!=orgblk)
						{
						if (sel->isxobj==3) {
							newno=pDoc->trk[newblk].nSoundsrc-1;
						} else
						if (sel->isxobj==2) {
							newno=pDoc->trk[newblk].nLightsrc-1;
						} else
						if (sel->isxobj==1) {
							newno=pDoc->xobj[4*newblk+sel->refchunk].nobj-1;
							newpt=&(pDoc->xobj[4*newblk+sel->refchunk].obj[newno].ptRef);
						} else {
							newno=pDoc->poly[newblk].obj[sel->refchunk].nobj-1;
							newpt=pDoc->trk[newblk].vert+
								pDoc->poly[newblk].obj[sel->refchunk].poly[newno]->vertex[0];
						}
						for (sel2=this;sel2!=NULL;sel2=sel2->multisel)
							if ((sel2->refblock==orgblk)&&
								(sel2->isxobj==sel->isxobj)&&
								(sel2->refchunk==sel->refchunk)) 
							{
								if (sel2->objno>orgno) sel2->objno--;
								else if (sel2->objno==orgno) { 
									sel2->objno=newno;
									sel2->refblock=newblk;
									if (sel2->isxobj!=2) sel2->refnode=newpt;
								}
							}
					}
				}
				pDoc->RecalcBoundingBox(orgblk);
				pDoc->RecalcBoundingBox(newblk);
			}
			UpdateRefBlock();
			//UpdateStatusbar();
			break;
		case ID_MODE_VROADEDIT:
			for (sel=this;sel!=NULL;sel=sel->multisel)
				sel->origflag=TRUE;
			for (sel=this;sel!=NULL;sel=sel->multisel) 
			if (sel->origflag)
			{
				orgblk=sel->refblock;
				orgno=sel->objno;
				newblk=pDoc->MoveObjectBy(orgblk,sel->isxobj,sel->refchunk,orgno,dx,dy,dz, AltKey, ShowFwSPD);
				if (isxobj==IS_AI_POINT)  //AI Point
				{
					CString sStr;
					int Speed;
					if (ShowFwSPD) 
					{
						Speed=pDoc->spdFAbin[objno].Speedvalue;
						sStr.Format("Forward AI Point object %d from block %d selected. Speed is %d,", objno ,refblock,Speed);
					}
					else 
					{
						Speed=pDoc->spdRAbin[objno].Speedvalue;
						sStr.Format("Backward AI Point object %d from block %d selected.Speed is %d,", objno ,refblock,Speed);
					}
					statusbar->SetPaneText(0,sStr,TRUE);
				}
				UpdateRefBlock();
			}
			break;
		
		case ID_MODE_POLYGON:
			for (sel=this;sel!=NULL;sel=sel->multisel) 
			{
				if (sel->refpoly!=NULL)
					for (i=0;i<4;i++) 
					{
						memcpy(sel->origpos+i,
							sel->refvertices+sel->refpoly->vertex[i],12);
						if (sel->isxobj) { 
							sel->origpos[i].x+=sel->xobjrefnode->x;
							sel->origpos[i].y+=sel->xobjrefnode->y;
							sel->origpos[i].z+=sel->xobjrefnode->z;
						}
					}
			}
			for (sel=this;sel!=NULL;sel=sel->multisel) {
				if (sel->refpoly!=NULL)
					for (i=0;i<4;i++) 
					{
						memcpy(&pt,
							sel->refvertices + sel->refpoly->vertex[i],12);
						if (sel->isxobj) { 
							pt.x+=sel->xobjrefnode->x;
							pt.y+=sel->xobjrefnode->y;
							pt.z+=sel->xobjrefnode->z;
						}
						if (fabs(pt.x-sel->origpos[i].x)+
							fabs(pt.y-sel->origpos[i].y)+
							fabs(pt.z-sel->origpos[i].z) < 1E-3)
								pDoc->MovePointBy(&pt,dx,dy,dz);
					}
			}
			break;
	}
	InvalidateRect(NULL,TRUE);
	if ((selMode==ID_MODE_POLYGON)&&isxobj) return; // no scroll !
	offsetx=rect.right/2-dragX;
	offsety=rect.bottom/2-dragY;
	for (sel=this;sel!=NULL;sel=sel->multisel)
		if (sel->refnode==&sel->myrefnode) {
			sel->myrefnode.x+=dx; 
			sel->myrefnode.y+=dy; 
			sel->myrefnode.z+=dz;
		}
}


void CT3EDView::OnUpdateEditUndo(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((!isEmpty)&&(GetDocument()->undoLevel>0));
}

void CT3EDView::OnEditUndo() 
{
	CT3EDDoc *pDoc=GetDocument();
	int lev=pDoc->undoLevel-1;

	if (multisel) delete multisel; multisel=NULL;
	refnode=&myrefnode;
	memcpy(refnode,&(pDoc->undoRefpt[lev]),12);
	refblock=pDoc->undoRefblk[lev];
	offsetx=pDoc->undoOfsx[lev];
	offsety=pDoc->undoOfsy[lev];
	pDoc->PerformUndo(false);
	isTruePoint=FALSE; refpoly=NULL; objno=-1; isxobj=0;
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnUpdateModeSmoothing(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&(selMode==ID_MODE_BLOCK||selMode==ID_MODE_EXTPOINT));
}

void CT3EDView::OnModeSmoothing() 
{
	if (selMode==ID_MODE_BLOCK) {
		CSmoothingBox1 dlg;
		dlg.m_sDist=smooth1Start;
		dlg.m_sWidth=smooth1Width;
		dlg.m_extraSmooth=extraSmooth;
		if (dlg.DoModal()!=IDOK) return;
		smooth1Start=dlg.m_sDist;
		smooth1Width=dlg.m_sWidth;
		extraSmooth=dlg.m_extraSmooth;
	}
	if (selMode==ID_MODE_EXTPOINT) {
		CSmoothingBox2 dlg;
		dlg.m_sDist=smooth2Start;
		dlg.m_sWidth=smooth2Width;
		if (dlg.DoModal()!=IDOK) return;
		smooth2Start=dlg.m_sDist;
		smooth2Width=dlg.m_sWidth;
	}
}

void CT3EDView::OnUpdateEditmodesExtrasmoothing(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&(selMode==ID_MODE_BLOCK));
	pCmdUI->SetCheck(!isEmpty&&extraSmooth);
}

void CT3EDView::OnEditmodesExtrasmoothing() 
{
	extraSmooth=!extraSmooth;	
}

void CT3EDView::OnUpdateToolsDelete(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&
	   (((selMode==ID_MODE_OBJECT)&&(objno!=-1))||
		((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL))||
		((selMode==ID_MODE_BLOCK)&&(refblock!=-1))));
}

void CT3EDView::OnToolsDelete() 
{
	//CDC *dc;
	//RECT rect;
	int i;
	CT3EDDoc *pDoc=GetDocument();
	CSelData *sel;

	if (selMode==ID_MODE_BLOCK)
	{
		//if (MessageBox("There is no undo for this operation. You really want to delete this block ?","T3ED",MB_YESNO)==IDNO) return;
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		pDoc->PrepareModifyCameras();
		pDoc->PrepareModifyVRoadHeightsSpdFiles();
		//pDoc->PrepareModifyXobj(pDoc->nBlocks); //Global objects
		for (i=refblock;i<pDoc->nBlocks;i++)
		{
			pDoc->PrepareModifyTrk(i);
			pDoc->PrepareModifyPoly(i);
			pDoc->PrepareModifyXobj(i);
		}

		refblock=pDoc->DeleteBlock(refblock);
		pDoc->RecalcBoundingBox(refblock);
		refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
		UpdateRefBlock();
		InvalidateRect(NULL,TRUE);

		return;
	}
	//Copy actual position
	myrefnode.x=refnode->x; 
	myrefnode.y=refnode->y; 
	myrefnode.z=refnode->z;

	//Multisel Polygon Delete
	if (selMode==ID_MODE_POLYGON)
	{
		for (sel=this;sel!=NULL;sel=sel->multisel) //Safety Check
		{
			if ((selMode==ID_MODE_POLYGON)&&(!sel->isxobj)&&(sel->refpolyobj==-1)&&(sel->refchunk<=4)&&!(sel->refchunk&1))
				if (pDoc->poly[refblock].sz[refchunk]==1) {AfxMessageBox("Can't remove the last polygon of a block !");return;}
		}
		
		//Check Ok, then go on
		/*dc=GetDC(); // delete object to avoid flicker
		dc->SelectObject(redPen);
		dc->SetROP2(R2_WHITE);
		GetClientRect(&rect);
		ShowSelectionAt(dc,rect.right/2-offsetx,rect.bottom/2-offsety);
		ReleaseDC(dc);*/

		//Now delete
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //Make undo point
		for (sel=this;sel!=NULL;sel=sel->multisel)
		{
			if (!isxobj&&(refchunk==4)&&(refpolyobj==-1)) 
			{
				pDoc->DelTrackPolygon(sel->refblock,sel->refpolyno);
				SelCorrectPolyAfterPolyDel(sel->refblock, sel->refchunk, sel->isxobj, sel->refpolyobj, sel->refpolyno);
				//InvalidateRect(NULL,TRUE);
			} 
			else 
			{
				if (pDoc->DelPolygon(sel->refblock, sel->isxobj, sel->refchunk,sel->refpolyobj, sel->refpolyno))
					SelCorrectPolyAfterObjectDel(sel->refblock, sel->refchunk, sel->isxobj, sel->refpolyobj); //Last poly of object, object was deleted.
				else
					SelCorrectPolyAfterPolyDel(sel->refblock, sel->refchunk, sel->isxobj, sel->refpolyobj, sel->refpolyno);
			}
		}
	}
	if (selMode==ID_MODE_OBJECT) //Multisel Object Delete
	{
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //Make undo point
		for (sel=this;sel!=NULL;sel=sel->multisel)
		{
			pDoc->DelObject(sel->refblock, sel->isxobj, sel->refchunk, sel->objno);
			SelCorrectObjectAfterObjectDel(sel->refblock, sel->refchunk, sel->isxobj, sel->objno);
		}
	}

	// Everything deleted, let's clear Sel Data
	if (multisel) { delete multisel; multisel=NULL; }
	objno=-1; refpoly=NULL; isxobj=NULL;
	refnode=&myrefnode;
	InvalidateRect(NULL,TRUE);
}


void CT3EDView::OnUpdateToolsDuplicate(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&
		(((selMode==ID_MODE_OBJECT)&&(bShowObjects))||
		((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL))));
}

void CT3EDView::OnToolsDuplicate() 
{
	CT3EDDoc *pDoc=GetDocument();
	CNewobjDlg newDlg;
	int texture,xtype, numPolys=0;
	short flags;
	//struct XOBJDATA *x;
	CSelData *sel;
	CString sStaStr="";
	BOOL AltKey=FALSE;
	if (GetAsyncKeyState(VK_MENU) & 0x8000) AltKey=TRUE;

	if (selMode==ID_MODE_OBJECT) { // object new/duplicate
		// multisel doesn't work here
		if (multisel) delete multisel; multisel=NULL;
		if (objno==-1) {
			newDlg.qfs=&(pDoc->qfsView);
			newDlg.m_flags=-32768;
			if (newDlg.DoModal()!=IDOK) return;
			isxobj=newDlg.m_xobj;
			refchunk=newDlg.m_chunk;
			texture=newDlg.m_texture;
			flags=newDlg.m_flags;
			xtype=newDlg.xobj_crosstype;
		}
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		if (objno==-1) {
			pDoc->NewObject(refblock,isxobj,refchunk,texture,flags,xtype);
			offsetx=0; offsety=0;
			if (isxobj)
				sStaStr.Format("Extra object for block %d chunk %d created.", refblock, refchunk);
			else
				sStaStr.Format("Polygon object for block %d chunk %d created.", refblock, refchunk);
			statusbar->SetPaneText(0,sStaStr,TRUE);
		}
		else 
		{
			pDoc->DuplObject(refblock,isxobj,refchunk,objno);
			if (isxobj)
				sStaStr.Format("Extra object block %d chunk %d duplicated.", refblock, refchunk);
			else
				sStaStr.Format("Polygon object block %d chunk %d duplicated.", refblock, refchunk);
			statusbar->SetPaneText(0,sStaStr,TRUE);
		}

		InvalidateRect(NULL,(objno==-1));
		if (isxobj==3) {
			objno=pDoc->trk[refblock].nSoundsrc-1;
			// refnode is still &myrefnode
		} else 
		if (isxobj==2) {
			objno=pDoc->trk[refblock].nLightsrc-1;
			// refnode is still &myrefnode
		} else
		if (isxobj==1) {
			objno=pDoc->xobj[4*refblock+refchunk].nobj-1;
			refnode=&(pDoc->xobj[4*refblock+refchunk].obj[objno].ptRef);
		} else {
			objno=pDoc->poly[refblock].obj[refchunk].nobj-1;
			refnode=pDoc->trk[refblock].vert+
				pDoc->poly[refblock].obj[refchunk].poly[objno]->vertex[0];
		}
		//InvalidateRect(NULL,TRUE);
	} 
	else 
		{ // polygon duplicate
			bool IsLast;
			sel=this;
			pDoc->PrepareNewUndo(sel->refnode,sel->refblock,offsetx,offsety);
			for (sel=this;sel!=NULL;sel=sel->multisel) 
			{
				if (!sel->isxobj&&(sel->refpolyobj==-1))
				{
					if (sel->refchunk==4) //Highpoly Trackpoly duplicate
					{
						IsLast=pDoc->TrackPolygonIsLastInRow(sel->refblock,sel->refchunk, sel->refpolyno);
						if (!AltKey && (sel->refchunk==4) && (pDoc->TrackPolygonIsFirstInRow(sel->refblock,sel->refchunk, sel->refpolyno) | IsLast))
							pDoc->AddTrackPolygonBeforeAfter(sel->refblock, sel->refchunk, sel->refpolyno);
						else 
						pDoc->DuplTrackPolygon(sel->refblock,sel->refpolyno);
					}
					else //Lane / Fance duplicate and Midres or Low track poly
						//sel->refpolyno=pDoc->DuplPolygon(sel->refblock,sel->isxobj,sel->refchunk,sel->refpolyobj,sel->refpolyno);
					    pDoc->DuplPolygon(sel->refblock,sel->isxobj,sel->refchunk,sel->refpolyobj,sel->refpolyno);
						//pDoc->DuplTrackPolygon(sel->refblock,sel->refpolyno);

					SelCorrectAfterPolyAdd(sel->refblock, sel->refchunk, sel->isxobj, sel->refpolyobj, sel->refpolyno, IsLast);
				}
				else //Object polygon duplicate
				{
					sel->refpolyno=pDoc->DuplPolygon(sel->refblock,sel->isxobj,sel->refchunk,sel->refpolyobj,sel->refpolyno);
					SelCorrectAfterPolyAdd(sel->refblock, sel->refchunk, sel->isxobj, sel->refpolyobj, sel->refpolyno, true);
				}
				numPolys++;
			}
			sStaStr.Format("%d polygon(s) duplicated.", numPolys);	//Show in statusbar
			statusbar->SetPaneText(0,sStaStr,TRUE);
			InvalidateRect(NULL,TRUE);
		}
}

void CT3EDView::OnExportObject() // Export with center point
{
	ExportSelectedObject(true);
}

void CT3EDView::OnExportObjectWZero() 
{
	ExportSelectedObject(false);	
}

bool CT3EDView::ExportSelectedObject(bool UseCenter)
{
	CT3EDDoc *pDoc=GetDocument();
	CString defPath,defName,filename,fname,sStr;
	CSelData *sel;
	struct NOBJDATA NewObjData;
	bool Ret=true;

	if (multisel) delete multisel; multisel=NULL;
	sel=this;

	if ((selMode==ID_MODE_OBJECT)&&(sel->objno>=0)) //Object selected ?
	{
		CFileDialog m_ldFile(FALSE,"off",defName,OFN_FILEMUSTEXIST|OFN_HIDEREADONLY,"Object File (*.off)|*.off|All Files (*.*)|*.*||");
		if (m_ldFile.DoModal() != IDOK) return false; // Dialogfeld ffnen zeigen und Ergebnis auffangen
		filename = m_ldFile.GetPathName();// Gewhlten Pfad & Dateinamen ermitteln
		fname = m_ldFile.GetFileName();// Gewhlten Dateinamen ermitteln
		if (!(GetFileAttributes(filename) == 0xFFFFFFFF))
			if (MessageBox("File already exists. Continue ?","T3ED",MB_OKCANCEL)==IDCANCEL) return false;

		pDoc->FindObjMinMax(sel->refblock,sel->isxobj,sel->refchunk,sel->objno);
		pDoc->CreateObjectData(&NewObjData,sel->refblock,sel->isxobj,sel->refchunk,sel->objno,UseCenter);
		if (NewObjData.nPoly>0)
			if (pDoc->SaveOffFile(&NewObjData,filename))
			{
				sStr.Format("Object successfully exported into '%s'.",fname);
				statusbar->SetPaneText(0,sStr,TRUE);
			}
			else
			{
				MessageBox("Object export failed.","T3ED",MB_ICONWARNING);
				Ret=false;
			}
		dofree(NewObjData.Vertices); //Give back memory
		dofree(NewObjData.vertshade);
		dofree(NewObjData.Polys);
	}
	if ((selMode==ID_MODE_BLOCK)&&refblock>-1)
	{
	    CFileDialog m_ldFile(FALSE,"off",defName,OFN_FILEMUSTEXIST|OFN_HIDEREADONLY,"Object File (*.off)|*.off|All Files (*.*)|*.*||");
		if (m_ldFile.DoModal() != IDOK) return false; // Dialogfeld ffnen zeigen und Ergebnis auffangen
		filename = m_ldFile.GetPathName();// Gewhlten Pfad & Dateinamen ermitteln
		fname = m_ldFile.GetFileName();// Gewhlten Dateinamen ermitteln
		if (!(GetFileAttributes(filename) == 0xFFFFFFFF))
			if (MessageBox("File already exists. Continue ?","T3ED",MB_OKCANCEL)==IDCANCEL) return false;
		pDoc->CreateObjectData(&NewObjData,sel->refblock,0,nDetail,-1,UseCenter); //objno -1 == Create object from track block
		if (NewObjData.nPoly>0)
			if (pDoc->SaveOffFile(&NewObjData,filename))
			{
				sStr.Format("Object successfully exported into '%s'.",fname);
				statusbar->SetPaneText(0,sStr,TRUE);
			}
			else
			{
				MessageBox("Object export failed.","T3ED",MB_ICONWARNING);
				Ret=false;
			}
		dofree(NewObjData.Vertices); //Give back memory
		dofree(NewObjData.vertshade);
		dofree(NewObjData.Polys);
	}
	return Ret;

}

void CT3EDView::OnImportObject() 
{
	CString defPath,defName,filename,fname;
	CFileDialog m_ldFile(TRUE,"off",defName,OFN_FILEMUSTEXIST|OFN_HIDEREADONLY,"Object File (*.off)|*.off|All Files (*.*)|*.*||");
	// Dialogfeld ffnen zeigen und Ergebnis auffangen
	if (m_ldFile.DoModal() != IDOK) return;
	// Gewhlten Dateinamen ermitteln
	filename = m_ldFile.GetPathName();
	fname = m_ldFile.GetFileName();

	CT3EDDoc *pDoc=GetDocument();
	CString sStr = "";
	CNewobjDlg newDlg;
	int texture, xtype, objno;
	short flags;
	newDlg.qfs=&(pDoc->qfsView);
	if (newDlg.DoModal()!=IDOK) return;
	
	isxobj=newDlg.m_xobj;
	refchunk=newDlg.m_chunk;
	texture=newDlg.m_texture;
	flags=newDlg.m_flags;
	xtype=newDlg.xobj_crosstype;

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	pDoc->NewObject(refblock,isxobj,refchunk,texture,-32768,xtype); //Basis Object zum Importieren
	offsetx=0; offsety=0;
	if (isxobj==1) //Find number of new object
		objno=pDoc->xobj[4*refblock+refchunk].nobj-1;
	else
		objno=pDoc->poly[refblock].obj[refchunk].nobj-1;

	if (pDoc->ImportOffFile(filename,refblock, isxobj, refchunk, objno))
	{
		OnModeObject();
		sStr.Format("Object '%s' successfully imported.",fname);
		statusbar->SetPaneText(0,sStr,TRUE);
		/* if (isxobj==1) objno=pDoc->xobj[4*refblock+refchunk].nobj-1;
		else objno=pDoc->poly[refblock].obj[refchunk].nobj-1; */
		
		if (multisel) { delete multisel; multisel=NULL; }
		pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
		refnode=&pDoc->MemObjMiddle; //Setview to new object center
		InvalidateRect(NULL,TRUE);
	}
	else
	{
		MessageBox("Import failed.");
		pDoc->DelObject(refblock, isxobj, refchunk, objno);
		objno=-1; refpoly=NULL;
		InvalidateRect(NULL,FALSE);
	}
	//OnModeObject();
}

void CT3EDView::OnToolsMoveto() 
{
	CT3EDDoc *pDoc=GetDocument();
	int i;
	CString sStr = "";
	CMoveTo MoveToDlg;
	MoveToDlg.m_dest_x=pDoc->settings.MoveTo_dest_x;
	MoveToDlg.m_dest_y=pDoc->settings.MoveTo_dest_y;
	MoveToDlg.m_dest_z=pDoc->settings.MoveTo_dest_z;
	MoveToDlg.m_chk_no_smooth=pDoc->settings.MoveTo_no_smooth;
	MoveToDlg.block_mode=(selMode==ID_MODE_BLOCK);
	MoveToDlg.m_int_startblock=refblock;
	MoveToDlg.m_int_endblock=refblock;
	MoveToDlg.LastMove=pDoc->LastMove;
	MoveToDlg.LastDistance=pDoc->LastDistance;

	if (!(MoveToDlg.DoModal () == IDOK)) return; //Cancel pressed
	{
		pDoc->settings.MoveTo_dest_x=MoveToDlg.m_dest_x;
		pDoc->settings.MoveTo_dest_y=MoveToDlg.m_dest_y;
		pDoc->settings.MoveTo_dest_z=MoveToDlg.m_dest_z;
		pDoc->settings.MoveTo_no_smooth=MoveToDlg.m_chk_no_smooth;
		pDoc->MoveToPoint.DestPt.x=MoveToDlg.m_dest_x;
		pDoc->MoveToPoint.DestPt.y=MoveToDlg.m_dest_y;
		pDoc->MoveToPoint.DestPt.z=MoveToDlg.m_dest_z;
		if ((MoveToDlg.m_int_startblock!=refblock)|(MoveToDlg.m_int_endblock!=refblock))
		{
			pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
			for (i=MoveToDlg.m_int_startblock;i<(MoveToDlg.m_int_endblock+1);i++)
			{
				if ((MoveToDlg.m_chk_no_smooth)&&(i<pDoc->nBlocks)) pDoc->MoveBlockSimple(i,MoveToDlg.m_dest_x,MoveToDlg.m_dest_y,MoveToDlg.m_dest_z);
			}
			sStr.Format("Block %d to %d moved.",MoveToDlg.m_int_startblock,MoveToDlg.m_int_endblock);
			statusbar->SetPaneText(0,sStr,TRUE);
			refnode=&(pDoc->trk[refblock].ptCentre);
			sStr.Format("X:%f Y:%f Z:%f InMemZ:%f", refnode->x, refnode->y, refnode->z, pDoc->memory_Zh );
			statusbar->SetPaneText(3,sStr,TRUE);
			UpdateRefBlock();
			InvalidateRect(NULL,TRUE);
		}
		else //Move one Block, or object, or point
		{
			pDoc->MoveToPoint.DestPointSet=TRUE;
			OnLButtonUp(0,NULL);
			pDoc->MoveToPoint.DestPointSet=FALSE;
		}

		if (selMode==ID_MODE_BLOCK) refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
		OnViewRecenter();
		//InvalidateRect(NULL,TRUE);
	}	
}

void CT3EDView::OnSetVis() 
{
	CT3EDDoc *pDoc=GetDocument();
	CSetVisiDlg SetVisi;
	int start, end,i;

	//Last settings
	SetVisi.m_int_num_blocks=pDoc->settings.setvisi_int_num_blocks;
	SetVisi.m_int_tr_bl_fromto=pDoc->settings.setvisi_int_tr_bl_fromto;
	SetVisi.m_int_end=pDoc->settings.setvisi_int_end;
	SetVisi.m_edit_start=pDoc->settings.setvisi_edit_start;
	SetVisi.m_int_behavior=pDoc->settings.setvisi_behavior;

	if (!(SetVisi.DoModal () == IDOK)) return; //Cancel pressed
	   {
		if (SetVisi.m_edit_start<0) SetVisi.m_edit_start=0;
		if (SetVisi.m_int_end>=pDoc->nBlocks) SetVisi.m_int_end=pDoc->nBlocks-1;
		if (!(SetVisi.m_edit_start<SetVisi.m_int_end)) return;
		//Store settings
		pDoc->settings.setvisi_int_num_blocks=SetVisi.m_int_num_blocks;
		pDoc->settings.setvisi_int_tr_bl_fromto=SetVisi.m_int_tr_bl_fromto;
		pDoc->settings.setvisi_int_end=SetVisi.m_int_end;
		pDoc->settings.setvisi_edit_start=SetVisi.m_edit_start;
		pDoc->settings.setvisi_behavior=SetVisi.m_int_behavior;
		if (SetVisi.m_int_tr_bl_fromto==0) {
			start=refblock;
			end=refblock;}
		if (SetVisi.m_int_tr_bl_fromto==1) {
			start=SetVisi.m_edit_start;
			end=SetVisi.m_int_end;}
		if (SetVisi.m_int_tr_bl_fromto==2) {
			start=0;
			end=pDoc->nBlocks-1;}

		//Make Undo
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		for (i=start;i<end+1;i++)
			pDoc->PrepareModifyTrk(i);


		if (SetVisi.m_int_behavior==0)
			pDoc->SetVisibility(start,end,SetVisi.m_int_num_blocks);
		else
			pDoc->SetVisibilityMin(start,end,SetVisi.m_int_num_blocks);
	   }
	   pDoc->bUpdatedScene=FALSE;  //Mark Trackpreview as invalid
	   InvalidateRect(NULL,TRUE);	//Update View
}


void CT3EDView::OnToolsExpand() 
{
	CT3EDDoc *pDoc=GetDocument();
	CSelData *sel;
	CExpandDlg Expand;
	ExpandBlock ExpandB;
	CString sStr;
	FLOATPT OldMax, OldMin;
	//BOOL er;

	//Use default settings
	Expand.m_floatExpMulti_x=pDoc->settings.expand_m_floatExpMulti_x;
	Expand.m_floatExpMulti_y=pDoc->settings.expand_m_floatExpMulti_y;
	Expand.m_floatExpMulti_z=pDoc->settings.expand_m_floatExpMulti_z;
	Expand.m_chk_connected=pDoc->settings.expand_m_chk_connected;
	Expand.m_radio_alignment=pDoc->settings.expand_m_radio_alignment;
	if (multisel) delete multisel; multisel=NULL;
	sel=this;

	if ((selMode==ID_MODE_OBJECT)&&(sel->objno>=0)) //Object selected ?
	  if (pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno)) //Find Minimum & Maximum
	  {
	   if (!(Expand.DoModal () == IDOK)) return; //Cancel pressed
	   {
		   	//Store used settings
			pDoc->settings.expand_m_floatExpMulti_x=Expand.m_floatExpMulti_x;
			pDoc->settings.expand_m_floatExpMulti_y=Expand.m_floatExpMulti_y;
			pDoc->settings.expand_m_floatExpMulti_z=Expand.m_floatExpMulti_z;
			pDoc->settings.expand_m_chk_connected=Expand.m_chk_connected;
			pDoc->settings.expand_m_radio_alignment=Expand.m_radio_alignment;

		   OldMax=pDoc->MemObjMax;
		   OldMin=pDoc->MemObjMin;
		   //sStr.Format("Expand.m_radio_alignment = %i", Expand.m_radio_alignment);
		   //MessageBox(sStr, "Expand-Shrink", MB_OK);
		
		   pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
		   pDoc->ExpandObject(refblock,isxobj,refchunk,objno,Expand.m_floatExpMulti_x,Expand.m_floatExpMulti_y,Expand.m_floatExpMulti_z); //Do the expand job
		   pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno); //Find new min & max of object
		   if (Expand.m_radio_alignment==0) //Restore top position of object
			   pDoc->MoveObjectBy(refblock,isxobj,refchunk,objno,0,0,(OldMax.z-pDoc->MemObjMax.z));

		   if (Expand.m_radio_alignment==2) //Restore bottom position of object
			   pDoc->MoveObjectBy(refblock,isxobj,refchunk,objno,0,0,(OldMin.z-pDoc->MemObjMin.z));

		   InvalidateRect(NULL,TRUE);
	   }
	  }
	  if (selMode==ID_MODE_BLOCK) //Expand Block
	  {
		ExpandB.m_edit_height=pDoc->settings.expand_bl_m_edit_height;
		ExpandB.m_edit_lenght=pDoc->settings.expand_bl_m_edit_lenght;
		ExpandB.m_edit_width=pDoc->settings.expand_bl_m_edit_width;
	    if (!(ExpandB.DoModal () == IDOK)) return; //Cancel pressed
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
		pDoc->ExpandBlock(refblock,ExpandB.m_edit_lenght, ExpandB.m_edit_width,ExpandB.m_edit_height); //Expand the Block
		
		pDoc->settings.expand_bl_m_edit_height=ExpandB.m_edit_height;
		pDoc->settings.expand_bl_m_edit_lenght=ExpandB.m_edit_lenght;
		pDoc->settings.expand_bl_m_edit_width=ExpandB.m_edit_width;

		pDoc->RecalcBoundingBox(refblock);
		refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
		InvalidateRect(NULL,TRUE);
	  }
}

void CT3EDView::OnToolsInvert() 
{
	CT3EDDoc *pDoc=GetDocument();
	CSelData *sel;
	LPPOLYGONDATA p;
	int vertdata[4], i;
	if (selMode==ID_MODE_POLYGON) //Quick Polygon rotation
	{
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		for (sel=this;sel!=NULL;sel=sel->multisel) 
		{
		  if (sel->isxobj)
			  pDoc->PrepareModifyXobj(4*sel->refblock+sel->refchunk);
		  else 
			  pDoc->PrepareModifyPoly(sel->refblock);
		  p=sel->refpoly;
		  for (i=0;i<4;i++)
			  vertdata[i]=p->vertex[i];
		  p->vertex[0]=vertdata[1];
		  p->vertex[1]=vertdata[0];
		  p->vertex[2]=vertdata[3];
		  p->vertex[3]=vertdata[2];
		  InvalidateRect(NULL,TRUE);
		}
	}
}

void CT3EDView::OnToolsRotate() 
{
	CT3EDDoc *pDoc=GetDocument();
	CSelData *sel;
	CRotateDlg RotateDlg;
	CString sStr;
	LPPOLYGONDATA p;
	int i,vertexnr;
	//double pi = 3.1415926535;
	//double rangle, sinrangle;
	BOOL AltKey=FALSE;
	if (GetAsyncKeyState(VK_MENU) & 0x8000) AltKey=TRUE;
	
	if (selMode==ID_MODE_POLYGON) //Quick Polygon rotation
	{
		if (refpoly==NULL) return;
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		for (sel=this;sel!=NULL;sel=sel->multisel) 
		{
		  if (sel->isxobj)
			pDoc->PrepareModifyXobj(4*sel->refblock+sel->refchunk);
		  else pDoc->PrepareModifyPoly(sel->refblock);
		  p=sel->refpoly;
		  vertexnr=p->vertex[0];
		  for (i=0;i<3;i++)
			  p->vertex[i]=p->vertex[i+1];
		  p->vertex[3]=vertexnr;
		  if (pDoc->bHSMode&&AltKey) //In HS Mode with Alt Key: Rotate Texture, too.
		  {
			  unsigned short m_flags=p->hs_textflags;

				int		m_rotation=(m_flags>>2)&3;
				int 	m_tiling=(m_flags>>6)&7;
					if (m_tiling>4) m_tiling=-1;
				BOOL m_fliph=(m_flags&0x10)?TRUE:FALSE;
				BOOL m_flipv=(m_flags&0x20)?TRUE:FALSE;
				BOOL m_twosided=(m_flags&0x8000)?TRUE:FALSE;
				BOOL m_BitTest=(m_flags&0x1)?TRUE:FALSE;

				m_rotation++;if (m_rotation>3) m_rotation=0;//Rotate 90
			    m_flags=(m_rotation << 2) + (m_tiling << 6)
						+(m_fliph?0x10:0)+(m_flipv?0x20:0)
						+(m_twosided?0x8000:0) +(m_BitTest?0x7E01:0);

				p->hs_textflags=m_flags;

		  }
		  InvalidateRect(NULL,TRUE);
		}
	}
	if ((selMode==ID_MODE_OBJECT)&&(objno!=-1)) //Object selected ?
	{
		if (multisel) delete multisel; multisel=NULL;
		sel=this;
	   RotateDlg.m_edit_angle=pDoc->settings.rotate_m_edit_angle;
	   RotateDlg.m_str_rtext="Rotate object with an angle of : ";
	   if (!(RotateDlg.DoModal () == IDOK)) return; //Cancel pressed ?
	   {
		   pDoc->settings.rotate_m_edit_angle=RotateDlg.m_edit_angle;
		   //rangle=((RotateDlg.m_edit_angle/180) * pi);
		   //sinrangle=sin( rangle );
		   //sStr.Format("RotateDlg.m_edit_angle = %f",RotateDlg.m_edit_angle );
		   //MessageBox(sStr, "T3ED Rotate", MB_OK);	
		   pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
		   //pDoc->ExpandObject(refblock,isxobj,refchunk,objno,Expand.m_floatExpMulti_x,Expand.m_floatExpMulti_y,Expand.m_floatExpMulti_z); //Do the expand job
		   pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno); //Find new min & max of object
		   pDoc->RotateObject(refblock,isxobj,refchunk,objno,RotateDlg.m_edit_angle); //Rotate object
		   InvalidateRect(NULL,TRUE);
	   }
	}

	if ((selMode==ID_MODE_BLOCK)&&(refblock>-1)) //Block selected ?
	{
	   if (multisel) delete multisel; multisel=NULL;
	   sel=this;
	   RotateDlg.m_edit_angle=pDoc->settings.rotate_m_edit_angle;
	   RotateDlg.m_str_rtext="Rotate block with an angle of : ";
	   if (!(RotateDlg.DoModal () == IDOK)) return; //Cancel pressed ?
	   {
		   pDoc->settings.rotate_m_edit_angle=RotateDlg.m_edit_angle;
		   //rangle=((RotateDlg.m_edit_angle/180) * pi);
		   //sinrangle=sin( rangle );
		   //sStr.Format("RotateDlg.m_edit_angle = %f",RotateDlg.m_edit_angle );
		   //MessageBox(sStr, "T3ED Rotate", MB_OK);	
		   pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
		   pDoc->RotateBlock(refblock,RotateDlg.m_edit_angle);
		   //pDoc->ExpandObject(refblock,isxobj,refchunk,objno,Expand.m_floatExpMulti_x,Expand.m_floatExpMulti_y,Expand.m_floatExpMulti_z); //Do the expand job
		   //pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno); //Find new min & max of object
		   //pDoc->RotateObject(refblock,isxobj,refchunk,objno,RotateDlg.m_edit_angle); //Rotate object
		   InvalidateRect(NULL,TRUE);
	   }
	}
}

void CT3EDView::OnUpdateToolsTexture(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&
	   (((selMode==ID_MODE_OBJECT)&&(objno!=-1))||
		((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL))||(selMode==ID_MODE_BLOCK)));
}

void CT3EDView::OnToolsTexture() 
{
	CT3EDDoc *pDoc=GetDocument();
	CQFSView *qfs=&(pDoc->qfsView);
	CSelData *sel;
	CString sStr = "Test", sAlso ="", s2;
	LPPOLYGONDATA p;
	struct OBJPOLYBLOCK *o;
	struct XOBJDATA *x;
	int mintex=9999;
	int i, k=0, l=0, num=0;
	int offset=0;

	if (selMode==ID_MODE_POLYGON)
	{
	  //Shadingtmp unsigned long;
	  qfs->m_nBmp=refpoly->texture;
	  qfs->m_flags=refpoly->hs_textflags;
	  qfs->polyunknown2=refpoly->unknown2;
	  qfs->m_char_unknow2=refpoly->unknown2; //View unknown2
	  qfs->texanimdata=refpoly->texanimdata; //Nappe1: Should work for NFSHS ANIMData... //NFS3 Double Side 

	  qfs->bHasHitFlags=FALSE;
	  if (pDoc->bHSMode) // HS Mode
		sStr.Format("Select new texture.\nCurrently number %u is used.\nHS Extra %X, Animdata %X\n",refpoly->texture, refpoly->hs_textflags, refpoly->texanimdata);
	  else
	  {
		sStr.Format("Select new texture id.\nCurrently number %u (%u) is used. Unknown2 is %u\n",refpoly->texture, pDoc->texture[refpoly->texture].texture, refpoly->unknown2);
		sAlso="";
		num=0;
		for (i=0;i<pDoc->nTextures;i++)
		{
			if (pDoc->texture[refpoly->texture].texture==pDoc->texture[i].texture)
			{
				if (num==0) 
					s2.Format("%u",i);
				else 
					s2.Format(",%u",i);
				num++;
				sAlso=sAlso + s2;
			}
		}
		if (num>1)
			sStr=sStr + "Same texture used as " + sAlso +".";
	  }
	  if (!pDoc->bHSMode)
		qfs->m_strBitLabel="Texture Id";

	  qfs->m_strLabel=sStr;
	  //qfs->OnChangeEdit1;
	  //qfs->m_numQFS="Numqfs";
	  if (qfs->DoModal()!=IDOK) return;
	  pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	  for (sel=this;sel!=NULL;sel=sel->multisel) {
		if (sel->isxobj)
			pDoc->PrepareModifyXobj(4*sel->refblock + sel->refchunk);
		else 
			pDoc->PrepareModifyPoly(sel->refblock);
		sel->refpoly->texture=qfs->m_nBmp;
		
		if (pDoc->bHSMode && qfs->bHasHitFlags)
			{
			sel->refpoly->hs_textflags=qfs->m_flags;
			sel->refpoly->texanimdata=qfs->texanimdata; //Nappe1: updating AnimData to the refpoly.
			refpoly->unknown2=qfs->polyunknown2;
			}
		if (!pDoc->bHSMode && qfs->bHasHitFlags)  //Update NFS3 Texture Properties
			{
			sel->refpoly->unknown2=qfs->polyunknown2; //Update changes of unknown2
			sel->refpoly->texanimdata=qfs->texanimdata; //Used for double sided Textures
			}
	  }
	}
	if (selMode==ID_MODE_OBJECT) //JimD: Now it's possible to change all textures of an object
	{
		  for (sel=this;sel!=NULL;sel=sel->multisel) //look at all objects
		  {
			if (sel->isxobj>1) return; //Special object selected -> no texture
			if ((sel->isxobj==0)||(sel->isxobj==1)) //Only available for objects
			  mintex=pDoc->MinTexObject(sel->refblock,sel->isxobj,sel->refchunk,sel->objno,mintex); // Get the lowest texture number from current object
		  }
		  qfs->m_nBmp=mintex; //Select lowest as default
		  sel=this;
		  if (isxobj==0) //set pointer to first polygon of object
			{
			  o=&pDoc->poly[sel->refblock].obj[sel->refchunk];
			  p=o->poly[sel->objno];
			}
		  if (isxobj==1) //set pointer to first polygon of extra object
			{
			  x=&pDoc->xobj[4*sel->refblock+sel->refchunk].obj[sel->objno];
			  p=x->polyData;
			}

		  qfs->m_flags=p->hs_textflags;
		  qfs->texanimdata=p->texanimdata; //Nappe1: Should work for NFSHS ANIMData...
		  qfs->bHasHitFlags=FALSE;

	      sStr.Format("Select new textures for object. Currently number %u is the lowest.",mintex);
	      qfs->m_strLabel=sStr;
	      if (qfs->DoModal()!=IDOK) return; // Show Texture Windows, End if cancel was pressed
		  offset=qfs->m_nBmp-mintex; // recalc offset for changes
		  for (sel=this;sel!=NULL;sel=sel->multisel)
			if ((sel->isxobj==0)||(sel->isxobj==1)) //Only available for objects
			{
			  pDoc->PrepareNewUndo(sel->refnode,sel->refblock,offsetx,offsety); //undo should be possible
			  pDoc->ChangeTexObject(sel->refblock,sel->isxobj,sel->refchunk,sel->objno,offset,(pDoc->bHSMode && qfs->bHasHitFlags),qfs->m_flags,qfs->texanimdata); //change poly or extra object
			}
	}
	if (selMode==ID_MODE_BLOCK)
	{
		for (sel=this;sel!=NULL;sel=sel->multisel)
			mintex=pDoc->MinTexBlock(sel->refblock,mintex);
		qfs->m_nBmp=mintex; //Select lowest as default
	    sStr.Format("Change all textures of a block. Currently number %u is the lowest.",mintex);
	    qfs->m_strLabel=sStr;
		if (qfs->DoModal()!=IDOK) return; // End if cancel was pressed
		offset=qfs->m_nBmp-mintex; // recalc offset for changes
		for (sel=this;sel!=NULL;sel=sel->multisel)
		{
		  pDoc->PrepareNewUndo(sel->refnode,sel->refblock,offsetx,offsety); //undo should be possible
		  pDoc->ChangeTexBlock(sel->refblock,offset); //Change all texture of a block with objects
		  /*for (i=0;i<pDoc->nBlocks;i++) //Change texture of whole track!
			pDoc->ChangeTexBlock(i,offset); */
		}
	}
	//HOO: (5)
	InvalidateRect(NULL,true);
	//HOO: (5)
}


//Nappe1: (DEV2.5 ADD ON) NFS HS NEIGHBOUR EDITING
void CT3EDView::OnToolsTrackBlockProps()
{
	CT3EDDoc *pDoc=GetDocument();
	CBlockProps propsdlg;
	int i;
	//CSelData *sel;
	//CString teksti = 'teksti';

	struct TRKBLOCK blk;
	//int nulld;
	//float nullf;

	blk=pDoc->trk[refblock];
	propsdlg.m_Neigh1=blk.hs_neighbors[0];
	propsdlg.m_Neigh2=blk.hs_neighbors[1];
	propsdlg.m_Neigh3=blk.hs_neighbors[2];
	propsdlg.m_Neigh4=blk.hs_neighbors[3];
	propsdlg.m_Neigh5=blk.hs_neighbors[4];
	propsdlg.m_Neigh6=blk.hs_neighbors[5];
	propsdlg.m_Neigh7=blk.hs_neighbors[6];
	propsdlg.m_Neigh8=blk.hs_neighbors[7];
	propsdlg.m_bool_merge=pDoc->settings.ConnectBlocks;
	propsdlg.m_float_Dist=pDoc->settings.ConnectBlocks_dist;
	//propsdlg.m_Neigh9=data.hs_neighbors[8];
	//propsdlg.m_clist1.AddString(teksti);

				

	if (propsdlg.DoModal()!=IDOK) return;
	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	pDoc->PrepareModifyTrk(refblock);
	
	pDoc->trk[refblock].hs_neighbors[0]=propsdlg.m_Neigh1;
	pDoc->trk[refblock].hs_neighbors[1]=propsdlg.m_Neigh2;
	pDoc->trk[refblock].hs_neighbors[2]=propsdlg.m_Neigh3;
	pDoc->trk[refblock].hs_neighbors[3]=propsdlg.m_Neigh4;
	pDoc->trk[refblock].hs_neighbors[4]=propsdlg.m_Neigh5;
	pDoc->trk[refblock].hs_neighbors[5]=propsdlg.m_Neigh6;
	pDoc->trk[refblock].hs_neighbors[6]=propsdlg.m_Neigh7;
	pDoc->trk[refblock].hs_neighbors[7]=propsdlg.m_Neigh8;
	pDoc->settings.ConnectBlocks=propsdlg.m_bool_merge;
	pDoc->settings.ConnectBlocks_dist=propsdlg.m_float_Dist;
	
	if (!propsdlg.m_bool_merge) return;
	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
	pDoc->PrepareModifyTrk(refblock);
	for (i=0;i<8;i++)
		if (pDoc->trk[refblock].hs_neighbors[i]>-1)
		{
			pDoc->PrepareModifyTrk(pDoc->trk[refblock].hs_neighbors[i]);
			pDoc->ConnectBlocks(refblock, pDoc->trk[refblock].hs_neighbors[i], propsdlg.m_float_Dist);			
			pDoc->RecalcBoundingBox(refblock);
			refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
			InvalidateRect(NULL,TRUE);
		}
}
//Nappe1: (DEV2.5 ADD ON) NFS HS NEIGHBOUR EDITING (END)

void CT3EDView::OnToolsVroadHeightsSpdfiles() 
{
	
	CVRoadHeightsSpdFileDlg VRHSFDlg;

	int min, max, i;
	struct TRKBLOCK blk;
	CString sStr;

	CT3EDDoc *pDoc=GetDocument();
	
	blk=pDoc->trk[refblock];
	if ((blk.nPositions==0)||(!pDoc->spdFALoaded)||(!pDoc->spdRALoaded)||(!pDoc->HeightsLoaded)) return;

	//Copy vRoad Info & Data 
	VRHSFDlg.bHSMode=(pDoc->bHSMode != 0); //Only used to skip the warning
	VRHSFDlg.m_nPositions=blk.nPositions;
	sStr.Format("Showing data from block %d. VRoad position starts at %d, and has %d entries.", refblock,blk.nStartPos, blk.nPositions);
	VRHSFDlg.m_Label_Txt=sStr;
	VRHSFDlg.m_colvrdata=(struct COLVROAD *)malloc(blk.nPositions*sizeof(struct COLVROAD));
	memcpy(VRHSFDlg.m_colvrdata,&pDoc->col.vroad[blk.nStartPos],blk.nPositions*sizeof(struct COLVROAD));

	VRHSFDlg.m_heightsdata=(struct HEIGHTSSIM *)malloc(blk.nPositions*sizeof(struct HEIGHTSSIM));
	memcpy(VRHSFDlg.m_heightsdata,&pDoc->hightssim[blk.nStartPos],blk.nPositions*sizeof(struct HEIGHTSSIM));

	VRHSFDlg.spdFAdata=(struct SPDFILE *)malloc(blk.nPositions*sizeof(struct SPDFILE));
	memcpy(VRHSFDlg.spdFAdata,&pDoc->spdFAbin[blk.nStartPos],blk.nPositions*sizeof(struct SPDFILE));

	VRHSFDlg.spdRAdata=(struct SPDFILE *)malloc(blk.nPositions*sizeof(struct SPDFILE));
	memcpy(VRHSFDlg.spdRAdata,&pDoc->spdRAbin[blk.nStartPos],blk.nPositions*sizeof(struct SPDFILE));

	VRHSFDlg.hs_extra=(struct HS_EXTRA *)malloc(blk.nPositions*sizeof(struct HS_EXTRA));
	if (pDoc->bHSMode) //Copy HS_EXTRA Data
		memcpy(VRHSFDlg.hs_extra, &pDoc->col.hs_extra[blk.nStartPos], blk.nPositions*sizeof(struct HS_EXTRA));
	else //No HS_EXTRA -> set to zero
		memset(VRHSFDlg.hs_extra, 0 ,blk.nPositions*sizeof(struct HS_EXTRA));

	VRHSFDlg.VRoadNumbers=(int *)malloc(VRHSFDlg.m_nPositions * sizeof(int)); //Create space for VRoad numbers
	for (i=0;i<VRHSFDlg.m_nPositions;i++)
		VRHSFDlg.VRoadNumbers[i]=blk.nStartPos+i;

	
	VRHSFDlg.m_Chk_Heights=pDoc->settings.VRoadHeightsSpd_Chk_Heights;
	VRHSFDlg.m_Chk_SpdFa=pDoc->settings.VRoadHeightsSpd_Chk_SpdFa;
	VRHSFDlg.m_Chk_SpdRa=pDoc->settings.VRoadHeightsSpd_Chk_SpdRa;
	VRHSFDlg.m_Chk_VRoad=pDoc->settings.VRoadHeightsSpd_Chk_VRoad;
	VRHSFDlg.m_Chk_HSExtra=pDoc->settings.VRoadHeightsSpd_Chk_HSExtra;
	VRHSFDlg.m_Chk_PVR=pDoc->settings.VRoadHeightsSpd_Chk_PVR;
	VRHSFDlg.m_Combo_Vector_Calc=pDoc->settings.VRoadHeightsSpd_Combo_Calc;
	VRHSFDlg.m_Chk_VRoad_z=pDoc->settings.VRoadHeightsSpd_Chk_VRoad_z;
	VRHSFDlg.m_Chk_AI_Lane_Recalc=pDoc->settings.VRoadHeightsSpd_Chk_AI_Lane_Recalc;


	if (VRHSFDlg.DoModal()!=IDOK) return; //Show Dialog.

	pDoc->settings.VRoadHeightsSpd_Chk_Heights=VRHSFDlg.m_Chk_Heights;
	pDoc->settings.VRoadHeightsSpd_Chk_SpdFa=VRHSFDlg.m_Chk_SpdFa;
	pDoc->settings.VRoadHeightsSpd_Chk_SpdRa=VRHSFDlg.m_Chk_SpdRa;
	pDoc->settings.VRoadHeightsSpd_Chk_VRoad=VRHSFDlg.m_Chk_VRoad;
	pDoc->settings.VRoadHeightsSpd_Chk_HSExtra=VRHSFDlg.m_Chk_HSExtra;
	pDoc->settings.VRoadHeightsSpd_Chk_PVR=VRHSFDlg.m_Chk_PVR;
	pDoc->settings.VRoadHeightsSpd_Combo_Calc=VRHSFDlg.m_Combo_Vector_Calc;
	pDoc->settings.VRoadHeightsSpd_Chk_VRoad_z=VRHSFDlg.m_Chk_VRoad_z;
	pDoc->settings.VRoadHeightsSpd_Chk_AI_Lane_Recalc=VRHSFDlg.m_Chk_AI_Lane_Recalc;

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	//pDoc->PrepareModifyTrk(refblock);
	pDoc->PrepareModifyVRoadHeightsSpdFiles();
	//Copy back changed data	
	memcpy(&pDoc->col.vroad[blk.nStartPos], VRHSFDlg.m_colvrdata, blk.nPositions*sizeof(struct COLVROAD));
	memcpy(&pDoc->hightssim[blk.nStartPos], VRHSFDlg.m_heightsdata, blk.nPositions*sizeof(struct HEIGHTSSIM));
	memcpy(&pDoc->spdFAbin[blk.nStartPos], VRHSFDlg.spdFAdata, blk.nPositions*sizeof(struct SPDFILE));
	memcpy(&pDoc->spdRAbin[blk.nStartPos], VRHSFDlg.spdRAdata, blk.nPositions*sizeof(struct SPDFILE));
	if (pDoc->bHSMode)
		memcpy(&pDoc->col.hs_extra[blk.nStartPos], VRHSFDlg.hs_extra,  blk.nPositions*sizeof(struct HS_EXTRA));

	if (pDoc->settings.VRoadHeightsSpd_Chk_VRoad_z) //Set VRoad_Z
	{
		min=blk.nStartPos;
		max=blk.nStartPos + blk.nPositions;
		for (i=min;i<max;i++) pDoc->DropObject(refblock, IS_VROAD,0,i);
		//for (i=min;i<max;i++) pDoc->AdjustVRoadPointZ(i);
	}

	if (pDoc->settings.VRoadHeightsSpd_Chk_AI_Lane_Recalc) //Recal AI lanes
	{
		min=blk.nStartPos;
		max=blk.nStartPos + blk.nPositions;
		for (i=min;i<max;i++)
		{
			pDoc->MoveObjectBy(-1, 6, 0, i, 0, 0, 0, 1, 1); //Forward Speed File
			pDoc->MoveObjectBy(-1, 6, 0, i, 0, 0, 0, 1, 0); //Backward Speed File
		}

	}

	if (pDoc->settings.VRoadHeightsSpd_Chk_PVR) //Poly VRoad Recalc
	{
		min=blk.nStartPos;
		max=blk.nStartPos + blk.nPositions;
		for (i=min;i<max;i++) pDoc->UpdateColVroadVecs(i);
		//RecalcPolyVroad for this block
		pDoc->RecalcPolyVroadForBlock(refblock, pDoc->settings.VRoadHeightsSpd_Combo_Calc);
	}


	dofree(VRHSFDlg.m_colvrdata);
	dofree(VRHSFDlg.m_heightsdata);
	dofree(VRHSFDlg.spdFAdata);
	dofree(VRHSFDlg.spdRAdata);
	if (pDoc->bHSMode)
		dofree(VRHSFDlg.hs_extra);

	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnToolsPolyflag() 
{
	CT3EDDoc *pDoc=GetDocument();
	CPolyFlags polydlg;
	struct POLYVROADDATA *pvrdata;
	struct TRKBLOCK *t=&(pDoc->trk[refblock]);
	struct VROADDATA *vrdata;
	//struct POLYGONBLOCK *p;
	//LPPOLYGONDATA p;
	int i, test;
	CSelData *sel;

	pvrdata=pDoc->trk[refblock].polyData + refpolyno;
	vrdata=t->vroadData + pvrdata->vroadEntry;  //Select VROADDATA

	polydlg.bMultiSel=false;
	polydlg.m_walldetect=((pvrdata->flags&0x80)!=0);  //Bit 7
	polydlg.m_xobjdetect=((pvrdata->flags&0x40)!=0);  //Bit 6
	polydlg.m_no_weather_effects=((pvrdata->flags&0x20)!=0);  //Bit 5
	polydlg.m_type=(pvrdata->flags&0x1f); //Bit 0 - 4
	polydlg.bHSMode=pDoc->bHSMode;
	polydlg.bTypeOnly=FALSE;
	polydlg.m_chk_recalc_pvr=0;
	polydlg.m_chk_drive_over=1;
	polydlg.m_int_block=refblock;
	polydlg.m_int_ref_polynr=refpolyno;
	polydlg.m_int_vroadEntry=(int) pvrdata->vroadEntry;
	test=pvrdata->flags&0x0f;
	test=(pvrdata->flags&0x0f)%14;
	if ((pDoc->bHSMode)&&((pvrdata->flags&0x0f)%14!=0)) 
	{
		polydlg.m_hsForwNeighbor=(pvrdata->hs_orphan[0]!=0);
		polydlg.m_hsBackNeighbor=(pvrdata->hs_orphan[2]!=0);
		polydlg.m_hsLeftNeighbor=(pvrdata->hs_orphan[1]!=0);
		polydlg.m_hsRightNeighbor=(pvrdata->hs_orphan[3]!=0);
	}
	if (multisel) { 
		polydlg.m_walldetect=2;
		polydlg.m_xobjdetect=2;
		polydlg.m_no_weather_effects=2;
		polydlg.m_hsForwNeighbor=2;
		polydlg.m_hsBackNeighbor=2;
		polydlg.m_hsLeftNeighbor=2;
		polydlg.m_hsRightNeighbor=2;
		polydlg.m_chk_drive_over=2;
		polydlg.bMultiSel=true;
		//polydlg.m_vredge=2;
	}

	polydlg.pUnknownData=(unsigned char *)malloc(7);
	memcpy(&polydlg.pUnknownData[0], &pvrdata->unknown[0], 6);
	if (pDoc->bHSMode) memcpy(&polydlg.pUnknownData[6], &pvrdata->hs_unknown, 1);
	
	if (polydlg.DoModal()!=IDOK) return;

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);

	memcpy(&pvrdata->unknown[0], &polydlg.pUnknownData[0], 6);
	if (pDoc->bHSMode) memcpy(&pvrdata->hs_unknown, &polydlg.pUnknownData[6], 1);

	for (sel=this;sel!=NULL;sel=sel->multisel) 
		if ((sel->refpolyobj==-1)&&(sel->refchunk==4))
	{
		pDoc->PrepareModifyTrk(sel->refblock);
		pvrdata=pDoc->trk[sel->refblock].polyData+sel->refpolyno;

		if ((pDoc->bHSMode)&&(polydlg.m_type%14!=0)) {
			if (polydlg.m_hsForwNeighbor<=1)
				pvrdata->hs_orphan[0]=polydlg.m_hsForwNeighbor?0xFF:0;
			if (polydlg.m_hsBackNeighbor<=1)
				pvrdata->hs_orphan[2]=polydlg.m_hsBackNeighbor?0xFF:0;
			if (polydlg.m_hsLeftNeighbor<=1)
				pvrdata->hs_orphan[1]=polydlg.m_hsLeftNeighbor?0xFF:0;
			if (polydlg.m_hsRightNeighbor<=1)
				pvrdata->hs_orphan[3]=polydlg.m_hsRightNeighbor?0xFF:0;

		}

		//pvrdata->flags=(pvrdata->flags&0x70)+polydlg.m_type; JimD: Why? I am using this now:
		if (polydlg.m_chk_drive_over==1) pvrdata->flags=(pvrdata->flags&0xE0) + polydlg.m_type; //Clear Bit 0 - 4 and add type
		if (polydlg.m_no_weather_effects==1) pvrdata->flags|=0x20; //Bit 5 = 1
		if (polydlg.m_no_weather_effects==0) pvrdata->flags&=0xdf; //Bit 5 = 0
		if (polydlg.m_xobjdetect==1) pvrdata->flags|=0x40; //Bit 6 = 1
		if (polydlg.m_xobjdetect==0) pvrdata->flags&=0xbf; //Bit 6 = 0
		if (polydlg.m_walldetect==1) pvrdata->flags|=0x80; //Bit 7 = 1
		if (polydlg.m_walldetect==0) pvrdata->flags&=0x7f; //Bit 7 = 0

		//JimD: Why this???
		if ((polydlg.m_type%14!=0)&&((pvrdata->flags&0x1f)%14==0))
			pvrdata->flags|=0x80; // made it passable : beware of neighbors

		int refnodeno = 0;
		int n = sel->refpolyno;
		for (i = 0; i < pDoc->trk[sel->refblock].nPositions; i++)
		{
			if (n < pDoc->trk[sel->refblock].posData[i].nPolygons)
				break;

			n -= pDoc->trk[sel->refblock].posData[i].nPolygons;
			refnodeno++;
		}

		pDoc->CorrectVirtualRoad(sel->refblock, refnodeno);

		//Change PolyVroad ?
		if (polydlg.m_chk_recalc_pvr==1)
		{
			pvrdata=pDoc->trk[sel->refblock].polyData + sel->refpolyno;
			struct FLOATPT *v, fpt;  //*vrdata;
			struct POLYGONDATA *p;
			vec3 p1, p2, point[4], direction;

			v=pDoc->trk[sel->refblock].vert;
			p=pDoc->poly[sel->refblock].poly[4] + sel->refpolyno;
			for (i=0;i<4;i++)
				point[i]=v[p->vertex[i]];

			switch(polydlg.m_combo_pvr)
			{
			case 0: //Full Left
				p1=point[0]; //Left Up
				p2=(point[0] + point[2])*0.5; //Poly middle
				break;
			case 1: //Left
				p1=point[0]; //Left Up
				p2=(point[3] + point[2])*0.5; //Middle down
				break;
			case 2:  //Straight Fw
				p1=(point[0] + point[1])*0.5; //Middle Up
				p2=(point[3] + point[2])*0.5; //Middle down
				break;
			case 3:  //Right 
				p1=point[1]; //Right Up
				p2=(point[3] + point[2])*0.5; //Middle down
				break;
			case 4:  //Full Right 
				p1=point[1]; //Right Up
				p2=(point[0] + point[2])*0.5; //Poly middle
				break;
			default: //Straight Fw
				p1=(point[0] + point[1])*0.5; //Middle Up
				p2=(point[3] + point[2])*0.5; //Middle down
			}
			direction=p1 - p2;
			fpt=pDoc->Vec3ToFloatpt(direction);
			pDoc->RecalcPolyVroad(sel->refblock, sel->refpolyno, &fpt);
		}

	}
	InvalidateRect(NULL, TRUE);
	RedrawWindow();
}

void CT3EDView::OnUpdateToolsPolyflag(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&(selMode==ID_MODE_POLYGON)&&(refpoly!=NULL)
		&&(refpolyobj==-1)&&(refchunk==4));
}

void CT3EDView::OnToolsMerge() 
{
	if (isDragging) return; // safety
	if (editMode==ID_TOOLS_MERGE) editMode=NULL;
	else editMode=ID_TOOLS_MERGE;
	if (multisel) {
		CleanCursorZone(selMode,FALSE);
		delete multisel; multisel=NULL;
	}
}

void CT3EDView::OnUpdateToolsMerge(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&((selMode==ID_MODE_POINT)|(selMode==ID_MODE_OBJECT)));
	pCmdUI->SetCheck(editMode==ID_TOOLS_MERGE);
}

void CT3EDView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CT3EDDoc *pDoc=GetDocument();

	//SplitPoint ?
	if (editMode==ID_TOOLS_MERGE && selMode==ID_MODE_POINT)
	{
		//isTruePoint=FALSE;
		OnLButtonDown(0,point); // select point, recenter...
		if (!isTruePoint) return;
		isTruePoint=FALSE;
		myrefnode.x=refnode->x;
		myrefnode.z=refnode->z;
		myrefnode.y=refnode->y;
		refnode=&myrefnode;
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		pDoc->SplitPoint(refnode);
		InvalidateRect(NULL,TRUE);
	}
}

void CT3EDView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	if (isEmpty) return;
	CT3EDDoc *pDoc=GetDocument();
	int dist,dist0,i,i0,x,y;
	RECT rect;
	GetClientRect(&rect);

	// toggle or set visibility?
	if (selMode==ID_MODE_BLOCK && ShowBasedOnVisi)
	{
		i0=-1; dist0=1<<30;
		for (i=0;i<pDoc->nBlocks;i++) {
			x=FloatX(pDoc->trk[i].ptCentre);
			y=FloatY(pDoc->trk[i].ptCentre);
			dist=(x>point.x)?(x-point.x):(point.x-x);
			dist+=(y>point.y)?(y-point.y):(point.y-y);
			if (dist<dist0) {i0=i; dist0=dist;}
		}

		if (!MeetsClipRect(&(pDoc->trk[i0]),&rect)) return;
		if (refblock==i0 || dist0>30) return; //Right click on selected block, or distance over 30? 
		//vis=pDoc->IsBlockVisibile(TrackViewBl,i0);

		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //New Undo Point
		pDoc->PrepareModifyTrk(refblock); //Save Refblock

		if ((MK_CONTROL&&nFlags)==1) //Control pressed ?
			pDoc->VisibilityToggle(refblock,i0);
		else
			pDoc->VisibilitySetToBlock(refblock,i0);

		//vis=pDoc->IsBlockVisibile(TrackViewBl,i0);
		pDoc->bUpdatedScene=FALSE;  //Mark Trackpreview as invalid
		InvalidateRect(NULL,TRUE);	//Update View

	}

	
	CView::OnRButtonUp(nFlags, point);
}

void CT3EDView::OnToolsAdjustwidth() 
{
	CT3EDDoc *pDoc=GetDocument();
	CVirtualRoadAdjust VRADlg;	
	float Size[4];
	int i;

	//Get settings
	VRADlg.m_AdjustType = pDoc->settings.AdjustRoad_AdjustType;
	VRADlg.m_StartBlock = pDoc->settings.AdjustRoad_StartBlock;
	VRADlg.m_EndBlock = pDoc->settings.AdjustRoad_EndBlock;
	//VRADlg.m_Check_VR = pDoc->settings.AdjustRoad_Check_VR;
	VRADlg.m_Check_Man_Set_Num_Lanes = pDoc->settings.AdjustRoad_Check_Man_Set_Num_Lanes;
	VRADlg.m_bHSMode = pDoc->bHSMode;

	VRADlg.m_Check_Change_VR_Width = pDoc->settings.AdjustRoad_Check_Change_VR_Width;
	VRADlg.m_Check_Detect_lanes = pDoc->settings.AdjustRoad_Check_Detect_lanes;
	VRADlg.m_Check_Auto_Set_Lane_Bitcoded = pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Bitcoded;
	VRADlg.m_Check_Auto_Set_Lane_Polys = pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Polys;
	VRADlg.m_Check_Auto_Set_Lane_Width = pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Width;

	VRADlg.m_int_Size_VR_L       = pDoc->settings.AdjustRoad_Size[0];
	VRADlg.m_int_Size_VR_R       = pDoc->settings.AdjustRoad_Size[1];
	VRADlg.m_nlanes_left		 = pDoc->settings.AdjustRoad_Size[2];
	VRADlg.m_nlanes_right	     = pDoc->settings.AdjustRoad_Size[3];


	if (VRADlg.DoModal()!=IDOK) return;

	if (VRADlg.m_StartBlock<0) VRADlg.m_StartBlock=0;
	if (VRADlg.m_EndBlock > (pDoc->nBlocks-1)) VRADlg.m_EndBlock = GetDocument()->nBlocks-1;
	//Save settings
	VRADlg.m_StartBlock=pDoc->RealBlockNum(VRADlg.m_StartBlock);
	VRADlg.m_EndBlock=pDoc->RealBlockNum(VRADlg.m_EndBlock);
	pDoc->settings.AdjustRoad_AdjustType=VRADlg.m_AdjustType;
	pDoc->settings.AdjustRoad_StartBlock=VRADlg.m_StartBlock; 
	pDoc->settings.AdjustRoad_EndBlock=VRADlg.m_EndBlock;
	//pDoc->settings.AdjustRoad_Check_VR   = VRADlg.m_Check_VR  ;
	pDoc->settings.AdjustRoad_Check_Man_Set_Num_Lanes = VRADlg.m_Check_Man_Set_Num_Lanes;	

	pDoc->settings.AdjustRoad_Check_Change_VR_Width = VRADlg.m_Check_Change_VR_Width;
	pDoc->settings.AdjustRoad_Check_Detect_lanes = VRADlg.m_Check_Detect_lanes;
	pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Bitcoded = VRADlg.m_Check_Auto_Set_Lane_Bitcoded;
	pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Polys = VRADlg.m_Check_Auto_Set_Lane_Polys;
	pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Width = VRADlg.m_Check_Auto_Set_Lane_Width;

	if (VRADlg.m_Check_Change_VR_Width && (VRADlg.m_AdjustType==3)) //Manual VRoad Size choosen
	{
		pDoc->settings.AdjustRoad_Size[0] = VRADlg.m_int_Size_VR_L;
		pDoc->settings.AdjustRoad_Size[1] = VRADlg.m_int_Size_VR_R; 
	}
	if (VRADlg.m_Check_Man_Set_Num_Lanes) //Manual setting of nLanes choosen
	{
		pDoc->settings.AdjustRoad_Size[2] = VRADlg.m_nlanes_left;
		pDoc->settings.AdjustRoad_Size[3] = VRADlg.m_nlanes_right;
	}

	for(i=0;i<4;i++)
		Size[i]=(float) pDoc->settings.AdjustRoad_Size[i];

	if (!VRADlg.m_Check_Change_VR_Width) //Change VR Width disabled
		VRADlg.m_AdjustType=-1;

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	//GetDocument()->AdjustRoadWidth(VRADlg.m_AdjustType, (VRADlg.m_MapLaneEdges !=0), VRADlg.m_StartBlock , VRADlg.m_EndBlock, (float) (VRADlg.m_int_Size * 10000));
	if (VRADlg.m_Check_Change_VR_Width|VRADlg.m_Check_Man_Set_Num_Lanes)
		pDoc->AdjustRoadWidth(VRADlg.m_AdjustType, VRADlg.m_StartBlock , VRADlg.m_EndBlock, Size, VRADlg.m_Check_Man_Set_Num_Lanes);
	if (VRADlg.m_Check_Detect_lanes)
	{
		struct TRKBLOCK *t1, *t2;
		t1=&(pDoc->trk[VRADlg.m_StartBlock]);
		t2=&(pDoc->trk[VRADlg.m_EndBlock]);
		for (i=t1->nStartPos; i < t2->nStartPos + t2->nPositions; i++)
			pDoc->VRoadLanesRecalc(i, VRADlg.m_Check_Auto_Set_Lane_Bitcoded, VRADlg.m_Check_Auto_Set_Lane_Polys, VRADlg.m_Check_Auto_Set_Lane_Width);
	}

	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnUpdateToolsAdjustwidth(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnToolsClearall() 
{
	CT3EDDoc *pDoc=GetDocument();
	CClearAll clearDlg;
	int i,j;
	struct XOBJBLOCK *x;
	float extradata[9];

	clearDlg.qfs=&(pDoc->qfsView);
	//Use stored settings
	clearDlg.m_shape_x=pDoc->settings.clearDlg_m_shape_x;
	clearDlg.m_shape_y=pDoc->settings.clearDlg_m_shape_y;
	clearDlg.m_shape_extra=pDoc->settings.clearDlg_m_shape_extra;
	clearDlg.m_numc1=pDoc->settings.clearDlg_m_numc1;
	clearDlg.m_numc2=pDoc->settings.clearDlg_m_numc2;
	clearDlg.m_sizec1=pDoc->settings.clearDlg_m_sizec1;
	clearDlg.m_sizec2=pDoc->settings.clearDlg_m_sizec2;
	clearDlg.m_elevation_extra=pDoc->settings.clearDlg_m_elevation_extra;
	clearDlg.m_height=pDoc->settings.clearDlg_m_height;
	clearDlg.m_numz1 =pDoc->settings.clearDlg_m_numz1;
	clearDlg.m_numz2 =pDoc->settings.clearDlg_m_numz2;
	clearDlg.m_sizez1=pDoc->settings.clearDlg_m_sizez1;
	clearDlg.m_sizez2=pDoc->settings.clearDlg_m_sizez2;
	clearDlg.m_Combo_Vector_Calc=pDoc->settings.VRoadHeightsSpd_Combo_Calc;
	clearDlg.m_merge_dist=pDoc->settings.ConnectBlocks_dist;
	clearDlg.m_SpeedF_Start=0;
	clearDlg.m_SpeedF_End=pDoc->col.vroadHead.nrec -1;


	if (clearDlg.DoModal()!=IDOK) return;

	//Write back settings
	pDoc->settings.clearDlg_m_shape_x=clearDlg.m_shape_x;
	pDoc->settings.clearDlg_m_shape_y=clearDlg.m_shape_y;
	pDoc->settings.clearDlg_m_shape_extra=clearDlg.m_shape_extra;
	pDoc->settings.clearDlg_m_numc1=clearDlg.m_numc1;
	pDoc->settings.clearDlg_m_numc2=clearDlg.m_numc2;
	pDoc->settings.clearDlg_m_sizec1=clearDlg.m_sizec1;
	pDoc->settings.clearDlg_m_sizec2=clearDlg.m_sizec2;
	pDoc->settings.clearDlg_m_elevation_extra=clearDlg.m_elevation_extra;
	pDoc->settings.clearDlg_m_height=clearDlg.m_height;
	pDoc->settings.clearDlg_m_numz1= clearDlg.m_numz1;
	pDoc->settings.clearDlg_m_numz2= clearDlg.m_numz2;
	pDoc->settings.clearDlg_m_sizez1=clearDlg.m_sizez1;
	pDoc->settings.clearDlg_m_sizez2=clearDlg.m_sizez2;
	pDoc->settings.ConnectBlocks_dist=clearDlg.m_merge_dist;

	if (!clearDlg.m_shape_extra) //No extra curves
	{
		clearDlg.m_numc1=1;
		clearDlg.m_numc2=1;
		clearDlg.m_sizec1=0;
		clearDlg.m_sizec1=0;
		extradata[0]=(float) 1;
		extradata[1]=(float) 0;
		extradata[2]=(float) 1;
		extradata[3]=(float) 0;
	}
	else //Extra curves
	{
		extradata[0]=(float) clearDlg.m_numc1;
		extradata[1]=(float) clearDlg.m_sizec1;
		extradata[2]=(float) clearDlg.m_numc2;
		extradata[3]=(float) clearDlg.m_sizec2;
	}

	if (!clearDlg.m_elevation_extra) //No extra hills & valleys
	{
		extradata[4]=(float) 1;
		extradata[5]=(float) 0;
		extradata[6]=(float) 1;
		extradata[7]=(float) 0;
	}
	else //Extra hills & valleys
	{
		extradata[4]=(float) clearDlg.m_numz1;
		extradata[5]=(float) clearDlg.m_sizez1;
		extradata[6]=(float) clearDlg.m_numz2;
		extradata[7]=(float) clearDlg.m_sizez2;
	}
	extradata[8]=(float) clearDlg.m_height; //Set new height

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	
	//ADDON By Nappe1: Cutting amount of track blocks:
	if (clearDlg.m_trackBLK) {
		if ((clearDlg.m_TrknBlocks >19) && (clearDlg.m_TrknBlocks < pDoc->nBlocks)) 
		{
			pDoc->CutAmountOfBlocks(clearDlg.m_TrknBlocks);
			//pDoc->nBlocks=clearDlg.m_TrknBlocks;
			//pDoc->col.vroadHead.nrec=8*(short)pDoc->nBlocks;
			//pDoc->col.vroadHead.nrec=pDoc->trk[pDoc->nBlocks-1].nStartPos+pDoc->trk[pDoc->nBlocks-1].nPositions; //Should be the same as above, but this must be right !
		}
		else MessageBox ("Track has to have at least 19 blocks and cannot have more than in the original one.");
	}
	//Nappe1: ADDITION ENDS.


	// one never knows what happens here
	myrefnode.x=refnode->x;
	myrefnode.z=refnode->z;
	myrefnode.y=refnode->y;
	refnode=&myrefnode;
	isTruePoint=FALSE;
	refpoly=NULL; objno=-1;
	//pDoc->col.nBlocks=80;
	//pDoc->nBlocks=10;
	
	//ADDON By Nappe1: setting up the shading vertices to FF FF FF FF as BGRA
	if (clearDlg.m_trackShade) {
		//Functions by Vitaly Kootin.	
		pDoc->SetRoadVertexShading(0, pDoc->nBlocks-1, 0xFFFFFFFF);
		pDoc->SetXObjVertexShading(0, pDoc->nBlocks, 0xFFFFFFFF);  //Extra & global objects
	}
	//Nappe1: ADDITION ENDS.

	if (clearDlg.m_xobj)
		for (i=0;i<pDoc->nBlocks;i++)
			pDoc->DelAllObjects(i,TRUE);

	if (clearDlg.m_polyobj)
		for (i=0;i<pDoc->nBlocks;i++)
			pDoc->DelAllObjects(i,FALSE);

	if (clearDlg.m_fences||clearDlg.m_sound_src) {
		for (i=0;i<pDoc->nBlocks;i++)
			pDoc->DelLanePolygons(i, clearDlg.m_fences, clearDlg.m_sound_src);
	}

	if (clearDlg.m_trackXY||clearDlg.m_trackZ) //Clear track shape
	{
		pDoc->MoveBlocks(-1,clearDlg.m_shape_x,clearDlg.m_shape_y,0,clearDlg.m_trackXY,clearDlg.m_trackZ,-1,extradata);
		refnode=&(pDoc->trk[refblock].ptCentre);
		offsetx=0; offsety=0;
	}

	if (clearDlg.m_sceneryZ)
		pDoc->ClearSceneryZ();

	if (clearDlg.m_roadTextures)
		pDoc->SetAllTextures(clearDlg.m_roadTexture,TRUE,clearDlg.m_roadFlags);

	if (clearDlg.m_sceneryTextures)
		pDoc->SetAllTextures(clearDlg.m_sceneryTexture,FALSE,clearDlg.m_sceneryFlags);

	if (clearDlg.m_globalobj) {
		// can't keep consistent undo, so delete it all
		for (i=0;i<pDoc->undoLevel;i++) pDoc->DeleteUndo(i);
		pDoc->undoLevel=0;
		// global xobj
		x=&(pDoc->xobj[4*pDoc->nBlocks]);
		pDoc->FreeXobjContents(x);
		x->obj=NULL;
		x->nobj=0;
		if (pDoc->hs_morexobjlen>0) {
			pDoc->hs_morexobj=(char *)realloc(pDoc->hs_morexobj,8);
			pDoc->hs_morexobjlen=8; // two 0L's
			memset(pDoc->hs_morexobj,0,8);
		}
		// COL objects
		if (pDoc->col.struct3D!=NULL) 
			for (i=0;i<pDoc->col.struct3DHead.nrec;i++) {
				dofree(pDoc->col.struct3D[i].vertex);
				dofree(pDoc->col.struct3D[i].polygon);
			}
		dofree(pDoc->col.struct3D);
		pDoc->col.struct3D=NULL;
		if (pDoc->col.object!=NULL)
			for (i=0;i<pDoc->col.objectHead.nrec;i++)
				dofree(pDoc->col.object[i].animData);
		dofree(pDoc->col.object);
		pDoc->col.object=NULL;
		if (pDoc->col.object2!=NULL)
			for (i=0;i<pDoc->col.object2Head.nrec;i++)
				dofree(pDoc->col.object2[i].animData);
		dofree(pDoc->col.object2);
		pDoc->col.object2=NULL;
		pDoc->col.nBlocks=2;
		pDoc->col.fileLength=24+pDoc->col.textureHead.size+pDoc->col.vroadHead.size;
		pDoc->col.xbTable[0]=8;
		pDoc->col.xbTable[1]=8+pDoc->col.textureHead.size;
	}
	if (clearDlg.m_block_neighbours)
	{
		for (i=0;i<pDoc->nBlocks;i++)
		{
			pDoc->trk[i].hs_neighbors[0]=i+1; //Next block
			if (pDoc->trk[i].hs_neighbors[0]>=pDoc->nBlocks)
				pDoc->trk[i].hs_neighbors[0]=0;
			pDoc->trk[i].hs_neighbors[1]=i - 1; //Previous block
			if (pDoc->trk[i].hs_neighbors[1]<0)
				pDoc->trk[i].hs_neighbors[1]=pDoc->nBlocks - 1;
			for (j=2;j<8;j++)
				pDoc->trk[i].hs_neighbors[j]=-1;

		}	
		MessageBox ("Default block neighbours has been set.");
	}
	if (clearDlg.m_Chk_PVR)
	{
		pDoc->settings.VRoadHeightsSpd_Combo_Calc=clearDlg.m_Combo_Vector_Calc;
		for (i=0;i<pDoc->nBlocks;i++)
		{
			pDoc->RecalcPolyVroadForBlock(i, pDoc->settings.VRoadHeightsSpd_Combo_Calc);
		}
	}
	if (clearDlg.m_merge_points)
	{
		CString sStr;
		CLodGenProgress *ProgresWin;
		ProgresWin = new CLodGenProgress;

		ProgresWin->Create(IDD_LOD_GENERATION, NULL);
		ProgresWin->ShowWindow(TRUE);
		ProgresWin->UpdateData(FALSE);
		ProgresWin->m_lodprogress.SetRange(0, (short) pDoc->nBlocks);

		for (j=0;j<pDoc->nBlocks;j++)
		{
			sStr.Format("Connecting points of block %d  / %d.", j, pDoc->nBlocks);
			ProgresWin->SetWindowText(sStr);
			ProgresWin->m_lodprogress.SetPos(j);

			for (i=0;i<8;i++)
				if (pDoc->trk[j].hs_neighbors[i]>-1)
				{
					pDoc->PrepareModifyTrk(pDoc->trk[j].hs_neighbors[i]);
					pDoc->ConnectBlocks(refblock, pDoc->trk[j].hs_neighbors[i], clearDlg.m_merge_dist);			

				}
		}
		delete ProgresWin;
	}
	if ((clearDlg.m_fSpeedfile|clearDlg.m_bSpeedfile)&&(clearDlg.m_SpeedFloat_Zero_Calc>-1))
	{

		if ((int) clearDlg.m_SpeedF_End > pDoc->col.vroadHead.nrec)
			clearDlg.m_SpeedF_End = pDoc->col.vroadHead.nrec - 1;

		if (clearDlg.m_SpeedFloat_Zero_Calc==0) //set speedfile floats to zero
		{
			for (i=(int) clearDlg.m_SpeedF_Start; i<= (int) clearDlg.m_SpeedF_End; i++)
			{
				if (clearDlg.m_fSpeedfile)
				{
					pDoc->spdFAbin[i].AI_Float=0;
					pDoc->MoveObjectBy(-1, 6, 0, i, 0, 0, 0, 1, 1); //Forward Speed File
				}
				if (clearDlg.m_bSpeedfile)
				{
					pDoc->spdRAbin[i].AI_Float=0;
					pDoc->MoveObjectBy(-1, 6, 0, i, 0, 0, 0, 1, 0); //Backward Speed File
				}
			}
		}
		if (clearDlg.m_SpeedFloat_Zero_Calc>0) //recalc speedfile floats 
		{
			int p1, p2;
			bool exit, curve=true;
			if (clearDlg.m_SpeedFloat_Zero_Calc==1) curve=false;

			if (clearDlg.m_fSpeedfile) //Recalc forward direction ?
			{
				exit=false;
				for (i=(int) clearDlg.m_SpeedF_Start; i<= (int) clearDlg.m_SpeedF_End; i++)  //Loop for AI points
				{
					if (pDoc->spdFAbin[i].AI_Float==0) //Float is zero
					{
						//Find none zero before
						p1=i;
						while ((pDoc->spdFAbin[p1].AI_Float==0)&&(!exit))
						{
							p1=pDoc->RealSliceNum(p1-1);
							if (p1==i)
							   exit=true;
						}
						p2=i;
						while ((pDoc->spdFAbin[p2].AI_Float==0)&&(!exit)) //find AI Float with not zero 
						{
							p2=pDoc->RealSliceNum(p2 + 1); //find AI Float with not zero 
							if (p1==p2)
							   exit=true;
						}
						if (!exit) pDoc->SpeedFile_Calc_Float_Between2AIPoints(p1,p2,true, curve);
						if (p2>i) i=p2;
					}
				}
			}

			if (clearDlg.m_bSpeedfile)  //Recalc backward direction ?
			{
				exit=false;
				for (i=(int) clearDlg.m_SpeedF_Start; i<= (int) clearDlg.m_SpeedF_End; i++)  //Loop for AI points
				{
					if (pDoc->spdRAbin[i].AI_Float==0) //Float is zero
					{
						//Find none zero before
						p1=i;
						while ((pDoc->spdRAbin[p1].AI_Float==0)&&(!exit))
						{
							p1=pDoc->RealSliceNum(p1-1);
							if (p1==i)
							   exit=true;
						}
						p2=i;
						while ((pDoc->spdRAbin[p2].AI_Float==0)&&(!exit)) //find AI Float with not zero 
						{
							p2=pDoc->RealSliceNum(p2 + 1); //find AI Float with not zero 
							if (p1==p2)
							   exit=true;
						}
						if (!exit) pDoc->SpeedFile_Calc_Float_Between2AIPoints(p1,p2,false, curve);
						if (p2>i) i=p2;
					}
				}
			}
		}
	}
	if (clearDlg.m_recalc_AI_lanes)
	{
			for (i=0;i<pDoc->col.vroadHead.nrec;i++)
			{
				//No move just, recalc AI lanes
				pDoc->MoveObjectBy(-1, 6, 0, i, 0, 0, 0, 1, 1); //Forward Speed File
				pDoc->MoveObjectBy(-1, 6, 0, i, 0, 0, 0, 1, 0); //Backward Speed File
			}
	}
	InvalidateRect(NULL, TRUE);
}

void CT3EDView::OnUpdateToolsClearall(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnViewVroad() 
{
	DrawVRoad=!DrawVRoad;

}

void CT3EDView::OnUpdateViewVroad(CCmdUI* pCmdUI) 
{

	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(DrawVRoad&&!isEmpty);
	InvalidateRect(NULL,TRUE);
	
}

//Nappe1: (DEV2.5 ADD ON) TRACK VISIBILITY TABLE EXPORT/IMPORT


void CT3EDView::OnExportVis() 
{
	bool list_END;
	CString Visfile;
	// TODO: Add your command handler code here
	//MessageBox("alussa");
	CT3EDDoc *pDoc=GetDocument();
	//MessageBox("dokumentti saatu");

	Visfile=pDoc->fileDir + "\\visibility.txt";
FILE* fout = fopen(Visfile, "w");
		//MessageBox("Tiedosto auki.");
		fprintf(fout, "Version: %d.%d\n", 1,2);
		fprintf(fout, "Blocks: %d\n", pDoc->nBlocks);
		for(int i=0;i<pDoc->nBlocks ;i++)
		{
			fprintf(fout, "Block: %d\n", i);
			/*fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[0].x);
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[0].y);
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[0].z);
			
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[1].x);
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[1].y);
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[1].z);
			
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[2].x);
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[2].y);
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[2].z);

			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[3].x);
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[3].y);
			fprintf(fout, "%f\n", pDoc->trk[i].ptBounding[3].z); */
			list_END=false;
			for(int u=0;u<300 ;u++)
				{
				if (pDoc->trk[i].nbdData[u].blk!=-1)
					{
					if (list_END==false)
						fprintf(fout, "%d\n", pDoc->trk[i].nbdData[u].blk);
					}
				else 
					{
					if (list_END==false)
						fprintf(fout, "%d\n\n", pDoc->trk[i].nbdData[u].blk);
					list_END=true;
					}

				}
		}
		fclose(fout);
		MessageBox("Table Exported.");	
}

void CT3EDView::OnImportVis() 
{
	int nulld, nulld2;
	//float nullf;
	bool version_OK, list_END;
	short value;
	//char dump;
	CString s;
	CString Visfile;

	CT3EDDoc *pDoc=GetDocument();
	// TODO: Add your command handler code here
	
	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	
	Visfile=pDoc->fileDir + "\\visibility.txt";
	FILE* fin = fopen(Visfile, "r");
	//fscanf(fin, "%d\n%c\n%f\n%s", &(arg->a), &(arg->b), &(arg->c), arg->d);
	//fclose(fin);
	if (fin==NULL)
		{
		version_OK=false;
		MessageBox("File open Error.");
		}
	else
		version_OK=true;

	/*for (loop=1;loop==9;loop++)
		fscanf(fin, "%c", &dump);*/
	if (version_OK==true)
		{
		fscanf(fin, "Version: %d.%d\n", &nulld, &nulld2);
		//s.Format("nulld: %d, nulld2: %d",nulld, nulld2);
		//MessageBox(s);

		if (nulld2!=2)
			{
			MessageBox("Wrong version of export file. Import abortted");
			version_OK=false;
			fclose(fin);
			}
		}
	if (version_OK==true)
		{
		fscanf(fin, "Blocks: %d\n", &nulld);
		if (nulld!=pDoc->nBlocks)
			{
			MessageBox("Export file has different amount of blocks than track.\nNothing imported for safety reasons.");
			version_OK=false;
			fclose(fin);
			}
		}

	if (version_OK==false) return;
	s="";
	for(int ii=0;ii<pDoc->nBlocks ;ii++)
		{
		pDoc->PrepareModifyTrk(ii);
		s="";
		fscanf(fin, "Block: %d\n", &nulld);
		/*fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[0].x));
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[0].y));
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[0].z));
		
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[1].x));
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[1].y));
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[1].z));
		
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[2].x));
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[2].y));
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[2].z));

		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[3].x));
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[3].y));
		fscanf(fin, "%f\n", &(pDoc->trk[ii].ptBounding[3].z)); */
			
		list_END=false;	
		for(int uu=0;uu<300 ;uu++)
			{
			if (list_END==false)
				fscanf(fin, "%hd\n", &value);
		
			if (value==-1)
				{
				if (list_END==false)
					{
					list_END=true;
					fscanf(fin, "\n");
					}
				}
			pDoc->trk[ii].nbdData[uu].blk=value;
			/*if (ii<5)
				{
				s.Format("Value: %d, Entry: %d\n",value, uu);
				MessageBox(s);
				} */
			}
		}
	fclose(fin);
	MessageBox("Table Imported.");
	pDoc->bUpdatedScene=FALSE;  //Mark Trackpreview as invalid
	InvalidateRect(NULL,TRUE);	//Update View
}
//Nappe1: (DEV2.5 ADD ON) TRACK VISIBILITY TABLE EXPORT/IMPORT (END)

void CT3EDView::OnEditCopy() 
{
	// Copy to Clipboard
	CT3EDDoc *pDoc=GetDocument();
	CSelData *sel;
	CString sStr = "";
	int size;
	
	if (selMode==ID_MODE_POINT) //Copy point position to clipboard
	{
		pDoc->CopyXYZToClipboard(refnode);
		sStr.Format("Position X:%f, Y:%f, Z:%f copied.",refnode->x, refnode->y, refnode->z);
		statusbar->SetPaneText(0,sStr,TRUE);
	}

	if (selMode==ID_MODE_OBJECT) //Copy objects to clipboard
	{
		if (multisel) delete multisel; multisel=NULL;
		sel=this;
		if ((sel!=NULL)&&(isxobj<4)&&(refblock!=pDoc->nBlocks))
		{
			//MessageBox("Object to Clipboard.");
			size=pDoc->CopyBlockToClipboard(refblock,isxobj,refchunk,objno);
			if (size!=-1)
				{
				switch (isxobj) {
					case 0: 
						sStr.Format("Object %d from block %d (chunk %d) copied.(%d bytes)",objno, refblock, refchunk, size);
						break;
					case 1:
						sStr.Format("Extra object %d from block %d (chunk %d) copied.(%d bytes)",objno, refblock, refchunk, size);
						break;
					case 2:
						sStr.Format("Light object %d from block %d (chunk %d) copied.(%d bytes)",objno, refblock, refchunk, size);
						break;
					case 3:
						sStr.Format("Sound object %d from block %d (chunk %d) copied.(%d bytes)",objno, refblock, refchunk, size);
						break;
				}
			}
			else
			{
				sStr.Format("Copy failed.");
			}
			statusbar->SetPaneText(0,sStr,TRUE);
		}
		else
			if ((sel!=NULL)&&(isxobj==5))
			{
				pDoc->CopyCamToClipboard(objno);
				sStr.Format("Replay Camera number %d copied.",objno +1); //+1 to have same numbering as Nappe's CamExit
				statusbar->SetPaneText(0,sStr,TRUE);
			}
	}
	if (selMode==ID_MODE_VROADEDIT) //Copy VRoad Point to clipboard
	{
		if (multisel) delete multisel; multisel=NULL;
		sel=this;
		if ((sel!=NULL)&&(isxobj==4))
		{
			pDoc->CopyVRoadToClipboard(objno);
			sStr.Format("VRoad data from point %d (block %d) copied.",objno, refblock);
			statusbar->SetPaneText(0,sStr,TRUE);
		}
	}

	if (selMode==ID_MODE_BLOCK ) //Copy block to clipboard
	{
		if (multisel) delete multisel; multisel=NULL;
		sel=this;
		if (sel!=NULL)
		{
			size=pDoc->CopyBlockToClipboard(refblock,-1,-1,-1);
			sStr.Format("Block %d copied to clipboard.(%d bytes)",refblock, size);
			statusbar->SetPaneText(0,sStr,TRUE);
		}
	}
}

void CT3EDView::OnEditCut() 
{
	CT3EDDoc *pDoc=GetDocument();
	CSelData *sel;
	int size;
	CString sStr = "";

	if (selMode==ID_MODE_BLOCK ) //Copy block to clipboard
	{
		if (multisel) delete multisel; multisel=NULL;
		sel=this;
		if (sel!=NULL)
		{
			size=pDoc->CopyBlockToClipboard(refblock,-1,-1,-1);
			sStr.Format("Cut Block %d to clipboard.(%d bytes,no undo)",refblock, size);
			statusbar->SetPaneText(0,sStr,TRUE);

			refblock=pDoc->DeleteBlock(refblock);
			pDoc->RecalcBoundingBox(refblock);
			refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
			UpdateRefBlock();
			InvalidateRect(NULL,TRUE);
		}
	}	
}

void CT3EDView::OnEditPaste() 	// Paste from Clipboard
{
	CT3EDDoc *pDoc=GetDocument();
	CSelData *sel;
	struct CLIPBLOCK CbInfo;
	struct FLOATPT RefOld;
	struct INTPT ipt1,ipt2;
	struct COLVROAD *vrdata;
	//struct TRKBLOCK blk;
	//struct COLVROAD *cvr;
	float dx=0,dy=0,dz=0, mLenght=1, mWidth=1;
	int i;
	short neighbourdata[8], visdata[300];
	double AngleOld,AngleNew, len1, len2;
	double pi = 3.14159265358979323846264338;
	CBlockPaste BlockPasteDlg;
	CVRoadPaste VRoadPasteDlg;
	CString sStr = "", Clip = "";
	BOOL er=FALSE, AltKey=FALSE;
	if (GetAsyncKeyState(VK_MENU) & 0x8000) AltKey=TRUE;

	if ((refblock>pDoc->nBlocks)|(refblock<0)) return; //Safety Check, at least a refblock is needed for destination

	//What is on Clipboard and change mode if needed
	Clip = pDoc->GetClipboardText(); // Returns "Block", "Object", "VRoad", "Camera" or nothing
	if (Clip=="Block") OnModeBlock();
	if (Clip=="Object") OnModeObject();
	if (Clip=="Camera") {bShowCams=TRUE;OnModeObject();}


	if (selMode==ID_MODE_POINT) //Paste x,y,z to a point
	{
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		pDoc->PrepareModifyTrk(refblock);

		pDoc->PasteXYZfromClipboard(refnode);
		
		InvalidateRect(NULL,TRUE);
	}

	if ((selMode==ID_MODE_OBJECT)&&(refblock!=pDoc->nBlocks)) //Paste an object, if refblock isn't set to global
	{
		sel=this;
		er=pDoc->BlockClipboardInfo(CbInfo); //Get Info about what is in Clipboard
		if ((CbInfo.clipNo!=-1)&&(CbInfo.clipIsobj<4)) //Only if a Object is found and selected
		{ 
			if (multisel) delete multisel; multisel=NULL;
			pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
			pDoc->PrepareModifyTrk(refblock);
			if (CbInfo.clipIsobj==1) pDoc->PrepareModifyXobj(refblock);

			pDoc->PasteBlockfromClipboard(-1,refblock,0,0,0,0,0, AltKey); //Paste Object out of block stored in clipboard
			
			//Delete wrong undodata for global objects
			int j;
			for (j=0;j<4;j++) 
				if (pDoc->undo[pDoc->undoLevel-1][pDoc->nBlocks].xobj[j]!=NULL) 
				{
					dofree(pDoc->undo[pDoc->undoLevel-1][pDoc->nBlocks].xobj[j]);
					pDoc->undo[pDoc->undoLevel-1][pDoc->nBlocks].xobj[j]=NULL;
				}


			if (CbInfo.clipNo!=-1){
				switch (CbInfo.clipIsobj) {
					case 0: 
						sStr.Format("Pasted object to block %d.", refblock);
						break;
					case 1:
						sStr.Format("Pasted extra object to block %d.", refblock);
						break;
					case 2:
						sStr.Format("Pasted light object to block %d.", refblock);
						break;
					case 3:
						sStr.Format("Pasted sound object to block %d.", refblock);
						break;
				}
			statusbar->SetPaneText(0,sStr,TRUE);
			}

			//Set view to new object just pasted.
			isxobj=CbInfo.clipIsobj; 
			refchunk=CbInfo.clipChunk;
			if (isxobj==3) {
				objno=pDoc->trk[refblock].nSoundsrc-1;
				refnode=&myrefnode;
				myrefnode.x=((float)pDoc->trk[refblock].soundsrc[objno].refpoint.x)/65536;
				myrefnode.y=((float)pDoc->trk[refblock].soundsrc[objno].refpoint.y)/65536;
				myrefnode.z=((float)pDoc->trk[refblock].soundsrc[objno].refpoint.z)/65536;
			} else 
			if (isxobj==2) {
				objno=pDoc->trk[refblock].nLightsrc-1;
				refnode=&myrefnode;
				myrefnode.x=((float)pDoc->trk[refblock].lightsrc[objno].refpoint.x)/65536;
				myrefnode.y=((float)pDoc->trk[refblock].lightsrc[objno].refpoint.y)/65536;
				myrefnode.z=((float)pDoc->trk[refblock].lightsrc[objno].refpoint.z)/65536;
			} else
			if (isxobj==1) {
				objno=pDoc->xobj[4*refblock+refchunk].nobj-1;
				refnode=&(pDoc->xobj[4*refblock+refchunk].obj[objno].ptRef);
			} else {
				objno=pDoc->poly[refblock].obj[refchunk].nobj-1;
				refnode=pDoc->trk[refblock].vert+
				pDoc->poly[refblock].obj[refchunk].poly[objno]->vertex[0];
				}
			InvalidateRect(NULL,TRUE);
		}
		if (pDoc->IsCamOnClipboard()) //Paste Replay Camera
		{
			pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //New undo point
			pDoc->PrepareModifyCameras();
			if (pDoc->PasteCamFromClipboard())
			{
				objno=pDoc->Camfile.nCams-1; //New Cam is last cam
				refnode=&pDoc->Camfile.pCamData[objno].CamPosition;
				refblock=pDoc->FindNearestBlock(refnode);
				isxobj=5;


				/*if (!(GetAsyncKeyState(VK_MENU) & 0x8000)) //ALT not pressed? 
				{

				}*/
				sStr.Format("Replay Camera number %d added.", objno +1);
				statusbar->SetPaneText(0,sStr,TRUE);
				InvalidateRect(NULL,TRUE);
			}

		}

	}

	if ((selMode==ID_MODE_VROADEDIT)&&(refblock!=pDoc->nBlocks)) //Paste VRoad point data
	{
		sel=this;
		if (isxobj==4) //Check if Vroad Point selected, VRoad Data can only be pasted on vroad
		{
			//if (multisel) delete multisel; multisel=NULL;
			if (pDoc->IsVRoadOnClipboard())
			{
				VRoadPasteDlg.m_bHeights=pDoc->settings.VRoadPaste_bHeights;
				VRoadPasteDlg.m_bHS_extra=(pDoc->settings.VRoadPaste_bHS_extra && pDoc->bHSMode);
				VRoadPasteDlg.m_bSPDFA=pDoc->settings.VRoadPaste_bSPDFA;
				VRoadPasteDlg.m_bSPDRA=pDoc->settings.VRoadPaste_bSPDRA;
				VRoadPasteDlg.m_bVRoad=pDoc->settings.VRoadPaste_bVRoad;
				if (!(VRoadPasteDlg.DoModal () == IDOK)) return; //Cancel pressed ?
				pDoc->settings.VRoadPaste_bHeights = VRoadPasteDlg.m_bHeights;
				pDoc->settings.VRoadPaste_bHS_extra = (VRoadPasteDlg.m_bHS_extra && pDoc->bHSMode);
				pDoc->settings.VRoadPaste_bSPDFA = VRoadPasteDlg.m_bSPDFA;
				pDoc->settings.VRoadPaste_bSPDRA = VRoadPasteDlg.m_bSPDRA;
				pDoc->settings.VRoadPaste_bVRoad = VRoadPasteDlg.m_bVRoad;

				i=0;
				pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //New undo point
				pDoc->PrepareModifyVRoadHeightsSpdFiles();
				for (sel=this;sel!=NULL;sel=sel->multisel) //loop for all seleted objects
					if (sel->isxobj==4) //Paste on all VRoad Points
						i+=pDoc->PasteVRoadFromClipboard(sel->objno, VRoadPasteDlg.m_bVRoad, VRoadPasteDlg.m_bHeights, VRoadPasteDlg.m_bSPDFA, VRoadPasteDlg.m_bSPDRA, VRoadPasteDlg.m_bHS_extra);
				sStr.Format("Pasted VRoad data on %d point(s).", i);
				statusbar->SetPaneText(0,sStr,TRUE);
				InvalidateRect(NULL,TRUE);
			}
		}	
	}

	if (selMode==ID_MODE_BLOCK) //Paste an block
	{
		er=pDoc->BlockClipboardInfo(CbInfo); //Get Info about what is in Clipboard
		if ((CbInfo.clipNo==-1)&&(er==TRUE)) //Found a block with no selected object
		{
			BlockPasteDlg.m_add_replace_block=pDoc->settings.m_add_replace_block; // Default setting
			BlockPasteDlg.m_bool_paste_block=pDoc->settings.m_bool_add_replace_block_paste_block;
			BlockPasteDlg.m_bool_move=pDoc->settings.m_bool_add_replace_block_move;
			BlockPasteDlg.m_bool_move_z=pDoc->settings.m_bool_add_replace_block_move_z;
			BlockPasteDlg.m_bool_rotate=pDoc->settings.m_bool_add_replace_block_rotate;
			BlockPasteDlg.m_bool_expand_lenght=pDoc->settings.m_bool_add_replace_block_expand_lenght;
			BlockPasteDlg.m_bool_expand_width=pDoc->settings.m_bool_add_replace_block_expand_width;
			BlockPasteDlg.m_bool_paste_heights=pDoc->settings.m_bool_add_replace_block_paste_heights;
			BlockPasteDlg.m_bool_paste_spdfa=pDoc->settings.m_bool_add_replace_block_paste_spdfa;
			BlockPasteDlg.m_bool_paste_spdra=pDoc->settings.m_bool_add_replace_block_paste_spdra;
			BlockPasteDlg.m_bool_paste_vroad=pDoc->settings.m_bool_add_replace_block_paste_vroad;
			BlockPasteDlg.m_bool_rearrange_block_obj=pDoc->settings.m_bool_add_replace_block_rearrange_block_obj;

			if (!(BlockPasteDlg.DoModal () == IDOK)) return; //Cancel pressed ?
			{
				pDoc->settings.m_add_replace_block=BlockPasteDlg.m_add_replace_block;
				pDoc->settings.m_bool_add_replace_block_paste_block=BlockPasteDlg.m_bool_paste_block;
				pDoc->settings.m_bool_add_replace_block_move=BlockPasteDlg.m_bool_move;
				pDoc->settings.m_bool_add_replace_block_move_z=BlockPasteDlg.m_bool_move_z;
				pDoc->settings.m_bool_add_replace_block_rotate=BlockPasteDlg.m_bool_rotate;
				pDoc->settings.m_bool_add_replace_block_expand_lenght=BlockPasteDlg.m_bool_expand_lenght;
				pDoc->settings.m_bool_add_replace_block_expand_width=BlockPasteDlg.m_bool_expand_width;
				pDoc->settings.m_bool_add_replace_block_paste_heights=BlockPasteDlg.m_bool_paste_heights;
				pDoc->settings.m_bool_add_replace_block_paste_spdfa=BlockPasteDlg.m_bool_paste_spdfa;
				pDoc->settings.m_bool_add_replace_block_paste_spdra=BlockPasteDlg.m_bool_paste_spdra;
				pDoc->settings.m_bool_add_replace_block_paste_vroad=BlockPasteDlg.m_bool_paste_vroad;
				pDoc->settings.m_bool_add_replace_block_rearrange_block_obj=BlockPasteDlg.m_bool_rearrange_block_obj;
				//int oldundoLevel;
				if (BlockPasteDlg.m_add_replace_block==0) // Add block as new last block
				{
					pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
					pDoc->PrepareModifyCameras();
					pDoc->PrepareModifyVRoadHeightsSpdFiles();

					pDoc->PasteBlockfromClipboard(0,pDoc->nBlocks,1,1,1,1,1); //Paste Block stored in Clipboard at the end
					refblock=pDoc->nBlocks-1;
					pDoc->VisibilityFixInsertBlock(refblock);
					pDoc->NeighborsFixInsertBlock(refblock);
					pDoc->RecalcBoundingBox(refblock);
					refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
					UpdateRefBlock();
					InvalidateRect(NULL,TRUE);
				}
				if (BlockPasteDlg.m_add_replace_block==1) // Insert block before actual block
				{
					pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
					pDoc->PrepareModifyCameras();
					pDoc->PrepareModifyVRoadHeightsSpdFiles();
					//pDoc->PrepareModifyXobj(pDoc->nBlocks); //Global objects
					for (i=refblock;i<pDoc->nBlocks;i++)
					{
						pDoc->PrepareModifyTrk(i);
						pDoc->PrepareModifyPoly(i);
						pDoc->PrepareModifyXobj(i);
					}
					pDoc->PasteBlockfromClipboard(0,pDoc->nBlocks,1,1,1,1,1); //Paste Block stored in Clipboard at the end
					pDoc->MoveLastBlockTo(refblock);
					pDoc->VisibilityFixInsertBlock(refblock);
					//pDoc->SetVisibilityMin(refblock,refblock,2);
					pDoc->SetVisibilityMin(RealBlockNum(refblock-1),RealBlockNum(refblock+1),2);
					pDoc->NeighborsFixInsertBlock(refblock);

					pDoc->RecalcBoundingBox(refblock);
					refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
					UpdateRefBlock();
					InvalidateRect(NULL,TRUE);

				}
				if (BlockPasteDlg.m_add_replace_block==2) //Replace selected block
				{
					//nStartPos=pDoc->trk[refblock].nStartPos;
					RefOld=pDoc->trk[refblock].ptCentre; //Old block middle
					ipt1=pDoc->col.vroad[pDoc->trk[refblock].nStartPos].refPt; //First vroad point
					ipt2=pDoc->col.vroad[pDoc->trk[refblock].nStartPos+pDoc->trk[refblock].nPositions-1].refPt; //Last vroad point
					AngleOld = (180 * atan2((ipt1.y - ipt2.y),(ipt1.x - ipt2.x)))/pi;// Actual Angle of old vroad;
					len1=pDoc->VRoadLenght(refblock);
					vrdata=(struct COLVROAD *)malloc(36*pDoc->trk[refblock].nPositions); //Backup Vroad
					memcpy(vrdata, &pDoc->col.vroad[pDoc->trk[refblock].nStartPos], 36*pDoc->trk[refblock].nPositions);
					for (i=0;i<8;i++) //Backup Block Neighbours
						neighbourdata[i]=(short)pDoc->trk[refblock].hs_neighbors[i];
					for (i=0;i<300;i++) //Backup Visibility
						visdata[i]=pDoc->trk[refblock].nbdData[i].blk;

					myrefnode.x=refnode->x; 
					myrefnode.y=refnode->y; 
					myrefnode.z=refnode->z;
					refnode=&myrefnode;

					pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //New undo point
					pDoc->PrepareModifyTrk(refblock);
					pDoc->PrepareModifyVRoadHeightsSpdFiles();

					pDoc->PasteBlockfromClipboard(2,refblock, BlockPasteDlg.m_bool_paste_block, BlockPasteDlg.m_bool_paste_heights, BlockPasteDlg.m_bool_paste_spdfa, BlockPasteDlg.m_bool_paste_spdra, BlockPasteDlg.m_bool_paste_vroad|BlockPasteDlg.m_bool_rearrange_block_obj); //Paste Block stored in Clipboard

					if ((pDoc->settings.m_bool_add_replace_block_move)|(pDoc->settings.m_bool_add_replace_block_move_z) && pDoc->settings.m_bool_add_replace_block_paste_block) //Move new block in position
					{
						if (pDoc->settings.m_bool_add_replace_block_move)
						{
							dx=RefOld.x - pDoc->trk[refblock].ptCentre.x;
							dy=RefOld.y - pDoc->trk[refblock].ptCentre.y;
						}
						if (pDoc->settings.m_bool_add_replace_block_move_z)
							dz=RefOld.z - pDoc->trk[refblock].ptCentre.z;
						pDoc->MoveBlockSimple(refblock,dx,dy,dz,true);
					}
					if (pDoc->settings.m_bool_add_replace_block_rotate && pDoc->settings.m_bool_add_replace_block_paste_block)
					{
						ipt1=pDoc->col.vroad[pDoc->trk[refblock].nStartPos].refPt; //First vroad point
						ipt2=pDoc->col.vroad[pDoc->trk[refblock].nStartPos+pDoc->trk[refblock].nPositions-1].refPt; //Last vroad point
						AngleNew = (180 * atan2((ipt1.y - ipt2.y),(ipt1.x - ipt2.x)))/pi;// Actual Angle of old vroad;
						pDoc->RotateBlock(refblock,(AngleNew-AngleOld), true);
					}
					if (pDoc->settings.m_bool_add_replace_block_expand_lenght && pDoc->settings.m_bool_add_replace_block_paste_block)
					{
						len2=pDoc->VRoadLenght(refblock);
						mLenght=(float)(len1/len2);
					}
					if ((pDoc->settings.m_bool_add_replace_block_expand_lenght||pDoc->settings.m_bool_add_replace_block_expand_width) && pDoc->settings.m_bool_add_replace_block_paste_block)
						pDoc->ExpandBlock(refblock,mLenght, mWidth, 1, true);
/*					if (pDoc->settings.m_bool_add_replace_block_oldvroad)
					{
						for(i=0;i<pDoc->trk[refblock].nPositions;++i)
							pDoc->col.vroad[pDoc->trk[refblock].nStartPos + i].refPt=vrdata[i].refPt;
						//pDoc->MoveBlocks(refblock,0,0,0,0,0,3); //Only Remap vertices
					}*/
					if (pDoc->settings.m_bool_add_replace_block_rearrange_block_obj) //Rearrange block to exiting vraod
					{
						i=0;
						pDoc->PrepareModifyVRoadHeightsSpdFiles();
						//Write back vroad points from original block
						memcpy(&pDoc->col.vroad[pDoc->trk[refblock].nStartPos], vrdata, 36*pDoc->trk[refblock].nPositions);
						pDoc->MoveBlocks(refblock,0,0,0,0,0,4); // Only remap vertices to block
					}

					for (i=0;i<8;i++) //Write back Block Neighbours
						pDoc->trk[refblock].hs_neighbors[i]=neighbourdata[i];
					for (i=0;i<300;i++) //Write back  Visibility
						pDoc->trk[refblock].nbdData[i].blk=visdata[i];
					dofree(vrdata);
					//pDoc->undoLevel=oldundoLevel;
					pDoc->RecalcBoundingBox(refblock);
					refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
					InvalidateRect(NULL,TRUE);
				}
				if (BlockPasteDlg.m_add_replace_block==3) //Replace texture only
				{
					//pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //New undo point
					pDoc->PasteBlockfromClipboard(3,refblock, BlockPasteDlg.m_bool_paste_block, BlockPasteDlg.m_bool_paste_heights, BlockPasteDlg.m_bool_paste_spdfa, BlockPasteDlg.m_bool_paste_spdra, BlockPasteDlg.m_bool_paste_vroad); //Paste Block stored in Clipboard

					pDoc->RecalcBoundingBox(refblock);
					refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
					InvalidateRect(NULL,TRUE);

				}
				if (BlockPasteDlg.m_add_replace_block==4) //Paste trackblock as object
				{
					//pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //New undo point
					pDoc->PasteBlockfromClipboard(4,refblock,0,0,0,0,0); //Paste high resolution trackblock as chunk 0 polygon object
					//Set view to new object just pasted.
					//CleanCursorZone(selMode,FALSE);
					selMode=ID_MODE_OBJECT;
					if (multisel!=NULL) { delete multisel; multisel=NULL; }
					isTruePoint=FALSE; refpoly=NULL;
					isxobj=0; 
					refchunk=0;
					objno=pDoc->poly[refblock].obj[0].nobj-1;
					refnode=pDoc->trk[refblock].vert + pDoc->poly[refblock].obj[0].poly[objno]->vertex[0];
					pDoc->RecalcBoundingBox(refblock);
					InvalidateRect(NULL,TRUE);
					CleanCursorZone(selMode,TRUE);
				}
				//nStartPos=pDoc->trk[refblock].nStartPos;
			}
		}
	}
}

void CT3EDView::OnEditFind() 
{
	CT3EDDoc *pDoc=GetDocument(); 
	FINDPOLYDATA PolyProps;
	CFindPolygonDlg FindPolyDlg;

	FindPolyDlg.m_block_choice=pDoc->settings.FindPoly_block_choice;
	FindPolyDlg.m_trackpolys=pDoc->settings.FindPoly_trackpolys;
	FindPolyDlg.m_startbl=pDoc->settings.FindPoly_startbl;
	FindPolyDlg.m_endbl=pDoc->settings.FindPoly_endbl;
	FindPolyDlg.m_extraobj=pDoc->settings.FindPoly_extraobj;
	FindPolyDlg.m_polygonobj=pDoc->settings.FindPoly_polygonobj;
	FindPolyDlg.m_texture=pDoc->settings.FindPoly_texture;
	FindPolyDlg.m_chk_texture=pDoc->settings.FindPoly_chk_texture;
	FindPolyDlg.hs_flags=pDoc->settings.FindPoly_m_flags;
	FindPolyDlg.m_chk_hstexture=pDoc->settings.FindPoly_chk_m_flags;
	FindPolyDlg.texanimdata=pDoc->settings.FindPoly_texanimdata;
	FindPolyDlg.m_chk_animated=pDoc->settings.FindPoly_chk_texanimdata;
	FindPolyDlg.pvrflags=pDoc->settings.FindPoly_pvrflags;
	FindPolyDlg.m_chk_pvrflags=pDoc->settings.FindPoly_chk_pvrflags;
	FindPolyDlg.m_select_percent=pDoc->settings.FindPoly_select_percent;
	FindPolyDlg.bHSMode=pDoc->bHSMode;
	FindPolyDlg.qfs=&(pDoc->qfsView);
	

	if (!(FindPolyDlg.DoModal () == IDOK)) return; //Cancel pressed

	pDoc->settings.FindPoly_block_choice=FindPolyDlg.m_block_choice;
	pDoc->settings.FindPoly_trackpolys=FindPolyDlg.m_trackpolys;
	if (FindPolyDlg.m_endbl>=pDoc->nBlocks) FindPolyDlg.m_endbl=pDoc->nBlocks-1;
	pDoc->settings.FindPoly_endbl=FindPolyDlg.m_endbl;  
	if (FindPolyDlg.m_startbl>FindPolyDlg.m_endbl) FindPolyDlg.m_startbl=FindPolyDlg.m_endbl;
	pDoc->settings.FindPoly_startbl=FindPolyDlg.m_startbl;
	pDoc->settings.FindPoly_extraobj=FindPolyDlg.m_extraobj;
	pDoc->settings.FindPoly_polygonobj=FindPolyDlg.m_polygonobj;
	pDoc->settings.FindPoly_texture=FindPolyDlg.m_texture;  
	pDoc->settings.FindPoly_chk_texture=FindPolyDlg.m_chk_texture;
	pDoc->settings.FindPoly_m_flags=FindPolyDlg.hs_flags;
	pDoc->settings.FindPoly_chk_m_flags=FindPolyDlg.m_chk_hstexture;
	pDoc->settings.FindPoly_texanimdata=FindPolyDlg.texanimdata;
	pDoc->settings.FindPoly_chk_texanimdata=FindPolyDlg.m_chk_animated;
	pDoc->settings.FindPoly_pvrflags=FindPolyDlg.pvrflags;
	pDoc->settings.FindPoly_chk_pvrflags=FindPolyDlg.m_chk_pvrflags;
	pDoc->settings.FindPoly_select_percent=FindPolyDlg.m_select_percent;

	//PolyProps == Information about what to find
	PolyProps.texture=FindPolyDlg.m_texture;
	PolyProps.search_texture=FindPolyDlg.m_chk_texture;
	PolyProps.hs_flags=FindPolyDlg.hs_flags;
	PolyProps.search_hs_flags=FindPolyDlg.m_chk_hstexture;
	PolyProps.texanimdata=FindPolyDlg.texanimdata;
	PolyProps.search_texanimdata=FindPolyDlg.m_chk_animated;
	PolyProps.pvrflags=FindPolyDlg.pvrflags;
	PolyProps.search_pvrflags=FindPolyDlg.m_chk_pvrflags;
	
	if (FindPolyDlg.m_block_choice==0)
		FindPoly(PolyProps,refblock,refblock,FindPolyDlg.m_trackpolys,FindPolyDlg.m_polygonobj,FindPolyDlg.m_extraobj,FindPolyDlg.m_select_percent);
	else
		FindPoly(PolyProps,FindPolyDlg.m_startbl,FindPolyDlg.m_endbl,FindPolyDlg.m_trackpolys,FindPolyDlg.m_polygonobj,FindPolyDlg.m_extraobj,FindPolyDlg.m_select_percent);

	//FindPoly(PolyProps,9,12,FALSE,FALSE,TRUE);
	InvalidateRect(NULL,TRUE);
	
	CDC *dc;
	if (!isDragging) return;
	dc=GetDC();
	dc->SelectObject(redPen);
	dc->SetROP2(R2_NOTXORPEN);
	ShowSelectionAt(dc,dragX,dragY);
	ReleaseDC(dc);
}

void CT3EDView::OnEditMerge() 
{
	CT3EDDoc *pDoc=GetDocument();
	int er;
	
	if (refblock<pDoc->nBlocks)
	{
		er=pDoc->MergeBlocks(refblock, refblock+1);
		if (er>-1)
		{
			refblock=er;
			pDoc->RecalcBoundingBox(refblock);
			refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
			InvalidateRect(NULL,TRUE);
		}
	}
}

BOOL CT3EDView::FindPolyMatches(FINDPOLYDATA &fpoly, LPPOLYGONDATA &p)
{
	BOOL Ok=TRUE;

	if ((fpoly.search_texture)&&(fpoly.texture!=p->texture)) Ok=FALSE;
	if ((fpoly.search_hs_flags)&&(fpoly.hs_flags!=p->hs_textflags)) Ok=FALSE;
	if ((fpoly.search_texanimdata)&&(p->texanimdata==0)) Ok=FALSE;

	return Ok;
}

BOOL CT3EDView::FindPolyVRMatches(FINDPOLYDATA &fpoly, POLYVROADDATA *pvr, LPPOLYGONDATA &p)
{
	BOOL Ok=TRUE;

	if ((fpoly.search_pvrflags)&&((pvr->flags&0x1f)!=fpoly.pvrflags)) Ok=FALSE;
	if ((fpoly.search_pvrflags)&&(p->texture>2047)) Ok=FALSE;

	return Ok;
}

void CT3EDView::FindPoly(FINDPOLYDATA &fpoly, int startbl, int endbl, BOOL FindTrackPoly, BOOL FindObjectPoly, BOOL FindXObjectPoly, int select_percent)
{
	int i,j,k,l,n,i0,j0;
	struct FLOATPT *pt;
	LPPOLYGONDATA p;
	struct OBJPOLYBLOCK *o;
	struct XOBJDATA *xx;
	struct POLYVROADDATA *pvrdata;
	CT3EDDoc *pDoc=GetDocument(); 
	int iselp=100-select_percent;
	//Radom initalise
	srand( (unsigned)time( NULL ) );

	if (multisel!=NULL)
		{ delete multisel; multisel=NULL; }
	refpoly=NULL;

	i0=-1; //p0=NULL,isx0=0;
	if (FindTrackPoly)
	for (i=startbl;i<endbl+1;i++) 
	{
		//if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
		pt=pDoc->trk[i].vert;
		for (k=0;k<7;k++) {
			if (!bShowLanes) if (k!=nDetail) continue;
			if (bShowLanes) if (((k&6)!=nDetail)&&(k!=6)) continue;
			if ((fpoly.search_pvrflags==TRUE)&&(k>4)) continue; //Flags are only on lower chunks
			if ((fpoly.search_pvrflags==TRUE)&&(nDetail!=HIGH_DETAIL)) continue; //Flags search only on high detail
			p=pDoc->poly[i].poly[k];
			n=pDoc->poly[i].sz[k];
			for (j=0;j<n;j++,p++) 
			{
				pvrdata=pDoc->trk[i].polyData+j;
				if  ((FindPolyMatches(fpoly, p)) && FindPolyVRMatches(fpoly, pvrdata, p) && ((rand() % 100 + 1)>iselp))
				{
						NewSel();
						refblock=i;		//refblock=i0;
						refchunk=k;	//refchunk=j0;
						refpolyobj=-1;	//refpolyobj=k0;
						refpolyno=j;	//refpolyno=l0;
						isxobj=0;
						refpoly=p;		//refpoly=p0;
						refvertices=pt;//refvertices=pt0;
						/*if (isx0) pt=coreref;
						else pt=refvertices+refpoly->vertex[0];
						x0=FloatX(*pt); y0=FloatY(*pt);*/
						refnode=pt;
				}
			}
		}
	}
	if (FindObjectPoly)
	for (i=startbl;i<endbl+1;i++) //Polygon objects
	{
		//if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
		pt=pDoc->trk[i].vert;
		for (j=0;j<4;j++) {
			o=&(pDoc->poly[i].obj[j]);
			if (o->n1==0) continue;
			for (k=0;k<o->nobj;k++) {
				p=o->poly[k];
				n=o->numpoly[k];
				for (l=0;l<n;l++,p++) 
				{
					if (FindPolyMatches(fpoly, p) && ((rand() % 100 + 1)>iselp))
					{
						NewSel();
						refblock=i;		//refblock=i0;
						refchunk=j;	//refchunk=j0;
						refpolyobj=k;	//refpolyobj=k0;
						refpolyno=l;	//refpolyno=l0;
						isxobj=0;
						refpoly=p;		//refpoly=p0;
						refvertices=pt;//refvertices=pt0;
					}
				}
			}
		}
	}
	if (FindXObjectPoly)
		for (i=4*startbl;i<4*(endbl+1);i++) {
			//if (!MeetsClipRect(&(pDoc->trk[i/4]),&rect)) { i=i|3; continue; }
			xx=pDoc->xobj[i].obj;
			for (j=0;j<pDoc->xobj[i].nobj;j++,xx++) {
				pt=xx->vert;
				p=xx->polyData;
				for (k=0;k<xx->nPolygons;k++,p++)
				{
					if (FindPolyMatches(fpoly, p) && ((rand() % 100 + 1)>iselp))
					{
						NewSel();
						refblock=i/4;
						refchunk=j0=i%4;
						refpolyobj=j;
						refpolyno=k;
						isxobj=1;
						refpoly=p;
						refvertices=pt;
						myrefnode=xx->ptRef; //New
						refnode=&(xx->ptRef);
						xobjrefnode=&(xx->ptRef); //New
					}
				}
			}
		}
}

void CT3EDView::OnPasteXY() 
{
	// Paste XY
	CT3EDDoc *pDoc=GetDocument(); 
	CSelData *sel;
	FLOATPT ClipPt;
	CString sStr;
	float MoveAmountX,MoveAmountY;

	CString Clip = "";
	//What is on Clipboard and change mode if needed
	Clip = pDoc->GetClipboardText(); // Returns "Block", "Object", "VRoad", "Camera" or nothing
	if (!(Clip=="FloatPt")) return;

	pDoc->GetXYZfromClipboard(&ClipPt);
	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	pDoc->PrepareModifyTrk(refblock);

	sStr.Format("Paste position X:%f, Y:%f.",refnode->x, refnode->y);
	statusbar->SetPaneText(0,sStr,TRUE);

	if (selMode==ID_MODE_POINT) // Only for Point mode
	{
		if (multisel) // Paste XY for more than one point
		{
			{
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					MoveAmountX=-1*(sel->refnode->x - ClipPt.x);
					MoveAmountY=-1*(sel->refnode->y - ClipPt.y);
					pDoc->MovePointBy(sel->refnode,MoveAmountX,MoveAmountY,0);
				}
			}
		}
		else // Paste XY for one point
		{
			MoveAmountX=-1*(refnode->x - ClipPt.x);
			MoveAmountY=-1*(refnode->y - ClipPt.y);
			pDoc->MovePointBy(refnode,MoveAmountX,MoveAmountY,0);
		}
	}
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnCopyZ() 
{
	// TODO: Add your command handler code here
	CT3EDDoc *pDoc=GetDocument(); 
	pDoc->memory_Zh = refnode->z;
	InvalidateRect(NULL,TRUE);
	
}


void CT3EDView::OnCOPYZl() 
{
	// TODO: Add your command handler code here
	CT3EDDoc *pDoc=GetDocument(); 
	pDoc->memory_Zl = refnode->z;
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnPasteZh() 
{
	// TODO: Add your command handler code here
	CT3EDDoc *pDoc=GetDocument(); 
	CSelData *sel=this;
	float mx,my,mz;
	double MoveAmount, shadestep;
	double pieni, suuri; 
	int PasteMode, counter, numentrys, number;
	CString s;
	PasteMode=pDoc->ZCopyMode;
	struct POLYVROADDATA *data;
	struct FLOATPT p1,p2;
	bool AltKey=false;
	if (GetAsyncKeyState(VK_MENU) & 0x8000) AltKey=true;
	
	data=pDoc->trk[refblock].polyData+refpolyno;
	
	
	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	pDoc->PrepareModifyTrk(refblock);
	
	if (selMode==ID_MODE_VROADEDIT)
	{
		if (isxobj!=6) return; //Last selection wasn't a AI Point
		if (multisel==NULL) return; //less than two points selected

		//CSelData *sel;
		int p1=objno, p2=-1;
		for (sel=this;sel!=NULL;sel=sel->multisel)
		{
			if ((sel->isxobj==6)&&(sel->objno!=p1)) p2=sel->objno;
		}
		if (p2==-1) return;
		pDoc->PrepareModifyVRoadHeightsSpdFiles();
		pDoc->SpeedFile_Calc_Float_Between2AIPoints(p1,p2,ShowFwSPD, !AltKey);

		CString sStr;
		if (ShowFwSPD) 
			{
				sStr.Format("Forward AI float from point %d to point %d calculated.", p1, p2);
			}
			else 
			{
				sStr.Format("Backward AI float from point %d to point %d calculated.", p1, p2);
			}
			statusbar->SetPaneText(0,sStr,TRUE);		
	}
	
	if (selMode==ID_MODE_POLYGON)
	{	
		if (multisel)
		{
			if (PasteMode==2)
			{
				
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					short TP;
					TP=sel->refpoly->vertex[1];
					sel->refpoly->vertex[1]=refpoly->vertex[0];
					sel->refpoly->vertex[0]=TP;

					TP=sel->refpoly->vertex[3];
					sel->refpoly->vertex[3]=refpoly->vertex[2];
					sel->refpoly->vertex[2]=TP;
				}
				
			}
			else
			{
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					data=pDoc->trk[sel->refblock].polyData+sel->refpolyno;
					data->virtualroadedge=!data->virtualroadedge;
				}
			}
		}
		else 
		{
			if (PasteMode==2)
			{
				short TP;
				TP=sel->refpoly->vertex[1];
				sel->refpoly->vertex[1]=refpoly->vertex[0];
				sel->refpoly->vertex[0]=TP;

				TP=sel->refpoly->vertex[3];
				sel->refpoly->vertex[3]=refpoly->vertex[2];
				sel->refpoly->vertex[2]=TP;
			}
			else
			{
				data->virtualroadedge=!data->virtualroadedge;
			}
		}
	}
	if (selMode==ID_MODE_POINT)
	{
		if (multisel)
		{
			//PasteMode==2, Multiselect ZShade.
			if (PasteMode==2) 
			{
				suuri=-99999;
				pieni=99999;
				counter=0;
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					//look for smalest and bigest
					if (counter<1)
						pieni=sel->refnode->z;
					suuri=sel->refnode->z;
					/*if (sel->refnode->z< small)
						small=sel->refnode->z;
					if (sel->refnode->z> big)
						big=sel->refnode->z;*/
					counter++;
				}
				counter--; //one too much, but why??
				shadestep=(suuri-pieni)/counter;
				numentrys=counter;
				counter=-1;
				number=numentrys+1;
				s.Format("Shading %d points.", number);
				MessageBox(s);
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					counter++;
					if (counter<numentrys && counter>0) {
						//s.Format("Counter: %d, NumEntrys:%d",counter, numentrys);
						//MessageBox(s);
						MoveAmount=-1*(sel->refnode->z-((counter*shadestep)+pieni));
						pDoc->MovePointBy(sel->refnode, 0, 0, (float)MoveAmount);	
					}
				}
			}
			else if (PasteMode==3) //MultiSelect Average.
			{
				float MAverage = 0;
				counter=0;
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					counter++;
					MAverage=MAverage+sel->refnode->z;
				}
				MAverage=MAverage/counter;
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					MoveAmount=-1*(sel->refnode->z-MAverage);
					pDoc->MovePointBy(sel->refnode, 0, 0, (float)MoveAmount);	
				}

			}
			//Line up x,y,(z) mode
			else if ((PasteMode==4)|(PasteMode==5)) {
				
				//get start & end point values
				sel=this;
				p1.x=sel->refnode->x;
				p1.y=sel->refnode->y;
				p1.z=sel->refnode->z;
				counter=0;
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					p2.x=sel->refnode->x;
					p2.y=sel->refnode->y;
					p2.z=sel->refnode->z;
					counter++;
				}
				number=counter-1;
				//Line up points.
				counter=0;
				if (number>1)
				{
					for (sel=this;sel!=NULL;sel=sel->multisel)
					{
						mx=(p1.x + counter*((p2.x - p1.x)/number)) - sel->refnode->x;
						my=(p1.y + counter*((p2.y - p1.y)/number)) - sel->refnode->y;
						mz=(p1.z + counter*((p2.z - p1.z)/number)) - sel->refnode->z;
						if (PasteMode==4) // only x & y
							pDoc->MovePointBy(sel->refnode, mx, my, 0);
						else // x, y & z
							pDoc->MovePointBy(sel->refnode, mx, my, mz);
						counter++;
					}
					s.Format("Line up x,y,(z) %d points.", counter);
					MessageBox(s);
				}
			}
			
			else
			{
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					MoveAmount=-1*(sel->refnode->z - pDoc->memory_Zh);
					pDoc->MovePointBy(sel->refnode, 0, 0, (float)MoveAmount);	
				}
			}
		}
		else
		{
			MoveAmount=-1*(refnode->z-pDoc->memory_Zh);
			pDoc->MovePointBy(refnode, 0,0,(float)MoveAmount);
		}
	}
	//refnode->z = pDoc->memory_Zh;
	InvalidateRect(NULL,TRUE);
	//turbo.Format("refpoly number: %d", refpoly);
	//MessageBox(turbo);

}


void CT3EDView::OnExportTrkvertices() 
{
	CT3EDDoc *pDoc=GetDocument();

FILE* fout = fopen("Vertices.txt", "w");
		//MessageBox("Tiedosto auki.");
		fprintf(fout, "%f\n", 2.0);
		fprintf(fout, "%d\n", pDoc->nBlocks);
		for(int i=0;i<pDoc->nBlocks ;i++)
		{
			fprintf(fout, "%d\n", pDoc->trk[i].nVertices);
			
			for(int u=0;u<pDoc->trk[i].nVertices ;u++)
			{
				fprintf(fout, "X: %f\n", pDoc->trk[i].vert[u].x);
				fprintf(fout, "Y: %f\n", pDoc->trk[i].vert[u].y);
				fprintf(fout, "Z: %f\n", pDoc->trk[i].vert[u].z);
				fprintf(fout, "C: %X\n", pDoc->trk[i].vertshade[u]);
			}
			
		}
		fclose(fout);
		MessageBox("Vertices exportted.");	
}


/*void CT3EDView::OnExportQuads() 
{
	// TODO: Add your command handler code here
	//MessageBox("alussa");
	CT3EDDoc *pDoc=GetDocument();
	//MessageBox("dokumentti saatu");

FILE* fout = fopen("Mesh.txt", "w");
		//MessageBox("Tiedosto auki.");
		fprintf(fout, "%f\n", 3.0);
		fprintf(fout, "%d\n", pDoc->nBlocks);
		for(int i=0;i<pDoc->nBlocks ;i++)
		{
			fprintf(fout, "%d\n", pDoc->trk[i].nPositions);
			
			/for(int u=0;u<pDoc->trk[i].nPositions-1;u++)
			{
				//fprintf(fout, "X: %f\n", pDoc->poly[i]->poly[6]->vertex[0]
				fprintf(fout, "Y: %f\n", pDoc->trk[i].vert[u].y);
				fprintf(fout, "Z: %f\n", pDoc->trk[i].vert[u].z);
				fprintf(fout, "C: %X\n", pDoc->trk[i].unknVertices[u]);
			} 
		
		}
		fclose(fout);
		MessageBox("Vertices Exportted.");	
	
}*/

void CT3EDView::OnFileProperties() 
{
	CFrdFileDlg FrdFileDlg;
	CT3EDDoc *pDoc=GetDocument();

	FrdFileDlg.m_int_nBlocks=pDoc->nBlocks;
	FrdFileDlg.m_short_nVRoad=pDoc->col.vroadHead.nrec;
	FrdFileDlg.m_int_gch0=pDoc->xobj[4*pDoc->nBlocks].nobj;
	FrdFileDlg.m_int_gch1=pDoc->xobj[4*pDoc->nBlocks +1].nobj;
	FrdFileDlg.p_header=pDoc->header;
	if (pDoc->bHSMode)
		FrdFileDlg.m_str_File_Format="NFS 4";
	else
		FrdFileDlg.m_str_File_Format="NFS 3";

	FrdFileDlg.DoModal();
}

void CT3EDView::OnToolsProperties() 
{
	//PrepareModifyTrk(blk);
	//PrepareModifyPoly(blk);
	float dist,dist0, Size[4];
	int i, j,k,l, num, oblock,oisxobj,orefchunk,oobjno;
	CSelData *sel;
	CString keke="";
	CString text="", sStr="";
	struct TRKBLOCK blk;
	CT3EDDoc *pDoc=GetDocument();
	struct NOBJDATA NewObjData;
	struct XOBJDATA *x, *ox;
	struct FLOATPT *v;
	//struct FLOATPT pt;
	//struct INTPT *pt;
	struct REFXOBJ *rx;
	//struct FLOATPT *type6testv;
	//char *type6test;
	//float dx, dy, dz;
	//LPPOLYGONDATA p;
	struct BGRA vs;
	BOOL bAutoObjMemOld;

	//i=sizeof(struct FLOATPT);
	bAutoObjMemOld=pDoc->bAutoObjMem;
	pDoc->bAutoObjMem=FALSE;


	if ((selMode==ID_MODE_POINT)|(selMode==ID_MODE_EXTPOINT))
	{
		CPointPropsDlg PDlg;
		CString strBlock, strNumP;

		sel=this;
		if (isTruePoint==FALSE) {pDoc->bAutoObjMem=bAutoObjMemOld;return;}
		// Get number of selected points
		num=0;
		for (sel=this;sel!=NULL;sel=sel->multisel) //look at all points
			num++;
		if (num==1)
			strNumP.Format("One point is selected.");
		else
			strNumP.Format("%d points are selected.",num);
		PDlg.m_str_num_points=strNumP;

		sel=this;
		strBlock.Format("Last selected point belongs to block %d.", refblock);
		PDlg.m_str_block=strBlock;
		PDlg.m_float_posx=sel->refnode->x;
		PDlg.m_float_posy=sel->refnode->y;
		PDlg.m_float_posz=sel->refnode->z;

		vs=pDoc->GetVertShade(sel->refblock,sel->refnode);
		PDlg.m_int_red=vs.red;
		PDlg.m_int_green=vs.green;
		PDlg.m_int_blue=vs.blue;
		PDlg.m_int_alpha=vs.alpha;
		
		if (PDlg.DoModal()!=IDOK) {pDoc->bAutoObjMem=bAutoObjMemOld;return;}

		//Write back x,y,z
		if ((PDlg.m_float_posx==sel->refnode->x)&&(PDlg.m_float_posy==sel->refnode->y)&&(PDlg.m_float_posz==sel->refnode->z)&&
			(PDlg.m_int_red==vs.red)&&(PDlg.m_int_green==vs.green)&&(PDlg.m_int_blue==vs.blue)&&(PDlg.m_int_alpha==vs.alpha)) {pDoc->bAutoObjMem=bAutoObjMemOld;return;} //Nothing changed do nothing
		
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);

		sel=this;
		//Write back position data

		//Modify XOBJ?
		i=sel->refblock;
		for (j=4*i;j<4*i+4;j++) 
		{

		  x=pDoc->xobj[j].obj;
		  for (k=0;k<pDoc->xobj[j].nobj;k++,x++) 
		  {
			v=x->vert;
			for (l=0;l<x->nVertices;l++,v++)
				if ((fabs(v->x+x->ptRef.x-sel->refnode->x)<1E-3)&&(fabs(v->z+x->ptRef.z-sel->refnode->z)<1E-3)&&(fabs(v->y+x->ptRef.y-sel->refnode->y)<1E-3))
				{
					pDoc->PrepareModifyXobj(j);
					v->x = PDlg.m_float_posx - x->ptRef.x;
					v->y = PDlg.m_float_posy - x->ptRef.y;	
					v->z = PDlg.m_float_posz - x->ptRef.z;
				}
		  }
		}

		pDoc->PrepareModifyTrk(refblock);
		//Modify refnode
		sel->refnode->x=PDlg.m_float_posx;
		sel->refnode->y=PDlg.m_float_posy;
		sel->refnode->z=PDlg.m_float_posz;

		//write back shading information
		if ((PDlg.m_int_red!=vs.red)|(PDlg.m_int_green!=vs.green)|(PDlg.m_int_blue!=vs.blue)|(PDlg.m_int_alpha!=vs.alpha))
		{
			for (sel=this;sel!=NULL;sel=sel->multisel) //make undo for all points
			{
						pDoc->PrepareModifyTrk(sel->refblock); //Undo info for trackblock
						i=sel->refblock;
						for (j=4*i;j<4*i+4;j++) //Undo info for xobjs
							pDoc->PrepareModifyXobj(j);
			}

			vs.red=PDlg.m_int_red;
			vs.green=PDlg.m_int_green;
			vs.blue=PDlg.m_int_blue;
			vs.alpha=PDlg.m_int_alpha;
			for (sel=this;sel!=NULL;sel=sel->multisel) //look at all points
				pDoc->SetVertShade(sel->refblock,sel->refnode,vs);
		}


		InvalidateRect(NULL,TRUE);

	}
	
	if (selMode==ID_MODE_POLYGON)
	{
		/*if ((refpoly!=NULL)&&(refpolyobj==-1)&&(refchunk==4))
		{
			OnToolsPolyflag();  //Show Polygons Flags of track poly
		}*/
		PolygonShading();
		return;
	}

	if ((selMode==ID_MODE_VROADEDIT)&&((isxobj==4)|(isxobj==6))&&pDoc->bHSMode) // VRoad Refpoint
	{
		CVRoadHeightsSpdFileDlg VRHSFDlg; // Create dialog
		num=0;
		for (sel=this;sel!=NULL;sel=sel->multisel) //look at all objects
			if ((sel->isxobj==4)|(sel->isxobj==6))
			{
				num++;
				if (num==1)
				{
					VRHSFDlg.m_colvrdata=(struct COLVROAD *)malloc(sizeof(struct COLVROAD)); //Get first memory
					VRHSFDlg.m_heightsdata=(struct HEIGHTSSIM *)malloc(sizeof(struct HEIGHTSSIM));
					VRHSFDlg.spdFAdata=(struct SPDFILE *)malloc(sizeof(struct SPDFILE));
					VRHSFDlg.spdRAdata=(struct SPDFILE *)malloc(sizeof(struct SPDFILE));
					VRHSFDlg.VRoadNumbers=(int *)malloc(sizeof(int)); //Create space for VRoad numbers
					if (pDoc->bHSMode)
						VRHSFDlg.hs_extra=(struct HS_EXTRA *)malloc(sizeof(struct HS_EXTRA));
				}
				else
				{
					VRHSFDlg.m_colvrdata=(struct COLVROAD *)realloc(VRHSFDlg.m_colvrdata,num * sizeof(struct COLVROAD)); //Get more memory
					VRHSFDlg.m_heightsdata=(struct HEIGHTSSIM *)realloc(VRHSFDlg.m_heightsdata,num * sizeof(struct HEIGHTSSIM));
					VRHSFDlg.spdFAdata=(struct SPDFILE *)realloc(VRHSFDlg.spdFAdata,num * sizeof(struct SPDFILE));
					VRHSFDlg.spdRAdata=(struct SPDFILE *)realloc(VRHSFDlg.spdRAdata,num * sizeof(struct SPDFILE));
					VRHSFDlg.VRoadNumbers=(int *)realloc(VRHSFDlg.VRoadNumbers,num * sizeof(int));
					if (pDoc->bHSMode)
						VRHSFDlg.hs_extra=(struct HS_EXTRA *)realloc(VRHSFDlg.hs_extra, num * sizeof(struct HS_EXTRA));
				}
				memcpy(&VRHSFDlg.m_colvrdata[num-1],&pDoc->col.vroad[sel->objno],sizeof(struct COLVROAD));
				memcpy(&VRHSFDlg.m_heightsdata[num-1],&pDoc->hightssim[sel->objno],sizeof(struct HEIGHTSSIM));
				memcpy(&VRHSFDlg.spdFAdata[num-1],&pDoc->spdFAbin[sel->objno],sizeof(struct SPDFILE));
				memcpy(&VRHSFDlg.spdRAdata[num-1],&pDoc->spdRAbin[sel->objno],sizeof(struct SPDFILE));
				VRHSFDlg.VRoadNumbers[num-1]=sel->objno;
				if (pDoc->bHSMode)
					memcpy(&VRHSFDlg.hs_extra[(num-1)],&pDoc->col.hs_extra[sel->objno], sizeof(struct HS_EXTRA));
			}

		VRHSFDlg.m_nPositions=num;
		VRHSFDlg.m_Chk_Heights=pDoc->settings.VRoadHeightsSpd_Chk_Heights;
		VRHSFDlg.m_Chk_SpdFa=pDoc->settings.VRoadHeightsSpd_Chk_SpdFa;
		VRHSFDlg.m_Chk_SpdRa=pDoc->settings.VRoadHeightsSpd_Chk_SpdRa;
		VRHSFDlg.m_Chk_VRoad=pDoc->settings.VRoadHeightsSpd_Chk_VRoad;
		VRHSFDlg.m_Chk_HSExtra=pDoc->settings.VRoadHeightsSpd_Chk_HSExtra;
		VRHSFDlg.m_Chk_PVR=pDoc->settings.VRoadHeightsSpd_Chk_PVR;
		VRHSFDlg.m_Combo_Vector_Calc=pDoc->settings.VRoadHeightsSpd_Combo_Calc;
		VRHSFDlg.m_Chk_VRoad_z=pDoc->settings.VRoadHeightsSpd_Chk_VRoad_z;
		VRHSFDlg.m_Chk_AI_Lane_Recalc=pDoc->settings.VRoadHeightsSpd_Chk_AI_Lane_Recalc;
		VRHSFDlg.bHSMode=(pDoc->bHSMode != 0); //Only used to skip the warning


		if (VRHSFDlg.DoModal()==IDOK)
		{
			pDoc->settings.VRoadHeightsSpd_Chk_Heights=VRHSFDlg.m_Chk_Heights;
			pDoc->settings.VRoadHeightsSpd_Chk_SpdFa=VRHSFDlg.m_Chk_SpdFa;
			pDoc->settings.VRoadHeightsSpd_Chk_SpdRa=VRHSFDlg.m_Chk_SpdRa;
			pDoc->settings.VRoadHeightsSpd_Chk_VRoad=VRHSFDlg.m_Chk_VRoad;
			pDoc->settings.VRoadHeightsSpd_Chk_HSExtra=VRHSFDlg.m_Chk_HSExtra;
			pDoc->settings.VRoadHeightsSpd_Chk_PVR=VRHSFDlg.m_Chk_PVR;
			pDoc->settings.VRoadHeightsSpd_Combo_Calc=VRHSFDlg.m_Combo_Vector_Calc;
			pDoc->settings.VRoadHeightsSpd_Chk_VRoad_z=VRHSFDlg.m_Chk_AI_Lane_Recalc;
			pDoc->settings.VRoadHeightsSpd_Chk_AI_Lane_Recalc=VRHSFDlg.m_Chk_VRoad_z;
			num=0;
			pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //Undo needed
			pDoc->PrepareModifyVRoadHeightsSpdFiles();
			for (sel=this;sel!=NULL;sel=sel->multisel) //look at all objects
				if ((sel->isxobj==4)|(sel->isxobj==6))
				{
					num++; //Copy back changed data
					memcpy(&pDoc->col.vroad[sel->objno],&VRHSFDlg.m_colvrdata[num-1],sizeof(struct COLVROAD));
					memcpy(&pDoc->hightssim[sel->objno],&VRHSFDlg.m_heightsdata[num-1],sizeof(struct HEIGHTSSIM));
					memcpy(&pDoc->spdFAbin[sel->objno],&VRHSFDlg.spdFAdata[num-1],sizeof(struct SPDFILE));
					memcpy(&pDoc->spdRAbin[sel->objno],&VRHSFDlg.spdRAdata[num-1],sizeof(struct SPDFILE));
					if (pDoc->bHSMode)
						memcpy(&pDoc->col.hs_extra[sel->objno], &VRHSFDlg.hs_extra[(num-1)], sizeof(struct HS_EXTRA));
					if (VRHSFDlg.m_Chk_VRoad_z) //Adjust VRoadZ?
						pDoc->AdjustVRoadPointZ(sel->objno);

					if (VRHSFDlg.m_Chk_AI_Lane_Recalc) //Recalc lanes
						{
							//No move just, recalc AI lanes
							pDoc->MoveObjectBy(-1, 6, 0, sel->objno, 0, 0, 0, 1, 1); //Forward Speed File
							pDoc->MoveObjectBy(-1, 6, 0, sel->objno, 0, 0, 0, 1, 0); //Backward Speed File
						}

					if (pDoc->settings.VRoadHeightsSpd_Chk_PVR) //Poly VRoad Recalc
						pDoc->UpdateColVroadVecs(sel->objno);
				}
			InvalidateRect(NULL,TRUE);
		}
		//Give back used memory
		dofree(VRHSFDlg.m_colvrdata);
		dofree(VRHSFDlg.m_heightsdata);
		dofree(VRHSFDlg.spdFAdata);
		dofree(VRHSFDlg.spdRAdata);
		if (pDoc->bHSMode)
			dofree(VRHSFDlg.hs_extra);


		{pDoc->bAutoObjMem=bAutoObjMemOld;return;}
	}
	if ((selMode==ID_MODE_OBJECT)&&(isxobj==5)) // Replay Camera properties
	{
		CCameraProps CamProp;

		CamProp.nCams=pDoc->Camfile.nCams;
		CamProp.SelectedCam=objno;
		CamProp.pCamData=(struct CAMDATA *)malloc(CamProp.nCams * sizeof(struct CAMDATA)); //Get memory to store cameras
		memcpy(CamProp.pCamData, pDoc->Camfile.pCamData, CamProp.nCams * sizeof(struct CAMDATA));

		CamProp.col_nrec=pDoc->col.vroadHead.nrec;
		CamProp.vroad=pDoc->col.vroad;

		if (CamProp.DoModal()!=IDOK) {pDoc->bAutoObjMem=bAutoObjMemOld;return;}

		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		pDoc->PrepareModifyCameras();

		pDoc->Camfile.nCams=CamProp.nCams; //New Number of Cams?
		pDoc->Camfile.pCamData=(struct CAMDATA *)realloc(pDoc->Camfile.pCamData, pDoc->Camfile.nCams * sizeof(struct CAMDATA)); //Get memory to store cameras
		memcpy(pDoc->Camfile.pCamData, CamProp.pCamData, CamProp.nCams * sizeof(struct CAMDATA));  //Store changed data

		//Show selected Cam
		objno=pDoc->SortCams(CamProp.SelectedCam); //New selection?
		myrefnode=pDoc->Camfile.pCamData[objno].CamPosition;
		refblock=pDoc->FindNearestBlock(&myrefnode);
		refnode=&myrefnode;
		sStr.Format("Replay Camera %d selected", (objno + 1));	//+1 to Show same number as Nappe's CamEdit tool
		statusbar->SetPaneText(0,sStr,TRUE);

		dofree(CamProp.pCamData);

	}

	if (multisel) delete multisel; multisel=NULL;
	sel=this;

	blk=pDoc->trk[refblock];
	if (selMode==ID_MODE_BLOCK) // Block Mode
	{
		blk=pDoc->trk[refblock];
		CBlockProp BlockProp;
		BlockProp.m_RefBlock=refblock;
		BlockProp.m_float_ptCentreX=blk.ptCentre.x;
		BlockProp.m_float_ptCentreY=blk.ptCentre.y;
		BlockProp.m_float_ptCentreZ=blk.ptCentre.z;
		BlockProp.m_nVertices=blk.nVertices;
		BlockProp.m_nHiResVert=blk.nHiResVert;
		BlockProp.m_nMedResVert=blk.nMedResVert;
		BlockProp.m_nLoResVert=blk.nLoResVert;
		//BlockProp.m_nLightsrc=blk.nLightsrc;
		//BlockProp.m_nSoundsrc=blk.nSoundsrc;
		BlockProp.m_AdjustRoad_AdjustType = pDoc->settings.AdjustRoad_AdjustType;
		BlockProp.m_AdjustRoad_Check_VR = pDoc->settings.AdjustRoad_Check_VR;
		BlockProp.m_AdjustRoad_Check_Man_Set_Num_Lanes = pDoc->settings.AdjustRoad_Check_Man_Set_Num_Lanes;

		BlockProp.m_AdjustRoad_Check_Change_VR_Width = pDoc->settings.AdjustRoad_Check_Change_VR_Width;
		BlockProp.m_AdjustRoad_Check_Detect_lanes = pDoc->settings.AdjustRoad_Check_Detect_lanes;
		BlockProp.m_AdjustRoad_Check_Auto_Set_Lane_Bitcoded = pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Bitcoded;
		BlockProp.m_AdjustRoad_Check_Auto_Set_Lane_Polys = pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Polys;
		BlockProp.m_AdjustRoad_Check_Auto_Set_Lane_Width = pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Width;

		BlockProp.m_bHSMode = pDoc->bHSMode;
		BlockProp.t=&pDoc->trk[refblock];


		//BlockProp.m_AdjustRoad_Size = pDoc->settings.AdjustRoad_Size;
		BlockProp.m_AdjustRoad_Size[0]= pDoc->settings.AdjustRoad_Size[0];
		BlockProp.m_AdjustRoad_Size[1]= pDoc->settings.AdjustRoad_Size[1];
		BlockProp.m_AdjustRoad_Size[2]= pDoc->settings.AdjustRoad_Size[2];
		BlockProp.m_AdjustRoad_Size[3]= pDoc->settings.AdjustRoad_Size[3];
		BlockProp.m_AdjustRoad_Selected = false;
		BlockProp.m_bool_c_shading=pDoc->settings.BlockProp_C_Shading;
		
		if (BlockProp.DoModal()!=IDOK) {pDoc->bAutoObjMem=bAutoObjMemOld;return;}
		pDoc->settings.BlockProp_C_Shading=BlockProp.m_bool_c_shading;

		blk.ptCentre.x=BlockProp.m_float_ptCentreX;
		blk.ptCentre.y=BlockProp.m_float_ptCentreY;
		blk.ptCentre.z=BlockProp.m_float_ptCentreZ;

		if ((BlockProp.m_bool_c_shading==TRUE)|(BlockProp.m_AdjustRoad_Selected==TRUE))
			pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible

		if (BlockProp.m_bool_c_shading)
		{
			pDoc->PrepareModifyTrk(refblock);  //Backup data for undo
			pDoc->PrepareModifyPoly(sel->refblock);
			for (i=0;i<4;i++) pDoc->PrepareModifyXobj(4*refblock+i);

			pDoc->SetRoadVertexShading(refblock, refblock, 0xFFFFFFFF);
			pDoc->SetXObjVertexShading(refblock, refblock, 0xFFFFFFFF);
		}


		if (BlockProp.m_AdjustRoad_Selected) //Adjust Road Width selected?
		{
			pDoc->settings.AdjustRoad_AdjustType = BlockProp.m_AdjustRoad_AdjustType;
			pDoc->settings.AdjustRoad_Check_VR = BlockProp.m_AdjustRoad_Check_VR;
		    pDoc->settings.AdjustRoad_Check_Man_Set_Num_Lanes = BlockProp.m_AdjustRoad_Check_Man_Set_Num_Lanes;

			pDoc->settings.AdjustRoad_Check_Change_VR_Width = BlockProp.m_AdjustRoad_Check_Change_VR_Width;
			pDoc->settings.AdjustRoad_Check_Detect_lanes = BlockProp.m_AdjustRoad_Check_Detect_lanes;
			pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Bitcoded = BlockProp.m_AdjustRoad_Check_Auto_Set_Lane_Bitcoded;
			pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Polys = BlockProp.m_AdjustRoad_Check_Auto_Set_Lane_Polys;
			pDoc->settings.AdjustRoad_Check_Auto_Set_Lane_Width = BlockProp.m_AdjustRoad_Check_Auto_Set_Lane_Width;

			//pDoc->settings.AdjustRoad_Size = BlockProp.m_AdjustRoad_Size;
			/*pDoc->settings.AdjustRoad_Size[0]=BlockProp.m_AdjustRoad_Size[0];
			pDoc->settings.AdjustRoad_Size[1]=BlockProp.m_AdjustRoad_Size[1];
			pDoc->settings.AdjustRoad_Size[2]=BlockProp.m_AdjustRoad_Size[2];
			pDoc->settings.AdjustRoad_Size[3]=BlockProp.m_AdjustRoad_Size[3];*/
			for(i=0;i<4;i++)
				Size[i]=(float) BlockProp.m_AdjustRoad_Size[i];

			if (BlockProp.m_AdjustRoad_Check_Change_VR_Width && (BlockProp.m_AdjustRoad_AdjustType==3)) //Manual VRoad Size choosen
			{
				pDoc->settings.AdjustRoad_Size[0] = BlockProp.m_AdjustRoad_Size[0];
				pDoc->settings.AdjustRoad_Size[1] = BlockProp.m_AdjustRoad_Size[1];
			}
			else
			{
				Size[0]=-1;Size[0]=-1;
			}
			if (BlockProp.m_AdjustRoad_Check_Man_Set_Num_Lanes) //Manual setting of nLanes choosen
			{
				pDoc->settings.AdjustRoad_Size[2] = BlockProp.m_AdjustRoad_Size[2];
				pDoc->settings.AdjustRoad_Size[3] = BlockProp.m_AdjustRoad_Size[3];
			}
			else
			{
				Size[2]=-1;Size[3]=-1;
			}
			if (!BlockProp.m_AdjustRoad_Check_Change_VR_Width) //Change VR Width disabled
				BlockProp.m_AdjustRoad_AdjustType=-1;

			if (BlockProp.m_AdjustRoad_Check_Change_VR_Width|BlockProp.m_AdjustRoad_Check_Man_Set_Num_Lanes)
				pDoc->AdjustRoadWidth (BlockProp.m_AdjustRoad_AdjustType, refblock , refblock, Size, BlockProp.m_AdjustRoad_Check_Man_Set_Num_Lanes);

			if (BlockProp.m_AdjustRoad_Check_Detect_lanes)
			{
				struct TRKBLOCK *t;
				t=&(pDoc->trk[refblock]);
				for (i=t->nStartPos; i < t->nStartPos + t->nPositions; i++)
					pDoc->VRoadLanesRecalc(i, BlockProp.m_AdjustRoad_Check_Auto_Set_Lane_Bitcoded, BlockProp.m_AdjustRoad_Check_Auto_Set_Lane_Polys, BlockProp.m_AdjustRoad_Check_Auto_Set_Lane_Width);

			}
			InvalidateRect(NULL,FALSE);
		}

	}


	if ((selMode==ID_MODE_OBJECT)&&(isxobj==0)&&(objno>-1)) // Poly Object
	{
		CPolyProperties PProp;
		//struct OBJPOLYBLOCK *o;
		
		PProp.m_intBlock=refblock;
		PProp.m_int_Chunk=sel->refchunk;
		PProp.m_int_ObjNum=sel->objno;
		num=pDoc->poly[sel->refblock].obj[sel->refchunk].numpoly[sel->objno];
		PProp.m_intNumPoly=num;
		PProp.m_bPolyPropsAutoObjMem=pDoc->bAutoObjMem;
		//p=pDoc->poly[refblock].obj[sel->refchunk].poly[sel->objno];

		if (PProp.DoModal()!=IDOK) {pDoc->bAutoObjMem=bAutoObjMemOld;return;}

		if (PProp.m_bool_convert) //Convert polygon object to extra object
		{
			pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
			pDoc->CreateObjectData(&NewObjData,refblock,isxobj,refchunk,objno,FALSE); //Get Object Data.
			pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno); //Calculate middle of old object
			pDoc->DelObject(refblock,isxobj,refchunk,objno); //delete old object.
			refblock=PProp.m_intBlock; //Set new block
			refchunk=PProp.m_int_Chunk; //Set new chunk
			isxobj=1; //New object will be an extra object
			pDoc->NewObject(refblock,isxobj,refchunk,0,-32768,4); //Base object for import
			objno=pDoc->xobj[4*refblock+refchunk].nobj-1; //Get objno of new created object
			x=&pDoc->xobj[4*refblock+refchunk].obj[objno]; //Set pointer x to new xobj
			pDoc->MoveObjectBy(refblock,isxobj,refchunk,objno,(pDoc->MemObjMiddle.x - x->ptRef.x),(pDoc->MemObjMiddle.y - x->ptRef.y),(pDoc->MemObjMiddle.z - x->ptRef.z));//Move new object center to old center position
			pDoc->ImportObject(&NewObjData,refblock,isxobj,refchunk,objno,TRUE); // Import Object from strored data
			pDoc->DelPolygon(refblock,isxobj,refchunk,objno,0); //Delete first given polygon
			dofree(NewObjData.Vertices); //Give back memory
			dofree(NewObjData.vertshade);
			dofree(NewObjData.Polys);
			//objno=pDoc->xobj[4*refblock+refchunk].nobj-1; //Get objno of new created object
			pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
			refnode=&pDoc->MemObjMiddle; //Setview to new object center
			InvalidateRect(NULL,TRUE);
			pDoc->RecalcBoundingBox(refblock);
			{pDoc->bAutoObjMem=bAutoObjMemOld;return;} //No more work to do.
		}

		if ((PProp.m_intBlock!=refblock)|(PProp.m_int_Chunk!=refchunk))
		{
			pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
			if (PProp.m_intBlock!=refblock) //Move PolyObject to new block if changed
			{
				pDoc->ChangeObjBlock(refblock, isxobj, refchunk, objno,PProp.m_intBlock);
				refblock=PProp.m_intBlock;
				objno=pDoc->poly[refblock].obj[refchunk].nobj-1;
			}
			if (PProp.m_int_Chunk!=refchunk) //Move PolyObject to new block if changed
			{
				pDoc->CreateObjectData(&NewObjData,refblock,isxobj,refchunk,objno,FALSE); //Get Object Data.
				pDoc->DelObject(refblock,isxobj,refchunk,objno); //delete old object.
				refchunk=PProp.m_int_Chunk; //Set new chunk
				pDoc->NewObject(refblock,isxobj,refchunk,0,-32768,4); //Base object for import
				objno=pDoc->poly[refblock].obj[refchunk].nobj-1; //Get num of new created object
				pDoc->ImportObject(&NewObjData,sel->refblock,sel->isxobj,sel->refchunk,sel->objno,TRUE); // Import Object from strored data in new chunk
				pDoc->DelPolygon(refblock,isxobj,refchunk,objno,0); //Delete first given polygon
				dofree(NewObjData.Vertices); //Give back memory
				dofree(NewObjData.vertshade);
				dofree(NewObjData.Polys);
			}
			pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
			refnode=&pDoc->MemObjMiddle; //Setview to object center
			InvalidateRect(NULL,TRUE);
		}
	}

	if ((selMode==ID_MODE_OBJECT)&&(isxobj==1)&&(objno>-1)) // Properties for Extra / Global Object
	{
		
		CExtraObjProps EObjProp;
		x=&pDoc->xobj[4*sel->refblock+sel->refchunk].obj[sel->objno];
		
		EObjProp.m_int_Block=refblock;
		EObjProp.m_bool_IsGlobal=FALSE;
		if (pDoc->nBlocks==refblock) EObjProp.m_bool_IsGlobal=TRUE;
		
		EObjProp.m_int_Chunk=sel->refchunk;
		EObjProp.m_int_ObjNum=sel->objno;
		//num=pDoc->xobj[sel->refblock*4+sel->refchunk].obj[sel->objno].nPolygons;
		EObjProp.m_int_NumPoly=pDoc->xobj[sel->refblock*4+sel->refchunk].obj[sel->objno].nPolygons;
		EObjProp.m_bExtraObjPropsAutoObjMem=pDoc->bAutoObjMem;
		EObjProp.m_long_Crosstype=x->crosstype;
		EObjProp.m_long_unknown=x->unknown;
		EObjProp.m_long_AnimMemory=x->AnimMemory;
		EObjProp.m_short_AnimDelay=x->AnimDelay;
		EObjProp.m_float_x=x->ptRef.x;
		EObjProp.m_float_y=x->ptRef.y;
		EObjProp.m_float_z=x->ptRef.z;
		EObjProp.m_nVertices=x->nVertices;
		EObjProp.m_shading=(struct BGRA *)malloc(x->nVertices * sizeof(struct BGRA)); //Create space for shading data
		memcpy(EObjProp.m_shading,x->vertshade,x->nVertices * sizeof(struct BGRA)); //Copy Shading Data

		if (x->crosstype==6)
		{
			EObjProp.m_float_t6x=x->hs_type6.pt.x;
			EObjProp.m_float_t6y=x->hs_type6.pt.y;
			EObjProp.m_float_t6z=x->hs_type6.pt.z;
			EObjProp.m_float_t6mass=x->hs_type6.mass;
			EObjProp.m_float_t6_hitbox_x=x->hs_type6.hitbox_x;
			EObjProp.m_float_t6_hitbox_y=x->hs_type6.hitbox_y;
			EObjProp.m_float_t6_hitbox_z=x->hs_type6.hitbox_z;

			//EObjProp.T6Data=x->hs_type6.Data;
			memcpy(&EObjProp.T6Data,&x->hs_type6.mass,60);
		}

		if (x->crosstype==4) 
		{
			rx=blk.xobj + x->crossno;
			EObjProp.m_short_unknown1=rx->unknown1;
			EObjProp.m_short_unknown2=rx->unknown2;
			EObjProp.m_short_collide_effect=rx->collideeffect;
		}
		else // Create a dummy rx
		{
			rx=(struct REFXOBJ *)malloc(sizeof(struct REFXOBJ));
			memset(rx,0,sizeof(struct REFXOBJ));
		}
		if ((x->crosstype==3)&&(x->nAnimLength>0)) //Animated
		{
			EObjProp.m_nAnimLength=x->nAnimLength;
			EObjProp.m_AnimData=(struct ANIMDATA *)malloc(x->nAnimLength * sizeof(struct ANIMDATA));
			memcpy(EObjProp.m_AnimData,x->animData,x->nAnimLength * sizeof(struct ANIMDATA));
		}
		EObjProp.m_short_unknown3=(short *) malloc(9 * sizeof(short)); //The unknown3 values
		memcpy(EObjProp.m_short_unknown3,x->unknown3,9 * sizeof(short));
		/*
		1 Static Global
		2 Static
		3 Animated
		4 Static, with collision
		5
		6 Complex-behavior (can be knocked over)
		*/

		if (EObjProp.DoModal()!=IDOK) {pDoc->bAutoObjMem=bAutoObjMemOld;return;}

		//Do changes to X object ?
		if ((EObjProp.m_bool_ReCenter==TRUE)|(EObjProp.m_long_Crosstype!=x->crosstype)|(EObjProp.m_int_Block!=refblock)|(EObjProp.m_int_Chunk!=refchunk)|(EObjProp.m_short_unknown1!=rx->unknown1)|(EObjProp.m_short_unknown2!=rx->unknown2)|(EObjProp.m_short_collide_effect!=rx->collideeffect)|(EObjProp.m_long_unknown!=x->unknown)|(EObjProp.m_long_AnimMemory!=x->AnimMemory)|(EObjProp.m_short_AnimDelay!=x->AnimDelay))
			pDoc->PrepareNewUndo(refnode,EObjProp.m_int_Block,offsetx,offsety); //Create a new undo point if needed

		if (x->crosstype!=4) dofree(rx); //Give back memory for dummy rx

		x->unknown=EObjProp.m_long_unknown;
		x->AnimMemory=EObjProp.m_long_AnimMemory;
		x->AnimDelay=EObjProp.m_short_AnimDelay;
		x->nAnimLength=EObjProp.m_nAnimLength;
		memcpy(x->vertshade, EObjProp.m_shading,x->nVertices * sizeof(struct BGRA)); //Copy back shading data
		dofree(EObjProp.m_shading);

		if (x->crosstype==3) //Use new Data on Animated ojbects
		{
			dofree(x->animData);
			x->animData=EObjProp.m_AnimData;
		}
		if (x->crosstype==6)
		{
			x->hs_type6.pt.x=EObjProp.m_float_t6x;
			x->hs_type6.pt.y=EObjProp.m_float_t6y;
			x->hs_type6.pt.z=EObjProp.m_float_t6z;
			memcpy(&x->hs_type6.mass, &EObjProp.T6Data, 60);
			x->hs_type6.mass=EObjProp.m_float_t6mass;
		}
		memcpy(x->unknown3,EObjProp.m_short_unknown3,9 * sizeof(short));
		dofree(EObjProp.m_short_unknown3);


		if (EObjProp.m_bool_Convert_Poly) //Convert extra object to polygon object
		{
			pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
			pDoc->CreateObjectData(&NewObjData,refblock,isxobj,refchunk,objno,FALSE); //Get Object Data.
			pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno); //Calculate middle of old object
			pDoc->DelObject(refblock,isxobj,refchunk,objno); //delete old object.
			refblock=EObjProp.m_int_Block; //Set new block
			refchunk=EObjProp.m_int_Chunk; //Set new chunk
			isxobj=0; //New object will be an extra object
			pDoc->NewObject(refblock,isxobj,refchunk,0,-32768,4); //Base object for import
			objno=pDoc->poly[refblock].obj[refchunk].nobj-1;
			pDoc->ImportObject(&NewObjData,refblock,isxobj,refchunk,objno,TRUE); // Import Object from strored data
			pDoc->DelPolygon(refblock,isxobj,refchunk,objno,0); //Delete first given polygon
			dofree(NewObjData.Vertices); //Give back memory
			dofree(NewObjData.vertshade);
			dofree(NewObjData.Polys);
			refnode=pDoc->trk[refblock].vert+
				pDoc->poly[refblock].obj[refchunk].poly[objno]->vertex[0];
			pDoc->RecalcBoundingBox(refblock);
			{pDoc->bAutoObjMem=bAutoObjMemOld;return;} //No more work to do.
		}

		if ((EObjProp.m_bool_Convert_Global==TRUE)&&!(refblock==pDoc->nBlocks)&&(EObjProp.m_long_Crosstype!=3)) //Prepare Extra Object to global conversion
		{
			if (x->crosstype==4) EObjProp.m_long_Crosstype=2; //Set crosstype to 2 if extra object with collision should be converted into a global object
			if (x->crosstype==6) //Type 6 move into global chunk 1
			{
				FLOATPT hitbox;
				EObjProp.m_int_Chunk=1;
				//Recalc T6 Middle and Hitbox
				pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
				hitbox.x=(pDoc->MemObjMax.x - pDoc->MemObjMin.x) / 2;
				hitbox.y=(pDoc->MemObjMax.y - pDoc->MemObjMin.y) / 2;
				hitbox.z=(pDoc->MemObjMax.z - pDoc->MemObjMin.z) / 2;
				x->hs_type6.pt.x=pDoc->MemObjMiddle.x;
				x->hs_type6.pt.y=pDoc->MemObjMiddle.y;
				x->hs_type6.pt.z=pDoc->MemObjMiddle.z;
				x->hs_type6.hitbox_x=hitbox.x;
				x->hs_type6.hitbox_y=hitbox.y;
				x->hs_type6.hitbox_z=hitbox.z;
			}
			else	//Other objects to chunk 0
				EObjProp.m_int_Chunk=0; //Set chunk to 0 if extra object should be converted into a global object


		}

		if (EObjProp.m_long_Crosstype!=x->crosstype)
		{
			oblock=refblock; //Store reference obj data
			oisxobj=isxobj;
			orefchunk=refchunk;
			oobjno=objno;
			refblock=EObjProp.m_int_Block; // New obj block
			refchunk=EObjProp.m_int_Chunk; // New obj chunk
			pDoc->CreateObjectData(&NewObjData,oblock,oisxobj,orefchunk,oobjno,FALSE); //Store polygon and texture data of object
			pDoc->NewObject(refblock,isxobj,refchunk,0,-32768,EObjProp.m_long_Crosstype); //Base object for import
			objno=pDoc->xobj[4*refblock+refchunk].nobj-1; //Get objno of new created object
			x=&pDoc->xobj[4*refblock+refchunk].obj[objno]; //Set pointer x to new xobj
			ox=&pDoc->xobj[4*oblock+orefchunk].obj[oobjno]; //ox is the old xobj
			pDoc->MoveObjectBy(refblock,isxobj,refchunk,objno,(ox->ptRef.x - x->ptRef.x),(ox->ptRef.y - x->ptRef.y),(ox->ptRef.z - x->ptRef.z));//Move new object center to old center position
			pDoc->ImportObject(&NewObjData,refblock,isxobj,refchunk,objno,TRUE); // Import Object from strored data
			pDoc->DelPolygon(refblock,isxobj,refchunk,objno,0); //Delete first given polygon
			dofree(NewObjData.Vertices); //Give back memory
			dofree(NewObjData.vertshade);
			dofree(NewObjData.Polys);
			if (x->crosstype==3)
			{
				x->AnimMemory=EObjProp.m_long_AnimMemory;
				x->AnimDelay=EObjProp.m_short_AnimDelay;
			}
			pDoc->DelObject(oblock,oisxobj,orefchunk,oobjno); //delete old object.
			objno=pDoc->xobj[4*refblock+refchunk].nobj-1; //Maybe objno has changed, but it's still the last object in chunk
			pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
			refnode=&pDoc->MemObjMiddle; //Setview to new object center
			InvalidateRect(NULL,TRUE);
		}

		if ((EObjProp.m_int_Block!=refblock)|(EObjProp.m_int_Chunk!=refchunk))
		{
			pDoc->CopyObjectTo(refblock, isxobj, refchunk, objno, EObjProp.m_int_Block,EObjProp.m_int_Chunk);
			pDoc->DelObject(refblock, isxobj, refchunk, objno);
			refblock=EObjProp.m_int_Block;
			refchunk=EObjProp.m_int_Chunk;
			objno=pDoc->xobj[4*refblock+refchunk].nobj-1;
			pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
			refnode=&pDoc->MemObjMiddle; //Setview to new object center
			InvalidateRect(NULL,TRUE);
		}

		if (EObjProp.m_bool_Convert_Global==TRUE) //Convert Global <-> Extra Objects
		{
			if (refblock==pDoc->nBlocks) //Convert global to extra object
			{
				x=&pDoc->xobj[4*refblock+refchunk].obj[objno];
				pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno); //Calculate Center of object
				blk=pDoc->trk[0];
				dist0=(float)(sqrt((pDoc->MemObjMiddle.x - blk.ptCentre.x)*(pDoc->MemObjMiddle.x - blk.ptCentre.x)+
								   (pDoc->MemObjMiddle.y - blk.ptCentre.y)*(pDoc->MemObjMiddle.y - blk.ptCentre.y)+
	  							   (pDoc->MemObjMiddle.z - blk.ptCentre.z)*(pDoc->MemObjMiddle.z - blk.ptCentre.z)));
				  num=0;
				for (i=0;i<pDoc->nBlocks;i++) {
					blk=pDoc->trk[i];
					dist= (float)(sqrt((pDoc->MemObjMiddle.x - blk.ptCentre.x)*(pDoc->MemObjMiddle.x - blk.ptCentre.x)+
								       (pDoc->MemObjMiddle.y - blk.ptCentre.y)*(pDoc->MemObjMiddle.y - blk.ptCentre.y)+
	  							       (pDoc->MemObjMiddle.z - blk.ptCentre.z)*(pDoc->MemObjMiddle.z - blk.ptCentre.z)));
					if (dist<dist0) { num=i; dist0=dist; }
				}

				if (x->crosstype==1)
				{
					x->crosstype=2; //No Crosstype 1 on extra objects...
					EObjProp.m_bool_ReCenter=TRUE; //Recenter the new XOBJ
				}
				pDoc->ChangeObjBlock(refblock,isxobj,refchunk,objno,num); //Create XOBJ on block 0
				refblock=num;
				objno=pDoc->xobj[4*refblock+refchunk].nobj-1;
				pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
				refnode=&pDoc->MemObjMiddle; //Setview to new object center
				InvalidateRect(NULL,TRUE);
			}
			else //Convert extra to global object
			{
				pDoc->ChangeObjBlock(refblock,isxobj,refchunk,objno,pDoc->nBlocks, EObjProp.m_int_Chunk); //Create XOBJ on last block +1
				refblock=pDoc->nBlocks;
				refchunk=EObjProp.m_int_Chunk;
				objno=pDoc->xobj[4*refblock+refchunk].nobj-1;
				x=&pDoc->xobj[4*refblock+refchunk].obj[objno];

				if (x->crosstype==2) //No Crosstype 2 on global objects..
				{
					pDoc->ChangeXobjRefpoint(refblock, isxobj, refchunk, objno, 0, 0, 0);
					x->crosstype=1;
					/*v=x->vert;
					for (k=0;k<x->nVertices;k++)
					{
						v[k].x-=dx;
						v[k].y-=dy;
						v[k].z-=dz;
					}*/

				}
				pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
				refnode=&pDoc->MemObjMiddle; //Setview to new object center
				InvalidateRect(NULL,TRUE);
			}

		}

		blk=pDoc->trk[refblock];
		x=&pDoc->xobj[4*refblock+refchunk].obj[objno]; //Set pointer again if object has changed
		if (x->crosstype==4)
		{
			pDoc->PrepareModifyXobj(4*refblock+refchunk);
			rx=blk.xobj + x->crossno;
			if (EObjProp.m_short_unknown1!=rx->unknown1) (rx->unknown1=EObjProp.m_short_unknown1);
			if (EObjProp.m_short_unknown2!=rx->unknown2) (rx->unknown2=EObjProp.m_short_unknown2);
			if (EObjProp.m_short_collide_effect!=rx->collideeffect) (rx->collideeffect=(char) EObjProp.m_short_collide_effect);
		}
		if (EObjProp.m_bool_ReCenter==TRUE) //ReCenter Object
		{
			pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
			if (EObjProp.m_int_ReCenter==1) pDoc->ChangeXobjRefpoint(refblock, isxobj, refchunk, objno, pDoc->MemObjMiddle.x,pDoc->MemObjMiddle.y,pDoc->MemObjMax.z);
			if (EObjProp.m_int_ReCenter==2) pDoc->ChangeXobjRefpoint(refblock, isxobj, refchunk, objno, pDoc->MemObjMiddle.x,pDoc->MemObjMiddle.y,pDoc->MemObjMiddle.z);
			if (EObjProp.m_int_ReCenter==3) pDoc->ChangeXobjRefpoint(refblock, isxobj, refchunk, objno, pDoc->MemObjMiddle.x,pDoc->MemObjMiddle.y,pDoc->MemObjMin.z);
			if (EObjProp.m_int_ReCenter==4) pDoc->ChangeXobjRefpoint(refblock, isxobj, refchunk, objno, EObjProp.m_float_x, EObjProp.m_float_y, EObjProp.m_float_z);
			refnode=&pDoc->MemObjMiddle; //Setview to new object center
			InvalidateRect(NULL,TRUE);
		}

	}

	if ((selMode==ID_MODE_OBJECT)&&(objno>-1)&&((isxobj==2)||(isxobj==3))) // Light/special effect or sound object
	{
		CSoundLightProps ts;
		struct LIGHTDATA *ALLLData, LData;
	
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		pDoc->PrepareModifyTrk(refblock);
		ts.bAddMode=FALSE;

		if (isxobj==3) 
		{	
			ts.bIsLight=false;
			ts.m_Byte1=blk.soundsrc[objno].type[0];
			ts.m_Byte2=blk.soundsrc[objno].type[1];
			ts.m_Byte3=blk.soundsrc[objno].type[2];
			ts.m_Byte4=blk.soundsrc[objno].type[3];
			ts.m_float_posx=(float) blk.soundsrc[objno].refpoint.x/65536;
			ts.m_float_posy=(float) blk.soundsrc[objno].refpoint.y/65536;
			ts.m_float_posz=(float) blk.soundsrc[objno].refpoint.z/65536;
			ts.m_strText1="Set sound source data here. Right field shows value in Hexadecimal system.";
		}

		if (isxobj==2) 
		{
			//Collect All track glows
			int nLights=0;
			memset(&LData, 0, sizeof(LIGHTDATA)); //Clear all
			do
			{
				LData=pDoc->GetLightData(nLights);
				if (LData.intensity > -1)
				{
					if (nLights==0)
						ALLLData=(struct LIGHTDATA *)malloc(sizeof(struct LIGHTDATA));
					else
						ALLLData=(struct LIGHTDATA *)realloc(ALLLData, sizeof(struct LIGHTDATA)*(1+nLights));

					memcpy(&ALLLData[nLights], &LData, sizeof(struct LIGHTDATA));
					nLights++;
				}
			} while (LData.intensity > -1);

			ts.bIsLight=true;
			ts.AllLightsData=ALLLData;
			ts.nLights=nLights;
			ts.m_Byte1=blk.lightsrc[objno].type[0];
			ts.m_Byte2=blk.lightsrc[objno].type[1];
			ts.m_Byte3=blk.lightsrc[objno].type[2];
			ts.m_Byte4=blk.lightsrc[objno].type[3];
			ts.m_float_posx=(float) blk.lightsrc[objno].refpoint.x/65536;
			ts.m_float_posy=(float) blk.lightsrc[objno].refpoint.y/65536;
			ts.m_float_posz=(float) blk.lightsrc[objno].refpoint.z/65536;
			ts.m_strText1="Set light/special effect source data here. Numbers from 0 to 31 are usually lights, that can be seleted by the combobox. Look at Tr(N).ini, [track glows] section. Higher numbers are special effects.";
			ts.m_float_light_multi=pDoc->settings.ray_m_float_light_multi;
		}

		keke.Format("%X",ts.m_Byte1); //Show HEX values
		ts.m_Byte1hex=keke;
		ts.m_intBlock=refblock;
		ts.bSLAutoObjMem=pDoc->bAutoObjMem;
		ts.maxblock=(pDoc->nBlocks-1);

		if (ts.DoModal()!=IDOK) {pDoc->bAutoObjMem=bAutoObjMemOld;return;}
	
		if (isxobj==3)
		{
			pDoc->trk[refblock].soundsrc[objno].type[0]=ts.m_Byte1;
			pDoc->trk[refblock].soundsrc[objno].type[1]=ts.m_Byte2;
			pDoc->trk[refblock].soundsrc[objno].type[2]=ts.m_Byte3;
			pDoc->trk[refblock].soundsrc[objno].type[3]=ts.m_Byte4;
			pDoc->trk[refblock].soundsrc[objno].refpoint.x=(long) (ts.m_float_posx * 65536);
			pDoc->trk[refblock].soundsrc[objno].refpoint.y=(long) (ts.m_float_posy * 65536);
			pDoc->trk[refblock].soundsrc[objno].refpoint.z=(long) (ts.m_float_posz * 65536);
		}
		if (isxobj==2)
		{
			pDoc->trk[refblock].lightsrc[objno].type[0]=ts.m_Byte1;
			pDoc->trk[refblock].lightsrc[objno].type[1]=ts.m_Byte2;
			pDoc->trk[refblock].lightsrc[objno].type[2]=ts.m_Byte3;
			pDoc->trk[refblock].lightsrc[objno].type[3]=ts.m_Byte4;
			pDoc->trk[refblock].lightsrc[objno].refpoint.x=(long) (ts.m_float_posx * 65536);
			pDoc->trk[refblock].lightsrc[objno].refpoint.y=(long) (ts.m_float_posy * 65536);
			pDoc->trk[refblock].lightsrc[objno].refpoint.z=(long) (ts.m_float_posz * 65536);
			pDoc->settings.ray_m_float_light_multi=ts.m_float_light_multi;
			dofree(ALLLData);
			if (ts.bTraceLight) pDoc->RayTraceLight(refblock, objno, pDoc->settings.ray_m_float_light_multi);
		}
		if (ts.m_intBlock!=refblock)
			{
			pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
			pDoc->ChangeObjBlock(refblock, isxobj, refchunk, objno,ts.m_intBlock);
			sel=NULL;
			refblock=ts.m_intBlock;
			refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
			}
	}
	pDoc->bAutoObjMem=bAutoObjMemOld;
	
	UpdateRefBlock(); //Maybe block has changed, show it.
	InvalidateRect(NULL,TRUE);
}


void CT3EDView::OnCopyMode() 
{
	// TODO: Add your command handler code here
	CT3EDDoc *pDoc=GetDocument();
	if (pDoc->ZCopyMode==1)
	{
		pDoc->ZCopyMode=2;
		statusbar->SetPaneText(4,"Shader (z)", TRUE);
	}
	else if (pDoc->ZCopyMode==2)
	{
		pDoc->ZCopyMode=3;
		statusbar->SetPaneText(4,"Average (z)", TRUE);
	}
	else if (pDoc->ZCopyMode==3)
	{
		pDoc->ZCopyMode=4;
		statusbar->SetPaneText(4,"Line (x,y)", TRUE);
	}
	else if (pDoc->ZCopyMode==4)
	{
		pDoc->ZCopyMode=5;
		statusbar->SetPaneText(4,"Line (x,y,z)", TRUE);
	}

	else
	{
		pDoc->ZCopyMode=1;
		statusbar->SetPaneText(4,"Normal (z)", TRUE);
	}

}

void CT3EDView::OnViewEditblock() 
{
	BlkHighlight=!BlkHighlight;
}

void CT3EDView::OnUpdateViewEditblock(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(BlkHighlight&&!isEmpty);
	InvalidateRect(NULL,TRUE);
	
}

void CT3EDView::OnViewPolyflag() 
{
	// TODO: Add your command handler code here
	DrawFlags=!DrawFlags;
}

void CT3EDView::OnUpdateViewPolyflag(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(DrawFlags&&!isEmpty);
	InvalidateRect(NULL,TRUE);	
}

void CT3EDView::OnToolsLodgen() 
{
	// TODO: Add your command handler code here
	CT3EDDoc *pDoc=GetDocument();
	int dippa;
	int startbl, endbl, maxbl;

	CLodStartEnd LodStartEnd;
	maxbl=pDoc->nBlocks;
	LodStartEnd.m_iLodStart=0;
	LodStartEnd.m_iLodEnd=maxbl;
	if (!(LodStartEnd.DoModal () == IDOK)) return; //Cancel pressed
	
	startbl = LodStartEnd.m_iLodStart;
	endbl = LodStartEnd.m_iLodEnd;
	if (endbl>maxbl)
		endbl=maxbl;
	if (startbl>endbl)
		startbl=endbl;

	CWaitCursor WCursur; //Show wait cursor

	CString keke;
	CLodGenProgress *ProgresWin;
	//ProgresWin.EnableWindow();
	//ProgresWin.m_okbutton.EnableWindow();
	ProgresWin = new CLodGenProgress;
	//qfsloadbox->m_progress.SetRange(0,nQfsEntries);
	ProgresWin->Create(IDD_LOD_GENERATION, NULL);
	ProgresWin->ShowWindow(TRUE);
	ProgresWin->UpdateData(FALSE);
	ProgresWin->m_lodprogress.SetRange(startbl,endbl);

	for (dippa=startbl;dippa<endbl;dippa++)
	{
		ProgresWin->m_lodprogress.SetPos(dippa);
		
		keke.Format("Genererating meshes... Block %d (%d of %d Blocks) Med" ,dippa, dippa-startbl, endbl-startbl);
		ProgresWin->SetWindowText(keke);
		keke=pDoc->MedDetailFixer(dippa, 1);
		
		keke.Format("Genererating meshes... Block %d (%d of %d Blocks) Low" ,dippa,dippa-startbl, endbl-startbl);
		ProgresWin->SetWindowText(keke);
		keke=pDoc->MedDetailFixer(dippa, 2);
		
		keke.Format("Genererating meshes... Block %d (%d of %d Blocks) Sort" ,dippa,dippa-startbl, endbl-startbl);
		ProgresWin->SetWindowText(keke);
		keke=pDoc->VertArrayFixer(dippa);
		//keke.Format("Please wait while genererating meshes... (%d of %d Blocks)",dippa, pDoc->nBlocks);
		//ProgresWin.m_progress=keke;
	}
	MessageBox("LOD genereration finished !");

	delete ProgresWin;
}

void CT3EDView::OnVirtualroadmask() 
{
	
	// TODO: Add your command handler code here
	DrawVRE=DrawVRB;	
	DrawVRB=!DrawVRB;
	
}

void CT3EDView::OnVirtualroadedgemask() 
{
	DrawVRE=DrawVRB;	
	DrawVRB=!DrawVRB;
	// TODO: Add your command handler code here
	
}

void CT3EDView::OnUpdateVirtualroadmask(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(DrawVRB&&!isEmpty);
	InvalidateRect(NULL,TRUE);	
	
}

void CT3EDView::OnUpdateVirtualroadedgemask(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(DrawVRE&&!isEmpty);
	InvalidateRect(NULL,TRUE);	
}

void CT3EDView::OnNonpassablepolygonmask() 
{
	// TODO: Add your command handler code here
	DrawNonPass=!DrawNonPass;
	
}

void CT3EDView::OnUpdateNonpassablepolygonmask(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(DrawNonPass&&!isEmpty);
	InvalidateRect(NULL,TRUE);		
}

void CT3EDView::OnModeVroadedit() 
{
	//DrawVRoadBitMap=FALSE;
	DrawVRoad=TRUE;
	if (isDragging) return; // safety
	CleanCursorZone(selMode,FALSE);
	//selMode=ID_MODE_VROADEDIT;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	isTruePoint=FALSE; refpoly=NULL;
	editMode=NULL;
	selMode=ID_MODE_VROADEDIT;
	CleanCursorZone(selMode,TRUE);
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnUpdateModeVroadedit(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((selMode==ID_MODE_VROADEDIT));	

}

void CT3EDView::OnExportTexture() 
{
	// TODO: Add your command handler code here
		//MessageBox("alussa");
	CT3EDDoc *pDoc=GetDocument();
	int i,j,k,l,num,t;
	int truedx,truedy;
	LPPOLYGONDATA p;
	struct FLOATPT *v;
	struct OBJPOLYBLOCK *o;
	struct XOBJDATA *x;
	//struct LIGHTSRC *light;
	//struct SOUNDSRC *sound;
	FILE* fout;
	//MessageBox("dokumentti saatu");

	fout = fopen("c:/Textures.txt", "w");
		//MessageBox("Tiedosto auki.");
		fprintf(fout, "%f\n", 3.0);
		//fprintf(fout, "%d\n", pDoc->nBlocks);
		
		fprintf(fout, "LOW\n");
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			p=pDoc->poly[i].poly[0];
			num=pDoc->poly[i].sz[0];
			for (j=0;j<num;j++,p++) {
				//p->texture
				fprintf(fout, "%d\n", p->texture);
				/*
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]])); */
			}
		}
		fprintf(fout, "MEDIUM\n");
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			p=pDoc->poly[i].poly[2];
			num=pDoc->poly[i].sz[2];
			for (j=0;j<num;j++,p++) {
				fprintf(fout, "%d\n", p->texture);
				//p->texture
				/*
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]])); */
			}
		}
		fprintf(fout, "HIGH\n");
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			p=pDoc->poly[i].poly[4];
			num=pDoc->poly[i].sz[4];
			for (j=0;j<num;j++,p++) {
				fprintf(fout, "%d\n", p->texture);
				if (p->unknown2!=249)
					t=p->unknown2;

				//p->texture
				/*
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]])); */
			}
		}
		
		fprintf(fout, "LANES\n");
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			for (k=1;k<6;k=k+2) {
				p=pDoc->poly[i].poly[k];
				num=pDoc->poly[i].sz[k];
				for (j=0;j<num;j++,p++) {
					fprintf(fout, "%d\n", p->texture);
					/*pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
					pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
					pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
					pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));*/
				}
			}
		}
		fprintf(fout, "OBJS\n");
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			for (j=0;j<4;j++) {
				o=&(pDoc->poly[i].obj[j]);
				if (o->n1==0) continue;
				for (k=0;k<o->nobj;k++) {
					p=o->poly[k];
					num=o->numpoly[k];
					for (l=0;l<num;l++,p++) {
						fprintf(fout, "%d\n", p->texture);
						if (p->unknown2!=249)
							t=p->unknown2;
						/*pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
						pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
						pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
						pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
						pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));*/
					}
				}
			}
		}
		fprintf(fout, "XOBJS\n");
		truedx=dxoffs; truedy=dyoffs;
		for (i=0;i<4*pDoc->nBlocks;i++) {
			
			x=pDoc->xobj[i].obj;
			for (j=0;j<pDoc->xobj[i].nobj;j++,x++) {
				dxoffs=FloatX(x->ptRef); dyoffs=FloatY(x->ptRef);
				v=x->vert;
				p=x->polyData;
				for (k=0;k<x->nPolygons;k++,p++) {
					fprintf(fout, "%d\n", p->texture);
					/*pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
					pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
					pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
					pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));*/
				}
				dxoffs=truedx; dyoffs=truedy;
			}
		}

//***************************************************************************
	fclose(fout);
	MessageBox("Texture Data exportted.");	
	
}

void CT3EDView::OnImportTexture() 
{
	// TODO: Add your command handler code here

CT3EDDoc *pDoc=GetDocument();
	int i,j,k,l,num;
	int truedx,truedy;
	LPPOLYGONDATA p;
	struct FLOATPT *v;
	struct OBJPOLYBLOCK *o;
	struct XOBJDATA *x;
	//struct LIGHTSRC *light;
	//struct SOUNDSRC *sound;
	FILE* fout;
	char input[10];
	//MessageBox("dokumentti saatu");

	fout = fopen("c:/Textures.txt", "r");
		//MessageBox("Tiedosto auki.");
		fscanf(fout, "%s\n", &input);
		//fprintf(fout, "%d\n", pDoc->nBlocks);
		fscanf(fout, "%s\n", &input);
		
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			p=pDoc->poly[i].poly[0];
			num=pDoc->poly[i].sz[0];
			for (j=0;j<num;j++,p++) {
				//p->texture
				fscanf(fout, "%hd\n", &p->texture);
				/*
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]])); */
			}
		}
		fscanf(fout, "%s\n", &input);
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			p=pDoc->poly[i].poly[2];
			num=pDoc->poly[i].sz[2];
			for (j=0;j<num;j++,p++) {
				fscanf(fout, "%hd\n", &p->texture);
				//p->texture
				/*
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]])); */
			}
		}
		fscanf(fout, "%s\n", &input);
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			p=pDoc->poly[i].poly[4];
			num=pDoc->poly[i].sz[4];
			for (j=0;j<num;j++,p++) {
				fscanf(fout, "%hd\n", &p->texture);
				//p->texture
				/*
				pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
				pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
				pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
				pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
				pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]])); */
			}
		}
		
		fscanf(fout, "%s\n", &input);
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			for (k=1;k<6;k=k+2) {
				p=pDoc->poly[i].poly[k];
				num=pDoc->poly[i].sz[k];
				for (j=0;j<num;j++,p++) {
					fscanf(fout, "%hd\n", &p->texture);
					/*pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
					pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
					pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
					pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));*/
				}
			}
		}
		fscanf(fout, "%s\n", &input);
		for (i=0;i<pDoc->nBlocks;i++) {
			v=pDoc->trk[i].vert;
			for (j=0;j<4;j++) {
				o=&(pDoc->poly[i].obj[j]);
				if (o->n1==0) continue;
				for (k=0;k<o->nobj;k++) {
					p=o->poly[k];
					num=o->numpoly[k];
					for (l=0;l<num;l++,p++) {
						fscanf(fout, "%hd\n", &p->texture);
						/*pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
						pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
						pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
						pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
						pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));*/
					}
				}
			}
		}
		fscanf(fout, "%s\n", &input);
		truedx=dxoffs; truedy=dyoffs;
		for (i=0;i<4*pDoc->nBlocks;i++) {
			
			x=pDoc->xobj[i].obj;
			for (j=0;j<pDoc->xobj[i].nobj;j++,x++) {
				dxoffs=FloatX(x->ptRef); dyoffs=FloatY(x->ptRef);
				v=x->vert;
				p=x->polyData;
				for (k=0;k<x->nPolygons;k++,p++) {
					fscanf(fout, "%hd\n", &p->texture);
					/*pDC->MoveTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));
					pDC->LineTo(FloatX(v[p->vertex[1]]),FloatY(v[p->vertex[1]]));
					pDC->LineTo(FloatX(v[p->vertex[2]]),FloatY(v[p->vertex[2]]));
					pDC->LineTo(FloatX(v[p->vertex[3]]),FloatY(v[p->vertex[3]]));
					pDC->LineTo(FloatX(v[p->vertex[0]]),FloatY(v[p->vertex[0]]));*/
				}
				dxoffs=truedx; dyoffs=truedy;
			}
		}

//***************************************************************************
	fclose(fout);
	MessageBox("Texture Data Imported Successfully.");	
}

void CT3EDView::OnVirroadbitmap() 
{
	// TODO: Add your command handler code here
	DrawVRoadBitMap=!DrawVRoadBitMap;
}

void CT3EDView::OnUpdateVirroadbitmap(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(DrawVRoadBitMap&&!isEmpty);
	InvalidateRect(NULL,TRUE);
}

BOOL CT3EDView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
	//Zoom In/Out using Mouse Wheel 
	if (!(GetAsyncKeyState(VK_MENU) & 0x8000)) 
	{
		if (zDelta>0)
			OnViewZoomin();
		if (zDelta<0)
			OnViewZoomout();
	}
	else //ALT pressed, Zoom 3D View only
	{
		if (zDelta>0)
			OnViewZoomin3d();
		if (zDelta<0)
			OnViewZoomout3d();
	}

	return CView::OnMouseWheel(nFlags, zDelta, pt);
}

void CT3EDView::OnToolsShadowraytracer() 
{
	// TODO: Add your command handler code here
	CT3EDDoc *pDoc=GetDocument(); 
	CString keke, keke2;
	CString sStr = "Test", sAngleTheta, sAngleRho;
	struct BGRA sun, shadow;
	int bl,i;
	float theta, rho, inirho;
	int startbl=0, endbl=0, maxbl=0;
	CLodGenProgress *ProgresWin;

	// Let'S be carefull
	if (multisel) { delete multisel; multisel=NULL; }
	myrefnode.x=refnode->x; 
	myrefnode.y=refnode->y; 
	myrefnode.z=refnode->z;
	refnode=&myrefnode;
	//sel=NULL;
	objno=-1; refpoly=NULL;
			
	CRayTraceDlg RayTraceDlg;

	pDoc->ReadTrIni("sun","angleTheta", sAngleTheta,"");
	RayTraceDlg.m_text_initheta=sAngleTheta;
	pDoc->ReadTrIni("sun","angleRho", sAngleRho,"");
	sscanf(sAngleRho,"%f",&inirho);
	sAngleRho.Format("%f", (1 - inirho));
	RayTraceDlg.m_text_inirho=sAngleRho;

	//Default settings for dialog
	RayTraceDlg.m_theta=pDoc->settings.ray_m_theta;
	RayTraceDlg.m_rho=pDoc->settings.ray_m_rho;
	RayTraceDlg.m_iStartBlock=pDoc->settings.ray_m_iStartBlock;
	if (pDoc->settings.ray_m_iEndBlock>=pDoc->nBlocks-1)
		pDoc->settings.ray_m_iEndBlock=pDoc->nBlocks-1;
	sStr.Format("End block (%u = whole track) : ",pDoc->nBlocks-1);
	RayTraceDlg.m_text_endbl=sStr;
	RayTraceDlg.m_iEndBlock=pDoc->settings.ray_m_iEndBlock;
	RayTraceDlg.m_bRayTraceSun=pDoc->settings.ray_m_bRayTraceSun;
	RayTraceDlg.m_b_CheckAlpha=pDoc->settings.ray_m_b_CheckAlpha;
	RayTraceDlg.m_bCheckTrack=pDoc->settings.ray_m_bCheckTrack;
	RayTraceDlg.m_bCheckFences=pDoc->settings.ray_m_bCheckFences;
	RayTraceDlg.m_bCheckLanes=pDoc->settings.ray_m_bCheckLanes;
	RayTraceDlg.m_bCheckObjects=pDoc->settings.ray_m_bCheckObjects;
	RayTraceDlg.m_bCheckExtra=pDoc->settings.ray_m_bCheckEObjects;
	RayTraceDlg.m_bCheckGlobal=pDoc->settings.ray_m_bCheckGObjects;
	RayTraceDlg.m_bCheckMiddle=pDoc->settings.ray_m_bCheckMiddle;
	RayTraceDlg.m_bCheckClose=pDoc->settings.ray_m_bCheckClose;
	RayTraceDlg.m_bCheckT1 = pDoc->settings.ray_m_bCheckT[1];
	RayTraceDlg.m_bCheckT2 = pDoc->settings.ray_m_bCheckT[2];
	RayTraceDlg.m_bCheckT3 = pDoc->settings.ray_m_bCheckT[3];
	RayTraceDlg.m_bCheckT4 = pDoc->settings.ray_m_bCheckT[4];
	RayTraceDlg.m_bCheckT6 = pDoc->settings.ray_m_bCheckT[6];

	RayTraceDlg.m_bCheckCST1 = pDoc->settings.ray_m_bCheckCST[1];
	RayTraceDlg.m_bCheckCST2 = pDoc->settings.ray_m_bCheckCST[2];
	RayTraceDlg.m_bCheckCST3 = pDoc->settings.ray_m_bCheckCST[3];
	RayTraceDlg.m_bCheckCST4 = pDoc->settings.ray_m_bCheckCST[4];
	RayTraceDlg.m_bCheckCST6 = pDoc->settings.ray_m_bCheckCST[6];

	RayTraceDlg.m_int_shade_blue  = pDoc->settings.ray_m_shade_blue;
	RayTraceDlg.m_int_shade_green = pDoc->settings.ray_m_shade_green;
	RayTraceDlg.m_int_shade_red   = pDoc->settings.ray_m_shade_red;
	RayTraceDlg.m_int_sun_blue    = pDoc->settings.ray_m_sun_blue;
	RayTraceDlg.m_int_sun_green   = pDoc->settings.ray_m_sun_green;
	RayTraceDlg.m_int_sun_red     = pDoc->settings.ray_m_sun_red;

	RayTraceDlg.m_bCheckLights		= pDoc->settings.ray_m_bLightTrace;
	RayTraceDlg.m_float_light_multi = pDoc->settings.ray_m_float_light_multi;


	if (RayTraceDlg.DoModal()!=IDOK) return; // Cancel pressed
	//if (!(RayTraceDlg.m_bCheckTrack|RayTraceDlg.m_bCheckObjects)) return; //Nothing selected
	theta = RayTraceDlg.m_theta;
	rho = RayTraceDlg.m_rho;
	startbl = RayTraceDlg.m_iStartBlock;
	if (startbl<0) startbl=0;
	endbl = RayTraceDlg.m_iEndBlock;
	if (endbl>pDoc->nBlocks-1)
		endbl=pDoc->nBlocks-1;
	if (startbl>endbl)
		startbl=endbl;
	//Save settings for next time
	pDoc->settings.ray_m_theta=theta;
	pDoc->settings.ray_m_rho=rho;
	pDoc->settings.ray_m_iEndBlock=endbl;
	pDoc->settings.ray_m_iStartBlock=startbl;
	pDoc->settings.ray_m_bRayTraceSun=RayTraceDlg.m_bRayTraceSun;
	pDoc->settings.ray_m_bCheckTrack=RayTraceDlg.m_bCheckTrack;
	pDoc->settings.ray_m_bCheckFences=RayTraceDlg.m_bCheckFences;
	pDoc->settings.ray_m_bCheckLanes=RayTraceDlg.m_bCheckLanes;
	pDoc->settings.ray_m_b_CheckAlpha=RayTraceDlg.m_b_CheckAlpha;
	pDoc->settings.ray_m_bCheckObjects=RayTraceDlg.m_bCheckObjects;
	pDoc->settings.ray_m_bCheckEObjects=RayTraceDlg.m_bCheckExtra;
	pDoc->settings.ray_m_bCheckGObjects=RayTraceDlg.m_bCheckGlobal;
	pDoc->settings.ray_m_bCheckMiddle=RayTraceDlg.m_bCheckMiddle;
	pDoc->settings.ray_m_bCheckClose=RayTraceDlg.m_bCheckClose;
	pDoc->settings.ray_m_bCheckT[1] = RayTraceDlg.m_bCheckT1;
	pDoc->settings.ray_m_bCheckT[2] = RayTraceDlg.m_bCheckT2;
	pDoc->settings.ray_m_bCheckT[3] = RayTraceDlg.m_bCheckT3;
	pDoc->settings.ray_m_bCheckT[4] = RayTraceDlg.m_bCheckT4;
	pDoc->settings.ray_m_bCheckT[6] = RayTraceDlg.m_bCheckT6;

	pDoc->settings.ray_m_bCheckCST[1] = RayTraceDlg.m_bCheckCST1;
	pDoc->settings.ray_m_bCheckCST[2] = RayTraceDlg.m_bCheckCST2;
	pDoc->settings.ray_m_bCheckCST[3] = RayTraceDlg.m_bCheckCST3;
	pDoc->settings.ray_m_bCheckCST[4] = RayTraceDlg.m_bCheckCST4;
	pDoc->settings.ray_m_bCheckCST[6] = RayTraceDlg.m_bCheckCST6;

	pDoc->settings.ray_m_shade_blue=RayTraceDlg.m_int_shade_blue;
	pDoc->settings.ray_m_shade_green=RayTraceDlg.m_int_shade_green;
	pDoc->settings.ray_m_shade_red=RayTraceDlg.m_int_shade_red;
	pDoc->settings.ray_m_sun_blue=RayTraceDlg.m_int_sun_blue;
	pDoc->settings.ray_m_sun_green=RayTraceDlg.m_int_sun_green;
	pDoc->settings.ray_m_sun_red=RayTraceDlg.m_int_sun_red;

	pDoc->settings.ray_m_bLightTrace = RayTraceDlg.m_bCheckLights;
	pDoc->settings.ray_m_float_light_multi = RayTraceDlg.m_float_light_multi;

	shadow.blue  = pDoc->settings.ray_m_shade_blue;
	shadow.green = pDoc->settings.ray_m_shade_green;
	shadow.red   = pDoc->settings.ray_m_shade_red;
	shadow.alpha = 0xFF;
	sun.blue    = pDoc->settings.ray_m_sun_blue;
	sun.green   = pDoc->settings.ray_m_sun_green;
	sun.red     = pDoc->settings.ray_m_sun_red;
	sun.alpha   = 0xFF;

	ProgresWin = new CLodGenProgress;

	ProgresWin->Create(IDD_LOD_GENERATION, NULL);
	ProgresWin->ShowWindow(TRUE);
	ProgresWin->UpdateData(FALSE);
	ProgresWin->m_lodprogress.SetRange((RayTraceDlg.m_bRayTraceSun + RayTraceDlg.m_bCheckLights) * startbl,
									   (RayTraceDlg.m_bRayTraceSun + RayTraceDlg.m_bCheckLights) * endbl);
	
	CWaitCursor WCursur; //Show wait cursor
	pDoc->FPtListCreate();
	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);

	if (RayTraceDlg.m_bRayTraceSun) //Do Sun & Shadows Raytracer
	{
		for (bl=startbl;bl<endbl+1;bl++) //Shadow raytracing for selected Blocks
		{
			ProgresWin->m_lodprogress.SetPos(bl);
			pDoc->PrepareModifyTrk(bl);
			keke2.Format("RayTracing Shadows (Block  %d)... (%d of %d Blocks)",bl, bl-startbl, endbl-startbl);
			ProgresWin->SetWindowText(keke2);
			UpdateWindow();

			if (RayTraceDlg.m_bCheckTrack)
			{
			//keke2.Format("RayTracing Shadows (Block  %d)... (%d of %d Blocks)",bl, bl-startbl, endbl-startbl);
			//ProgresWin->SetWindowText(keke2);
			//UpdateWindow();
			keke=pDoc->ShadeBlock(bl, theta, rho, sun, shadow, RayTraceDlg.m_bCheckFences, RayTraceDlg.m_bCheckLanes ,RayTraceDlg.m_b_CheckAlpha, RayTraceDlg.m_bCheckMiddle, pDoc->settings.ray_m_bCheckCST);
			}
			if (RayTraceDlg.m_bCheckObjects)
			{
			//keke2.Format("RayTracing Shadows (Object %d)... (%d of %d Blocks)",bl, bl-startbl, endbl-startbl);
			//ProgresWin->SetWindowText(keke2);
			keke=pDoc->ShadeObject(bl, theta, rho, sun, shadow, RayTraceDlg.m_b_CheckAlpha, RayTraceDlg.m_bCheckMiddle, pDoc->settings.ray_m_bCheckCST);
			}

			if (RayTraceDlg.m_bCheckExtra)
			{
				for (i=0;i<4;i++)//Undo
					pDoc->PrepareModifyXobj(4*bl + i);

				//keke2.Format("RayTracing Shadows (Extra Object %d)... (%d of %d Blocks)",bl, bl-startbl, endbl-startbl);
				//ProgresWin->SetWindowText(keke2);
				//UpdateWindow();
				keke=pDoc->ShadeObjectExtraGlobalObject(bl, theta, rho, sun, shadow,RayTraceDlg.m_b_CheckAlpha, pDoc->settings.ray_m_bCheckCST, pDoc->settings.ray_m_bCheckT);
			}

		}
		if (RayTraceDlg.m_bCheckGlobal)
		{
				for (i=0;i<2;i++)//2 global blocks
					pDoc->PrepareModifyXobj(4*pDoc->nBlocks + i);

				keke2.Format("RayTracing Shadows (Global Objects)");
				ProgresWin->SetWindowText(keke2);
				UpdateWindow();
				keke=pDoc->ShadeObjectExtraGlobalObject(pDoc->nBlocks, theta, rho, sun, shadow, RayTraceDlg.m_b_CheckAlpha, pDoc->settings.ray_m_bCheckCST, pDoc->settings.ray_m_bCheckT);
		}
		if (RayTraceDlg.m_bCheckClose)
		{
			for (bl=startbl;bl<endbl;bl++)
			{
				pDoc->ShadeNear(bl, sun, shadow);
			}
			if (RayTraceDlg.m_bCheckGlobal)
				pDoc->ShadeNear(pDoc->nBlocks, sun, shadow);
		}
	}
	if (RayTraceDlg.m_bCheckLights) //Raytrace Lights
	{
		struct TRKBLOCK *t;
		for (bl=startbl;bl<endbl+1;bl++) //Shadow raytracing for selected Blocks
		{

			ProgresWin->m_lodprogress.SetPos(RayTraceDlg.m_bRayTraceSun*(endbl-startbl) + bl);

			t=&pDoc->trk[bl];

			keke2.Format("RayTracing Lights of Block %d (%d)", bl, t->nLightsrc);
			ProgresWin->SetWindowText(keke2);
			UpdateWindow();
			for (i=0;i<t->nLightsrc;i++)
				pDoc->RayTraceLight(bl, i, RayTraceDlg.m_float_light_multi, RayTraceDlg.m_bCheckTrack, RayTraceDlg.m_bCheckObjects, RayTraceDlg.m_bCheckFences, RayTraceDlg.m_bCheckLanes, RayTraceDlg.m_bCheckGlobal, RayTraceDlg.m_bCheckExtra, RayTraceDlg.m_b_CheckAlpha, &pDoc->settings.ray_m_bCheckCST[0], &pDoc->settings.ray_m_bCheckT[0]);
		}
	}
	delete ProgresWin;
	pDoc->FPtListClear();
	MessageBox("RayTracing finished !");
	InvalidateRect(NULL, TRUE);
	
}

void CT3EDView::OnPASTEZl(void)
{
// MessageBox("Q!");
}


void CT3EDView::OnEditPasteNormal() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	CT3EDDoc *pDoc=GetDocument();
	pDoc->ZCopyMode=1;
	statusbar->SetPaneText(4,"Normal (z)", TRUE);
}

void CT3EDView::OnEditPasteShader() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	CT3EDDoc *pDoc=GetDocument();
	pDoc->ZCopyMode=2;
	statusbar->SetPaneText(4,"Shader (z)", TRUE);
}

void CT3EDView::OnEditPasteAverage() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	CT3EDDoc *pDoc=GetDocument();
	pDoc->ZCopyMode=3;
	statusbar->SetPaneText(4,"Average (z)", TRUE);
}

void CT3EDView::OnEditPasteLineXy() 
{
	CT3EDDoc *pDoc=GetDocument();
	pDoc->ZCopyMode=4;
	statusbar->SetPaneText(4,"Line (x,y)", TRUE);
}

void CT3EDView::OnEditPasteLineXyz() 
{
	CT3EDDoc *pDoc=GetDocument();
	pDoc->ZCopyMode=5;
	statusbar->SetPaneText(4,"Line (x,y,z)", TRUE);	
}

void CT3EDView::OnUpdateEditPasteNormal(CCmdUI* pCmdUI) 
{
	CT3EDDoc *pDoc=GetDocument();
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((pDoc->ZCopyMode==1)&&!isEmpty);
}

void CT3EDView::OnUpdateEditPasteShader(CCmdUI* pCmdUI) 
{
	CT3EDDoc *pDoc=GetDocument();
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((pDoc->ZCopyMode==2)&&!isEmpty);
}

void CT3EDView::OnUpdateEditPasteAverage(CCmdUI* pCmdUI) 
{
	CT3EDDoc *pDoc=GetDocument();
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((pDoc->ZCopyMode==3)&&!isEmpty);
}

void CT3EDView::OnUpdateEditPasteLineXy(CCmdUI* pCmdUI) 
{
	CT3EDDoc *pDoc=GetDocument();
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((pDoc->ZCopyMode==4)&&!isEmpty);	
}

void CT3EDView::OnUpdateEditPasteLineXyz(CCmdUI* pCmdUI) 
{
	CT3EDDoc *pDoc=GetDocument();
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((pDoc->ZCopyMode==5)&&!isEmpty);	
}

void CT3EDView::OnUpdateCopyZ(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
	//CT3EDDoc *pDoc=GetDocument();
	pCmdUI->Enable((selMode==ID_MODE_POINT)&&!isEmpty);
	//pCmdUI->SetCheck((pDoc->ZCopyMode==1)&&!isEmpty);
}

void CT3EDView::OnUpdatePasteZh(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
	pCmdUI->Enable( ( (selMode==ID_MODE_POINT)|(selMode==ID_MODE_VROADEDIT) )&&!isEmpty);
}

void CT3EDView::OnUpdateEditPasteXy(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((selMode==ID_MODE_POINT)&&!isEmpty);
}

void CT3EDView::OnUpdateToolsExpand(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((((selMode==ID_MODE_OBJECT)|(selMode==ID_MODE_BLOCK))&&!isEmpty));
}

void CT3EDView::OnUpdateEditmodesAutoobjmember(CCmdUI* pCmdUI) 
{
	CT3EDDoc *pDoc=GetDocument();
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(pDoc->bAutoObjMem);	
}

void CT3EDView::OnEditmodesAutoobjmember() 
{
	CT3EDDoc *pDoc=GetDocument();
	pDoc->bAutoObjMem=(!pDoc->bAutoObjMem);	
}

void CT3EDView::OnUpdateToolsRotate(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((((selMode==ID_MODE_OBJECT)|(selMode==ID_MODE_BLOCK)|(selMode==ID_MODE_POLYGON))&&!isEmpty));
}

void CT3EDView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
}

void CT3EDView::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
}


void CT3EDView::OnUpdateEditUndoKeepVr(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((!isEmpty)&&(GetDocument()->undoLevel>0));
}

void CT3EDView::OnEditUndoKeepVr()  //Undo without VRoad Data
{
	CT3EDDoc *pDoc=GetDocument();
	struct COLVROAD *vrdata;
	int lev=pDoc->undoLevel-1;

	vrdata=(struct COLVROAD *)malloc(36*pDoc->col.vroadHead.nrec); //Backup VRoad data
	memcpy(vrdata, pDoc->undoCol[lev],36*pDoc->col.vroadHead.nrec);

	if (multisel) delete multisel; multisel=NULL;
	refnode=&myrefnode;
	memcpy(refnode,&(pDoc->undoRefpt[lev]),12);
	refblock=pDoc->undoRefblk[lev];
	offsetx=pDoc->undoOfsx[lev];
	offsety=pDoc->undoOfsy[lev];
	pDoc->PerformUndo(true);
	isTruePoint=FALSE; refpoly=NULL; objno=-1; isxobj=0;
	InvalidateRect(NULL,TRUE);

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //New undo for VRoad
	//pDoc->PrepareModifyVRoadHeightsSpdFiles();
	if (pDoc->undoCol[pDoc->undoLevel-1]==NULL) {
		pDoc->undoCol[pDoc->undoLevel-1]=(struct COLVROAD *)malloc(36*pDoc->col.vroadHead.nrec);
		memcpy(pDoc->undoCol[pDoc->undoLevel-1],vrdata,36*pDoc->col.vroadHead.nrec);
	}
	dofree(vrdata);
}

void CT3EDView::OnUpdateToolsMoveto(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((!isEmpty) && ( ((selMode==ID_MODE_BLOCK)&&(refblock>-1)) | 
								   ((selMode==ID_MODE_OBJECT)&&(objno>-1)) |
								   ((selMode==ID_MODE_EXTPOINT)&&(isTruePoint)) |
								   ((selMode==ID_MODE_POINT)&&(isTruePoint)) |
								   ((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL))								   
								   ));
}

void CT3EDView::OnUpdateToolsProperties(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateToolsNeighbours(CCmdUI* pCmdUI)
{
	CT3EDDoc *pDoc=GetDocument();
	pCmdUI->Enable(!isEmpty && pDoc->bHSMode);
}

void CT3EDView::OnUpdateToolsShadowraytracer(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateToolsLodgen(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateExportVis(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateExportTrkvertices(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateExportTexture(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateImportVis(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateImportTexture(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateImportObject(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateExportObject(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(((selMode==ID_MODE_OBJECT)||(selMode==ID_MODE_BLOCK))&&!isEmpty);	
}

void CT3EDView::OnToolsMergeObject()
{
	CT3EDDoc *pDoc=GetDocument();
	CSelData *sel;
	int orefblock,oisxobj,orefchunk,oobjno=-1;
	struct NOBJDATA NewObjData;
	BOOL changed=FALSE;
	CString sStr = "";

	for (sel=this;sel!=NULL;sel=sel->multisel) //look at all objects
	{
		if ((sel->isxobj<2)&&(isxobj<2)) //Only available for objects
		{
			if ((!((sel->refblock==refblock)&&(sel->isxobj==isxobj)&&(sel->refchunk==refchunk)&&(sel->objno==objno)))&&(sel->isxobj<2)&&(isxobj<2)) //Two different (extra -) objects ? Because sound / light objects causes crashes
			{
				pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //New undo point
				isTruePoint=FALSE;
				myrefnode.x=refnode->x; //
				myrefnode.z=refnode->z;
				myrefnode.y=refnode->y;
				refnode=&myrefnode;
				//pDoc->PrepareNewUndo(sel->refnode,sel->refblock,offsetx,offsety);
				orefblock=sel->refblock;oisxobj=sel->isxobj;orefchunk=sel->refchunk;oobjno=sel->objno;
				if ((sel->refblock==refblock)&&(sel->isxobj==isxobj)&&(sel->refchunk==refchunk)&&(objno<sel->objno))
					oobjno--; //decrease objno if deleted object is stored before
				pDoc->CreateObjectData(&NewObjData,refblock,isxobj,refchunk,objno,FALSE);
				pDoc->ImportObject(&NewObjData,sel->refblock,sel->isxobj,sel->refchunk,sel->objno,TRUE);
				pDoc->DelObject(refblock,isxobj,refchunk,objno);
				changed=TRUE;
			}
		}
	}
	//changed=TRUE;
	if (changed==TRUE)
	{
		offsetx=0; offsety=0;
		if (multisel) { delete multisel; multisel=NULL; }
		refblock=orefblock;isxobj=oisxobj;refchunk=orefchunk;objno=oobjno;
		pDoc->FindObjMinMax(refblock,isxobj,refchunk,objno);
		refnode=&pDoc->MemObjMiddle; //Setview to new object center
		InvalidateRect(NULL,TRUE);
		sStr.Format("Merged one object with %d polygons.",NewObjData.nPoly);
		statusbar->SetPaneText(0,sStr,TRUE);
		dofree(NewObjData.Vertices); //Give back memory
		dofree(NewObjData.vertshade);
		dofree(NewObjData.Polys);
	}
	//changed=TRUE; //Nur fr Haltepunkt, kann weg.
}

void CT3EDView::OnUpdateToolsInvert(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(((selMode==ID_MODE_POLYGON)&&!isEmpty));	
}

void CT3EDView::OnUpdateFileProperties(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnUpdateToolsVroadHeightsSpdfiles(CCmdUI* pCmdUI) 
{
	CT3EDDoc *pDoc=GetDocument();
	pCmdUI->Enable((!isEmpty)&&(pDoc->spdFALoaded)&&(pDoc->spdRALoaded)&&(pDoc->HeightsLoaded));		
}

void CT3EDView::OnUpdateEditFind(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&
		(selMode==ID_MODE_POLYGON));	
}


void CT3EDView::OnUpdateEditMerge(CCmdUI* pCmdUI) 
{
	/*pCmdUI->Enable(!isEmpty&&
		(selMode==ID_MODE_BLOCK));*/
	pCmdUI->Enable(FALSE);
}


void CT3EDView::OnUpdateEditCut(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(((selMode==ID_MODE_BLOCK)&&!isEmpty));		
}



void CT3EDView::OnUpdateSetVis(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);		
}


void CT3EDView::OnUpdateViewVisibility(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(ShowBasedOnVisi&&!isEmpty);
	InvalidateRect(NULL,TRUE);	
}

void CT3EDView::OnViewVisibility() 
{
	CT3EDDoc* pDoc = GetDocument();
	ShowBasedOnVisi=!ShowBasedOnVisi;
	pDoc->bUpdatedScene=0; //Trackview needs to be refreshed
}

void CT3EDView::OnUpdateVisFwIncrease(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((ShowBasedOnVisi)&&(!isEmpty));
}

void CT3EDView::OnUpdateVisFwDecrease(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((ShowBasedOnVisi)&&(!isEmpty));
}

void CT3EDView::OnUpdateVisBwIncrease(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((ShowBasedOnVisi)&&(!isEmpty));	
}

void CT3EDView::OnUpdateVisBwDecrease(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((ShowBasedOnVisi)&&(!isEmpty));	
}

void CT3EDView::TrackViewDrawBlock(int blk, int vblock)
{
	CT3EDDoc* pDoc = GetDocument();

	if (blk>pDoc->nBlocks) blk=blk-pDoc->nBlocks;
	if (blk<0) blk=blk+pDoc->nBlocks;

	//Draw Track and Polygon objects
	if  (pDoc->nBlocks!=blk) pDoc->TrackView->CreateScene(&(pDoc->trk[blk]),&(pDoc->poly[blk]), &(pDoc->qfsView), vblock, nDetail);
	//Draw Extra objects
	pDoc->TrackView->CreateSceneEx(&(pDoc->xobj[blk*4]), &(pDoc->qfsView), vblock*4);
	pDoc->TrackView->CreateSceneEx(&(pDoc->xobj[1+blk*4]), &(pDoc->qfsView), vblock*4+1);
	pDoc->TrackView->CreateSceneEx(&(pDoc->xobj[2+blk*4]), &(pDoc->qfsView), vblock*4+2);
	pDoc->TrackView->CreateSceneEx(&(pDoc->xobj[3+blk*4]), &(pDoc->qfsView), vblock*4+3);
}

int CT3EDView::RealBlockNum(int blk)
{
	CT3EDDoc* pDoc = GetDocument();
	if (blk>=pDoc->nBlocks) blk=blk-pDoc->nBlocks;
	if (blk<0) blk=blk+pDoc->nBlocks;

	return blk;
}

void CT3EDView::OnTest() 
{
	//int i;
	//long lT;
	//struct FLOATPT pt;
	// Only used to test new functions
	CT3EDDoc* pDoc = GetDocument();
	//CSelData *sel;
	//if (pDoc->bHSMode) 
	//pDoc->Convert4to3(refblock);
	//i=pDoc->LoadCam();

	//Test SpeedFile Shift
	pDoc->SpeedFileShiftData(pDoc->spdFAbin, pDoc->nSpeedFileShift);
	pDoc->SpeedFileShiftData(pDoc->spdRAbin, -pDoc->nSpeedFileShift);

	statusbar->SetPaneText(0,"Test Speedfile Shift",TRUE);
	InvalidateRect(NULL,true);

	//NUmber of selected Items
		/*CSelData *sel;
		CString sStr;
		int counter=0;	
		//get start & end point values
		sel=this;
		if (multisel!=NULL)
			for (sel=this;sel!=NULL;sel=sel->multisel)
			{
				counter++;
			}
		sStr.Format("Number of selected items %d", counter);
		AfxMessageBox(sStr);
		*/


	//New Fence 
	/*pDoc->NewFence(refblock, nDetail+1);
	InvalidateRect(NULL,true);*/

	//Paste Block to all Blocks
	/*CString Clip = "";
	Clip = pDoc->GetClipboardText(); // Returns "Block", "Object", "VRoad", "Camera" or nothing
	if (Clip=="Block")
	{ 
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		OnModeBlock();
		int i;
		//for (i=1;i<pDoc->nBlocks;i++)
		for (i=1;i<300;i++)
		{
			if (i<pDoc->nBlocks)
				pDoc->PasteBlockfromClipboard(2,i, TRUE, TRUE, TRUE, TRUE, TRUE); //Paste Block stored in Clipboard
			else
				pDoc->PasteBlockfromClipboard(0,pDoc->nBlocks,1,1,1,1,1); //Paste Block stored in Clipboard at the end

			pDoc->MoveBlockSimple(i,0, (float) i*32,0);
		}
	
	}
	InvalidateRect(NULL,true);*/



	/*
	//---------------------------------------------------
	//TNFS_SE Block Creation
	if (refblock>-1)
	{
		struct TRKBLOCK *t;
		struct FLOATPT *v;
		LPPOLYGONDATA p;
		int j,zeile=0, spalte=0, num, st;

		t=&(pDoc->trk[refblock]);

		//High Resolution
		v=pDoc->trk[refblock].vert;
		p=pDoc->poly[refblock].poly[4];
		num=pDoc->poly[refblock].sz[4];
		nDetail=nDetail;

		spalte=0;zeile=0;
		for (j=0;j<num;j++,p++) 
		{

			if (spalte<4) //4 Polys
			{
				st=zeile*11 -spalte; //Start ist abhngig von zeile
				p->vertex[0]=st + 21; 
				p->vertex[1]=st + 20; 
				p->vertex[2]=st +  9; 
				p->vertex[3]=st + 10; 
			}
			if (spalte==4) //Poly 5
			{
				st=zeile*11; //Start ist abhngig von zeile
				p->vertex[0]=st + 17; 
				p->vertex[1]=st + 11; 
				p->vertex[2]=st +  0; 
				p->vertex[3]=st +  6; 
			}
			if (spalte>4) //Poly 6 und hher
			{
				st=zeile*11 + spalte -5; //Start ist abhngig von zeile
				p->vertex[0]=st + 11; 
				p->vertex[1]=st + 12; 
				p->vertex[2]=st +  1; 
				p->vertex[3]=st +  0; 
			}
			spalte++;
			if (spalte>9)
				{spalte=0;zeile++;} //10 Polys (0-9) Pro Zeile

		
		}

		//Med Resolution
		v=pDoc->trk[refblock].vert;
		p=pDoc->poly[refblock].poly[2];
		num=pDoc->poly[refblock].sz[2];
		spalte=0;zeile=0;

		for (j=0;j<num;j++,p++) 
		{

			if (spalte<4) //4 Polys 0-3
			{
				st=zeile*22 -spalte; //Start ist abhngig von zeile
				p->vertex[0]=st + 32; 
				p->vertex[1]=st + 31; 
				p->vertex[2]=st +  9; 
				p->vertex[3]=st + 10; 
			}
			if (spalte==4) //Poly 4
			{
				st=zeile*22; //Start ist abhngig von zeile
				p->vertex[0]=st + 28; 
				p->vertex[1]=st + 22; 
				p->vertex[2]=st +  0; 
				p->vertex[3]=st +  6; 
			}
			if (spalte>4) //Poly 5 und hher
			{
				st=zeile*22 + spalte -5; //Start ist abhngig von zeile
				p->vertex[0]=st + 22; 
				p->vertex[1]=st + 23; 
				p->vertex[2]=st +  1; 
				p->vertex[3]=st +  0; 
			}
			spalte++;
			if (spalte>9)
				{spalte=0;zeile++;} //10 Polys (0-9) Pro Zeile

		
		}

		//Low Resolution
		v=pDoc->trk[refblock].vert;
		p=pDoc->poly[refblock].poly[0];
		num=pDoc->poly[refblock].sz[0];

		spalte=0;zeile=0;
		for (j=0;j<num;j++,p++) 
		{

			if (spalte<4) //4 Polys
			{
				st=zeile*44 -spalte; //Start ist abhngig von zeile
				p->vertex[0]=st + 54; 
				p->vertex[1]=st + 53; 
				p->vertex[2]=st +  9; 
				p->vertex[3]=st + 10; 
			}
			if (spalte==4) //Poly 5
			{
				st=zeile*44; //Start ist abhngig von zeile
				p->vertex[0]=st + 50; 
				p->vertex[1]=st + 44; 
				p->vertex[2]=st +  0; 
				p->vertex[3]=st +  6; 
			}
			if (spalte>4) //Poly 6 und hher
			{
				st=zeile*44 + spalte -5; //Start ist abhngig von zeile
				p->vertex[0]=st + 44; 
				p->vertex[1]=st + 45; 
				p->vertex[2]=st +  1; 
				p->vertex[3]=st +  0; 
			}
			spalte++;
			if (spalte>9)
				{spalte=0;zeile++;} //10 Polys (0-9) Pro Zeile

		}

		//set the vertices
		for (zeile=0;zeile<9;zeile++)
			for (spalte=0;spalte<11;spalte++)
			{
				j=spalte + zeile * 11;
				t->vert[j].y=(float) zeile * 4;
				t->vert[j].z=0;
				if (spalte<6)
					t->vert[j].x=(float) spalte*5;
				else
					t->vert[j].x=(float) (spalte-5) * -5;

			}

		InvalidateRect(NULL,true);

		//refchunk=refchunk;
	}
	//TNFS_SE Block Creation End
	//---------------------------------------------------
	*/




	// VRoad Poly Left, Poly Right
	/*
	CSelData *sel;
	struct FLOATPT Right;
	if ((selMode==ID_MODE_OBJECT)&&(isxobj==4)&&pDoc->bHSMode) // VRoad Refpoint
	{
		for (sel=this;sel!=NULL;sel=sel->multisel) //look at all objects
		if (sel->isxobj==4) //VRoad Point selected
		{
			Right.x=float (pDoc->col.vroad[sel->objno].right.x)/128;
			Right.y=float (pDoc->col.vroad[sel->objno].right.y)/128;
			Right.z=float (pDoc->col.vroad[sel->objno].right.z)/128;
			pDoc->RecalcPassableLanes(sel->objno);

		}
	}
	*/


	// VRoad Poly Left, Poly Right of whole track
	/*int i;
	for (i=0;i<pDoc->col.vroadHead.nrec;i++)
		pDoc->VRoadLanesRecalc(i, TRUE, TRUE, FALSE);
	AfxMessageBox ("RecalcPassableLanes for track finished.");*/




	//DriveableBelowTest
	/*
	if ((selMode==ID_MODE_POINT)|(selMode==ID_MODE_EXTPOINT))
	{
		CSelData *sel;
		FLOATPT Point;
		int er, fblock=-1;
		sel=this;

		if (isTruePoint==TRUE)
		{
			Point.x=sel->refnode->x;
			Point.y=sel->refnode->y;
			Point.z=sel->refnode->z;
			er=pDoc->DriveablePolyBelow(refblock, Point, &fblock);
			if (er!=-1)
				AfxMessageBox ("Passable.");
			else
				AfxMessageBox ("Not passable.");

		}

	}
	*/




	// HS_EXTRA_ShortcutToVRoad Test
	/*
	CString sStr;
	int i;

	for (i=0;i<pDoc->col.vroadHead.nrec;i++)
	{
		if ((pDoc->col.hs_extra[i].ShortcutToVRoad[0]!=-1)|(pDoc->col.hs_extra[i].ShortcutToVRoad[1]!=-1))
		{
			//memcpy(&uid[0], &lT, sizeof(long));
			sStr.Format("VRoad Point %d has a shortcut to %d, %d", i, pDoc->col.hs_extra[i].ShortcutToVRoad[0], pDoc->col.hs_extra[i].ShortcutToVRoad[1]);
			AfxMessageBox (sStr);
		}
	}
	AfxMessageBox ("Check fertig.");
	*/


	// HS_EXTRA_UNKNOWN1 Test
	/*CString sStr;
	int i;
	long lT;
	short uid[2];

	for (i=0;i<pDoc->col.vroadHead.nrec;i++)
	{
		//lT=pDoc->col.hs_extra[i].unknown1[0];

		if ((pDoc->col.hs_extra[i].ShortcutToVRoad[0]!=-1)|(pDoc->col.hs_extra[i].ShortcutToVRoad[1]!=-1))
		{
			//memcpy(&uid[0], &lT, sizeof(long));
			sStr.Format("VRoad Point %d ist hs_extra[i].unknown1 nicht -1 sondern %d UINT %d, %d", i, lT, uid[0], uid[1]);
			AfxMessageBox (sStr);
		}
	}
	AfxMessageBox ("Check fertig.");*/


	//Search spcial effects
/*
	if (isDragging) return; // safety
	CleanCursorZone(selMode,FALSE);
	selMode=ID_MODE_OBJECT;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	isTruePoint=FALSE; refpoly=NULL;
	editMode=NULL;
	CleanCursorZone(selMode,TRUE);

	int i, bl, type;
	struct TRKBLOCK *t;
	//struct FLOATPT pt;
	for (bl=0;bl<pDoc->nBlocks;bl++) //Shadow raytracing for selected Blocks
	{

		t=&pDoc->trk[bl];

		for (i=0;i<t->nLightsrc;i++)
		{
			type=t->lightsrc[i].type[0];
			if ((type>31)&&(type!=100)&&(type!=101)&&(type!=102)&&(type!=103)&&(type!=104)&&(type!=105))
			{
				refblock=bl;
				isxobj=2;
				objno=i;
				refchunk=0;
				//pt=&myrefnode;
				myrefnode.x=((float)pDoc->trk[bl].lightsrc[i].refpoint.x)/65536;
				myrefnode.y=((float)pDoc->trk[bl].lightsrc[i].refpoint.y)/65536;
				myrefnode.z=((float)pDoc->trk[bl].lightsrc[i].refpoint.z)/65536;
				InvalidateRect(NULL,TRUE);
				return;
			}
		}
	}
	AfxMessageBox ("Check fertig.");
*/

	//Add Light Test
	/*CSoundLightProps ts;
	ts.m_strText1="Set light source data here.";
	ts.m_tyyppi=1; //Light type 1
	ts.m_tyyppihex="01";
	ts.m_intBlock=refblock;
	ts.maxblock=(pDoc->nBlocks-1);

	if (ts.DoModal()!=IDOK) return;

	for (sel=this;sel!=NULL;sel=sel->multisel)
	{
		pDoc->AddLight(sel->refblock, sel->refnode, ts.m_tyyppi);
	}*/

	/*
	//lineSegIntersectTri Test
	vec3 hitpoint;
	memset(&hitpoint,0,sizeof(vec3));
	vec3 tri[3];
	vec3 line0[2];
	vec3 line1[2];

	tri[0].x=-1;tri[0].y=-1;tri[0].z=0;
	tri[1].x=1;tri[1].y=-1;tri[1].z=0;
	tri[2].x=1;tri[2].y=1;tri[2].z=0;

	line0[0].x=0.5;line0[0].y=-0.5;line0[0].z=-1;// should intersect
	line0[1].x=0.5;line0[1].y=-0.5;line0[1].z=1;
	
	line1[0].x=-0.5;line1[0].y=0.5;line1[0].z=-1;// should not intersect
	line1[1].x=-0.5;line1[1].y=0.5;line1[1].z=1;

	i=pDoc->LineSegIntersectTri(line0, tri, &hitpoint); //i=1 intersect
	i=pDoc->LineSegIntersectTri(line1, tri, &hitpoint); //i=0 not intersect

	//lineSegIntersectPoly Test
	vec3 mypoly[4];
	memcpy(&mypoly[0], &tri[0], 3 * sizeof(vec3));
	mypoly[3].x=-1; mypoly[3].y=1.75;mypoly[3].z=-1;

	i=pDoc->LineSegIntersectPoly(line1, mypoly, &hitpoint); //i=1  intersect
	i=pDoc->LineSegIntersectPoly(line0, mypoly, &hitpoint); //i=1  intersect
	*/

}

void CT3EDView::OnUpdateExportTextureblock(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();

	pCmdUI->Enable((!isEmpty)&&(!(pDoc->bHSMode)));
	
}

void CT3EDView::OnExportTextureblock() 
{
	CT3EDDoc *pDoc=GetDocument();
	CString TBFile, Output, sStr;
	int i=0, j=0;
	unsigned long c[8];
	FILE* fout;

	TBFile=pDoc->fileDir + "\\Textureblock.csv";

	fout = fopen(TBFile, "w");
	fprintf(fout, "Entries;%d\n", pDoc->nTextures);
	fprintf(fout, "%s\n", "Number;QFSNumber;Width;Height;IsLane;Unknown1;Unknown2;c0;c1;c2;c3;c4;c5;c6;c7");
	
	for (i=0;i<pDoc->nTextures;i++)
	{
		memcpy(&c[0],&pDoc->texture[i].corners[0],sizeof(unsigned long) * 8);
		fprintf( fout, "%d;%d;%d;%d;%d;%X;%X;%X;%X;%X;%X;%X;%X;%X;%X\n", i,pDoc->texture[i].texture, pDoc->texture[i].width, pDoc->texture[i].height, pDoc->texture[i].islane, pDoc->texture[i].unknown1, pDoc->texture[i].unknown2, c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]);
		//fprintf( fout, "%d;%d;%d;%d;%d;%X;%X;%g;%g;%g;%g;%g;%g;%g;%g\n", i,pDoc->texture[i].texture, pDoc->texture[i].width, pDoc->texture[i].height, pDoc->texture[i].islane, pDoc->texture[i].unknown1, pDoc->texture[i].unknown2, pDoc->texture[i].corners[0], pDoc->texture[i].corners[1], pDoc->texture[i].corners[2], pDoc->texture[i].corners[3], pDoc->texture[i].corners[4], pDoc->texture[i].corners[5], pDoc->texture[i].corners[6], pDoc->texture[i].corners[7]);
		/*for (j=0;j<8;j++)
			fprintf( fout, ";%g", pDoc->texture[i].corners[j]);
		fprintf( fout, "\n");*/
	}
	fclose(fout);
	sStr.Format("Texttureblock with %d entries written to Textureblock.csv.", pDoc->nTextures);
	MessageBox(sStr);	
}

void CT3EDView::OnUpdateImportTextureblock(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();

	pCmdUI->Enable((!isEmpty)&&(!(pDoc->bHSMode)));	
}

void CT3EDView::OnImportTextureblock() 
{
	CT3EDDoc *pDoc=GetDocument();
	CString TBFile, In, sStr;
	int i=0, j=0, er, nr,texture,width, height, islane;
	unsigned long unknown1, unknown2;
	bool OK=true;
	unsigned long c[8];
	FILE* fin;

	for (j=0;j<8;j++)
			c[j]=0;

	TBFile=pDoc->fileDir + "\\Textureblock.csv";
	fin = fopen(TBFile, "r");

	if (fin==NULL)
		{
		OK=false;
		MessageBox("File open Error.");
		return;
		}
	else
		OK=true;

	if (OK==true)
		{
		er=fscanf(fin, "Entries;%d\n", &nr);
		if ((er==1)&&(nr>0)){
			pDoc->nTextures=nr;
			pDoc->texture=(struct TEXTUREBLOCK *)realloc(pDoc->texture, pDoc->nTextures*sizeof(struct TEXTUREBLOCK));
			}
		else OK=false;
		}


	if (OK==true)
		{
		fscanf(fin, "%s\n", In);
		if (In!="Number;QFSNumber;Width;Height;IsLane;Unknown1;Unknown2;c0;c1;c2;c3;c4;c5;c6;c7") OK=false;
		}

	if (OK==true) for (i=0;i<pDoc->nTextures;i++)
	{
		er=fscanf( fin, "%d;%d;%d;%d;%d;%X;%X;%X;%X;%X;%X;%X;%X;%X;%X\n", &nr,&texture,&width, &height, &islane, &unknown1, &unknown2,&c[0],&c[1],&c[2],&c[3],&c[4],&c[5],&c[6],&c[7]);
		//fscanf(fin, "Block: %d\n", &nulld);
		if ((er==15)&&(i==nr)) //Read 15 values & right number ?
		{
			pDoc->texture[i].texture=texture;
			pDoc->texture[i].width=width;
			pDoc->texture[i].height=height;
			pDoc->texture[i].islane=islane;
			pDoc->texture[i].unknown1=unknown1;
			pDoc->texture[i].unknown2=unknown2;
			memcpy(&pDoc->texture[i].corners[0],&c[0],sizeof(unsigned long) * 8);
			/*for (j=0;j<8;j++)
				pDoc->texture[i].corners[j]=c[j];*/

		}
		else 
		{
			OK=false;
			sStr.Format("Error reading entry %d", i);
			MessageBox(sStr);
			i=pDoc->nTextures; //End the for loop
		}
	}

	if (OK==false) MessageBox("Texttureblock Import failed.");
	else{
		sStr.Format("Texttureblock with %d entries imported from Textureblock.csv.", pDoc->nTextures);
		MessageBox(sStr);
	}

	fclose(fin);

}


void CT3EDView::OnUpdateExportObjectWZero(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(((selMode==ID_MODE_OBJECT)||(selMode==ID_MODE_BLOCK))&&!isEmpty);		
}


void CT3EDView::OnUpdateAllTextures(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnAllTextures() 
{
	CT3EDDoc *pDoc=GetDocument();
	CInputDlg Inputdlg;
	CSelData *sel;
	int i;
	sel=this;

	Inputdlg.m_str_Label="Difference for all textures :";


	if (Inputdlg.DoModal() == IDOK) 
	{
		pDoc->PrepareNewUndo(sel->refnode,sel->refblock,offsetx,offsety); //undo should be possible
		for (i=0;i<=pDoc->nBlocks;i++)
		{
			pDoc->ChangeTexBlock(i,Inputdlg.m_int_Edit1); //Change all texture of a block with objects
		}
		//HOO: (5)
		InvalidateRect(NULL,true);
		//HOO: (5)
	}
}

void CT3EDView::OnUpdateExpandwholetrack(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}


void CT3EDView::OnExpandwholetrack() 
{
	CT3EDDoc *pDoc=GetDocument();
	CExprandTrack ExprandTrackDlg;

	ExprandTrackDlg.m_float_x=pDoc->settings.expand_track_m_edit_xy;
	ExprandTrackDlg.m_float_y=pDoc->settings.expand_track_m_edit_xy;
	ExprandTrackDlg.m_float_z=pDoc->settings.expand_track_m_edit_z;
	
	if (!(ExprandTrackDlg.DoModal () == IDOK)) return; //Cancel pressed

	if ((ExprandTrackDlg.m_float_x==1)&&(ExprandTrackDlg.m_float_y==1)&&(ExprandTrackDlg.m_float_z==1)) return; //Nothing to do

	pDoc->settings.expand_track_m_edit_xy=ExprandTrackDlg.m_float_x;
	pDoc->settings.expand_track_m_edit_z=ExprandTrackDlg.m_float_z;

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
	pDoc->Expandwholetrack(ExprandTrackDlg.m_float_x, ExprandTrackDlg.m_float_y, ExprandTrackDlg.m_float_z);

	pDoc->RecalcBoundingBox(refblock);
	refnode=&(pDoc->trk[refblock].ptCentre); //Setview to Block Centre
	InvalidateRect(NULL,TRUE);

}


void CT3EDView::OnUpdateRemapobjects(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
}

void CT3EDView::OnRemapobjects() 
{
	CT3EDDoc *pDoc=GetDocument();
	CLodGenProgress *ProgresWin;
	CString sStr = "Test";
	int i,j ,objchanged=0;

	ProgresWin = new CLodGenProgress;
	ProgresWin->Create(IDD_LOD_GENERATION, NULL);
	ProgresWin->ShowWindow(TRUE);
	ProgresWin->UpdateData(FALSE);
	ProgresWin->m_lodprogress.SetRange(0,(short) pDoc->nBlocks);
	CWaitCursor WCursur; //Show wait cursor

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible


	for (i=0;i<pDoc->nBlocks;i++)
	{
		sStr.Format("Checking objects of block  %d... (of %d Blocks)",i, pDoc->nBlocks);
		ProgresWin->SetWindowText(sStr);
		ProgresWin->m_lodprogress.SetPos(i);
		UpdateWindow();
		pDoc->PrepareModifyTrk(i);
		pDoc->PrepareModifyPoly(i);
		for (j=0;j<4;j++) pDoc->PrepareModifyXobj(4*i+j);

		objchanged+=pDoc->RemapObjects(i); //Check block i
	}
	for (i=0;i<pDoc->nBlocks;i++)
		pDoc->RecalcBoundingBox(i);

	delete ProgresWin;

	CleanCursorZone(selMode,FALSE);
	myrefnode.x=refnode->x; 
	myrefnode.y=refnode->y; 
	myrefnode.z=refnode->z;
	refnode=&myrefnode;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	isTruePoint=FALSE; refpoly=NULL;
	CleanCursorZone(selMode,TRUE);

	sStr.Format("%d object memberships changed to another block.",objchanged);
	MessageBox(sStr);
	InvalidateRect(NULL, TRUE);
	
}

void CT3EDView::OnUpdateExportVrHSpd(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();

	pCmdUI->Enable(pDoc->spdFALoaded && pDoc->spdRALoaded && pDoc->HeightsLoaded);		
}

void CT3EDView::OnExportVrHSpd() 
{
	CT3EDDoc* pDoc = GetDocument();

	int slice=0;
	CString File, sStr;
	FILE* fout;

	File=pDoc->fileDir + "\\Vr_H_Spd.csv";

	if (pDoc->bHSMode) //NFS4
	{
		/*fout = fopen(File, "w");
		fprintf(fout, "Entries;%d;;;;;;;;;;;;;;;\n", pDoc->col.vroadHead.nrec);
		fprintf(fout, "%s\n", "Slice;VR_x;VR_y_;VR_z;VR-Left;VR-Right;L-Lane_Polys;R-Lane_Polys;WidthL-Polys;WidthR-Polys;Height;spdFA_Speed;spdFA_AI_Lane;spdFA_float;spdRA_Speed;spdRA_AI_Lane;spdRA_float");

		for (slice=0;slice<pDoc->col.vroadHead.nrec;slice++)
		{
			fprintf( fout, "%u;%f;%f;%f;%u;%u;%u;%u;%u;%u;%f;%u;%u;%f;%u;%u;%f\n", slice, 
				(float)(pDoc->col.vroad[slice].refPt.x)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536, (float)(pDoc->col.vroad[slice].refPt.z)/65536, // %f;%f;%f
				(pDoc->col.vroad[slice].leftWall / 10000), (pDoc->col.vroad[slice].rightWall / 10000), //%u;%u
				pDoc->col.hs_extra[slice].nLeftLanePolys, pDoc->col.hs_extra[slice].nRightLanePolys, //%u;%u
				(long) pDoc->col.hs_extra[slice].WidthLeftLane,  (long) pDoc->col.hs_extra[slice].WidthRightLane, //%u;%u
				pDoc->hightssim[slice].heights, // %f
				pDoc->spdFAbin[slice].Speedvalue, pDoc->spdFAbin[slice].AI_Lane, pDoc->spdFAbin[slice].AI_Float, // %u;%u;%f
				pDoc->spdRAbin[slice].Speedvalue, pDoc->spdRAbin[slice].AI_Lane, pDoc->spdRAbin[slice].AI_Float // %u;%u;%f
				);

		}*/
		fout = fopen(File, "w");
		fprintf(fout, "Entries;%d;;;;;;;;;;;;;;;;;;;;;;;;;\n", pDoc->col.vroadHead.nrec);
		fprintf(fout, "%s\n", "Slice;VR_x;VR_y_;VR_z;VR-Left;VR-Right;Shorcut1;Shorcut2;L-Lane_Polys;R-Lane_Polys;WidthL-Polys;WidthR-Polys;LanesLeftPassable;LanesRightPassable;Unknown2(L);Unknown2(R);ChromeEffect(L);ChromeEffect(R);HallEffect(L);HallEffect(R);Height;spdFA_Speed;spdFA_AI_Lane;spdFA_float;spdRA_Speed;spdRA_AI_Lane;spdRA_float");

		for (slice=0;slice<pDoc->col.vroadHead.nrec;slice++)
		{
			fprintf( fout, "%u;%f;%f;%f;%u;%u;%d;%d;%u;%u;%f;%f;%u;%u;%u;%u;%u;%u;%u;%u;%f;%u;%u;%f;%u;%u;%f\n", slice, 
				(float)(pDoc->col.vroad[slice].refPt.x)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536, (float)(pDoc->col.vroad[slice].refPt.z)/65536, // %f;%f;%f
				(pDoc->col.vroad[slice].leftWall / 10000), (pDoc->col.vroad[slice].rightWall / 10000), //%u;%u
				(short) pDoc->col.hs_extra[slice].ShortcutToVRoad[0], (short) pDoc->col.hs_extra[slice].ShortcutToVRoad[1],//%d;%d
				pDoc->col.hs_extra[slice].nLeftLanePolys, pDoc->col.hs_extra[slice].nRightLanePolys, //%u;%u
				(float) pDoc->col.hs_extra[slice].WidthLeftLane,  (float) pDoc->col.hs_extra[slice].WidthRightLane, //%f;%f
				
				pDoc->col.hs_extra[slice].LanesLeftPassable, pDoc->col.hs_extra[slice].LanesRightPassable, //%u;%u
				pDoc->col.hs_extra[slice].Unknown2[0], pDoc->col.hs_extra[slice].Unknown2[1], //%u;%u
				pDoc->col.hs_extra[slice].ChromeEffect[0], pDoc->col.hs_extra[slice].ChromeEffect[1], //%u;%u
				pDoc->col.hs_extra[slice].HallEffect[0], pDoc->col.hs_extra[slice].HallEffect[1], //%u;%u
				
				pDoc->hightssim[slice].heights, // %f
				pDoc->spdFAbin[slice].Speedvalue, pDoc->spdFAbin[slice].AI_Lane, pDoc->spdFAbin[slice].AI_Float, // %u;%u;%f
				pDoc->spdRAbin[slice].Speedvalue, pDoc->spdRAbin[slice].AI_Lane, pDoc->spdRAbin[slice].AI_Float // %u;%u;%f
				);

		}
		/*for (slice=0;slice<pDoc->col.vroadHead.nrec;slice++)
		{
			fprintf( fout, "%u;%f;%f;%f;%u;%u;%d;%d;%u;%u;%u;%u;%u;%u;%u;%u;%u;%u;%u;%u;%f;%u;%u;%f;%u;%u;%f\n", slice, 
				(float)(pDoc->col.vroad[slice].refPt.x)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536, (float)(pDoc->col.vroad[slice].refPt.z)/65536, // %f;%f;%f
				(pDoc->col.vroad[slice].leftWall / 10000), (pDoc->col.vroad[slice].rightWall / 10000), //%u;%u
				(short) pDoc->col.hs_extra[slice].ShortcutToVRoad[0], (short) pDoc->col.hs_extra[slice].ShortcutToVRoad[1],//%d;%d
				pDoc->col.hs_extra[slice].nLeftLanePolys, pDoc->col.hs_extra[slice].nRightLanePolys, //%u;%u
				(long) pDoc->col.hs_extra[slice].WidthLeftLane,  (long) pDoc->col.hs_extra[slice].WidthRightLane, //%u;%u
				
				pDoc->col.hs_extra[slice].LanesLeftPassable, pDoc->col.hs_extra[slice].LanesRightPassable, //%u;%u
				pDoc->col.hs_extra[slice].Unknown2[0], pDoc->col.hs_extra[slice].Unknown2[1], //%u;%u
				pDoc->col.hs_extra[slice].ChromeEffect[0], pDoc->col.hs_extra[slice].ChromeEffect[1], //%u;%u
				pDoc->col.hs_extra[slice].HallEffect[0], pDoc->col.hs_extra[slice].HallEffect[1], //%u;%u
				
				pDoc->hightssim[slice].heights, // %f
				pDoc->spdFAbin[slice].Speedvalue, pDoc->spdFAbin[slice].AI_Lane, pDoc->spdFAbin[slice].AI_Float, // %u;%u;%f
				pDoc->spdRAbin[slice].Speedvalue, pDoc->spdRAbin[slice].AI_Lane, pDoc->spdRAbin[slice].AI_Float // %u;%u;%f
				);

		}*/
		fprintf(fout, "End;;;;;;;;;;;;;;;;;;;;;;;;;;\n");

		fclose(fout);
		sStr.Format("VR, Heights and Speefiles with %d entries written to Vr_H_Spd.csv.", pDoc->col.vroadHead.nrec);
		MessageBox(sStr);
	}
	else  //NFS3
		{
		fout = fopen(File, "w");
		fprintf(fout, "Entries;%d;;;;;;;\n", pDoc->col.vroadHead.nrec);
		fprintf(fout, "%s\n", "Slice;VR_x;VR_y_;VR_z;Height;spdFA_Speed;spdFA_AI_Lane;spdRA_Speed;spdRA_AI_Lane");

		for (slice=0;slice<pDoc->col.vroadHead.nrec;slice++)
		{
			fprintf( fout, "%u;%f;%f;%f;%f;%u;%u;%u;%u\n", slice, //%u
				(float)(pDoc->col.vroad[slice].refPt.x)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536, (float)(pDoc->col.vroad[slice].refPt.z)/65536, // %f;%f;%f
				pDoc->hightssim[slice].heights, // %f
				pDoc->spdFAbin[slice].Speedvalue, pDoc->spdFAbin[slice].AI_Lane, // %u;%u
				pDoc->spdRAbin[slice].Speedvalue, pDoc->spdRAbin[slice].AI_Lane // %u;%u
				);
		}
		fprintf(fout, "End;;;;;;;;\n");

		fclose(fout);
		sStr.Format("VR, Heights and Speefiles with %d entries written to Vr_H_Spd.csv.", pDoc->col.vroadHead.nrec);
		MessageBox(sStr);
	}
}

void CT3EDView::OnUpdateImportVrHSpd(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();

	pCmdUI->Enable(pDoc->spdFALoaded && pDoc->spdRALoaded && pDoc->HeightsLoaded);		
}

void CT3EDView::OnImportVrHSpd()
{
	CT3EDDoc* pDoc = GetDocument();

	int slice=0, er, nr=0, i;
	CString File, sStr, In;
	bool OK=true, VRChange=false;
	FILE* fin;

	struct FLOATPT VRPt;
	unsigned long leftWall, rightWall, nLeftLanePolys, nRightLanePolys;
	short ShortcutToVRoad1,ShortcutToVRoad2;
	float heights, WidthLeftLane, WidthRightLane;
	struct SPDFILE spdFa, spdRa;
	unsigned long LanesLeftPassable, LanesRightPassable,Unknown21,Unknown22, ChromeEffect1, ChromeEffect2, HallEffect1, HallEffect2;

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	//pDoc->PrepareModifyTrk(refblock);
	pDoc->PrepareModifyVRoadHeightsSpdFiles();
	//Copy back changed data

	File=pDoc->fileDir + "\\Vr_H_Spd.csv";
	fin = fopen(File, "r");

	if (fin==NULL)
		{
		OK=false;
		AfxMessageBox("File open Error.");
		return;
		}
	else
		OK=true;

	memcpy(&myrefnode,refnode,12);
	refnode=&myrefnode;
	//No selection, to be sure noting goes wrong
	if (multisel) delete multisel; multisel=NULL;


	if (pDoc->bHSMode)
	{
		if (OK==true)
			{
			er=fscanf(fin, "Entries;%d;;;;;;;;;;;;;;;;;;;;;;;;;\n", &nr);
			if ((er!=1)|(nr!=pDoc->col.vroadHead.nrec))
				OK=false;
			}

		if (OK==true)
			{
			fscanf(fin, "%s\n", In);
			if (In!="Slice;VR_x;VR_y_;VR_z;VR-Left;VR-Right;Shorcut1;Shorcut2;L-Lane_Polys;R-Lane_Polys;WidthL-Polys;WidthR-Polys;LanesLeftPassable;LanesRightPassable;Unknown2(L);Unknown2(R);ChromeEffect(L);ChromeEffect(R);HallEffect(L);HallEffect(R);Height;spdFA_Speed;spdFA_AI_Lane;spdFA_float;spdRA_Speed;spdRA_AI_Lane;spdRA_float") OK=false;
			}

		LanesRightPassable=255;
		if (OK==true) 
			for (slice=0;slice<pDoc->col.vroadHead.nrec;slice++)
			{
				if (slice>500)
					slice=slice;
				//fscanf(fin, "%s\n", In);
				//AfxMessageBox(In);
				er=fscanf( fin, "%u;%f;%f;%f;%u;%u;%d;%d;%u;%u;%f;%f;%u;%u;%u;%u;%u;%u;%u;%u;%f;%u;%u;%f;%u;%u;%f\n", &i, 
					//(float)(pDoc->col.vroad[slice].refPt.x)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536, %f,%f,%f
					&VRPt.x, &VRPt.y, &VRPt.z, 
					//pDoc->col.vroad[slice].leftWall * 10000, pDoc->col.vroad[slice].rightWall * 10000,
					&leftWall, &rightWall,
					//(short) pDoc->col.hs_extra[slice].ShortcutToVRoad[0], (short) pDoc->col.hs_extra[slice].ShortcutToVRoad[1],//%d;%d
					&ShortcutToVRoad1, &ShortcutToVRoad2,
					//pDoc->col.hs_extra[slice].nLeftLanePolys,pDoc->col.hs_extra[slice].nRightLanePolys, //%u;%u
					&nLeftLanePolys, &nRightLanePolys,
					//pDoc->col.hs_extra[slice].WidthLeftLane,pDoc->col.hs_extra[slice].WidthRightLane, //%f;%f
					&WidthLeftLane, &WidthRightLane,

					//pDoc->col.hs_extra[slice].LanesLeftPassable, pDoc->col.hs_extra[slice].LanesRightPassable, //%u;%u
					&LanesLeftPassable, &LanesRightPassable,		
					//pDoc->col.hs_extra[slice].Unknown2[0], pDoc->col.hs_extra[slice].Unknown2[1], //%u;%u
					&Unknown21, &Unknown22,
					//pDoc->col.hs_extra[slice].ChromeEffect[0], pDoc->col.hs_extra[slice].ChromeEffect[1], //%u;%u
					&ChromeEffect1, &ChromeEffect2,
					//pDoc->col.hs_extra[slice].HallEffect[0], pDoc->col.hs_extra[slice].HallEffect[1], //%u;%u
					&HallEffect1, &HallEffect2,
					//pDoc->hightssim[slice].heights,
					&heights,
					//pDoc->spdFAbin[slice].Speedvalue, pDoc->spdFAbin[slice].AI_Lane, pDoc->spdFAbin[slice].AI_Float,
					&spdFa.Speedvalue, &spdFa.AI_Lane, &spdFa.AI_Float,
					//pDoc->spdRAbin[slice].Speedvalue, pDoc->spdRAbin[slice].AI_Lane, pDoc->spdRAbin[slice].AI_Float
					&spdRa.Speedvalue, &spdRa.AI_Lane, &spdRa.AI_Float
					);
				if (er==27) //Got all values?
				{
					//(float)(pDoc->col.vroad[slice].refPt.x)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536,
					if ((abs(pDoc->col.vroad[slice].refPt.x - (int) (VRPt.x*65536)) >1)|
						(abs(pDoc->col.vroad[slice].refPt.y - (int) (VRPt.y*65536)) >1)|
						(abs(pDoc->col.vroad[slice].refPt.z - (int) (VRPt.z*65536)) >1))
					{
						//New VRoad Position!
						pDoc->col.vroad[slice].refPt.x=(int) (VRPt.x*65536);
						pDoc->col.vroad[slice].refPt.y=(int) (VRPt.y*65536);
						pDoc->col.vroad[slice].refPt.z=(int) (VRPt.z*65536);
						VRChange=true;
					}
					//pDoc->col.vroad[slice].leftWall / 10000, pDoc->col.vroad[slice].rightWall / 10000, //%u;%u
					pDoc->col.vroad[slice].leftWall=(long) leftWall * 10000; pDoc->col.vroad[slice].rightWall= (long) rightWall * 10000;

					//(short) pDoc->col.hs_extra[slice].ShortcutToVRoad[0], (short) pDoc->col.hs_extra[slice].ShortcutToVRoad[1],//%d;%d
					pDoc->col.hs_extra[slice].ShortcutToVRoad[0]=ShortcutToVRoad1;pDoc->col.hs_extra[slice].ShortcutToVRoad[1]=ShortcutToVRoad2;

					//pDoc->col.hs_extra[slice].nLeftLanePolys,pDoc->col.hs_extra[slice].nRightLanePolys, //%u;%u
					pDoc->col.hs_extra[slice].nLeftLanePolys=(long) nLeftLanePolys; pDoc->col.hs_extra[slice].nRightLanePolys=(long) nRightLanePolys;

					//pDoc->col.hs_extra[slice].WidthLeftLane,pDoc->col.hs_extra[slice].WidthRightLane, //%f;%f
					pDoc->col.hs_extra[slice].WidthLeftLane=(float) WidthLeftLane; pDoc->col.hs_extra[slice].WidthRightLane = (float) WidthRightLane;


					//pDoc->col.hs_extra[slice].LanesLeftPassable, pDoc->col.hs_extra[slice].LanesRightPassable, //%u;%u
					pDoc->col.hs_extra[slice].LanesLeftPassable=(unsigned char) LanesLeftPassable; pDoc->col.hs_extra[slice].LanesRightPassable=(unsigned char) LanesRightPassable;
					//pDoc->col.hs_extra[slice].Unknown2[0], pDoc->col.hs_extra[slice].Unknown2[1], //%u;%u
					pDoc->col.hs_extra[slice].Unknown2[0]=(unsigned char) Unknown21, pDoc->col.hs_extra[slice].Unknown2[1]=(unsigned char) Unknown21,
					//pDoc->col.hs_extra[slice].ChromeEffect[0], pDoc->col.hs_extra[slice].ChromeEffect[1], //%u;%u
					pDoc->col.hs_extra[slice].ChromeEffect[0]=(unsigned char) ChromeEffect1, pDoc->col.hs_extra[slice].ChromeEffect[1]=(unsigned char) ChromeEffect2,
					//pDoc->col.hs_extra[slice].HallEffect[0], pDoc->col.hs_extra[slice].HallEffect[1], //%u;%u
					pDoc->col.hs_extra[slice].HallEffect[0]=(unsigned char) HallEffect1, pDoc->col.hs_extra[slice].HallEffect[1]=(unsigned char) HallEffect2,

					//pDoc->hightssim[slice].heights,
					pDoc->hightssim[slice].heights=(float) heights;
					//pDoc->spdFAbin[slice].Speedvalue, pDoc->spdFAbin[slice].AI_Lane, pDoc->spdFAbin[slice].AI_Float,
					pDoc->spdFAbin[slice].Speedvalue=(unsigned char) spdFa.Speedvalue;
					pDoc->spdFAbin[slice].AI_Lane=(unsigned char) spdFa.AI_Lane;
					pDoc->spdFAbin[slice].AI_Float=(float) spdFa.AI_Float;

					//pDoc->spdRAbin[slice].Speedvalue, pDoc->spdRAbin[slice].AI_Lane, pDoc->spdRAbin[slice].AI_Float
					pDoc->spdRAbin[slice].Speedvalue=(unsigned char) spdRa.Speedvalue;
					pDoc->spdRAbin[slice].AI_Lane=(unsigned char) spdRa.AI_Lane;
					pDoc->spdRAbin[slice].AI_Float=(float) spdRa.AI_Float;
				}
				else
				{
					OK=false;
					slice=pDoc->col.vroadHead.nrec;
				}
			}
		}
	else //NFS3
	{
		if (OK==true)
			{
			er=fscanf(fin, "Entries;%d;;;;;;;\n", &nr);
			if ((er!=1)|(nr!=pDoc->col.vroadHead.nrec))
				OK=false;
			}

		if (OK==true)
			{
			fscanf(fin, "%s\n", In);
			if (In!="Slice;VR_x;VR_y_;VR_z;Height;spdFA_Speed;spdFA_AI_Lane;spdRA_Speed;spdRA_AI_Lane") OK=false;
			}

		if (OK==true) 
			for (slice=0;slice<pDoc->col.vroadHead.nrec;slice++)
			{
				er=fscanf( fin, "%u;%f;%f;%f;%f;%u;%u;%u;%u\n", &i, 
					//(float)(pDoc->col.vroad[slice].refPt.x)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536,
					&VRPt.x, &VRPt.y, &VRPt.z, 
					//pDoc->hightssim[slice].heights,
					&heights,
					//pDoc->spdFAbin[slice].Speedvalue, pDoc->spdFAbin[slice].AI_Lane
					&spdFa.Speedvalue, &spdFa.AI_Lane,
					//pDoc->spdRAbin[slice].Speedvalue, pDoc->spdRAbin[slice].AI_Lane
					&spdRa.Speedvalue, &spdRa.AI_Lane
					);
				if (er==9) //Got all values?
				{
					//(float)(pDoc->col.vroad[slice].refPt.x)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536, (float)(pDoc->col.vroad[slice].refPt.y)/65536,
					if ((abs(pDoc->col.vroad[slice].refPt.x - (int) (VRPt.x*65536)) >5)|
						(abs(pDoc->col.vroad[slice].refPt.y - (int) (VRPt.y*65536)) >5)|
						(abs(pDoc->col.vroad[slice].refPt.z - (int) (VRPt.z*65536)) >5))
					{
						//New VRoad Position!
						pDoc->col.vroad[slice].refPt.x=(int) (VRPt.x*65536);
						pDoc->col.vroad[slice].refPt.y=(int) (VRPt.y*65536);
						pDoc->col.vroad[slice].refPt.z=(int) (VRPt.z*65536);
						VRChange=true;
					}

					//pDoc->hightssim[slice].heights,
					pDoc->hightssim[slice].heights=(float) heights;
					//pDoc->spdFAbin[slice].Speedvalue, pDoc->spdFAbin[slice].AI_Lane
					pDoc->spdFAbin[slice].Speedvalue=(unsigned char) spdFa.Speedvalue;
					pDoc->spdFAbin[slice].AI_Lane=(unsigned char) spdFa.AI_Lane;

					//pDoc->spdRAbin[slice].Speedvalue, pDoc->spdRAbin[slice].AI_Lane
					pDoc->spdRAbin[slice].Speedvalue=(unsigned char) spdRa.Speedvalue;
					pDoc->spdRAbin[slice].AI_Lane=(unsigned char) spdRa.AI_Lane;
				}
				else
				{
					OK=false;
					slice=pDoc->col.vroadHead.nrec;
				}
			}
	}

	fclose(fin);

	if (OK==false) 
	{
		sStr.Format("VR, Heights and Speefiles import failed. (Slice %d)", slice);
		AfxMessageBox("VR, Heights and Speefiles import failed.",MB_ICONWARNING);
		pDoc->PerformUndo(false);
		InvalidateRect(NULL,TRUE);
	}
	else
	{
		sStr.Format("VR, Heights and Speefiles with %d entries imported from Vr_H_Spd.csv.", pDoc->col.vroadHead.nrec);
		if (VRChange)
		{
			sStr.Format("VRoad position has been changed. Rearange track to new VRoad?");
			if (AfxMessageBox(sStr,MB_YESNO)==IDYES)
				pDoc->MoveBlocks(-2,0,0,0,0,0,4); // Rearrange vertices from whole track to new vroad
		}
		else
			MessageBox(sStr,"T3ED",MB_ICONINFORMATION);

		sStr.Format("Recalc AI_Lanes of speedfiles?/n/n It can be necessary if float or width values have changed.");
		if (AfxMessageBox(sStr,MB_YESNO)==IDYES)
		{
			for (i=0;i<pDoc->col.vroadHead.nrec;i++)
			{
				//No move just, recalc AI lanes
				pDoc->MoveObjectBy(-1, 6, 0, i, 0, 0, 0, 1, 1); //Forward Speed File
				pDoc->MoveObjectBy(-1, 6, 0, i, 0, 0, 0, 1, 0); //Backward Speed File
			}

		}

		//Always Update view after import.
		InvalidateRect(NULL,TRUE);
	}
}

void CT3EDView::OnUpdateViewShowcams(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	pCmdUI->Enable(pDoc->CamsLoaded && bShowObjects);
	pCmdUI->SetCheck(bShowCams && bShowObjects && pDoc->CamsLoaded);
}

void CT3EDView::OnViewShowcams() 
{
	bShowCams=!bShowCams;
	InvalidateRect(NULL,!bShowCams);
}

void CT3EDView::OnUpdateToolsCamedit(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	pCmdUI->Enable(pDoc->CamsLoaded);
}

void CT3EDView::OnToolsCamedit() 
{
	CT3EDDoc* pDoc = GetDocument();
	CString sStr="";

	CCameraProps CamProp;
	CamProp.nCams=pDoc->Camfile.nCams;
	CamProp.SelectedCam=0;
	CamProp.pCamData=(struct CAMDATA *)malloc(CamProp.nCams * sizeof(struct CAMDATA)); //Get memory to store cameras
	memcpy(CamProp.pCamData, pDoc->Camfile.pCamData, CamProp.nCams * sizeof(struct CAMDATA));
	CamProp.col_nrec=pDoc->col.vroadHead.nrec;
	CamProp.vroad=pDoc->col.vroad;
	/*sStr.Format("Slice Numbers (0-%d):", CamProp.col_nrec);
	CamProp.m_text_slice=sStr;'*/

	if (CamProp.DoModal()!=IDOK) return;

	OnModeObject(); //Auto enable object mode
	bShowCams=TRUE; //Show Replay Cams

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	pDoc->PrepareModifyCameras();

	pDoc->Camfile.nCams=CamProp.nCams; //New Number of Cams?
	pDoc->Camfile.pCamData=(struct CAMDATA *)realloc(pDoc->Camfile.pCamData, pDoc->Camfile.nCams * sizeof(struct CAMDATA)); //Get memory to store cameras
	memcpy(pDoc->Camfile.pCamData, CamProp.pCamData, CamProp.nCams * sizeof(struct CAMDATA));  //Store changed data

	if ((bShowCams)&&(selMode==ID_MODE_OBJECT))
	{
		if (multisel) delete multisel; multisel=NULL;
		objno=pDoc->SortCams(CamProp.SelectedCam); //New selection?
		isxobj=5;
		refchunk=0;
		myrefnode=pDoc->Camfile.pCamData[objno].CamPosition;
		refblock=pDoc->FindNearestBlock(&myrefnode);
		refnode=&myrefnode;
		sStr.Format("Replay Camera %d selected", (objno + 1));	//+1 to Show same number as Nappe's CamEdit tool
		statusbar->SetPaneText(0,sStr,TRUE);
	}
	dofree(CamProp.pCamData);
	InvalidateRect(NULL,TRUE);

}

void CT3EDView::PolygonShading()
{
	if (refpoly==NULL) return;
	CT3EDDoc* pDoc = GetDocument();
	CSelData *sel;
	CPolyShade PolyShade;

	int i;
	struct FLOATPT pt;
	struct BGRA shade1;
	//struct TRKBLOCK *t;
	struct XOBJDATA *x;

	//Find BGRA of first point
	sel=this;
	if (isxobj==0)
	{
		//t=&(pDoc->trk[refblock]);
		//i=sel->refpoly->vertex[0];
		shade1=pDoc->trk[refblock].vertshade[sel->refpoly->vertex[0]];
		//shade1=&t->vertshade(sel->refpoly->vertex[0]);

	}
	else if (isxobj==1)
	{
		i=sel->refpoly->vertex[0];
		x=pDoc->xobj[4*refblock + refchunk].obj;
		shade1=x->vertshade[i];
	}

	PolyShade.shade=shade1;
	if (PolyShade.DoModal()!=IDOK) return;

	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety); //undo should be possible
	shade1=PolyShade.shade;
	//Loop for all vertices
	for (sel=this;sel!=NULL;sel=sel->multisel) 
	{
		for (i=0;i<4;i++) 
		{
			memcpy(&pt,	sel->refvertices + sel->refpoly->vertex[i],12);
			if (sel->isxobj) 
			{ 
				pt.x+=sel->refnode->x;
				pt.y+=sel->refnode->y;
				pt.z+=sel->refnode->z;
			}
			pDoc->SetVertShade(sel->refblock,&pt,shade1); //Now working also on neighbour blocks!
		}
	}

}

void CT3EDView::OnVisFwIncrease() 
{
	CT3EDDoc* pDoc = GetDocument();

	if ((ShowBasedOnVisi)&&(isxobj!=5))  //Only in Show Based on Visibility Mode, and Block Mode
	{
		pDoc->InDecreaseVis(refblock,1,1); //Add a visible block
		pDoc->bUpdatedScene=FALSE;  //Mark Trackpreview as invalid
		InvalidateRect(NULL,TRUE);	//Update View
	}	
}

void CT3EDView::OnVisFwDecrease() 
{
	CT3EDDoc* pDoc = GetDocument();

	if ((ShowBasedOnVisi)&&(isxobj!=5))  //Only in Show Based on Visibility Mode, and Block Mode
	{
		pDoc->InDecreaseVis(refblock,1,-1);
		pDoc->bUpdatedScene=FALSE;
		InvalidateRect(NULL,TRUE);	
	}
}

void CT3EDView::OnVisBwIncrease() 
{
	CT3EDDoc* pDoc = GetDocument();

	if ((ShowBasedOnVisi)&&(isxobj!=5)) //Only in Show Based on Visibility Mode, and Block Mode
	{
		pDoc->InDecreaseVis(refblock,-1,1);
		pDoc->bUpdatedScene=FALSE;
		InvalidateRect(NULL,TRUE);	
	}
}

void CT3EDView::OnVisBwDecrease() 
{
	CT3EDDoc* pDoc = GetDocument();

	if ((ShowBasedOnVisi)&&(isxobj!=5))  //Only in Show Based on Visibility Mode, and Block Mode
	{
		pDoc->InDecreaseVis(refblock,-1,-1);
		pDoc->bUpdatedScene=FALSE;
		InvalidateRect(NULL,TRUE);
	}
}

void CT3EDView::OnPgDown() 
{
	CT3EDDoc* pDoc = GetDocument();

	if ((isxobj==5)&&(objno>-1)&&(objno<pDoc->Camfile.nCams)) //Decrease cameras end slice?
	{
		pDoc->Camfile.pCamData[objno].Stop=pDoc->RealSliceNum(pDoc->Camfile.pCamData[objno].Stop -1);
		InvalidateRect(NULL,TRUE);	//Update View
	}
	else
		OnVisFwDecrease();
}

void CT3EDView::OnPgDownAlt() 
{
	CT3EDDoc* pDoc = GetDocument();

	if ((isxobj==5)&&(objno>-1)&&(objno<pDoc->Camfile.nCams)) //Increase cameras start slice?
	{
		pDoc->Camfile.pCamData[objno].Start=pDoc->RealSliceNum(pDoc->Camfile.pCamData[objno].Start +1);
		InvalidateRect(NULL,TRUE);	//Update View
	}
	else
		OnVisBwDecrease();
}

void CT3EDView::OnPgUp() 
{
	CT3EDDoc* pDoc = GetDocument();

	if ((isxobj==5)&&(objno>-1)&&(objno<pDoc->Camfile.nCams)) //Increase cameras end slice?
	{
		pDoc->Camfile.pCamData[objno].Stop=pDoc->RealSliceNum(pDoc->Camfile.pCamData[objno].Stop +1);
		InvalidateRect(NULL,TRUE);	//Update View
	}
	else
		OnVisFwIncrease();
}

void CT3EDView::OnPgUpAlt() 
{
	CT3EDDoc* pDoc = GetDocument();

	if ((isxobj==5)&&(objno>-1)&&(objno<pDoc->Camfile.nCams)) //Increase cameras start slice?
	{
		pDoc->Camfile.pCamData[objno].Start=pDoc->RealSliceNum(pDoc->Camfile.pCamData[objno].Start -1);
		InvalidateRect(NULL,TRUE);	//Update View
	}
	else
		OnVisBwIncrease();

}


void CT3EDView::OnPasteZ() 
{
	OnEditPasteZ();
}

void CT3EDView::OnUpdateEditPasteZ(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((selMode==ID_MODE_POINT)&&!isEmpty);
}

void CT3EDView::OnEditPasteZ() 
{
	// Paste Z
	CT3EDDoc *pDoc=GetDocument(); 
	CSelData *sel;
	FLOATPT ClipPt;
	CString sStr;
	float MoveAmountZ;

	CString Clip = "";
	//What is on Clipboard and change mode if needed
	Clip = pDoc->GetClipboardText(); // Returns "Block", "Object", "VRoad", "Camera" or nothing
	if (!(Clip=="FloatPt")) return;

	pDoc->GetXYZfromClipboard(&ClipPt);
	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	pDoc->PrepareModifyTrk(refblock);

	sStr.Format("Paste height Z:%f.",refnode->z);
	statusbar->SetPaneText(0,sStr,TRUE);

	if (selMode==ID_MODE_POINT) // Only for Point mode
	{
		if (multisel) // Paste XY for more than one point
		{
			{
				for (sel=this;sel!=NULL;sel=sel->multisel)
				{
					MoveAmountZ=-1*(sel->refnode->z - ClipPt.z);
					pDoc->MovePointBy(sel->refnode,0,0,MoveAmountZ);
				}
			}
		}
		else // Paste XY for one point
		{
			MoveAmountZ=-1*(refnode->z - ClipPt.z);
			pDoc->MovePointBy(refnode,0,0,MoveAmountZ);
		}
	}
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnUpdateToolsDrop(CCmdUI* pCmdUI) //Shortcut Alt + D
{
	pCmdUI->Enable(!isEmpty&&
		(((selMode==ID_MODE_OBJECT)&&(bShowObjects)) |
		((selMode==ID_MODE_POINT)&&(isTruePoint)) |
		((selMode==ID_MODE_VROADEDIT)&&(objno>-1)) |
		((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL))));
}

void CT3EDView::OnToolsDrop() //Shortcut Alt + D
{
	OnToolsdrop();
}

void CT3EDView::OnUpdateToolsdrop(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty&&
		(((selMode==ID_MODE_OBJECT)&&(bShowObjects))|
		((selMode==ID_MODE_POINT)&&(isTruePoint)) |
		((selMode==ID_MODE_VROADEDIT)&&(objno>-1)) |
		((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL))));
}

void CT3EDView::OnToolsdrop() 
{
	CT3EDDoc *pDoc=GetDocument();
	CSelData *sel;
	int i;
	float z;
	struct FLOATPT *v, tmppt;

	if (selMode==ID_MODE_POINT)
	{
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		for (sel=this;sel!=NULL;sel=sel->multisel) 
		{
			tmppt.x=sel->refnode->x;tmppt.y=sel->refnode->y;tmppt.z=sel->refnode->z;
			z=pDoc->FindZonRoad(sel->refblock,tmppt, FALSE);
			pDoc->MovePointBy(sel->refnode,0,0,z - tmppt.z);
			sel->refnode->z=z;
		}
		InvalidateRect(NULL,TRUE);
	}

	if (selMode==ID_MODE_POLYGON)
	{
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		for (sel=this;sel!=NULL;sel=sel->multisel) 
		{
			if (sel->refchunk==6) //Drop Lane polygons
			{
				pDoc->PrepareModifyTrk(sel->refblock);
				for (i=0;i<4;i++) //loop for the four vertices
				{
					v=&pDoc->trk[sel->refblock].vert[sel->refpoly->vertex[i]];
					tmppt.x=v->x;tmppt.y=v->y;tmppt.z=v->z;
					tmppt.z=pDoc->FindZonRoad(sel->refblock,tmppt, FALSE) + (float) 0.025;
					v->z=tmppt.z;  //Set z
				}
			}
		}
		InvalidateRect(NULL,TRUE);
	}
	if (((selMode==ID_MODE_OBJECT)|(selMode==ID_MODE_VROADEDIT))&&(objno>-1))
	{
		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
		for (sel=this;sel!=NULL;sel=sel->multisel) 
		{
			pDoc->DropObject(sel->refblock,sel->isxobj,sel->refchunk,sel->objno);
		}
		InvalidateRect(NULL,TRUE);
	}
}


void CT3EDView::OnUpdateToolsAddLight(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((!isEmpty) && ( ((selMode==ID_MODE_EXTPOINT)&&(isTruePoint)) |
								   ((selMode==ID_MODE_POINT)&&(isTruePoint)) |
								   ((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL)) |
								   ((selMode==ID_MODE_OBJECT)&&(objno>-1))
								   ));
}

void CT3EDView::OnToolsAddLight() 
{

	CT3EDDoc* pDoc = GetDocument();
	CSelData *sel;
	struct FLOATPT pt, ptx, *v;
	int i;
	struct LIGHTDATA *ALLLData, LData;
	CSoundLightProps ts;
	unsigned char Bytes[4];

	if ( ((selMode==ID_MODE_EXTPOINT)&&(isTruePoint)) | ((selMode==ID_MODE_POINT)&&(isTruePoint)) | ((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL)) | ((selMode==ID_MODE_OBJECT)&&(objno>-1)))
	{
		//Collect All track glows
		int nLights=0;
		memset(&LData, 0, sizeof(LIGHTDATA)); //Clear all
		do
		{
			LData=pDoc->GetLightData(nLights);
			if (LData.intensity > -1)
			{
				if (nLights==0)
					ALLLData=(struct LIGHTDATA *)malloc(sizeof(struct LIGHTDATA));
				else
					ALLLData=(struct LIGHTDATA *)realloc(ALLLData, sizeof(struct LIGHTDATA)*(1+nLights));
				memcpy(&ALLLData[nLights], &LData, sizeof(struct LIGHTDATA));
				nLights++;
			}
		} while (LData.intensity > -1);

		ts.bSLAutoObjMem=FALSE;
		ts.bIsLight=true;
		ts.AllLightsData=ALLLData;
		ts.nLights=nLights;
		ts.m_strText1="Set light/special effect source data here. Numbers from 0 to 31 are usually lights, that can be seleted by the combobox. Look at Tr(N).ini, [track glows] section. Higher numbers are special effects.";
		ts.m_Byte1=0; //Light type 1
		ts.m_Byte2=0;
		ts.m_Byte3=0;
		ts.m_Byte4=0;
		ts.bAddMode=TRUE;
		ts.m_Byte1hex="01";
		ts.m_intBlock=refblock;
		ts.maxblock=(pDoc->nBlocks-1);

		if (ts.DoModal()!=IDOK) return;

		Bytes[0]=ts.m_Byte1;
		Bytes[1]=ts.m_Byte2;
		Bytes[2]=ts.m_Byte3;
		Bytes[3]=ts.m_Byte4;

		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);

		for (sel=this;sel!=NULL;sel=sel->multisel)
		{
			pDoc->PrepareModifyTrk(sel->refblock);
			if ( (selMode==ID_MODE_EXTPOINT) | (selMode==ID_MODE_POINT) )
				pDoc->AddLight(sel->refblock, sel->refnode, Bytes);  //Add light on point position
			else if (selMode==ID_MODE_POLYGON)
			{
				pt.x=0;pt.y=0;pt.z=0;
				for (i=0;i<4;i++) //The four points
				{
					if (sel->isxobj==0) //Add positions of polygons
					{
						v=&pDoc->trk[sel->refblock].vert[sel->refpoly->vertex[i]];
					    pt.x+=v->x; pt.y+=v->y; pt.z+=v->z;
					}
					else if (sel->isxobj==1) //Add positions of X-Obj polygons
					{
						memcpy(&ptx, sel->refvertices + sel->refpoly->vertex[i],12);
						pt.x+=ptx.x + sel->refnode->x; pt.y+=ptx.y + sel->refnode->y; pt.z+=ptx.z + sel->refnode->z;
					}
				}
				pt.x=pt.x/4;pt.y=pt.y/4;pt.z=pt.z/4; //Four points added, calculate the middle
				pDoc->AddLight(sel->refblock, &pt, Bytes);  //Add light on point position
			}
			else if (selMode==ID_MODE_OBJECT)
			{
				pDoc->FindObjMinMax(sel->refblock,sel->isxobj,sel->refchunk,sel->objno);
				pDoc->AddLight(sel->refblock, &pDoc->MemObjMiddle, Bytes);  //Add light on objects middle 
			}
		}
		dofree(ALLLData);
		InvalidateRect(NULL,TRUE);
	}

}

void CT3EDView::OnUpdateToolsAddSound(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable((!isEmpty) && ( ((selMode==ID_MODE_EXTPOINT)&&(isTruePoint)) |
								   ((selMode==ID_MODE_POINT)&&(isTruePoint)) |
								   ((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL)) |
								   ((selMode==ID_MODE_OBJECT)&&(objno>-1))
								   ));
}

void CT3EDView::OnToolsAddSound() 
{
	CT3EDDoc* pDoc = GetDocument();
	CSelData *sel;
	struct FLOATPT pt, ptx, *v;
	int i;
	unsigned char Bytes[4];
	if ( ((selMode==ID_MODE_EXTPOINT)&&(isTruePoint)) | ((selMode==ID_MODE_POINT)&&(isTruePoint)) | ((selMode==ID_MODE_POLYGON)&&(refpoly!=NULL)) | ((selMode==ID_MODE_OBJECT)&&(objno>-1)))
	{
		CSoundLightProps ts;
		ts.m_strText1="Set sound source data here.";
		ts.bIsLight=false;
		ts.m_Byte1=1; //Sound type 1
		ts.m_Byte2=0;
		ts.m_Byte3=0;
		ts.m_Byte4=0;
		ts.bAddMode=TRUE;
		ts.m_Byte1hex="01";
		ts.m_intBlock=refblock;
		ts.maxblock=(pDoc->nBlocks-1);

		if (ts.DoModal()!=IDOK) return;

		Bytes[0]=ts.m_Byte1;
		Bytes[1]=ts.m_Byte2;
		Bytes[2]=ts.m_Byte3;
		Bytes[3]=ts.m_Byte4;

		pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);

		for (sel=this;sel!=NULL;sel=sel->multisel)
		{
			pDoc->PrepareModifyTrk(sel->refblock);
			if ( (selMode==ID_MODE_EXTPOINT) | (selMode==ID_MODE_POINT) )
				pDoc->AddSound(sel->refblock, sel->refnode, Bytes);  //Add sound on point position
			
			else if (selMode==ID_MODE_POLYGON)
			{

				pt.x=0;pt.y=0;pt.z=0;
				for (i=0;i<4;i++) //The four points
				{
					if (sel->isxobj==0) //Add positions of polygons
					{
						v=&pDoc->trk[sel->refblock].vert[sel->refpoly->vertex[i]];
					    pt.x+=v->x; pt.y+=v->y; pt.z+=v->z;
					}
					else if (sel->isxobj==1) //Add positions of X-Obj polygons
					{
						memcpy(&ptx, sel->refvertices + sel->refpoly->vertex[i],12);
						pt.x+=ptx.x + sel->refnode->x; pt.y+=ptx.y + sel->refnode->y; pt.z+=ptx.z + sel->refnode->z;
					}
				}
				pt.x=pt.x/4;pt.y=pt.y/4;pt.z=pt.z/4; //Four points added, calculate the middle
				pDoc->AddSound(sel->refblock, &pt, Bytes);  //Add light on point position
			}
			else if (selMode==ID_MODE_OBJECT)
			{
				pDoc->FindObjMinMax(sel->refblock,sel->isxobj,sel->refchunk,sel->objno);
				pDoc->AddSound(sel->refblock, &pDoc->MemObjMiddle, Bytes);  //Add light on objects middle 
			}
		}
		InvalidateRect(NULL,TRUE);
	}
}

void CT3EDView::OnUpdateViewSpdFw(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	pCmdUI->Enable(!isEmpty&&pDoc->spdFALoaded&&pDoc->spdRALoaded);
	pCmdUI->SetCheck((ShowFwSPD)&&!isEmpty);	
}

void CT3EDView::OnUpdateViewSpdBw(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	pCmdUI->Enable(!isEmpty&&pDoc->spdFALoaded&&pDoc->spdRALoaded);
	pCmdUI->SetCheck((!ShowFwSPD)&&!isEmpty);
}

void CT3EDView::OnViewSpdFw() 
{
	ShowFwSPD=true;
	InvalidateRect(NULL,TRUE);
}


void CT3EDView::OnViewSpdBw() 
{
	ShowFwSPD=false;
	InvalidateRect(NULL,TRUE);
}

struct INTPT CT3EDView::AI_Intpt(int no)
{
	CT3EDDoc* pDoc = GetDocument();
	struct INTPT ipt;

	ipt.x=0;
	ipt.y=0;
	ipt.z=0;
	if (ShowFwSPD)
	{
		ipt.x=(long) (pDoc->col.vroad[no].refPt.x + pDoc->col.vroad[no].right.x * pDoc->spdFAbin[no].AI_Float * 512);
		ipt.y=(long) (pDoc->col.vroad[no].refPt.y + pDoc->col.vroad[no].right.y * pDoc->spdFAbin[no].AI_Float * 512);
		ipt.z=(long) (pDoc->col.vroad[no].refPt.z + pDoc->col.vroad[no].right.z * pDoc->spdFAbin[no].AI_Float * 512);
	}
	else
	{
		ipt.x=(long) (pDoc->col.vroad[no].refPt.x + pDoc->col.vroad[no].right.x * pDoc->spdRAbin[no].AI_Float * 512);
		ipt.y=(long) (pDoc->col.vroad[no].refPt.y + pDoc->col.vroad[no].right.y * pDoc->spdRAbin[no].AI_Float * 512);
		ipt.z=(long) (pDoc->col.vroad[no].refPt.z + pDoc->col.vroad[no].right.z * pDoc->spdRAbin[no].AI_Float * 512);
	}
	return ipt;
}


void CT3EDView::OnViewPolyvroad() 
{
	DrawPolyVRoad=!DrawPolyVRoad;
	
}

void CT3EDView::OnUpdateViewPolyvroad(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	pCmdUI->Enable(!isEmpty && pDoc->bHSMode);
	pCmdUI->SetCheck(DrawPolyVRoad&&!isEmpty);
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::SelCorrectAfterPolyAdd(int block, int chunk, int isxobj, int polyobj, int newpolyno, bool IsLast)
{
	CT3EDDoc* pDoc = GetDocument();
	CSelData *sel;
	struct XOBJDATA *x;

	for (sel=this;sel!=NULL;sel=sel->multisel) 
	{
		if (polyobj==-1) //Trackblock poly was added / inserted
		{
			if ((!sel->isxobj) && (sel->refpolyobj==-1)) //Trackblock Polygon in selection
			{
				//if ((sel->refblock==block) && (sel->refpolyno>=newpolyno)) //Track poly inserted before this track poly
				if ((sel->refblock==block) && (sel->refchunk==chunk) && ((sel->refpolyno>newpolyno) | ((sel->refpolyno==newpolyno) && IsLast))) //Track poly inserted before this track poly
					sel->refpolyno++;
				sel->refpoly=pDoc->poly[sel->refblock].poly[sel->refchunk]+sel->refpolyno;
				sel->refvertices=pDoc->trk[sel->refblock].vert;
				sel->refnode=sel->refvertices+sel->refpoly->vertex[0];
			}
		}
		else //Object poly was added
		{
			if (sel->isxobj) //Select new created xobj polygon
				{
					x=pDoc->xobj[4*sel->refblock + sel->refchunk].obj + sel->refpolyobj;
					sel->refpoly=x->polyData + sel->refpolyno;
					sel->refvertices=x->vert;
					sel->refnode=&(x->ptRef);
				} 
				else 
				{
					if (sel->refpolyobj==-1) //Select Track Polygon?
						sel->refpoly=pDoc->poly[sel->refblock].poly[sel->refchunk]+sel->refpolyno;
					else 
						sel->refpoly=pDoc->poly[sel->refblock].obj[sel->refchunk].poly[sel->refpolyobj]+sel->refpolyno;
					sel->refvertices=pDoc->trk[sel->refblock].vert;
					sel->refnode=sel->refvertices + sel->refpoly->vertex[0];
				}
		}
	}
}

void CT3EDView::OnUpdateToolsAddFence(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
}

void CT3EDView::OnToolsAddFence() 
{
	CT3EDDoc* pDoc = GetDocument();
	//CSelData *sel;

	if (isDragging) return; // safety
	CleanCursorZone(selMode,FALSE);
	selMode=ID_MODE_POLYGON;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	isTruePoint=FALSE; objno=-1;
	editMode=NULL;
	CleanCursorZone(selMode,TRUE);

	//New Fence 
	//sel=this;
	refpolyno=pDoc->NewFence(refblock, nDetail+1, pDoc->settings.fencetexture);
	if (refpolyno<0) return;
	refchunk=nDetail+1;
	refpolyobj=-1;
	isxobj=0;
	refpoly=pDoc->poly[refblock].poly[refchunk]+refpolyno;
	refvertices=pDoc->trk[refblock].vert;
	refnode=refvertices + refpoly->vertex[0];

	OnToolsTexture();  //Select texture
	pDoc->settings.fencetexture=refpoly->texture;

	offsetx=0; offsety=0;
	InvalidateRect(NULL,true);

}

bool CT3EDView::IsNewSelection(SELINFO FSel)
{
	CSelData *sel;
	//sel=this;
	for (sel=this;sel!=NULL;sel=sel->multisel)
	{

		switch(selMode)
		{
			case ID_MODE_POINT:
			case ID_MODE_EXTPOINT:
				if (FSel.isxobj) //xobj point
				{
					if ((sel->refnode->x==FSel.myrefnode.x)&&(sel->refnode->y==FSel.myrefnode.y)&&(sel->refnode->z==FSel.myrefnode.z))
						return false;
				}
				else //track point
					if (sel->refnode==FSel.refnode)
						return false;
			break;

			case ID_MODE_POLYGON:
				if ((sel->refblock==FSel.refblock)&&
					(sel->refchunk==FSel.refchunk)&&
					(sel->refpolyobj==FSel.objno)&&
					(sel->refpolyno==FSel.refpolyno)&&
					(sel->isxobj==FSel.isxobj)&&
					(sel->refpoly==FSel.refpoly))
					return false;

			break;

			case ID_MODE_OBJECT:
			case ID_MODE_VROADEDIT:
				if ((sel->refblock==FSel.refblock)&&(sel->refchunk==FSel.refchunk)&&(sel->isxobj==FSel.isxobj)&&(sel->objno==FSel.objno))
					return false;
			break;
		}
	}
	return true;
}

void CT3EDView::SelectPolygon(CPoint point, struct SELINFO *FSel)
{
	//int blk, i,j,k,l,n,x,y,dist,dist0=1<<30,x0,y0,TrackViewBl;  //l0  still used for number of seleted point
	int blk, i,j,k,l,n,x,y,dist,dist0=50,x0,y0,TrackViewBl;  //l0  still used for number of seleted point
	RECT rect;
	CT3EDDoc *pDoc=GetDocument();
	struct FLOATPT *pt;
	struct XOBJDATA *xx;
	LPPOLYGONDATA p;
	struct OBJPOLYBLOCK *o;
	vec3 mypt;
	bool ScrollKey=(GetKeyState(VK_SCROLL) & 0x0001);

	TrackViewBl=refblock; //Use nearest block if refblock is global
	if (TrackViewBl==pDoc->nBlocks)
		TrackViewBl=pDoc->FindNearestBlock(refnode);

	GetClientRect(&rect);
	rect.left=point.x-10; rect.right=point.x+10;
	rect.top=point.y-10; rect.bottom=point.y+10;

	for (i=0;i<pDoc->nBlocks;i++) 
	{
		if (ScrollKey && (i!=TrackViewBl)) continue; //Scroll Lock active ? Then select only from current block
		if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
		if ((ShowBasedOnVisi)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) continue;
		pt=pDoc->trk[i].vert;
		if (bShowTrackBlocks){//Visible trackblocks / fences ?
			for (k=nDetail;k<nDetail+2;k++) { //Check trackblock & fence chunks
				p=pDoc->poly[i].poly[k];
				n=pDoc->poly[i].sz[k];
				for (j=0;j<n;j++,p++) {
					mypt=pt[p->vertex[0]];
					mypt+=pt[p->vertex[1]];
					mypt+=pt[p->vertex[2]];
					mypt+=pt[p->vertex[3]];
					mypt*=0.25;
					x=Vec3X(mypt);
					y=Vec3Y(mypt);
					dist=((x>point.x)?(x-point.x):(point.x-x))
						+((y>point.y)?(y-point.y):(point.y-y));
					if (dist<dist0) {
						FSel->refblock=i; x0=x; y0=y; FSel->trackkpoly=true;
						FSel->refchunk=k; FSel->objno=-1; FSel->refpolyno=j;
						dist0=dist; FSel->refpoly=p; FSel->refvertices=pt; FSel->isxobj=0;
						memcpy(&FSel->myrefnode, &mypt, sizeof(vec3));
						FSel->refnode=&FSel->myrefnode;
					}
				}
			}
		}
		if (bShowLanes){//Visible lanes ?
			p=pDoc->poly[i].poly[6]; //Lane chunk is 6
			n=pDoc->poly[i].sz[6];
			for (j=0;j<n;j++,p++) {
				mypt=pt[p->vertex[0]];
				mypt+=pt[p->vertex[1]];
				mypt+=pt[p->vertex[2]];
				mypt+=pt[p->vertex[3]];
				mypt*=0.25;
				x=Vec3X(mypt);
				y=Vec3Y(mypt);
				dist=((x>point.x)?(x-point.x):(point.x-x))
					+((y>point.y)?(y-point.y):(point.y-y));
				if (dist<dist0) {
					FSel->refblock=i; x0=x; y0=y; FSel->trackkpoly=true;
					FSel->refchunk=k; FSel->objno=-1; FSel->refpolyno=j;
					dist0=dist; FSel->refpoly=p; FSel->refvertices=pt; FSel->isxobj=0;
					memcpy(&FSel->myrefnode, &mypt, sizeof(vec3));
					FSel->refnode=&FSel->myrefnode;
				}
			}
		}
	}

	if (bShowObjects) 
	{
		for (i=0;i<pDoc->nBlocks;i++) { //Select polygon from blue object
			if (ScrollKey && (i!=TrackViewBl)) continue; //Scroll Lock active ? Then select only from current block
			if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
			if ((ShowBasedOnVisi)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) continue;
			pt=pDoc->trk[i].vert;
			for (j=0;j<4;j++) {
				o=&(pDoc->poly[i].obj[j]);
				if (o->n1==0) continue;
				for (k=0;k<o->nobj;k++) {
					p=o->poly[k];
					n=o->numpoly[k];
					for (l=0;l<n;l++,p++) {
						mypt=pt[p->vertex[0]];
						mypt+=pt[p->vertex[1]];
						mypt+=pt[p->vertex[2]];
						mypt+=pt[p->vertex[3]];
						mypt*=0.25;
						x=Vec3X(mypt);
						y=Vec3Y(mypt);
						dist=((x>point.x)?(x-point.x):(point.x-x))
							+((y>point.y)?(y-point.y):(point.y-y));
						if (dist<dist0) {
							FSel->refblock=i; x0=x; y0=y; FSel->trackkpoly=false;
							FSel->refchunk=j; FSel->objno=k; FSel->refpolyno=l;
							dist0=dist; FSel->refpoly=p; FSel->refvertices=pt; FSel->isxobj=0;
							memcpy(&FSel->myrefnode, &mypt, sizeof(vec3));
							FSel->refnode=&FSel->myrefnode;
						}
					}
				}
			}
		}
		for (i=0;i<(2 + 4*pDoc->nBlocks);i++) { //Select Extra oder Global object Polygon
			blk=(int) i/4;
			if (!MeetsClipRect(&(pDoc->trk[blk]),&rect)) continue;
			if (ScrollKey && (i!=blk)) continue; //Scroll Lock active ? Then select only from current block
			//if (!MeetsClipRect(&(pDoc->trk[i/4]),&rect)) { i=i|3; continue; }
			//if ((i!=4*pDoc->nBlocks)&&(i!=1+4*pDoc->nBlocks)&&(!MeetsClipRect(&(pDoc->trk[i/4]),&rect))) { i=i|3; continue; } //Select also global objects
			if ((ShowBasedOnVisi)&&(blk!=pDoc->nBlocks)&&(!pDoc->IsBlockVisibile(TrackViewBl,int(i/4)))) continue;
			xx=pDoc->xobj[i].obj;
			for (j=0;j<pDoc->xobj[i].nobj;j++,xx++) {
				pt=xx->vert;
				p=xx->polyData;
				for (k=0;k<xx->nPolygons;k++,p++) {
					mypt=pt[p->vertex[0]];
					mypt+=pt[p->vertex[1]];
					mypt+=pt[p->vertex[2]];
					mypt+=pt[p->vertex[3]];
					mypt*=0.25;
					mypt+=xx->ptRef;
					x=Vec3X(mypt);
					y=Vec3Y(mypt);
					x=(FloatFloatX(pt[p->vertex[0]],xx->ptRef)+FloatFloatX(pt[p->vertex[1]],xx->ptRef)
					  +FloatFloatX(pt[p->vertex[2]],xx->ptRef)+FloatFloatX(pt[p->vertex[3]],xx->ptRef))/4;
					y=(FloatFloatY(pt[p->vertex[0]],xx->ptRef)+FloatFloatY(pt[p->vertex[1]],xx->ptRef)
					  +FloatFloatY(pt[p->vertex[2]],xx->ptRef)+FloatFloatY(pt[p->vertex[3]],xx->ptRef))/4;
					dist=((x>point.x)?(x-point.x):(point.x-x))
						+((y>point.y)?(y-point.y):(point.y-y));
					if (dist<dist0) {
						FSel->refblock=i/4; x0=x; y0=y; FSel->trackkpoly=false;
						FSel->refchunk=i%4; FSel->objno=j; FSel->refpolyno=k;
						dist0=dist; FSel->refpoly=p; FSel->refvertices=pt; 
						FSel->isxobj=1; FSel->coreref=&(xx->ptRef);
						memcpy(&FSel->myrefnode, &mypt, sizeof(vec3));
						FSel->refnode=&FSel->myrefnode;
					}
				}
			}
		}
	}
	if (FSel->isxobj) 
	{
		pt=FSel->coreref;
		FSel->refnode=pt;
	}
}

void CT3EDView::SelectPoint(CPoint point, SELINFO *FSel)
{
	//int ch, i,j,k,l,n,x,y,dist,dist0=1<<30,x0,y0,TrackViewBl;  //l0  still used for number of seleted point
	int ch, i,j,k,l,n,x,y,dist,dist0=50,x0,y0,TrackViewBl;  //l0  still used for number of seleted point
	RECT rect;
	CT3EDDoc *pDoc=GetDocument();
	struct FLOATPT *pt; //,tmppt;
	struct XOBJDATA *xx;
	vec3 mypt;
	bool ScrollKey=(GetKeyState(VK_SCROLL) & 0x0001);

	TrackViewBl=refblock; //Use nearest block if refblock is global
	if (TrackViewBl==pDoc->nBlocks)
		TrackViewBl=pDoc->FindNearestBlock(refnode);

	GetClientRect(&rect);
	rect.left=point.x-10; rect.right=point.x+10;
	rect.top=point.y-10; rect.bottom=point.y+10;

	FSel->coreref=NULL; FSel->refnode=NULL; dist0=10;
	for (i=0;i<pDoc->nBlocks;i++) 
	{
		if (ScrollKey && (i!=refblock)) continue; //Scroll Lock active ? Then select only from current block
		if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) continue;
		if ((ShowBasedOnVisi)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) continue;
		pt=pDoc->trk[i].vert;
		n=pDoc->trk[i].nVertices;
		for (j=0;j<n;j++,pt++) 
		{
			x=FloatX(*pt); y=FloatY(*pt);
			dist=((x>point.x)?(x-point.x):(point.x-x))
				+((y>point.y)?(y-point.y):(point.y-y));
			if (dist<dist0)
				if (IsVisibleNode(i,pt)) 
				{
					FSel->refblock=i; x0=x; y0=y; FSel->refchunk=j;
					dist0=dist; FSel->refnode=pt; FSel->nPt=j;
					FSel->isxobj=0;
					FSel->coreref=NULL;
				}
		}
	  if (bShowObjects||bShowLanes) 
	  {
		ch=0; FSel->refchunk=0;
		for (j=4*i;j<4*i+4;j++, ch++) 
		{ // explore xobjs
			xx=pDoc->xobj[j].obj;
			for (k=0;k<pDoc->xobj[j].nobj;k++,xx++) 
			{
				pt=xx->vert;
				for (l=0;l<xx->nVertices;l++,pt++) 
				{
					x=FloatFloatX(*pt,xx->ptRef); y=FloatFloatY(*pt,xx->ptRef);
					dist=((x>point.x)?(x-point.x):(point.x-x))
						+((y>point.y)?(y-point.y):(point.y-y));
					if (dist<dist0) 
					{
						FSel->refblock=i; x0=x; y0=y; FSel->objno=k; FSel->nPt=l; FSel->refchunk=ch;
						dist0=dist; FSel->refnode=pt;
						FSel->coreref=&(xx->ptRef);
						FSel->isxobj=1;
						FSel->myrefnode.x=FSel->coreref->x + FSel->refnode->x; FSel->myrefnode.z=FSel->coreref->z + FSel->refnode->z; FSel->myrefnode.y=FSel->coreref->y + FSel->refnode->y;								
					}
				}
			}
		}
	  }
	}
}

void CT3EDView::OnUpdateToolsAddLane(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
}

void CT3EDView::OnToolsAddLane() 
{
	CT3EDDoc* pDoc = GetDocument();

	if (isDragging) return; // safety
	CleanCursorZone(selMode,FALSE);
	selMode=ID_MODE_POLYGON;
	if (multisel!=NULL) { delete multisel; multisel=NULL; }
	isTruePoint=FALSE; objno=-1;
	editMode=NULL;
	CleanCursorZone(selMode,TRUE);

	//New Lane
	if (pDoc->settings.lanetexture<0) pDoc->settings.lanetexture=2048;
	refpolyno=pDoc->NewLane(refblock, pDoc->settings.lanetexture);
	if (refpolyno<0) return;
	refchunk=6;
	refpolyobj=-1;
	isxobj=0;
	refpoly=pDoc->poly[refblock].poly[refchunk]+refpolyno;
	refvertices=pDoc->trk[refblock].vert;
	refnode=refvertices + refpoly->vertex[0];
	OnToolsdrop();
	OnToolsTexture();  //Select texture
	pDoc->settings.lanetexture=refpoly->texture;

	offsetx=0; offsety=0;
	InvalidateRect(NULL,true);
}

void CT3EDView::SelCorrectPolyAfterPolyDel(int block, int chunk, int isxobj, int polyobj, int delpolyno)
{//Renews the selected polygons of a polygon was deleted.
	CT3EDDoc* pDoc = GetDocument();
	CSelData *sel;
	struct XOBJDATA *x;

	for (sel=this;sel!=NULL;sel=sel->multisel) 
	{
		if (polyobj==-1) //Trackblock poly was added / inserted
		{
			if ((!sel->isxobj) && (sel->refpolyobj==-1)) //Trackblock Polygon in selection
			{
				//if ((sel->refblock==block) && (sel->refpolyno>=newpolyno)) //Track poly inserted before this track poly
				if ((sel->refblock==block) && (sel->refchunk==chunk) && (sel->refpolyno>delpolyno)) //Track poly inserted before this track poly
					sel->refpolyno--;
				sel->refpoly=pDoc->poly[sel->refblock].poly[sel->refchunk]+sel->refpolyno;
				sel->refvertices=pDoc->trk[sel->refblock].vert;
				sel->refnode=sel->refvertices+sel->refpoly->vertex[0];
			}
		}
		else //Object poly was added
		{
			if (sel->isxobj) //Select new created xobj polygon
				{
					if ((sel->refblock==block) && (sel->refchunk==chunk) && (sel->refpolyno>delpolyno))
						sel->refpolyno--;
					x=pDoc->xobj[4*sel->refblock + sel->refchunk].obj + sel->refpolyobj;
					sel->refpoly=x->polyData + sel->refpolyno;
					sel->refvertices=x->vert;
					sel->refnode=&(x->ptRef);
				} 
				else 
				{
					if ((sel->refblock==block) && (sel->refchunk==chunk) && (sel->refpolyno>delpolyno))
						sel->refpolyno--;					
					if (sel->refpolyobj==-1) //Select Track Polygon?
						sel->refpoly=pDoc->poly[sel->refblock].poly[sel->refchunk]+sel->refpolyno;
					else 
						sel->refpoly=pDoc->poly[sel->refblock].obj[sel->refchunk].poly[sel->refpolyobj]+sel->refpolyno;
					sel->refvertices=pDoc->trk[sel->refblock].vert;
					sel->refnode=sel->refvertices + sel->refpoly->vertex[0];
				}
		}
	}

}

void CT3EDView::SelCorrectPolyAfterObjectDel(int block, int chunk, int isxobj, int delobjno)
{
	CT3EDDoc* pDoc = GetDocument();
	CSelData *sel;
	struct XOBJDATA *x;

	for (sel=this;sel!=NULL;sel=sel->multisel)
	{
		if (sel->isxobj) //Select new created xobj polygon
		{
			if ((sel->refblock==block) && (sel->refchunk==chunk) && (sel->refpolyobj>delobjno))
				sel->refpolyobj--;
			x=pDoc->xobj[4*sel->refblock + sel->refchunk].obj + sel->refpolyobj;
			sel->refpoly=x->polyData + sel->refpolyno;
			sel->refvertices=x->vert;
			sel->refnode=&(x->ptRef);
		} 
		else 
		{
			if ((sel->refblock==block) && (sel->refchunk==chunk) && (sel->refpolyobj>delobjno))
				sel->refpolyobj--;					
			if (sel->refpolyobj==-1) //Select Track Polygon?
				sel->refpoly=pDoc->poly[sel->refblock].poly[sel->refchunk]+sel->refpolyno;
			else 
				sel->refpoly=pDoc->poly[sel->refblock].obj[sel->refchunk].poly[sel->refpolyobj]+sel->refpolyno;
			sel->refvertices=pDoc->trk[sel->refblock].vert;
			sel->refnode=sel->refvertices + sel->refpoly->vertex[0];
		}
	}
}

void CT3EDView::SelCorrectObjectAfterObjectDel(int block, int chunk, int isxobj, int delobjno)
{
	CT3EDDoc* pDoc = GetDocument();
	CSelData *sel;
	struct XOBJDATA *x;

	for (sel=this;sel!=NULL;sel=sel->multisel)
	{
		if (sel->isxobj) //Select new created xobj polygon
		{
			if ((sel->refblock==block) && (sel->refchunk==chunk) && (sel->objno>delobjno))
				sel->objno--;
			x=pDoc->xobj[4*sel->refblock + sel->refchunk].obj + sel->objno;
			sel->refpoly=x->polyData + sel->refpolyno;
			sel->refvertices=x->vert;
		} 
		else 
		{
			if ((sel->refblock==block) && (sel->refchunk==chunk) && (sel->objno>delobjno))
				sel->objno--;					
			if (sel->objno==-1) //Select Track Polygon?
				sel->refpoly=pDoc->poly[sel->refblock].poly[sel->refchunk]+sel->refpolyno;
			else 
				sel->refpoly=pDoc->poly[sel->refblock].obj[sel->refchunk].poly[sel->objno]+sel->refpolyno;
			sel->refvertices=pDoc->trk[sel->refblock].vert;
		}
	}
}

void CT3EDView::OnShiftS() 
{
	CT3EDDoc *pDoc=GetDocument(); 
	CSelData *sel=this;
	pDoc->PrepareNewUndo(refnode,refblock,offsetx,offsety);
	pDoc->PrepareModifyTrk(refblock);

	bool AltKey=false;
	if (GetAsyncKeyState(VK_MENU) & 0x8000) AltKey=true;

	if (selMode==ID_MODE_VROADEDIT)
	{
		if (isxobj!=6) return; //Last selection wasn't a AI Point
		if (multisel==NULL) return; //less than two points selected

		//CSelData *sel;
		int p1=objno, p2=-1;
		for (sel=this;sel!=NULL;sel=sel->multisel)
		{
			if ((sel->isxobj==6)&&(sel->objno!=p1)) p2=sel->objno;
		}
		if (p2==-1) return;

		pDoc->PrepareModifyVRoadHeightsSpdFiles();
		//pDoc->SpeedFile_Calc_Float_Between2AIPoints(p1,p2,ShowFwSPD, !AltKey);
		if (!pDoc->SpeedFile_Calc_Speed_Between2AIPoints(p1,p2,ShowFwSPD, false)) return;

		CString sStr;
		InvalidateRect(NULL,true);
		if (ShowFwSPD) 
			{
				sStr.Format("Forward AI speed from point %d to point %d calculated.", p1, p2);
			}
			else 
			{
				sStr.Format("Backward AI speed from point %d to point %d calculated.", p1, p2);
			}
			statusbar->SetPaneText(0,sStr,TRUE);
	}
}

void CT3EDView::OnDrawVRoadBitMap(CDC *pDC)
{
	CT3EDDoc* pDoc = GetDocument();
	RECT rect;
	int i,j,k=0,num;
	LPPOLYGONDATA p;
	struct FLOATPT *v;
	bool ScrollKey=(GetKeyState(VK_SCROLL) & 0x0001);

	HPEN pen, oldPen;
	HBRUSH brush, brush2, oldBrush;

	brush = CreateSolidBrush(RGB(0,196,0));
	brush2 = CreateSolidBrush(RGB(0,127,0));
	oldBrush = (HBRUSH)::SelectObject(pDC->m_hDC, brush);

	GetClientRect(&rect);

	pDC->SelectStockObject(NULL_PEN);

	for (i=0;i<pDoc->nBlocks;i++) 
	{
		if (ScrollKey && (i!=refblock)) continue; //Scroll Lock active ? Then select only from current block
		if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) 	continue;

		v=pDoc->trk[i].vert;
		p=pDoc->poly[i].poly[4];

		for (int n = 0; n < pDoc->trk[i].nPositions; n++)
		{
			int nodeIdx = i*8+n;

			POSITIONDATA& posd = pDoc->trk[i].posData[n];
			COLVROAD_VIT& vr = *(COLVROAD_VIT*)&pDoc->col.vroad[nodeIdx];

			p = pDoc->poly[i].poly[4] + posd.polygon;
			num = posd.nPolygons;

			int center = pDoc->GetCenterQuad(i, n);

			short rWidth, lWidth;
			if (!pDoc->bHSMode)
			{
				lWidth = vr.scales >> 4; 
				rWidth = vr.scales & 0x0F;
			}
			else
			{
				/*long *tmpptr = pDoc->col.hs_extra + nodeIdx * 7;
				lWidth = (short)tmpptr[3]; 
				rWidth = (short)tmpptr[4];*/
				lWidth = (short) pDoc->col.hs_extra[nodeIdx].nLeftLanePolys;
				rWidth = (short) pDoc->col.hs_extra[nodeIdx].nRightLanePolys;

			}

			p = pDoc->poly[i].poly[4] + posd.polygon;
			for (j=0; j<num; j++, p++) 
			{
				POLYVROADDATA& pvr = pDoc->trk[i].polyData[k];

				unsigned long _bit = 1L << (center - j + 8);
				if ((vr.FullMask & _bit) == 0)
					continue;

				POINT points[4];
				points[0].x = FloatX(v[p->vertex[0]]); points[0].y = FloatY(v[p->vertex[0]]);
				points[1].x = FloatX(v[p->vertex[1]]); points[1].y = FloatY(v[p->vertex[1]]);
				points[2].x = FloatX(v[p->vertex[2]]); points[2].y = FloatY(v[p->vertex[2]]);
				points[3].x = FloatX(v[p->vertex[3]]); points[3].y = FloatY(v[p->vertex[3]]);

				if (j <= center)
				{
					if (center - j < lWidth)
						::SelectObject(pDC->m_hDC, brush);
					else
						::SelectObject(pDC->m_hDC, brush2);
				}
				else
				{
					if (j - center <= rWidth)
						::SelectObject(pDC->m_hDC, brush);
					else
						::SelectObject(pDC->m_hDC, brush2);
				}

				pDC->Polygon(points, 4);
			}
		}
	}

	pDC->SelectObject(oldBrush);
	DeleteObject(brush2);
	DeleteObject(brush);


	///////////////////////////////////////////////////////////////////////////////////////////
	// Draw Bots line Forward or Backward
	///////////////////////////////////////////////////////////////////////////////////////////
	if (pDoc->spdFALoaded&&pDoc->spdRALoaded)
	{
		struct INTPT pt;
		pen = CreatePen(PS_SOLID, 5, RGB(196,0,0));
		oldPen = (HPEN)::SelectObject(pDC->m_hDC, pen);
		pDC->SelectObject(thickdarkredpen);

		//Starting point
		i=pDoc->col.vroadHead.nrec-1;
		pt=AI_Intpt(i);
		pDC->MoveTo(IntX(pt),IntY(pt));

		//Draw Line
		for (i=0;i<pDoc->col.vroadHead.nrec;i++) 
		{
			pt=AI_Intpt(i);
			pDC->LineTo(IntX(pt),IntY(pt));
		}
		pDC->SelectObject(oldPen);
		DeleteObject(pen);
	}
	///////////////////////////////////////////////////////////////////////////////////////////
	// Draw center line
	///////////////////////////////////////////////////////////////////////////////////////////

	pen = CreatePen(PS_SOLID, 5, RGB(196,0,0));
	oldPen = (HPEN)::SelectObject(pDC->m_hDC, pen);

	COLVROAD_VIT& _ovr = *(COLVROAD_VIT*)&pDoc->col.vroad[pDoc->col.vroadHead.nrec-1];

	int _ox = IntX(_ovr.refPt);
	int _oy = IntY(_ovr.refPt);
	pDC->MoveTo(_ox, _oy);

	for (i=0;i<pDoc->col.vroadHead.nrec;i++) 
	{
		int x = IntX(pDoc->col.vroad[i].refPt);
		int y = IntY(pDoc->col.vroad[i].refPt);
		pDC->LineTo(x, y);
	}

	pDC->SelectObject(oldPen);
	DeleteObject(pen);


	///////////////////////////////////////////////////////////////////////////////////////////
	// Draw vroad borders
	///////////////////////////////////////////////////////////////////////////////////////////

	pen = CreatePen(PS_SOLID, 5, RGB(196,0,196));  //Purple Line
	oldPen = (HPEN)::SelectObject(pDC->m_hDC, pen);

	CFltVector RefPt, Right, res;

	RefPt = CFltVector(_ovr.refPt.x / 65536.0f, _ovr.refPt.z / 65536.0f, _ovr.refPt.y / 65536.0f);
	Right = CFltVector(_ovr.right.x / 128.0f, _ovr.right.z / 128.0f, _ovr.right.y / 128.0f);
	Right.Normalize();
	res = RefPt - Right * (_ovr.leftWall / 65536.0f);

	_ox = FloatX(*(FLOATPT*)&res);
	_oy = FloatY(*(FLOATPT*)&res);
	pDC->MoveTo(_ox, _oy);

	for (i=0;i<pDoc->col.vroadHead.nrec;i++) 
	{
		COLVROAD_VIT& vr = *(COLVROAD_VIT*)&pDoc->col.vroad[i];
		RefPt = CFltVector(vr.refPt.x / 65536.0f, vr.refPt.z / 65536.0f, vr.refPt.y / 65536.0f);
		Right = CFltVector(vr.right.x / 128.0f, vr.right.z / 128.0f, vr.right.y / 128.0f);
		Right.Normalize();
		res = RefPt - Right * (vr.leftWall / 65536.0f);

		int x = FloatX(*(FLOATPT*)&res);
		int y = FloatY(*(FLOATPT*)&res);
		pDC->LineTo(x, y);
	}

	RefPt = CFltVector(_ovr.refPt.x / 65536.0f, _ovr.refPt.z / 65536.0f, _ovr.refPt.y / 65536.0f);
	Right = CFltVector(_ovr.right.x / 128.0f, _ovr.right.z / 128.0f, _ovr.right.y / 128.0f);
	Right.Normalize();
	res = RefPt + Right * (_ovr.rightWall / 65536.0f);

	_ox = FloatX(*(FLOATPT*)&res);
	_oy = FloatY(*(FLOATPT*)&res);
	pDC->MoveTo(_ox, _oy);

	for (i=0;i<pDoc->col.vroadHead.nrec;i++) 
	{
		COLVROAD_VIT& vr = *(COLVROAD_VIT*)&pDoc->col.vroad[i];
		RefPt = CFltVector(vr.refPt.x / 65536.0f, vr.refPt.z / 65536.0f, vr.refPt.y / 65536.0f);
		Right = CFltVector(vr.right.x / 128.0f, vr.right.z / 128.0f, vr.right.y / 128.0f);
		Right.Normalize();
		res = RefPt + Right * (vr.rightWall / 65536.0f);

		int x = FloatX(*(FLOATPT*)&res);
		int y = FloatY(*(FLOATPT*)&res);
		pDC->LineTo(x, y);
	}

	pDC->SelectObject(oldPen);
	DeleteObject(pen);
///////////////////////////////////////////////////////////////////////////////////////////
// Draw lane centers
///////////////////////////////////////////////////////////////////////////////////////////

	pen = CreatePen(PS_SOLID, 2, RGB(0,196,196));
	oldPen = (HPEN)::SelectObject(pDC->m_hDC, pen);

	if (pDoc->bHSMode)
	{
		RefPt = CFltVector(_ovr.refPt.x / 65536.0f, _ovr.refPt.z / 65536.0f, _ovr.refPt.y / 65536.0f);
		Right = CFltVector(_ovr.right.x / 128.0f, _ovr.right.z / 128.0f, _ovr.right.y / 128.0f);
		float *delta = (float*)pDoc->col.hs_extra + (pDoc->col.vroadHead.nrec-1) * 7 + 0;
		float d;

		d = *delta * ((long*)(delta))[3];
		res = RefPt - Right * d;

		_ox = FloatX(*(FLOATPT*)&res);
		_oy = FloatY(*(FLOATPT*)&res);
		pDC->MoveTo(_ox, _oy);

		delta = (float*)pDoc->col.hs_extra + 0;
		for (i=0;i<pDoc->col.vroadHead.nrec;i++, delta += 7) 
		{
			COLVROAD_VIT& vr = *(COLVROAD_VIT*)&pDoc->col.vroad[i];

			RefPt = CFltVector(vr.refPt.x / 65536.0f, vr.refPt.z / 65536.0f, vr.refPt.y / 65536.0f);
			Right = CFltVector(vr.right.x / 128.0f, vr.right.z / 128.0f, vr.right.y / 128.0f);
			d = *delta * ((long*)(delta))[3];

			res = RefPt - Right * d;

			int x = FloatX(*(FLOATPT*)&res);
			int y = FloatY(*(FLOATPT*)&res);
			pDC->LineTo(x, y);
		}

		RefPt = CFltVector(_ovr.refPt.x / 65536.0f, _ovr.refPt.z / 65536.0f, _ovr.refPt.y / 65536.0f);
		Right = CFltVector(_ovr.right.x / 128.0f, _ovr.right.z / 128.0f, _ovr.right.y / 128.0f);
		delta = (float*)pDoc->col.hs_extra + (pDoc->col.vroadHead.nrec-1) * 7 + 1;
		d = *delta * ((long*)(delta))[3];

		res = RefPt + Right * d;

		_ox = FloatX(*(FLOATPT*)&res);
		_oy = FloatY(*(FLOATPT*)&res);
		pDC->MoveTo(_ox, _oy);

		delta = (float*)pDoc->col.hs_extra + 1;
		for (i=0;i<pDoc->col.vroadHead.nrec;i++, delta += 7) 
		{
			COLVROAD_VIT& vr = *(COLVROAD_VIT*)&pDoc->col.vroad[i];

			RefPt = CFltVector(vr.refPt.x / 65536.0f, vr.refPt.z / 65536.0f, vr.refPt.y / 65536.0f);
			Right = CFltVector(vr.right.x / 128.0f, vr.right.z / 128.0f, vr.right.y / 128.0f);
			d = *delta * ((long*)(delta))[3];

			res = RefPt + Right * d;

			int x = FloatX(*(FLOATPT*)&res);
			int y = FloatY(*(FLOATPT*)&res);
			pDC->LineTo(x, y);
		}
	}
	else
	{
		RefPt = CFltVector(_ovr.refPt.x / 65536.0f, _ovr.refPt.z / 65536.0f, _ovr.refPt.y / 65536.0f);
		Right = CFltVector(_ovr.right.x / 128.0f, _ovr.right.z / 128.0f, _ovr.right.y / 128.0f);

		short lWidth = _ovr.scales >> 4; 
		res = RefPt - Right * _ovr.LeftCenter / 2 * lWidth;

		_ox = FloatX(*(FLOATPT*)&res);
		_oy = FloatY(*(FLOATPT*)&res);
		pDC->MoveTo(_ox, _oy);

		for (i=0;i<pDoc->col.vroadHead.nrec;i++) 
		{
			COLVROAD_VIT& vr = *(COLVROAD_VIT*)&pDoc->col.vroad[i];

			RefPt = CFltVector(vr.refPt.x / 65536.0f, vr.refPt.z / 65536.0f, vr.refPt.y / 65536.0f);
			Right = CFltVector(vr.right.x / 128.0f, vr.right.z / 128.0f, vr.right.y / 128.0f);

			lWidth = vr.scales >> 4; 
			res = RefPt - Right * vr.LeftCenter / 2 * lWidth;

			int x = FloatX(*(FLOATPT*)&res);
			int y = FloatY(*(FLOATPT*)&res);
			pDC->LineTo(x, y);
		}

		RefPt = CFltVector(_ovr.refPt.x / 65536.0f, _ovr.refPt.z / 65536.0f, _ovr.refPt.y / 65536.0f);
		Right = CFltVector(_ovr.right.x / 128.0f, _ovr.right.z / 128.0f, _ovr.right.y / 128.0f);

		short rWidth = _ovr.scales & 0x0F;

		res = RefPt + Right * _ovr.RightCenter / 2 * rWidth;

		_ox = FloatX(*(FLOATPT*)&res);
		_oy = FloatY(*(FLOATPT*)&res);
		pDC->MoveTo(_ox, _oy);

		for (i=0;i<pDoc->col.vroadHead.nrec;i++) 
		{
			COLVROAD_VIT& vr = *(COLVROAD_VIT*)&pDoc->col.vroad[i];

			RefPt = CFltVector(vr.refPt.x / 65536.0f, vr.refPt.z / 65536.0f, vr.refPt.y / 65536.0f);
			Right = CFltVector(vr.right.x / 128.0f, vr.right.z / 128.0f, vr.right.y / 128.0f);

			rWidth = vr.scales & 0x0f; 
			res = RefPt + Right * vr.RightCenter / 2 * rWidth;

			int x = FloatX(*(FLOATPT*)&res);
			int y = FloatY(*(FLOATPT*)&res);
			pDC->LineTo(x, y);
		}
	}

	pDC->SelectObject(oldPen);
	DeleteObject(pen);
}

void CT3EDView::OnUpdateViewBlockDirection(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck(DrawBlkDirection&&!isEmpty);
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnViewBlockDirection() 
{
	DrawBlkDirection=!DrawBlkDirection;	
}

void CT3EDView::OnDrawBlkDirection(CDC *pDC)
{
	CT3EDDoc* pDoc = GetDocument();
	RECT rect; GetClientRect(&rect);
	int i, np23;
	//float dx, dy;

	int	TrackViewBl=refblock; //Used for based on visibility, because if refblock is global it has no visibility information
	if (TrackViewBl==pDoc->nBlocks)
		TrackViewBl=pDoc->FindNearestBlock(refnode);

	CPen *thickorangePen;
	thickorangePen=new CPen(PS_SOLID,2,RGB(230,185,125));
	pDC->SelectObject(thickorangePen);

	vec3 VRP1, VRP2, VRP3, P1, P2;

	for (i=0;i<pDoc->nBlocks;i++) 
	{
		if ((ShowBasedOnVisi==true)&&(!pDoc->IsBlockVisibile(TrackViewBl,i))) //Show Direction only for visible blocks
			continue; 	
		if (!MeetsClipRect(&(pDoc->trk[i]),&rect)) //Check if block should be drawed
			continue;
		if (pDoc->trk[i].nPositions < 4)
			continue;

		VRP1=pDoc->col.vroad[ pDoc->trk[i].nStartPos + pDoc->trk[i].nPositions -1].refPt;  //Top middle point
		np23=pDoc->trk[i].nStartPos + 1;
		VRP2=pDoc->col.vroad[np23].refPt;  //Base for down right point
		VRP3=pDoc->col.vroad[np23].refPt;  //Base for down left point

		VRP2.x+=pDoc->col.vroad[np23].right.x/16; //Move to right a bit
		VRP2.y+=pDoc->col.vroad[np23].right.y/16;

		VRP3.x-=pDoc->col.vroad[np23].right.x/16; //Move to left a bit
		VRP3.y-=pDoc->col.vroad[np23].right.y/16;
		
		pDC->MoveTo(Vec3X(VRP2),Vec3Y(VRP2)); // Draw direction
		pDC->LineTo(Vec3X(VRP1),Vec3Y(VRP1));
		pDC->LineTo(Vec3X(VRP3),Vec3Y(VRP3));

	}

}

void CT3EDView::OnUpdateViewShowhidetrackblocks(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);	
	pCmdUI->SetCheck(bShowTrackBlocks&&!isEmpty);	
}

void CT3EDView::OnViewShowhidetrackblocks() 
{
	bShowTrackBlocks=!bShowTrackBlocks;
	CSelData *sel;

	if (!bShowTrackBlocks && selMode==ID_MODE_BLOCK)
	{
		selMode=NULL;
		editMode=NULL;
		if (multisel!=NULL) { delete multisel; multisel=NULL; }
		//sel=NULL;
		//refblock=-1;
		isTruePoint=FALSE; refpoly=NULL; objno=-1;
		myrefnode.x=refnode->x; 
		myrefnode.y=refnode->y; 
		myrefnode.z=refnode->z;
		refnode=&myrefnode;
		sel=this;
	}

	InvalidateRect(NULL, TRUE);
}

void CT3EDView::OnUpdateModeSelFromCurrentBlockOnly(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!isEmpty);
	pCmdUI->SetCheck((GetKeyState(VK_SCROLL) & 0x0001)&&!isEmpty);	
}

void CT3EDView::OnModeSelFromCurrentBlockOnly() 
{
	//toggle the Scroll Lock state
	keybd_event(VK_SCROLL, 0x45, KEYEVENTF_EXTENDEDKEY, 0); // Key down
	keybd_event(VK_SCROLL, 0x45, KEYEVENTF_EXTENDEDKEY | KEYEVENTF_KEYUP, 0); // Key 

	OnScrollLock();
}

void CT3EDView::OnScrollLock() 
{
	InvalidateRect(NULL,TRUE);
}

void CT3EDView::OnUpdateFileSpeedshift(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(isEmpty);	
}

void CT3EDView::OnFileSpeedshift() 
{
			
}

void CT3EDView::OnUpdateFileSpeedshift0(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	//pCmdUI->Enable(isEmpty);
	pCmdUI->SetCheck(pDoc->nSpeedFileShift==0);
}

void CT3EDView::OnFileSpeedshift0() 
{
	CT3EDDoc* pDoc = GetDocument();
	SpeedshiftChange(0);
}

void CT3EDView::OnUpdateFileSpeedshift2(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	//pCmdUI->Enable(isEmpty);
	pCmdUI->SetCheck(pDoc->nSpeedFileShift==2);	
}

void CT3EDView::OnFileSpeedshift2() 
{
	CT3EDDoc* pDoc = GetDocument();
	SpeedshiftChange(2);	
}

void CT3EDView::OnUpdateFileSpeedshift4(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	//pCmdUI->Enable(isEmpty);
	pCmdUI->SetCheck(pDoc->nSpeedFileShift==4);
}

void CT3EDView::OnFileSpeedshift4() 
{
	CT3EDDoc* pDoc = GetDocument();
	SpeedshiftChange(4);	
}

void CT3EDView::OnUpdateFileSpeedshift6(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	//pCmdUI->Enable(isEmpty);
	pCmdUI->SetCheck(pDoc->nSpeedFileShift==6);	
}

void CT3EDView::OnFileSpeedshift6() 
{
	CT3EDDoc* pDoc = GetDocument();
	SpeedshiftChange(6);
}

void CT3EDView::OnUpdateFileSpeedshift8(CCmdUI* pCmdUI) 
{
	CT3EDDoc* pDoc = GetDocument();
	//pCmdUI->Enable(isEmpty);
	pCmdUI->SetCheck(pDoc->nSpeedFileShift==8);
}

void CT3EDView::OnFileSpeedshift8() 
{
	CT3EDDoc* pDoc = GetDocument();
	SpeedshiftChange(8);
}

void CT3EDView::SpeedshiftChange(int nstep)
{
	CT3EDDoc* pDoc = GetDocument();
	//pDoc->nSpeedFileShift=8;

	if (nstep==pDoc->nSpeedFileShift) return; //nothing to Do

	if (!isEmpty) //Track present
	{
		pDoc->SpeedFileShiftData(pDoc->spdFAbin, -pDoc->nSpeedFileShift); //Shift spdFAbin SpeedFile Data back to original position
		pDoc->SpeedFileShiftData(pDoc->spdRAbin, pDoc->nSpeedFileShift); //Shift spdFAbin SpeedFile Data back to original position

		pDoc->SpeedFileShiftData(pDoc->spdFAbin, nstep); //Shift spdFAbin SpeedFile Data with new step
		pDoc->SpeedFileShiftData(pDoc->spdRAbin, -nstep); //Shift spdRAbin SpeedFile Data with new step

		InvalidateRect(NULL,TRUE); //Make visible
	}

	pDoc->nSpeedFileShift=nstep;  //store new step

}
