// T3EDDoc.h : interface of the CT3EDDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_T3EDDOC_H__EA21D10E_8ED3_11D2_8486_000000000000__INCLUDED_)
#define AFX_T3EDDOC_H__EA21D10E_8ED3_11D2_8486_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

// #define dofree(x) if ((x)!=NULL) free(x)
#define dofree free
#define UNDO_LEVELS 64
#define MAX_BLOCKS 500
//#define nSpeedFileShift 2

#include "QFSView.h"
//#include "Vectors.h"

// !!! for arrays : structures are aligned to their largest member
// !!! structure members are aligned on their own size (up to the /Zp parameter)
#include <iostream.h> //  Off Read
#include <fstream.h> //  Off Read
#include <math.h>

typedef struct FLOATPT
{
	float x,z,y;
} FLOATPT;

typedef struct SHORTPT  //For TNFS_SE
{
	short x,z,y; //relative x,z,y coordinate
} SHORTPT;

typedef struct INTPT
{
	long x,z,y;
} INTPT;

typedef struct NEIGHBORDATA  // info on neighbouring block numbers
{
	short blk,unknown;
} NEIGHBORDATA;

typedef struct POSITIONDATA  // enumerate polygons which lie at center
{
	short polygon;
	unsigned char nPolygons;
	char unknown;
	short extraNeighbor1,extraNeighbor2;
} POSITIONDATA;

typedef struct POLYVROADDATA  // vroad data associated with a polygon
{
	unsigned char vroadEntry;
	unsigned char flags;
	unsigned char unknown[6];
	unsigned char hs_minmax[4];
	unsigned char hs_orphan[4];
	unsigned char hs_unknown;
	bool virtualroadedge;
} POLYVROADDATA;

typedef struct MCO_POLYVROADDATA { //24 Bytes for MCO loading
    unsigned char minY,maxY,minX,maxX;
    //char isEdge[4];
    char flags;
    char unknown;
    short polygon;
    short xNorm,zNorm,yNorm;
    short xForw,zForw,yForw;
} MCO_POLYVROADDATA;

typedef struct MCO_REFXOBJ {
    struct INTPT pt;
    short unknown;
    short globalno;
    char unknown2[4];
} MCO_REFXOBJ;

typedef struct MCO_REFPOLYOBJ //20? Bytes for MCO loading
{
    short head;  //For polygon objects, the head member equals 4 
    char type;	//and the type member equals 1.
    char no;	//The no member is a serial number among the blocks objects 
    struct INTPT pt;  //The pt member contains the reference position of the object
    char crossindex; // ?
    char unknown[3];
} MCO_REFPOLYOBJ;

typedef struct VROADDATA  // vroad vectors
{
	short xNorm,zNorm,yNorm;
	short xForw,zForw,yForw;
} VROADDATA;

// WARNING: in the following 2 structures, don't rely on crossindex :
// it's not implemented in NFSHS's REFXOBJ, and due to a bug in T3ED
// refxobj.crossindex doesn't change properly if a polyobj's REFPOLYOBJ
// is deleted !

typedef struct REFXOBJ // description of a block's XOBJects.
{
	struct INTPT pt;
	short unknown1;
	short globalno;  // sequence number in all of the track's xobjs
	short unknown2;
	char crossindex; // position in first POLYOBJ chunk (0 if not in first chunk)
	char collideeffect; //0=Nothing, 1=Solid (like Trees), 2 Hit & fall (Signs), 3 Drivethrough with sound effekt
} REFXOBJ; // !!! does not list the animated XOBJs

// LET'S JUST FORGET THEM -- UNUSED BY NFS3 ! 
/*typedef struct REFPOLYOBJ // description of first POLYOBJ chunk
{
	short entrysize;
	char type;       // 4 if XOBJ, 1 if described in POLYOBJ chunk
	char no;         // serial number among the block's objects (useless)
		// !!! not consecutive as the 4 POLYOBJ chunks are interlaced !
	struct INTPT pt;
	unsigned char crossindex; // only present if XOBJ : index in REFXOBJ table
	char unknown[3]; // always 0 in NFS3, not in NFSHS
} REFPOLYOBJ;*/

typedef struct SOUNDSRC {
	struct INTPT refpoint;
	//long type;
	unsigned char type[4];
} SOUNDSRC;

typedef struct LIGHTSRC {
	struct INTPT refpoint;
	//long type;
	unsigned char type[4];
} LIGHTSRC;

typedef struct LIGHTDATA { //stored in Tr(N).ini
	int intensity, red, green, blue, flashes, t, x;
	float diameter;
} LIGHTDATA;

typedef struct BGRA  //Shading Colors
{
	unsigned char blue;
	unsigned char green;
	unsigned char red; 
	unsigned char alpha;
} BGRA;

typedef struct PTINFO //T3ED only, not part of frd file
{
	struct FLOATPT vert;
	float shadow;
	int isxobj;
	int chunk;
	int nobj;
	int nvert;
} PTINFO;

typedef struct FLOATPTLIST //T3ED only, not part of frd file
{
	long nVertices; // Vertices of block
	long vertmem; //number of vertices that can be stored in *vert memonry
	struct PTINFO *ptinf;  // the info list
} FLOATPTLIST;

typedef struct TRKBLOCK
{
	struct FLOATPT ptCentre;
	struct FLOATPT ptBounding[4];
	long nVertices; // total stored
	long nHiResVert,nLoResVert,nMedResVert; // #poly[...]+#polyobj
	long nVerticesDup,nObjectVert;
	struct FLOATPT *vert;  // the vertices
	//unsigned long *unknVertices; //Shading Information as RGBA 8Bpc
	struct BGRA *vertshade; //Shading Information as BGRA
	struct NEIGHBORDATA nbdData[0x12C];  // neighboring blocks
	long nStartPos,nPositions;
	long nPolygons,nVRoad,nXobj,nPolyobj,nSoundsrc,nLightsrc;
	struct POSITIONDATA *posData;  // positions along track. Is used to indicate which track polygons are attached to a given node (VRoad Point).
	struct POLYVROADDATA *polyData;  // polygon vroad references & flags
	struct VROADDATA *vroadData;   // vroad vectors
	struct REFXOBJ *xobj;
/* USELESS & BUGGY : let's just forget it
	struct REFPOLYOBJ **polyobj; // table of pointers on the blocks themselves
							     // malloc is linear and 20*nPolyobj, though.
*/
	struct SOUNDSRC *soundsrc;
	struct LIGHTSRC *lightsrc;
	struct FLOATPT hs_ptMin,hs_ptMax;
	long hs_neighbors[8];
} TRKBLOCK;

typedef struct POLYGONDATA
{
	short vertex[4];  //0==top left, 1 == top right, 2 == down right, 3 == down left
	short texture;
	unsigned short hs_textflags; /* HS texture properties
						bit 2 & 3 Rotation bit 2=90, 3=180, 2&3=270
						bit 4 flip hori
						bit 5 flip vert

						bit 6 Tiling Horizontal x2
						bit 6 & 7  Tiling Horizontal x4
						bit 7 Tiling Vertical  x2
						bit 8 Tiling Vertical  x4
						bit 13 Scroll effect
						bit 15 two sided
						*/
	
	unsigned char texanimdata; // NFS4 used for animated textures, AnimInfo (Length bit 0-2, Duration bit 3-7)
							   // NFS3 Animated texture if bit 2 (0x4) is set. Two sided if bit 4 (0x10) is set. 
	unsigned char unknown2;    // NFS3 used for animated textures, AnimInfo (Length bit 0-2, Duration bit 3-7)
} POLYGONDATA;

typedef struct POLYGONDATA *LPPOLYGONDATA;

typedef struct OBJPOLYBLOCK  // a POLYOBJ chunk
{
	long n1;        // total number of polygons
	long n2;        // total number of objects including XOBJs
	long nobj;      // not stored in .FRD : number of type 1 objects
	long *types;    // when 1, there is an associated object; else XOBJ
	long *numpoly;  // size of each object (only for type 1 objects)
	LPPOLYGONDATA *poly;	// the polygons themselves
} OBJPOLYBLOCK;

typedef struct POLYGONBLOCK  //Trackpolys, fences, and lane
{
	long sz[7],szdup[7]; 
	// 7 blocks == //Chunk 0 Low res, 1 low fences, 2 Mid res, 3 mid fences, 4 High res, 5 High fences, 6 Lane
	LPPOLYGONDATA poly[7];
    struct OBJPOLYBLOCK obj[4]; // the POLYOBJ chunks
		// if not present, then all objects in the chunk are XOBJs
		// the 1st chunk is described anyway in the TRKBLOCK
} POLYGONBLOCK;

typedef struct ANIMDATA
{
	struct INTPT pt; //Center point of the animated object 
	short od1,od2,od3,od4;  //Coefficients of a quaternion. The coefficients in nfs are in the order: b d c a. See http://stackoverflow.com/questions/7937143/3d-rotation-without-trigonometry
} ANIMDATA;

typedef struct TYPE6DATA //Data for Type6 objects should always be 72 Bytes
{
	struct FLOATPT pt; //12 Bytes, Center point of the Type6 object == XObj refpt
	float mass; //4 Bytes - Mass of the t6 object
	unsigned char Data1[36]; //Unknown Data
	float hitbox_x, hitbox_z, hitbox_y; //12 Bytes
	unsigned char Data2[8]; //Unknown Data
} TYPE6DATA;

typedef struct XOBJDATA
{
	long crosstype; // type 4, or more rarely 3 (animated): JimD: Type 2 is onyl used in HS!, Type 6 complex behavior only in global object chunk 1
	long crossno;   // obj number from REFXOBJ table in TRKBLOCK
	long unknown;
// this section only for type 4 basic objects
	struct FLOATPT ptRef;
	long AnimMemory; // JimDiabolo : nAnimLength * 20 + 8
// this section only for type 3 animated objects
	short unknown3[9]; // 6 first are all alike; [6]==[8]=?; [7]=0
	// in HS, only 6 are used ; 6 = expected 4
	char type3,objno;  // type3==3; objno==index among all block's objects?
	short nAnimLength,AnimDelay; //JimDiabolo : The bigger the AnimDelay, that slower is the movement
	struct ANIMDATA *animData;
// common section
	long nVertices;
	struct FLOATPT *vert;  // the vertices
	struct BGRA *vertshade;
	//long *unknVertices;
	long nPolygons;
	struct POLYGONDATA *polyData;  // polygon data
	//char *hs_type6;
	struct TYPE6DATA hs_type6;
} XOBJDATA;

typedef struct XOBJBLOCK
{
	long nobj;
	struct XOBJDATA *obj;
} XOBJBLOCK;

#pragma pack(1)
typedef struct TEXTUREBLOCK // WARNING: packed but not byte-aligned !!!
{
	short width,height;
	unsigned long unknown1;
	float corners[8]; // 4x planar coordinates == tiling?
	unsigned long unknown2;
	char islane;      // 1 if not a real texture (lane), 0 usually
	short texture;    // index in QFS file
} TEXTUREBLOCK;
#pragma pack()

// the associated COL file

#define XBID_TEXTUREINFO 2
#define XBID_STRUCT3D 8
#define XBID_OBJECT 7
#define XBID_OBJECT2 18
#define XBID_VROAD 15

typedef struct XBHEAD {
	long size;
	short xbid;
	short nrec;
} XBHEAD;

typedef struct COLTEXTUREINFO {
	short texture;  // position in .QFS file
	short unknown1; // zero ?
	short unknown2; // texture offset ?
	short unknown3;
} COLTEXTUREINFO;

typedef struct COLVERTEX {
	struct FLOATPT pt; // relative coord
	long unknown;      // like the unknVertices structures in FRD
} COLVERTEX;

typedef struct COLPOLYGON {
	short texture;
	char v[4]; // vertices
} COLPOLYGON;

typedef struct COLSTRUCT3D {
	long size;
	short nVert,nPoly;
	struct COLVERTEX *vertex;
	struct COLPOLYGON *polygon;
} COLSTRUCT3D;

typedef struct COLOBJECT {
	short size;
	char type;     // 1 = basic object, 3 = animated ...
	char struct3D; // reference in previous block
// type 1
	struct INTPT ptRef;
// type 3
	short animLength;
	short unknown;
	struct ANIMDATA *animData; // same structure as in xobjs
} COLOBJECT;

typedef struct COLVECTOR {
	signed char x,z,y,unknown;
} COLVECTOR;

typedef struct COLVECTOR_VIT {
	signed char x,z,y;
} COLVECTOR_VIT;


typedef struct COLVROAD {
	struct INTPT refPt;
	long unknown;  // flags ?
	struct COLVECTOR normal,forward,right;
	long leftWall,rightWall;
} COLVROAD;

typedef struct COLVROAD_VIT {
	struct INTPT refPt;
	union {
		struct { unsigned char RightMask, LeftMask; };
		unsigned short FullMask;
	};
	unsigned char wallKinds;
	char _zero;
	struct COLVECTOR_VIT normal;
	unsigned char scales;
	struct COLVECTOR_VIT forward;
	unsigned char LeftCenter;
	struct COLVECTOR_VIT right;
	unsigned char RightCenter;
	long leftWall,rightWall;
} COLVROAD_VIT;

typedef struct HS_VROADBLOCK { // HS's equivalent to a COLVROAD
    struct FLOATPT refPt;
    struct FLOATPT normal,forward,right;
    float leftWall,rightWall;
	union {
		struct {
			float centers[2];
			short xtraNei[2];
			long scales[2];
			short fullMap;
			short _unknown1;
			char wallKinds[2];
			char _unknown2[2];
		};
		struct {
			float unknown1[2];
			long unknown2[5];
		};
	};
} HS_VROADBLOCK;

typedef struct HS_EXTRA { // HS's Extra Data 28 Bytes
    float WidthLeftLane,WidthRightLane;
	//long unknown1;
	short ShortcutToVRoad[2]; //Contains the number of the VRoad point to which there is an shortcut. If there are none it is -1. Two VRoad points can be specified.
	long nLeftLanePolys,nRightLanePolys;
	unsigned char LanesRightPassable, LanesLeftPassable;  //Unknowdata 0,1 ==  View on lanes for AI described in bits. "LanesLeftPassable" are Left from VRoad. "LanesRightPassable" are the right sight. 
												 //Here is a sample, block 14 from Uk track. It has 00000011 and 01100000 for all VRoad points. That means four drivable lanes ("1") and one blocked ("0") in the middle, right from VRoad RefPoint.
	unsigned char Unknown2[2]; // Unknowdata 2,3
	unsigned char ChromeEffect[2]; // Unknowdata 4,5 == ChromeEffect on Cars. With 00, there's no chrome at all. Use 02 - low chrome with always dry road, weather effects has no effect on this. 04 - normal chrome with dry or wet road, depends on weather effects disabled or enabled
	unsigned char HallEffect[2]; // Unknowdata 6,7 == Hall effect Left an right from VRoad, Set them to 03 or 04 for hall effect. 00 to disable hall effect. 06 is used in the underwater tunnel of aquatica.
} HS_EXTRA;

typedef struct COLFILE {
	char collID[4]; // 'COLL'
	long version;   // 11
	long fileLength;
	long nBlocks;
	long xbTable[5];
	struct XBHEAD textureHead;
	struct COLTEXTUREINFO *texture;
	struct XBHEAD struct3DHead;
	struct COLSTRUCT3D *struct3D;
	struct XBHEAD objectHead;
	struct COLOBJECT *object;
	struct XBHEAD object2Head;
	struct COLOBJECT *object2;
	struct XBHEAD vroadHead;
	struct COLVROAD *vroad;
	//struct HS_VROADBLOCK *vroad;
	struct HS_EXTRA *hs_extra; // for the extra HS data in COLVROAD
} COLFILE;

typedef struct UNDOINFO {
	struct TRKBLOCK *trk;
	struct POLYGONBLOCK *poly;
	struct XOBJBLOCK *xobj[4];
} UNDOINFO;

typedef struct CLIPBLOCK {
	int clipBlk;
	int clipIsobj;
	int clipChunk;
	int clipNo;
	BOOL bHSMode;
	BOOL clipspdFALoaded;
	BOOL clipspdRALoaded;
	BOOL clipHeightsLoaded;
	struct TRKBLOCK *trk;
	struct POLYGONBLOCK *poly;
	struct XOBJBLOCK *xobj[4];
} CLIPBLOCK;

typedef struct FINDPOLYDATA {
	int texture;
	BOOL	search_texture;
	short   hs_flags;
	BOOL	search_hs_flags;
	unsigned char texanimdata;
	BOOL	search_texanimdata;
	unsigned char	pvrflags;
	BOOL			search_pvrflags;
} FINDPOLYDATA;

typedef struct PDATA
	{
		int vertex[4];
		int texture;
		unsigned char texanimdata;
		unsigned char unknown2;
		short hs_textflags; //HS Texture flags
	} PDATA;

typedef struct NOBJDATA
	{
		int nVert;
		int nPoly;
		struct FLOATPT *Vertices;
		struct BGRA *vertshade;
		struct PDATA *Polys;
	} NOBJDATA;

typedef	struct SETTING {
	int	m_add_replace_block;
	BOOL m_bool_add_replace_block_move;
	BOOL m_bool_add_replace_block_move_z;
	BOOL m_bool_add_replace_block_rotate;
	BOOL m_bool_add_replace_block_expand_lenght;
	BOOL m_bool_add_replace_block_expand_width;
	BOOL m_bool_add_replace_block_paste_block;
	BOOL m_bool_add_replace_block_paste_heights;
	BOOL m_bool_add_replace_block_paste_spdfa;
	BOOL m_bool_add_replace_block_paste_spdra;
	BOOL m_bool_add_replace_block_paste_vroad;
	BOOL m_bool_add_replace_block_rearrange_block_obj;
	BOOL VRoadPaste_bHeights;
	BOOL VRoadPaste_bHS_extra;
	BOOL VRoadPaste_bSPDFA;
	BOOL VRoadPaste_bSPDRA;
	BOOL VRoadPaste_bVRoad;
	float  clearDlg_m_shape_x;
	float  clearDlg_m_shape_y;
	BOOL clearDlg_m_shape_extra;
	unsigned int clearDlg_m_numc1;
	unsigned int clearDlg_m_numc2;
	int clearDlg_m_sizec1;
	int clearDlg_m_sizec2;
	BOOL clearDlg_m_elevation_extra;
	unsigned int clearDlg_m_numz1,clearDlg_m_numz2;
	int clearDlg_m_sizez1, clearDlg_m_sizez2;
	float clearDlg_m_height;
	float	expand_m_floatExpMulti_x;
	float	expand_m_floatExpMulti_y;
	float	expand_m_floatExpMulti_z;
	BOOL	expand_m_chk_connected;
	int		expand_m_radio_alignment;
	float	expand_bl_m_edit_height;
	float	expand_bl_m_edit_lenght;
	float	expand_bl_m_edit_width;
	float	expand_track_m_edit_xy;
	float	expand_track_m_edit_z;
	double	rotate_m_edit_angle;
	float	ray_m_theta;
	float	ray_m_rho;
	float	ray_m_float_light_multi;
	int		ray_m_iEndBlock;
	int		ray_m_iStartBlock;
	BOOL	ray_m_bRayTraceSun;
	BOOL	ray_m_b_CheckAlpha;
	BOOL	ray_m_bCheckTrack;
	BOOL	ray_m_bCheckFences;
	BOOL	ray_m_bCheckLanes;
	BOOL	ray_m_bCheckObjects;
	BOOL	ray_m_bCheckEObjects;
	BOOL	ray_m_bCheckGObjects;
	BOOL	ray_m_bCheckMiddle;
	BOOL	ray_m_bCheckClose;
	BOOL	ray_m_bLightTrace;
	BOOL	ray_m_bCheckT[7];
	BOOL	ray_m_bCheckCST[7];
	unsigned char ray_m_shade_blue;
    unsigned char ray_m_shade_green;
    unsigned char ray_m_shade_red;
    unsigned char ray_m_sun_blue;
    unsigned char ray_m_sun_green;
    unsigned char ray_m_sun_red;
	float MoveTo_dest_x;
	float MoveTo_dest_y;
	float MoveTo_dest_z;
	BOOL  MoveTo_no_smooth;
	BOOL  ConnectBlocks;
	float ConnectBlocks_dist;
	int	AdjustRoad_AdjustType;
	int AdjustRoad_StartBlock;
	int AdjustRoad_EndBlock;
	BOOL AdjustRoad_Check_VR;
	//BOOL AdjustRoad_Check_Lane;
	BOOL AdjustRoad_Check_Man_Set_Num_Lanes;

	BOOL AdjustRoad_Check_Change_VR_Width;
	BOOL AdjustRoad_Check_Detect_lanes;
	BOOL AdjustRoad_Check_Auto_Set_Lane_Bitcoded;
	BOOL AdjustRoad_Check_Auto_Set_Lane_Polys;
	BOOL AdjustRoad_Check_Auto_Set_Lane_Width;

	unsigned int AdjustRoad_Size[4];
	BOOL BlockProp_C_Shading;
	BOOL	VRoadHeightsSpd_Chk_Heights;
	BOOL	VRoadHeightsSpd_Chk_SpdFa;
	BOOL	VRoadHeightsSpd_Chk_SpdRa;
	BOOL	VRoadHeightsSpd_Chk_VRoad;
	BOOL	VRoadHeightsSpd_Chk_HSExtra;
	BOOL	VRoadHeightsSpd_Chk_PVR;
	int		VRoadHeightsSpd_Combo_Calc;
	BOOL	VRoadHeightsSpd_Chk_VRoad_z;
	BOOL	VRoadHeightsSpd_Chk_AI_Lane_Recalc;
	int		FindPoly_block_choice;
	BOOL	FindPoly_trackpolys;
	int		FindPoly_startbl;
	int		FindPoly_endbl;
	BOOL	FindPoly_extraobj;
	BOOL	FindPoly_polygonobj;
	int		FindPoly_texture;
	BOOL	FindPoly_chk_texture;
	short   FindPoly_m_flags;
	BOOL	FindPoly_chk_m_flags;
	unsigned char FindPoly_texanimdata; //for texture animation data...
	BOOL	FindPoly_chk_texanimdata;
	unsigned char	FindPoly_pvrflags;
	BOOL	FindPoly_chk_pvrflags;
	unsigned int FindPoly_select_percent;
	int		setvisi_int_num_blocks;
	int		setvisi_int_tr_bl_fromto;
	int		setvisi_int_end;
	int		setvisi_edit_start;
	int		setvisi_behavior;
	short	fencetexture;
	short	lanetexture;
	} SETTING;

typedef struct MOVETO {
	BOOL DestPointSet;
	struct FLOATPT DestPt;
} MOVETO;

typedef struct HEIGHTSSIM {
	float heights; // store heights.sim data
} HEIGHTSSIM;

typedef struct SPDFILE { // store spdxA.bin data
	unsigned char Speedvalue;
	unsigned char AI_Lane;
	float AI_Float; 
} SPDFILE;

typedef struct CAMDATA { // Camera Data (68 Bytes)
	unsigned long CamType; //4 Bytes
	FLOATPT CamPosition; //12 Bytes
	float floatData[9];
	float ZoomFactor; //4 Bytes
	unsigned long Start, Render, Stop;  //12 Bytes
} CAMDATA;

typedef struct CAMFILE { // store Tr.cam data
	long nCams;
	struct CAMDATA *pCamData;
} CAMFILE;

typedef struct CLIPVROAD {
	BOOL bHSMode;
	struct COLVROAD colvrdata;
	struct HEIGHTSSIM heights;
	struct SPDFILE spdFAdata, spdRAdata;
	long hs_extra[7];
} CLIPVROAD;

//HOO: Header file to add a track view (1)
#include "TrackView.h"
//HOO: Place here because it requires some of the above structures (1)

//Start for lineSegIntersectTri
class vec3 {
public:
    float x, z, y;

    float dot(const vec3& b) {
        return vec3::x * b.x + vec3::y * b.y + vec3::z * b.z;
    }

    vec3 cross(const vec3& b) {
        return vec3::vec3(
            vec3::y * b.z - vec3::z * b.y,
            vec3::z * b.x - vec3::x * b.z,
            vec3::x * b.y - vec3::y * b.x
        );
    }

    vec3 normalize() {
        const float s = 1.0f / sqrtf(vec3::x * vec3::x + vec3::y * vec3::y + vec3::z * vec3::z);
        return vec3::vec3(vec3::x * s, vec3::y * s, vec3::z * s);
    }

    vec3 operator+(const vec3& b) {
        return vec3::vec3(
            vec3::x + b.x,
            vec3::y + b.y,
            vec3::z + b.z
        );
    }
    vec3 operator+=(const vec3& b) {
        *this = vec3::operator+(b);
        return *this;
    }

    vec3 operator-(const vec3& b) {
        return vec3::vec3(
            vec3::x - b.x,
            vec3::y - b.y,
            vec3::z - b.z
        );
    }
    vec3 operator-=(const vec3& b) {
        *this = vec3::operator-(b);
        return *this;
    }

    vec3 operator*(const vec3& b) {
        return vec3::vec3(
            vec3::x * b.x,
            vec3::y * b.y,
            vec3::z * b.z
        );
    }
    vec3 operator*=(const vec3& b) {
        *this = vec3::operator*(b);
        return *this;
    }
    vec3 operator*(float b) {
        return vec3::vec3(
            vec3::x * b,
            vec3::y * b,
            vec3::z * b
        );
    }
    vec3 operator*=(float b) {
        *this = vec3::operator*(b);
        return *this;
    }

    vec3 operator/(const vec3& b) {
        return vec3::vec3(
            vec3::x / b.x,
            vec3::y / b.y,
            vec3::z / b.z
        );
    }
    vec3 operator/=(const vec3& b) {
        *this = vec3::operator/(b);
        return *this;
    }
    vec3 operator/(float b) {
        return vec3::vec3(
            vec3::x * b,
            vec3::y * b,
            vec3::z * b
        );
    }
    vec3 operator/=(float b) {
        *this = vec3::operator/(b);
        return *this;
    }

    vec3(float x, float y, float z) {
        vec3::x = x;
        vec3::y = y;
        vec3::z = z;
    }
	vec3(struct FLOATPT v) {
        vec3::x = v.x;
        vec3::y = v.y;
        vec3::z = v.z;
    }
	vec3(struct FLOATPT *v) {
        vec3::x = v->x;
        vec3::y = v->y;
        vec3::z = v->z;
    }
	vec3(struct INTPT pt) {
        vec3::x = ((float) pt.x)/65536;
        vec3::y = ((float) pt.y)/65536;
        vec3::z = ((float) pt.z)/65536;
    }
	vec3(struct SHORTPT pt) {
        vec3::x = ((float) pt.x)/256;
        vec3::y = ((float) pt.y)/256;
        vec3::z = ((float) pt.z)/256;
    }
    vec3(float x) {
        vec3::x = x;
        vec3::y = x;
        vec3::z = x;
    }
    vec3() {
        //
    }
    ~vec3() {
        //
    }
};

typedef struct SELINFO
{
	int refblock, sceneRefBlock;
	struct FLOATPT *refnode;
	struct FLOATPT myrefnode; // if it's an xobj !!!
	// for POLYGON mode
	LPPOLYGONDATA refpoly;
	struct FLOATPT *refvertices;
	long *refshadingvert;
	int refchunk; // 0..3 for objects/xobjs, else 0..6
	int refpolyobj;   // object #, -1 if track polygon
	int refpolyno;
	int nPt; //Number of point in list
	// for both POLYGON and OBJECT modes
	int isxobj; // 0 if not, 1 if xobj, 2 lightsrc, 3 soundsrc, 4 VRoad point, 5 replay camera, 6 AI Points 
		// in polygon mode, must add refnode==center to coordinates
	struct FLOATPT *coreref;
	// OBJECT mode only
	int objno;
	BOOL trackkpoly;
} SELINFO;

//For TNFS_SE Import

typedef struct TNFS_INT8PT
{
	char rx,rz,ry; //relative x,z,y coordinate
} TNFS_INT8PT;

typedef struct TNFS_INTPT
{
	long x,z,y; //relative x,z,y coordinate
} TNFS_INTPT;

typedef struct TNFS_SE_VROAD
{
	unsigned char a[4]; //a0,a1,a2,a3 are 8-bit values which specify the width of the main road, and the width of the finging area.
	unsigned char b[4];//b0,b1,b2,b3 are 8-bit values of unknown purpose.
	//long x,z,y; //- x, z and y coordinates are signed long values.
	struct INTPT refPt;
	short slope, slant_A, orientation, unknown1, y_orientation, slant_B, x_orientation, unknown2;
} TNFS_SE_VROAD;

typedef struct TNFS_SE_OBJ_DATA  //16 bytes long
{
	long refnode; //reference node
	//unsigned char bitmap; //bitmap number
	unsigned char descriptorRef; //descriptorRef number
	//unsigned char rotation; //flip - The 8-bit flip value is equal to 0 for an object that is perfectly perpendi-cular to the track (e.g. a road sign), larger values for objects that are slightly turned, until 64 for an object that is mapped along the track (e.g. an ad on the side of the road), then up to 128 which is the perfectly reversed position.
	unsigned char Orientation; //OpenTNFS name
	unsigned char flags[4]; //flags (unknown purpose)
	//short rx,rz,ry; //relative x,z,y coordinate
	struct SHORTPT rpos; //relative x,z,y coordinate
} TNFS_SE_OBJ_DATA;

typedef struct TNFS_SceneryObjectDescriptor  //The sixteen byte records!
{
	unsigned char Flags;  //Byte 0
	unsigned char Type;   //BYte 1
	unsigned char ResourceId;  //Byte 2
	unsigned char ResourceId2; //Byte 3
	unsigned char unknown1[2]; //Byte 4+5
	short Width; //Byte 6 + 7
	unsigned char AnimationFrameCount; //Byte 8
	unsigned char unknown2[5]; //Byte 9 to 13 
	short Height; //Byte 14 + 15
} TNFS_SceneryObjectDescriptor;

typedef struct TNFS_SceneryObject
{
	struct TNFS_SceneryObjectDescriptor Descriptor;
	int ReferenceNode;
	float Orientation;
	vec3 RelativePosition;
} TNFS_SceneryObject;

typedef struct TNFS_SE_OBJ_CHUNK
{
	unsigned char three_byte[1800]; //3-byte records (there are 600... as many as scenery blocks ?)
	long objectDescriptorCount; //40h (?)
	long objectCount; //3E8h = 1000 (size of the main block in records)
	unsigned char sjob[4];
	long unknown3; //428Ch (total length of the remaining blocks)
	long unknown4; //? - not after TNFS_SceneryObjectDescriptor ?
	//unsigned char sixteen_byte[0x400]; //16-byte records -> objectDescriptor Data
	struct TNFS_SceneryObjectDescriptor sd[64]; //16 bytes * 64 Entries = 1024 == 0x400
	struct TNFS_SE_OBJ_DATA objdata[1000];
} TNFS_SE_OBJ_CHUNK;

typedef struct TNFS_SE_SCENERY
{
	unsigned char TRKD[4]; //'TRKD'
	long blockLength; //114h = length of the record contents
	long blockNumber; //00000000h
	unsigned char unknown1, fencetype;  // ? - fencetype Bit 0-5 Texture of fence, bit 6 = right fence, bit 7 left fence
	unsigned char bitmap[10]; //textures
	//struct TNFS_INTPT refpoint; //reference point
	struct SHORTPT points[44];  //A0 - D10 Each point is given by three signed 16-bit relative coordinates (x,z,y as usual). The coordinates are in the same reference frame as in the virtualroad data. The coordinates are relative to the virtual track point as given in the virtual track data.
} TNFS_SE_SCENERY;

typedef struct TNFS_BLOCK_DATA
{
	//struct FLOATPT vertices[44];
	vec3  vertices[44];
} TNFS_BLOCK_DATA;

typedef struct FAM_Chunk
{
	unsigned char Type[4]; //'WWWW' ?
	long nSubchunks;
	unsigned char *pData;
	long *pSuChOffset;
} FAM_Chunk;

// End TNFS_SE import

//#define EPSILON 0.000001f
//End for lineSegIntersectTri


class CT3EDDoc : public CDocument
{
protected: // create from serialization only
	CT3EDDoc();
	DECLARE_DYNCREATE(CT3EDDoc)

// Attributes
public: 
	
	float memory_Zh; //Nappe1: Height_h Copy/Paste
	float memory_Zl; //Nappe1: Height_l Copy/Paste
	float memory_x; //JimD: X position Copy/Paste
	float memory_y; //JimD: Y position Copy/Paste
	int ZCopyMode; //Nappe1: memory_Zh's paste mode.
	int nSpeedFileShift;
	char AttachpointCount; //Nappe1 number of Attach Points.
	FLOATPT *AttachpointList[256]; //Nappe1: for attaching objects on the ground.
	FLOATPT MemObjMax, MemObjMin, MemObjMiddle;
	BOOL bEmpty;
	BOOL bHSMode, bMCOMode;
	BOOL HeightsLoaded, spdFALoaded, spdRALoaded, CamsLoaded ;
	BOOL bAutoObjMem;
	char header[28], headerMCO[16]; /* file header */
	long nBlocks;
	struct TRKBLOCK *trk;
	struct POLYGONBLOCK *poly;
	struct XOBJBLOCK *xobj; // xobj[4*blk+chunk]; global=xobj[4*nblocks]
	long hs_morexobjlen;
	char *hs_morexobj;  // 4N & 4N+1 in HS format (xobj[4N] left empty)
	long nTextures;
	struct TEXTUREBLOCK *texture;
	struct COLFILE col;
	struct SETTING settings;
	struct MOVETO MoveToPoint;
	struct HEIGHTSSIM *hightssim;
	struct SPDFILE *spdFAbin, *spdRAbin;
	struct CAMFILE Camfile;
	struct FLOATPTLIST *FPtListShadow;  //A list of points with shadows
	struct FLOATPTLIST *FPtListNoShadow;  //A list of points without shadows

	//HOO: The track view object (2)
	CTrackView* TrackView;
	BOOL bUpdatedScene;
	BOOL bCreateScene;
	//HOO: Scene can be only created once after reseting (2)

// undo info
	struct UNDOINFO undo[UNDO_LEVELS][MAX_BLOCKS];
	struct COLVROAD *undoCol[UNDO_LEVELS];
	struct HS_EXTRA *undoCol_hsextra[UNDO_LEVELS];
	struct FLOATPT undoRefpt[UNDO_LEVELS];
	struct HEIGHTSSIM *undoHeights[UNDO_LEVELS];
	struct SPDFILE *undoSpdFa[UNDO_LEVELS], *undoSpdRa[UNDO_LEVELS];
	struct CAMFILE *undoCam[UNDO_LEVELS];

	int undoRefblk[UNDO_LEVELS],undoOfsx[UNDO_LEVELS],undoOfsy[UNDO_LEVELS],undo_nBlocks[UNDO_LEVELS],undo_vroadHead_nrec[UNDO_LEVELS];
	int undoLevel;
	BOOL wasInitiallyModified;
	CQFSView qfsView;

// Operations
public:
	void PrepareNewUndo(struct FLOATPT *refpt,int block,int ofsx,int ofsy);
	void PrepareModifyTrk(int blk);
	void PrepareModifyPoly(int blk);
	void PrepareModifyXobj(int blk);
	void FreeTrkContents(struct TRKBLOCK *trk);
	void FreePolyContents(struct POLYGONBLOCK *poly);
	void FreeXobjContents(struct XOBJBLOCK *xobj);
	void DeleteUndo(int i);
	void PerformUndo(BOOL KeepVRoad=false);

	BOOL CanContainPoint(struct TRKBLOCK *t,struct FLOATPT *pt,float margin);
	void RecalcBoundingBox(int i);
	void RecalcPolyVroad(int blk,int no,struct FLOATPT *optdir=NULL);
	void MovePointBy(struct FLOATPT *refpt,float dx,float dy,float dz);
	void ExtMovePointBy(struct FLOATPT *refpt,float dx,float dy,float dz,float sDist,float sWidth);
	int MoveObjectBy(int blk,int isxobj,int chunk,int no,float dx,float dy,float dz, BOOL AltKey=FALSE, BOOL ShowFwSPD=TRUE);
	void ChangeObjBlock(int blk1,int isxobj,int chunk1,int no,int blk2,int chunk2=-1);
	float Distance(struct FLOATPT &a,struct INTPT &b);
	int GlobalLocalCoord(struct FLOATPT &org,struct FLOATPT &res,struct COLVROAD *c,int start,int minblk,int maxblk);
	void LocalGlobalCoord(struct FLOATPT &org,struct FLOATPT &res,struct COLVROAD *c,int i);
	void MoveBlocks(int blk,float dx,float dy,float dz,int sDist,int sWidth,int extraSmooth, float *extradata=NULL);
	void UpdateColVroadVecs(int i);
	void DelObject(int blk,int isxobj,int chunk,int no);
	void DuplObject(int blk,int isxobj,int chunk,int no);
	void NewObject(int blk,int isxobj,int chunk,int texture,short flags,int xobjcrosstype, vec3 *position=NULL, float Width=2, float Height=2);
	bool DelPolygon(int blk,int isxobj,int chunk,int obj,int no);
	void SetCollisionHandling(struct FLOATPT *pt);
	BOOL DoesPointExist(struct FLOATPT *pt);
	int DuplPolygon(int blk,int isxobj,int chunk,int obj,int no);
	void MergePoint(struct FLOATPT *pt1,struct FLOATPT *pt2);
	void SplitPoint(struct FLOATPT *refpt);
	void AdjustRoadWidth(int AdjustType, int Startblk, int Endblk, float size[4], BOOL Set_nLanes=FALSE);
	void HS_RecalcMinMaxXY();
	void SetAllTextures(int texture,BOOL drivable,short flags);
	void DelAllObjects(int blk,int isxobj);
	void DelLanePolygons(int blk, BOOL fences, BOOL soundsrc);
	void ClearSceneryZ();
	void DelTrackPolygon(int blk,int no);
	int DuplTrackPolygon(int blk,int no);
	void SetRoadVertexShading(int nStartBlk, int nEndBlk, unsigned long dwColorValue);
	void SetXObjVertexShading(int nStartBlk, int nEndBlk, unsigned long dwColorValue);
	unsigned long RGBTool(CString inmode, unsigned long dwColorValue, CString outmode); //Nappe1: name says it all. 
	float VectorAngle(struct FLOATPT Vect1, struct FLOATPT Vect2, struct FLOATPT Startpt);
	int PolysNode(int blk, int polynum);
	CString MedDetailFixer(int blk, int AngleLimit);
	CString VertArrayFixer(int blk);
	FLOATPT SumVector(FLOATPT vect1, FLOATPT vect2);
	FLOATPT VectorNormalize (FLOATPT nc);
	FLOATPT QuadNormalVectorCalc(FLOATPT a, FLOATPT b, FLOATPT c, FLOATPT d);
	FLOATPT NormalVectorCalc(FLOATPT a, FLOATPT b, FLOATPT c);
	FLOATPT VertexNormal(int blk, int VertexIndex);
	int GetCenterQuad(int blockIdx, int nodeIdx);
	void CorrectVirtualRoad(int blockIdx, int nodeIdx);
	void CorrectVirtualRoad();
	CString CT3EDDoc::ShadeBlock(int blk, float theta, float rho, struct BGRA sun, struct BGRA shadow, BOOL Fences, BOOL Lanes, BOOL Alpha255only, BOOL CheckMiddle, BOOL ObjCastShadows[7]);
	CString ShadeObject(int blk, float theta, float rho, struct BGRA sun, struct BGRA shadow, BOOL Alpha255only, BOOL CheckMiddle, BOOL ObjCastShadows[6]);
	CString frdfilename, fileDir;
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CT3EDDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void DeleteContents();
	virtual void OnCloseDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	int BlockFound;
	int FindNearestBlockTrackPolyBased(FLOATPT *refpt);
	void SpeedFileShiftData(SPDFILE *spdfiledata, int step);
	bool SpeedFile_Calc_Speed_Between2AIPoints(int p1, int p2, bool FwSPD, bool UseCos);
bool SpeedFile_Calc_Float_Between2AIPoints(int p1, int p2, bool FwSPD, bool UseCos=true);
	short NewLane(int blk, int texture=2048, short flags=0, vec3 *vertices=NULL);
	bool FAM_GetChunkData(struct FAM_Chunk *FC);
	short NewFence(int blk, int chunk, int texture=10, short flags=-32768, vec3 *vertices=NULL);
	void MergeDoubleVerticesOfBlock(int blk);
	int AddTrackPolygonBeforeAfter(int blk, int chunk, int no);
	bool TrackPolygonIsLastInRow(int blk, int chunk, int polyno);
	bool TrackPolygonIsFirstInRow(int blk, int chunk, int polyno);
	bool TrackPolysConnected(int block, int poly1, int poly2);
	void VRoadLanesRecalc(int VRoadPoint, BOOL bSet_Lane_Bitcoded=TRUE, BOOL bSet_nLanes=FALSE, BOOL bSet_Lane_Width=FALSE);
	int TrackPolyBelow(int block, FLOATPT refpt, int *FoundBlock=NULL, int *DriverOverBehavior=NULL);
	void ShowUnknownData(unsigned char *data, UINT nBytes, CString sTitle);
	BOOL LoadMCOFRD(CArchive& ar,long nPos);
	FLOATPT LastMove, LastDistance;
	bool IsBlockNeighbor(int refblock, int block);
	bool ReadTrIni(LPCTSTR lpSection, LPCTSTR lpKey, CString& strRet,  LPCTSTR lpDefault);
	bool LineSegIntersectPolyM(vec3 line[2], vec3 poly[4], vec3* point, float pmulti=0.05);
	int RayCheck_Line_on_Block_Neighbors(vec3 line[], int checkblock, BOOL ObjCastShadows[7], vec3 *point, vec3 cpoint);
	struct FLOATPT Vec3ToFloatpt(vec3 v);
	int RayCheck_Line_on_Block(vec3 line[], int checkblock, BOOL ObjCastShadows[7], vec3 *point, vec3 cpoint);
	//int RayCheck_Line_on_Block(int block, BOOL ObjCastShadows[7], long nLight, float LightDistMulti=0.1, bool CheckTrackPolyOnly=false);
	float DistVec3(vec3 pt1, vec3 pt2);
	//void RayTraceLight(int block, long nLight, bool CheckTrackPolyOnly=false);
	void RayTraceLight(int block, long nLight, float LMulti=0.1, BOOL bLoTrack=TRUE, BOOL bLoObj=TRUE, BOOL bLoFences=TRUE, BOOL bLoLanes=TRUE, BOOL bLoGlobal=TRUE, BOOL bLoExtra=TRUE, BOOL bAlpha=TRUE, BOOL *pObjCastShadows=NULL, BOOL *pTypesToChange=NULL);
	LIGHTDATA GetLightData(int glow);
	long AddSound(int blk, struct FLOATPT *refpt, unsigned char Bytes[4]);
	BOOL IsSamePoint(struct FLOATPT *pt1, struct FLOATPT *pt2);
	long AddLight(int blk, struct FLOATPT *refpt, unsigned char Bytes[4]);
	void DropObject(int blk, int isxobj, int chunk, int no);
	float FindZonRoad(int block, FLOATPT refpt, bool CheckTrackPolyOnly=true);
	bool LineSegIntersectPoly(vec3 line[2], vec3 poly[4], vec3* point);
	bool LineSegIntersectTri(vec3 line[2], vec3 tri[3], vec3* point);
	BOOL GetXYZfromClipboard(FLOATPT *refpt);
	int SortCams(int oCamNum=0);
	CString GetClipboardText();
	int FindNearestVRoadRefPt(FLOATPT *refpt);
	int RealSliceNum(int slice);
	int FindNearestBlock(FLOATPT *refpt);
	BOOL PasteCamFromClipboard();
	BOOL IsCamOnClipboard();
	BOOL CopyCamToClipboard(int no);
	void PrepareModifyCameras();
	void SaveCams();
	BOOL LoadCam();
	BOOL AdjustVRoadPointZ(int no);
	BOOL IsVRoadOnClipboard();
	BOOL PasteVRoadFromClipboard(int no, BOOL VRoadData, BOOL Heights, BOOL spdFA, BOOL spdRA, BOOL HSextra);
	BOOL CopyVRoadToClipboard(int no);
	void SetVisibilityMin(int startbl, int endbl, int distance);
	//void PrepareModifyVRoad();
	int ShadeFindNear(int blk,FLOATPT pt, float dist);
	void ShadeNear(int blk, struct BGRA sun, struct BGRA shadow);
	void FPtListClear();
	void FPtListAddPoint(int blk, int isxobj, int chunk, int nobj, int nvert, struct FLOATPT vert, float shadow);
	void FPtListCreate();
	float DistFloatPt(struct FLOATPT *pt1, struct FLOATPT *pt2);
	int RemapObjects(int blk);
	void ExpandFloatPtSimple(FLOATPT *fpt, float x, float y, float z);
	void ExpandIntPtSimple (struct INTPT *ipt,float x, float y, float z);
	void Expandwholetrack(float x,float y,float z);
	CString ShadeObjectExtraGlobalObject(int blk, float theta, float rho, struct BGRA sun, struct BGRA shadow, BOOL Alpha255only, BOOL ObjCastShadows[6], BOOL TypesToChange[6]);
	int RayCheck_Start_Dir_on_Block(double StartPos[3], double RayDir[3], int checkblock, BOOL ObjCastShadows[6]);
	void SetVertShade(int block, struct FLOATPT *refpt, struct BGRA vertshade, bool addmode=false);
	struct BGRA GetVertShade(int block, struct FLOATPT *refpt);
	void SaveTestBin(char *Data, int len);
	void RecalcPolyVroadForBlock(int blk, int mode=0);
	void NeighborsFixInsertBlock(int refbl);
	void VisibilityFixInsertBlock(int refbl);
	void VisibilityCorrect(int refbl);
	void VisibilitySetToBlock(int refbl, int bl);
	void VisibilityToggle(int refbl,int bl);
	int FindLaneInTextureblock(int Bitmap);
	int FindBitmapInTextureblock(int Bitmap);
	void Convert4to3(int blk);
	CString GetContainingFolder(CString &file);
	bool IsBlockVisibile(int refbl, int block);
	int RealBlockNum(int blk);
	void InDecreaseVis(int block,int direction,int InDe);
	void SetVisibility(int startbl, int endbl, int distance);
	void MoveLastBlockTo(int dblk);
	int DeleteBlock(int blk);
	int MergeBlocks(int blk1, int blk2);
	void PrepareModifyVRoadHeightsSpdFiles();
	void CutAmountOfBlocks(int NewnBlocks);
	void SaveSpeedFile(CFile &spdfileh, struct SPDFILE *spdpoint);
	BOOL LoadSpeedFile(CFile &spdfileh, struct SPDFILE *spdpoint);
	void SaveHeightssim(CFile &heightsfile);
	BOOL LoadHeightssim(CFile& heightsfile);
	void ChangeXobjRefpoint(int blk,int isxobj,int chunk,int no,float ptx,float pty,float ptz);
	void CopyObjectTo(int srcblk,int srcisxobj,int srcchunk,int srcno,int dstblk,int dstchunk);
	BOOL SaveOffFile(struct NOBJDATA *NewObjData, CString FileName);
	void CreateObjectData(struct NOBJDATA *NewObjData, int blk, int isxobj, int chunk, int objno, bool relative);
	BOOL ImportObject(struct NOBJDATA *NewObjData, int blk, int isxobj, int chunk, int objno, bool addmode);
	void DeleteDoubleVerticesFromObject(int blk, int isxobj, int chunk, int objno);
	BOOL ImportOffFile(CString FileName, int blk, int isxobj, int chunk, int no);
	void ConnectBlocks(int blk1, int blk2, float mdist);
	float VRoadLenght(int blk);
	void ExpandVertice(int blk,FLOATPT &ver, float xmulti, float ymulti, float zmulti);
	void ExpandBlock(int blk, float xmulti, float ymulti, float zmulti, bool NoUndo=false);
	void RotateINTPT(int blk,INTPT &pt, double angledegree);
	void RotateVertice(int blk, FLOATPT &ver, double angledegree);
	void RotateBlock(int blk, double angledegree, bool NoUndo=false);
	void MoveINTPT(INTPT &pt, float dx, float dy, float dz);
	void MoveVertice(FLOATPT &ver, float dx, float dy, float dz);
	void LoadSettings();
	void MoveBlockSimple(int blk,float dx,float dy,float dz, bool NoUndo=false);
	BOOL BlockClipboardInfo(struct CLIPBLOCK &cb);
	//struct CLIPBLOCK Clipblk;
	//struct NOBJDATA NewObjData;
	void PasteBlockfromClipboard(int mode, int blk, BOOL paste_block, BOOL paste_heights, BOOL paste_spdfa, BOOL paste_spdra, BOOL paste_vroad, BOOL AltKey=FALSE);
	int CopyBlockToClipboard(int blk,int isxobj=-1,int chunk=-1,int no=-1);
	BOOL PasteXYZfromClipboard(struct FLOATPT *refpt);
	BOOL CopyXYZToClipboard(struct FLOATPT *refpt);
	BOOL CopyTextToClipboard(CString strText);
	void RotateObject(int blk, int isxobj, int chunk, int no, double angledegree);
	BOOL ExpandObject(int blk, int isxobj, int chunk, int no, float xmulti, float ymulti, float zmulti);
	BOOL FindObjMinMax(int blk, int isxobj, int chunk, int no);
	void ChangeTexBlock(int blk,int offset);
	int MinTexBlock(int blk,int MinTextur);
	void ChangeTexObject(int blk, int isxobj, int chunk, int no, int offset,BOOL HSandHHFlags, short flags, unsigned char texanimdata);
	int MinTexObject(int blk,int isxobj,int chunk,int no,int MinTextur);
	virtual ~CT3EDDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	BOOL LoadFRD(CArchive& ar);
	BOOL LoadCOL(CFile& coll);
	void SaveFRD(CArchive& ar);
	void SaveCOL(CFile& coll);
	BOOL LoadHSFRD(CArchive& ar,long nPos);
	void CT3EDDoc::SaveHSFRD(CArchive& ar);

// Generated message map functions
protected:
	//{{AFX_MSG(CT3EDDoc)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	bool LoadT3edIni();
	void SaveT3edIni();
	void LoadSettingsFile();
	void SaveSettingsFile();
	void ExpandINTPT(int blk, INTPT &pt, float xmulti, float ymulti, float zmulti);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_T3EDDOC_H__EA21D10E_8ED3_11D2_8486_000000000000__INCLUDED_)
