// SoundLightProps.cpp : implementation file
//

#include "stdafx.h"
#include "T3ED.h"
#include "T3EDDoc.h"
#include "SoundLightProps.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSoundLightProps dialog


CSoundLightProps::CSoundLightProps(CWnd* pParent /*=NULL*/)
	: CDialog(CSoundLightProps::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSoundLightProps)
	m_strText1 = _T("");
	m_intBlock = 0;
	m_Byte1 = 0;
	m_Byte1hex = _T("");
	m_Byte2 = 0;
	m_Byte2hex = _T("");
	m_Byte3 = 0;
	m_Byte3hex = _T("");
	m_Byte4 = 0;
	m_Byte4hex = _T("");
	m_float_posx = 0.0f;
	m_float_posy = 0.0f;
	m_float_posz = 0.0f;
	m_float_light_multi = 0.0f;
	//}}AFX_DATA_INIT
}


void CSoundLightProps::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSoundLightProps)
	DDX_Control(pDX, IDC_COMBO_COLOR, m_combo_color);
	DDX_Text(pDX, IDC_TEXT1, m_strText1);
	DDV_MaxChars(pDX, m_strText1, 200);
	DDX_Text(pDX, IDC_EDIT_BLOCK, m_intBlock);
	DDV_MinMaxInt(pDX, m_intBlock, 0, 65535);
	DDX_Text(pDX, IDC_EDIT1, m_Byte1);
	DDX_Text(pDX, IDC_EDIT1_HEX, m_Byte1hex);
	DDX_Text(pDX, IDC_EDIT2, m_Byte2);
	DDX_Text(pDX, IDC_EDIT2_HEX, m_Byte2hex);
	DDX_Text(pDX, IDC_EDIT3, m_Byte3);
	DDX_Text(pDX, IDC_EDIT3_HEX, m_Byte3hex);
	DDX_Text(pDX, IDC_EDIT4, m_Byte4);
	DDX_Text(pDX, IDC_EDIT4_HEX, m_Byte4hex);
	DDX_Text(pDX, IDC_EDIT_POSX, m_float_posx);
	DDX_Text(pDX, IDC_EDIT_POSY, m_float_posy);
	DDX_Text(pDX, IDC_EDIT_POSZ, m_float_posz);
	DDX_Text(pDX, IDC_EDIT_RT_LIGHT_MULTI, m_float_light_multi);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSoundLightProps, CDialog)
	//{{AFX_MSG_MAP(CSoundLightProps)
	ON_EN_CHANGE(IDC_EDIT1, OnChangeEdit1)
	ON_EN_KILLFOCUS(IDC_EDIT_BLOCK, OnKillfocusEditBlock)
	ON_CBN_SELCHANGE(IDC_COMBO_COLOR, OnSelchangeComboColor)
	ON_BN_CLICKED(IDC_BUTTON_RT_LIGHT, OnButtonRtLight)
	ON_EN_CHANGE(IDC_EDIT2, OnChangeEdit2)
	ON_EN_CHANGE(IDC_EDIT3, OnChangeEdit3)
	ON_EN_CHANGE(IDC_EDIT4, OnChangeEdit4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSoundLightProps message handlers

void CSoundLightProps::OnChangeEdit1() 
{
	UpdateHex();

	if (bIsLight)
		if ((m_Byte1<106)&&(m_Byte1>-1))
		{
			m_combo_color.SetCurSel(m_Byte1);
			GetDlgItem(IDC_BUTTON_RT_LIGHT)->ShowWindow(TRUE);
		}
		else
		{
			m_combo_color.SetCurSel(-1);
			GetDlgItem(IDC_BUTTON_RT_LIGHT)->ShowWindow(FALSE);
		}

	UpdateData(FALSE);
}

BOOL CSoundLightProps::OnInitDialog() 
{
	CDialog::OnInitDialog();
	if (bAddMode)
	{
		GetDlgItem(IDC_EDIT_POSX)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_EDIT_POSY)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_EDIT_POSZ)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_LABEL_X)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_LABEL_Y)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_LABEL_Z)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_GROUP_POSITION)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_BUTTON_RT_LIGHT)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
	}
	
	CWnd *edblock=GetDlgItem(IDC_EDIT_BLOCK);
	if (!bSLAutoObjMem)
		edblock->EnableWindow(TRUE);

	if (bIsLight) InitColors();//Fill Color Combobox
	else 
	{
		GetDlgItem(IDC_COMBO_COLOR)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_BUTTON_RT_LIGHT)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_TXT_RT_LIGHT)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_EDIT_RT_LIGHT_MULTI)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_LABEL_INFO_BYTE_2)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
	}
	OnChangeEdit1(); //Select Color
	bTraceLight=false;

	//m_combo_color.InitializeDefaultColors();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CSoundLightProps::OnKillfocusEditBlock() 
{
	UpdateData(TRUE);
	if (m_intBlock>maxblock)
		m_intBlock=maxblock;
	if (m_intBlock<0)
		m_intBlock=0;
	UpdateData(FALSE);	
}

void CSoundLightProps::OnOK() 
{
	// TODO: Zustzliche Prfung hier einfgen
	if (m_intBlock>maxblock)
		m_intBlock=maxblock;
	if (m_intBlock<0)
		m_intBlock=0;
	CDialog::OnOK();
}

void CSoundLightProps::InitColors()
{
	int i;
	CString sStr="";
	DWORD Color;
	
	for (i=0;i<nLights;i++)
	{

		//sStr.Format("glow %d, intensity %d, diameter %f",i, AllLightsData[i].intensity,AllLightsData[i].diameter);
		sStr.Format("glow %d, intensity %d", i, AllLightsData[i].intensity);
		if (AllLightsData[i].flashes==1)
			sStr+=", flashes";
		Color=RGB( AllLightsData[i].red, AllLightsData[i].green, AllLightsData[i].blue);
		m_combo_color.AddColor(sStr, Color);
	}

	Color=RGB(255,255,255);
	for (i=nLights;i<106;i++)
	{
		sStr.Format("Special effect %d",i);
		switch(i)
		{
			case 100:
				sStr+=" Smoke to side";
				break;
			case 101:
				sStr+=" Sparks";
				break;
			case 102:
				sStr+=" Steam";
				break;
			case 103:
				sStr+=" Dots falling";
				break;
			case 104:
				sStr+=" Fire";
				break;
			case 105:
				sStr+=" Smoke up";
				break;
		}
		m_combo_color.AddColor(sStr, Color);
	}
}

void CSoundLightProps::OnSelchangeComboColor() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	m_Byte1=m_combo_color.GetCurSel();
	UpdateData(FALSE);
	OnChangeEdit1();
}



void CSoundLightProps::OnButtonRtLight() 
{
	bTraceLight=true;
	OnOK();
}

void CSoundLightProps::UpdateHex()
{
	UpdateData(TRUE);
	CString sStr;

	sStr.Format("%X", m_Byte1);
	m_Byte1hex=sStr;

	sStr.Format("%X", m_Byte2);
	m_Byte2hex=sStr;

	sStr.Format("%X", m_Byte3);
	m_Byte3hex=sStr;

	sStr.Format("%X", m_Byte4);
	m_Byte4hex=sStr;

	UpdateData(FALSE);
}

void CSoundLightProps::OnChangeEdit2() 
{
	UpdateHex();
}

void CSoundLightProps::OnChangeEdit3() 
{
	UpdateHex();
}

void CSoundLightProps::OnChangeEdit4() 
{
	UpdateHex();	
}
