// RayTraceDlg.cpp : implementation file
//

#include "stdafx.h"
#include "T3ED.h"
#include "RayTraceDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRayTraceDlg dialog


CRayTraceDlg::CRayTraceDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRayTraceDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRayTraceDlg)
	m_theta = 0.0f;
	m_rho = 0.0f;
	m_iEndBlock = 0;
	m_iStartBlock = 0;
	m_bCheckTrack = FALSE;
	m_bCheckObjects = FALSE;
	m_text_endbl = _T("");
	m_bCheckExtra = FALSE;
	m_bCheckGlobal = FALSE;
	m_int_shade_blue = 0;
	m_int_shade_green = 0;
	m_int_shade_red = 0;
	m_int_sun_blue = 0;
	m_int_sun_green = 0;
	m_int_sun_red = 0;
	m_bCheckT1 = FALSE;
	m_bCheckT2 = FALSE;
	m_bCheckT3 = FALSE;
	m_bCheckT4 = FALSE;
	m_bCheckT6 = FALSE;
	m_b_CheckAlpha = FALSE;
	m_bCheckCST1 = FALSE;
	m_bCheckCST2 = FALSE;
	m_bCheckCST3 = FALSE;
	m_bCheckCST4 = FALSE;
	m_bCheckCST5 = FALSE;
	m_bCheckCST6 = FALSE;
	m_bCheckMiddle = FALSE;
	m_bCheckFences = FALSE;
	m_bCheckLanes = FALSE;
	m_bCheckClose = FALSE;
	m_bCheckLights = FALSE;
	m_float_light_multi = 0.0f;
	m_bRayTraceSun = FALSE;
	m_text_inirho = _T("");
	m_text_initheta = _T("");
	//}}AFX_DATA_INIT
}


void CRayTraceDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRayTraceDlg)
	DDX_Control(pDX, IDC_COLOR_BUTTON_2, m_color_button_2);
	DDX_Control(pDX, IDC_COLOR_BUTTON_1, m_color_button_1);
	DDX_Text(pDX, IDC_EDIT1, m_theta);
	DDX_Text(pDX, IDC_EDIT2, m_rho);
	DDX_Text(pDX, IDC_EDIT4, m_iEndBlock);
	DDV_MinMaxInt(pDX, m_iEndBlock, 0, 299);
	DDX_Text(pDX, IDC_EDIT3, m_iStartBlock);
	DDV_MinMaxInt(pDX, m_iStartBlock, 0, 255);
	DDX_Check(pDX, IDC_CHECKTrack, m_bCheckTrack);
	DDX_Check(pDX, IDC_CHECKObjects, m_bCheckObjects);
	DDX_Text(pDX, IDC_TEXT_ENDBL, m_text_endbl);
	DDX_Check(pDX, IDC_CHECKExtraObjects, m_bCheckExtra);
	DDX_Check(pDX, IDC_CHECK_Global_Objects, m_bCheckGlobal);
	DDX_Text(pDX, IDC_EDIT_SHADE_BLUE, m_int_shade_blue);
	DDX_Text(pDX, IDC_EDIT_SHADE_GREEN, m_int_shade_green);
	DDX_Text(pDX, IDC_EDIT_SHADE_RED, m_int_shade_red);
	DDX_Text(pDX, IDC_EDIT_SUN_BLUE, m_int_sun_blue);
	DDX_Text(pDX, IDC_EDIT_SUN_GREEN, m_int_sun_green);
	DDX_Text(pDX, IDC_EDIT_SUN_RED, m_int_sun_red);
	DDX_Check(pDX, IDC_CHECK_T1, m_bCheckT1);
	DDX_Check(pDX, IDC_CHECK_T2, m_bCheckT2);
	DDX_Check(pDX, IDC_CHECK_T3, m_bCheckT3);
	DDX_Check(pDX, IDC_CHECK_T4, m_bCheckT4);
	DDX_Check(pDX, IDC_CHECK_T6, m_bCheckT6);
	DDX_Check(pDX, IDC_CHECK_ALPHA, m_b_CheckAlpha);
	DDX_Check(pDX, IDC_CHECK_CST1, m_bCheckCST1);
	DDX_Check(pDX, IDC_CHECK_CST2, m_bCheckCST2);
	DDX_Check(pDX, IDC_CHECK_CST3, m_bCheckCST3);
	DDX_Check(pDX, IDC_CHECK_CST4, m_bCheckCST4);
	DDX_Check(pDX, IDC_CHECK_CST5, m_bCheckCST5);
	DDX_Check(pDX, IDC_CHECK_CST6, m_bCheckCST6);
	DDX_Check(pDX, IDC_CHECK_MIDDLE, m_bCheckMiddle);
	DDX_Check(pDX, IDC_CHECKFences, m_bCheckFences);
	DDX_Check(pDX, IDC_CHECKLanes, m_bCheckLanes);
	DDX_Check(pDX, IDC_CHECK_CLOSE, m_bCheckClose);
	DDX_Check(pDX, IDC_CHECK_LIGHTS, m_bCheckLights);
	DDX_Text(pDX, IDC_EDIT_LIGHT_MULTI, m_float_light_multi);
	DDX_Check(pDX, IDC_CHECK_RAYTRACE_SUN, m_bRayTraceSun);
	DDX_Text(pDX, IDC_TXT_INIRHO, m_text_inirho);
	DDX_Text(pDX, IDC_TXT_INITHETA, m_text_initheta);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRayTraceDlg, CDialog)
	//{{AFX_MSG_MAP(CRayTraceDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_SUN_RED, OnKillfocusEditSunRed)
	ON_EN_KILLFOCUS(IDC_EDIT_SUN_GREEN, OnKillfocusEditSunGreen)
	ON_EN_KILLFOCUS(IDC_EDIT_SUN_BLUE, OnKillfocusEditSunBlue)
	ON_EN_KILLFOCUS(IDC_EDIT_SHADE_RED, OnKillfocusEditShadeRed)
	ON_EN_KILLFOCUS(IDC_EDIT_SHADE_GREEN, OnKillfocusEditShadeGreen)
	ON_EN_KILLFOCUS(IDC_EDIT_SHADE_BLUE, OnKillfocusEditShadeBlue)
	ON_BN_CLICKED(IDC_CHECK_LIGHTS, OnCheckLights)
	//}}AFX_MSG_MAP

	//For ColorButton
	ON_MESSAGE(CPN_SELENDOK,     OnSelEndOK)
    ON_MESSAGE(CPN_SELENDCANCEL, OnSelEndCancel)
    ON_MESSAGE(CPN_SELCHANGE,    OnSelChange)
    ON_MESSAGE(CPN_CLOSEUP,      OnCloseUp)
    ON_MESSAGE(CPN_DROPDOWN,     OnDropDown)
END_MESSAGE_MAP()

	
/////////////////////////////////////////////////////////////////////////////
// ColorButton message handlers

LONG CRayTraceDlg::OnSelEndOK(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Selection ended OK\n");
	m_int_sun_blue=GetBValue(m_color_button_1.Color);
	m_int_sun_green=GetGValue(m_color_button_1.Color);
	m_int_sun_red=GetRValue(m_color_button_1.Color);
	UpdateData(FALSE);

	m_int_shade_blue=GetBValue(m_color_button_2.Color);
	m_int_shade_green=GetGValue(m_color_button_2.Color);
	m_int_shade_red=GetRValue(m_color_button_2.Color);
	UpdateData(FALSE);

    return TRUE;
}

LONG CRayTraceDlg::OnSelEndCancel(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Selection cancelled\n");
    return TRUE;
}

LONG CRayTraceDlg::OnSelChange(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Selection changed\n");
    return TRUE;
}

LONG CRayTraceDlg::OnCloseUp(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Colour picker close up\n");
    return TRUE;
}

LONG CRayTraceDlg::OnDropDown(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Colour picker drop down\n");
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CRayTraceDlg message handlers

BOOL CRayTraceDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_color_button_1.DefaultText = _T("");
	m_color_button_1.Color=RGB(m_int_sun_red, m_int_sun_green, m_int_sun_blue);

	m_color_button_2.DefaultText = _T("");
	m_color_button_2.Color=RGB(m_int_shade_red, m_int_shade_green, m_int_shade_blue);
	OnCheckLights();

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CRayTraceDlg::OnKillfocusEditSunRed() 
{
	UpdateData(TRUE);
	m_color_button_1.Color=RGB(m_int_sun_red, m_int_sun_green, m_int_sun_blue);
	UpdateData(FALSE);	
}

void CRayTraceDlg::OnKillfocusEditSunGreen() 
{
	UpdateData(TRUE);
	m_color_button_1.Color=RGB(m_int_sun_red, m_int_sun_green, m_int_sun_blue);
	UpdateData(FALSE);	
}

void CRayTraceDlg::OnKillfocusEditSunBlue() 
{
	UpdateData(TRUE);
	m_color_button_1.Color=RGB(m_int_sun_red, m_int_sun_green, m_int_sun_blue);
	UpdateData(FALSE);
}

void CRayTraceDlg::OnKillfocusEditShadeRed() 
{
	UpdateData(TRUE);
	m_color_button_2.Color=RGB(m_int_shade_red, m_int_shade_green, m_int_shade_blue);
	UpdateData(FALSE);	
}

void CRayTraceDlg::OnKillfocusEditShadeGreen() 
{
	UpdateData(TRUE);
	m_color_button_2.Color=RGB(m_int_shade_red, m_int_shade_green, m_int_shade_blue);
	UpdateData(FALSE);		
}

void CRayTraceDlg::OnKillfocusEditShadeBlue() 
{
	UpdateData(TRUE);
	m_color_button_2.Color=RGB(m_int_shade_red, m_int_shade_green, m_int_shade_blue);
	UpdateData(FALSE);		
}

void CRayTraceDlg::OnCheckLights() 
{
	UpdateData(TRUE);
	if (m_bCheckLights==TRUE)
		GetDlgItem(IDC_EDIT_LIGHT_MULTI)->EnableWindow(TRUE); 
	else
		GetDlgItem(IDC_EDIT_LIGHT_MULTI)->EnableWindow(FALSE); 

}
