// PolyShade.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "T3ED.h"
#include "T3EDDoc.h"
#include "ColorButton.h"
#include "PolyShade.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPolyShade 


CPolyShade::CPolyShade(CWnd* pParent /*=NULL*/)
	: CDialog(CPolyShade::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPolyShade)
	m_u_int_shade_alpha = 0;
	m_u_int_shade_blue = 0;
	m_u_int_shade_green = 0;
	m_u_int_shade_red = 0;
	//}}AFX_DATA_INIT
}


void CPolyShade::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPolyShade)
	DDX_Control(pDX, IDC_COLOR_BUTTON_1, m_color_button_1);
	DDX_Text(pDX, IDC_EDIT_SHADE_ALPHA, m_u_int_shade_alpha);
	DDX_Text(pDX, IDC_EDIT_SHADE_BLUE, m_u_int_shade_blue);
	DDX_Text(pDX, IDC_EDIT_SHADE_GREEN2, m_u_int_shade_green);
	DDX_Text(pDX, IDC_EDIT_SHADE_RED, m_u_int_shade_red);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPolyShade, CDialog)
	//{{AFX_MSG_MAP(CPolyShade)
	ON_BN_CLICKED(IDC_COLOR_BUTTON_1, OnColorButton1)
	ON_EN_KILLFOCUS(IDC_EDIT_SHADE_RED, OnKillfocusEditShadeRed)
	ON_EN_KILLFOCUS(IDC_EDIT_SHADE_GREEN2, OnKillfocusEditShadeGreen2)
	ON_MESSAGE(CPN_SELENDOK,     OnSelEndOK)
    ON_MESSAGE(CPN_SELENDCANCEL, OnSelEndCancel)
    ON_MESSAGE(CPN_SELCHANGE,    OnSelChange)
    ON_MESSAGE(CPN_CLOSEUP,      OnCloseUp)
    ON_MESSAGE(CPN_DROPDOWN,     OnDropDown)
	ON_EN_KILLFOCUS(IDC_EDIT_SHADE_BLUE, OnKillfocusEditShadeBlue)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CPolyShade 

BOOL CPolyShade::OnInitDialog() 
{
	CDialog::OnInitDialog();
	//COLORREF color;
	
	m_u_int_shade_alpha = shade.alpha;
	m_u_int_shade_blue = shade.blue;
	m_u_int_shade_green = shade.green;
	m_u_int_shade_red = shade.red;
	m_color_button_1.DefaultText = _T("");
	m_color_button_1.Color=RGB(shade.red,shade.green,shade.blue);
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}


void CPolyShade::OnOK() 
{
	UpdateData(TRUE);
	shade.alpha=m_u_int_shade_alpha;
	shade.blue= m_u_int_shade_blue ;
	shade.green=m_u_int_shade_green;
	shade.red=  m_u_int_shade_red  ;	
	CDialog::OnOK();
}

void CPolyShade::OnColorButton1() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	
}

/////////////////////////////////////////////////////////////////////////////
// CDemoPage message handlers

LONG CPolyShade::OnSelEndOK(UINT /*lParam*/, LONG /*wParam*/)
{
    //TRACE0("Selection ended OK\n");
	m_u_int_shade_blue=GetBValue(m_color_button_1.Color);
	m_u_int_shade_green=GetGValue(m_color_button_1.Color);
	m_u_int_shade_red=GetRValue(m_color_button_1.Color);
	UpdateData(FALSE);
    return TRUE;
}

LONG CPolyShade::OnSelEndCancel(UINT /*lParam*/, LONG /*wParam*/)
{
    //TRACE0("Selection cancelled\n");
    return TRUE;
}

LONG CPolyShade::OnSelChange(UINT /*lParam*/, LONG /*wParam*/)
{
    //TRACE0("Selection changed\n");
    return TRUE;
}

LONG CPolyShade::OnCloseUp(UINT /*lParam*/, LONG /*wParam*/)
{
    //TRACE0("Colour picker close up\n");
    return TRUE;
}

LONG CPolyShade::OnDropDown(UINT /*lParam*/, LONG /*wParam*/)
{
    //TRACE0("Colour picker drop down\n");
    return TRUE;
}

void CPolyShade::OnKillfocusEditShadeRed() 
{
	UpdateData(TRUE);
	m_color_button_1.Color=RGB(m_u_int_shade_red, m_u_int_shade_green, m_u_int_shade_blue);
	UpdateData(FALSE);
}

void CPolyShade::OnKillfocusEditShadeGreen2() 
{
	UpdateData(TRUE);
	m_color_button_1.Color=RGB(m_u_int_shade_red, m_u_int_shade_green, m_u_int_shade_blue);
	UpdateData(FALSE);	
}

void CPolyShade::OnKillfocusEditShadeBlue() 
{
	UpdateData(TRUE);
	m_color_button_1.Color=RGB(m_u_int_shade_red, m_u_int_shade_green, m_u_int_shade_blue);
	UpdateData(FALSE);	
}
