// PolyFlag.cpp : implementation file
//

#include "stdafx.h"
#include "T3ED.h"
#include "PolyFlag.h"
#include "UnknownData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPolyFlags dialog


CPolyFlags::CPolyFlags(CWnd* pParent /*=NULL*/)
	: CDialog(CPolyFlags::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPolyFlags)
	m_type = -1;
	m_walldetect = FALSE;
	m_xobjdetect = FALSE;
	m_hsForwNeighbor = FALSE;
	m_hsBackNeighbor = FALSE;
	m_hsLeftNeighbor = FALSE;
	m_hsRightNeighbor = FALSE;
	m_no_weather_effects = FALSE;
	m_chk_recalc_pvr = FALSE;
	m_combo_pvr = -1;
	m_chk_drive_over = FALSE;
	m_int_block = 0;
	m_int_vroadEntry = 0;
	m_int_ref_polynr = 0;
	//}}AFX_DATA_INIT
}


void CPolyFlags::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPolyFlags)
	DDX_CBIndex(pDX, IDC_COMBO1, m_type);
	DDX_Check(pDX, IDC_CHECK1, m_walldetect);
	DDX_Check(pDX, IDC_CHECK2, m_xobjdetect);
	DDX_Check(pDX, IDC_CHECK3, m_hsForwNeighbor);
	DDX_Check(pDX, IDC_CHECK4, m_hsBackNeighbor);
	DDX_Check(pDX, IDC_CHECK5, m_hsLeftNeighbor);
	DDX_Check(pDX, IDC_CHECK6, m_hsRightNeighbor);
	DDX_Check(pDX, IDC_CHECK_FLAGS_BIT5, m_no_weather_effects);
	DDX_Check(pDX, IDC_CHECK_RECALC_PVR, m_chk_recalc_pvr);
	DDX_CBIndex(pDX, IDC_COMBO_PVR, m_combo_pvr);
	DDX_Check(pDX, IDC_CHECK_DRIVE_OVER, m_chk_drive_over);
	DDX_Text(pDX, IDC_EDIT_BLOCK, m_int_block);
	DDX_Text(pDX, IDC_EDIT_VROAD_ENTRY, m_int_vroadEntry);
	DDX_Text(pDX, IDC_EDIT_POLY_NR, m_int_ref_polynr);
	//}}AFX_DATA_MAP
	if (!bHSMode) {
		GetDlgItem(IDC_CHECK3)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_CHECK4)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_CHECK_FLAGS_BIT5)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_CHECK_RECALC_PVR)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_COMBO_PVR)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
	}
}


BEGIN_MESSAGE_MAP(CPolyFlags, CDialog)
	//{{AFX_MSG_MAP(CPolyFlags)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	ON_BN_CLICKED(IDUNKNOWNDATA, OnUnknowndata)
	ON_BN_CLICKED(IDC_CHECK_RECALC_PVR, OnCheckRecalcPvr)
	ON_BN_CLICKED(IDC_CHECK_DRIVE_OVER, OnCheckDriveOver)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPolyFlags message handlers

BOOL CPolyFlags::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if (bTypeOnly)
	{
		GetDlgItem(IDC_CHECK1)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK2)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK3)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK4)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK5)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK6)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK_DRIVE_OVER)->EnableWindow(FALSE);
	}
	if (bMultiSel)
	{
		GetDlgItem(IDC_EDIT_POLY_NR)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_EDIT_BLOCK)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
		GetDlgItem(IDC_EDIT_VROAD_ENTRY)->ModifyStyle(WS_VISIBLE,WS_DISABLED);
	}
	OnCheckRecalcPvr();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CPolyFlags::OnSelchangeCombo1() 
{
	int last_type=m_type;
	CComboBox *pCbType = (CComboBox*) GetDlgItem(IDC_COMBO1);
	UpdateData(TRUE);
	if (!bHSMode && (m_type>15)) m_type=last_type;
	pCbType->SetCurSel(m_type);
	UpdateData(TRUE);
	m_chk_drive_over=1;
	UpdateData(FALSE);
}

void CPolyFlags::OnUnknowndata() 
{
	CUnknownData UnknownData; // Create dialog
	UnknownData.m_nBytes=6 + bHSMode;
	CString sStr = "Unknown Poly VroadData 6 bytes + 1 byte in HS mode.Showing only data from last selected polygon.";
	UnknownData.m_sTitle=sStr;
	UnknownData.data=(unsigned char *)malloc(UnknownData.m_nBytes);
	memcpy(UnknownData.data, pUnknownData, UnknownData.m_nBytes);

	if (UnknownData.DoModal()==IDOK)
	{
		memcpy(pUnknownData, UnknownData.data, UnknownData.m_nBytes);
	}
	dofree(UnknownData.data);
}

void CPolyFlags::OnCheckRecalcPvr() 
{
	UpdateData(TRUE);
	if (m_chk_recalc_pvr==1)
	{
		GetDlgItem(IDC_COMBO_PVR)->EnableWindow(TRUE);
		if (m_combo_pvr<0) m_combo_pvr=2;
	}
	else
		GetDlgItem(IDC_COMBO_PVR)->EnableWindow(FALSE);

	UpdateData(FALSE);
}

void CPolyFlags::OnCheckDriveOver() 
{
	UpdateData(TRUE);
	if (m_chk_drive_over==0) m_chk_drive_over=1;
	UpdateData(FALSE);
}
