// PointPropsDlg.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "T3ED.h"
#include "PointPropsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPointPropsDlg 


CPointPropsDlg::CPointPropsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPointPropsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPointPropsDlg)
	m_float_posx = 0.0f;
	m_float_posy = 0.0f;
	m_float_posz = 0.0f;
	m_str_block = _T("");
	m_str_num_points = _T("");
	m_int_alpha = 0;
	m_int_blue = 0;
	m_int_green = 0;
	m_int_red = 0;
	//}}AFX_DATA_INIT
}


void CPointPropsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPointPropsDlg)
	DDX_Control(pDX, IDC_COLOR_BUTTON_1, m_color_button_1);
	DDX_Text(pDX, IDC_EDIT_POSX, m_float_posx);
	DDX_Text(pDX, IDC_EDIT_POSY, m_float_posy);
	DDX_Text(pDX, IDC_EDIT_POSZ, m_float_posz);
	DDX_Text(pDX, IDC_TXT_BLOCK, m_str_block);
	DDX_Text(pDX, IDC_TXT_NUM_POINTS, m_str_num_points);
	DDX_Text(pDX, IDC_EDIT_SHADE_ALPHA, m_int_alpha);
	DDV_MinMaxUInt(pDX, m_int_alpha, 0, 255);
	DDX_Text(pDX, IDC_EDIT_SHADE_BLUE, m_int_blue);
	DDV_MinMaxUInt(pDX, m_int_blue, 0, 255);
	DDX_Text(pDX, IDC_EDIT_SHADE_GREEN2, m_int_green);
	DDV_MinMaxUInt(pDX, m_int_green, 0, 255);
	DDX_Text(pDX, IDC_EDIT_SHADE_RED, m_int_red);
	DDV_MinMaxUInt(pDX, m_int_red, 0, 255);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPointPropsDlg, CDialog)
	//{{AFX_MSG_MAP(CPointPropsDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_SHADE_RED, OnKillfocusEditShadeRed)
	ON_EN_KILLFOCUS(IDC_EDIT_SHADE_GREEN2, OnKillfocusEditShadeGreen2)
	ON_MESSAGE(CPN_SELENDOK,     OnSelEndOK)
    ON_MESSAGE(CPN_SELENDCANCEL, OnSelEndCancel)
    ON_MESSAGE(CPN_SELCHANGE,    OnSelChange)
    ON_MESSAGE(CPN_CLOSEUP,      OnCloseUp)
    ON_MESSAGE(CPN_DROPDOWN,     OnDropDown)
	ON_EN_KILLFOCUS(IDC_EDIT_SHADE_BLUE, OnKillfocusEditShadeBlue)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CPointPropsDlg 

BOOL CPointPropsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	m_color_button_1.DefaultText = _T("");
	m_color_button_1.Color=RGB(m_int_red,m_int_green,m_int_blue);
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}


LONG CPointPropsDlg::OnSelEndOK(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Selection ended OK\n");
	m_int_blue=GetBValue(m_color_button_1.Color);
	m_int_green=GetGValue(m_color_button_1.Color);
	m_int_red=GetRValue(m_color_button_1.Color);
	UpdateData(FALSE);
    return TRUE;
}

LONG CPointPropsDlg::OnSelEndCancel(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Selection cancelled\n");
    return TRUE;
}

LONG CPointPropsDlg::OnSelChange(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Selection changed\n");
    return TRUE;
}

LONG CPointPropsDlg::OnCloseUp(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Colour picker close up\n");
    return TRUE;
}

LONG CPointPropsDlg::OnDropDown(UINT /*lParam*/, LONG /*wParam*/)
{
    TRACE0("Colour picker drop down\n");
    return TRUE;
}

void CPointPropsDlg::OnKillfocusEditShadeRed() 
{
	UpdateData(TRUE);
	m_color_button_1.Color=RGB(m_int_red,m_int_green,m_int_blue);
	UpdateData(FALSE);
}

void CPointPropsDlg::OnKillfocusEditShadeGreen2() 
{
	UpdateData(TRUE);
	m_color_button_1.Color=RGB(m_int_red,m_int_green,m_int_blue);
	UpdateData(FALSE);	
}

void CPointPropsDlg::OnKillfocusEditShadeBlue() 
{
	UpdateData(TRUE);
	m_color_button_1.Color=RGB(m_int_red,m_int_green,m_int_blue);
	UpdateData(FALSE);	
}
