// ClearAll.cpp : implementation file
//

#include "stdafx.h"
#include "T3ED.h"
#include "T3EDDoc.h"
#include "ClearAll.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClearAll dialog


CClearAll::CClearAll(CWnd* pParent /*=NULL*/)
	: CDialog(CClearAll::IDD, pParent)
{
	//{{AFX_DATA_INIT(CClearAll)
	m_trackXY = FALSE;
	m_trackZ = FALSE;
	m_sceneryZ = FALSE;
	m_xobj = FALSE;
	m_polyobj = FALSE;
	m_roadTextures = FALSE;
	m_sceneryTextures = FALSE;
	m_roadTexture = 0;
	m_sceneryTexture = 0;
	m_fences = FALSE;
	m_globalobj = FALSE;
	m_trackBLK = FALSE;
	m_TrknBlocks = 0;
	m_trackShade = FALSE;
	m_block_neighbours = FALSE;
	m_shape_x = 0.0f;
	m_shape_y = 0.0f;
	m_shape_extra = FALSE;
	m_numc1 = 0;
	m_numc2 = 0;
	m_sizec1 = 0;
	m_sizec2 = 0;
	m_elevation_extra = FALSE;
	m_height = 0.0f;
	m_numz1 = 0;
	m_numz2 = 0;
	m_sizez1 = 0;
	m_sizez2 = 0;
	m_sound_src = FALSE;
	m_Chk_PVR = FALSE;
	m_merge_points = FALSE;
	m_merge_dist = 0.0f;
	m_recalc_AI_lanes = FALSE;
	m_fSpeedfile = FALSE;
	m_bSpeedfile = FALSE;
	m_SpeedFloat_Zero_Calc = -1;
	m_SpeedF_Start = 0;
	m_SpeedF_End = 0;
	//}}AFX_DATA_INIT
	m_roadFlags=0;
	m_sceneryFlags=0;
}


void CClearAll::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CClearAll)
	DDX_Check(pDX, IDC_CHECK1, m_trackXY);
	DDX_Check(pDX, IDC_CHECK2, m_trackZ);
	DDX_Check(pDX, IDC_CHECK3, m_sceneryZ);
	DDX_Check(pDX, IDC_CHECK5, m_xobj);
	DDX_Check(pDX, IDC_CHECK4, m_polyobj);
	DDX_Check(pDX, IDC_CHECK6, m_roadTextures);
	DDX_Check(pDX, IDC_CHECK7, m_sceneryTextures);
	DDX_Text(pDX, IDC_EDIT6, m_roadTexture);
	DDX_Text(pDX, IDC_EDIT7, m_sceneryTexture);
	DDX_Check(pDX, IDC_CHECK8, m_fences);
	DDX_Check(pDX, IDC_CHECK9, m_globalobj);
	DDX_Check(pDX, IDC_CHECK10, m_trackBLK);
	DDX_Text(pDX, IDC_EDIT8, m_TrknBlocks);
	DDX_Check(pDX, IDC_CHECK11, m_trackShade);
	DDX_Check(pDX, IDC_CHECK13, m_block_neighbours);
	DDX_Text(pDX, IDC_EDIT_SHAPE_X, m_shape_x);
	DDX_Text(pDX, IDC_EDIT_SHAPE_Y, m_shape_y);
	DDX_Check(pDX, IDC_CHECK1_EXTRA, m_shape_extra);
	DDX_Text(pDX, IDC_EDIT_NUMC1, m_numc1);
	DDX_Text(pDX, IDC_EDIT_NUMC2, m_numc2);
	DDX_Text(pDX, IDC_EDIT_SIZEC1, m_sizec1);
	DDX_Text(pDX, IDC_EDIT_SIZEC2, m_sizec2);
	DDX_Check(pDX, IDC_CHECK2_EXTRA, m_elevation_extra);
	DDX_Text(pDX, IDC_EDIT_HEIGHT, m_height);
	DDX_Text(pDX, IDC_EDIT_NUMZ1, m_numz1);
	DDX_Text(pDX, IDC_EDIT_NUMZ2, m_numz2);
	DDX_Text(pDX, IDC_EDIT_SIZEZ1, m_sizez1);
	DDX_Text(pDX, IDC_EDIT_SIZEZ2, m_sizez2);
	DDX_Check(pDX, IDC_CHECK12, m_sound_src);
	DDX_Check(pDX, IDC_CHECK_PVR, m_Chk_PVR);
	DDX_Check(pDX, IDC_CHECK_MERGE_POINTS, m_merge_points);
	DDX_Text(pDX, IDC_EDIT_MERGE_DIST, m_merge_dist);
	DDX_Check(pDX, IDC_CHECK14, m_recalc_AI_lanes);
	DDX_Check(pDX, IDC_CHECK15, m_fSpeedfile);
	DDX_Check(pDX, IDC_CHECK16, m_bSpeedfile);
	DDX_Radio(pDX, IDC_RADIO_SPEEDF1, m_SpeedFloat_Zero_Calc);
	DDX_Text(pDX, IDC_EDIT_SPEED_START, m_SpeedF_Start);
	DDX_Text(pDX, IDC_EDIT_SPEED_END, m_SpeedF_End);
	//}}AFX_DATA_MAP
	DDV_MinMaxInt(pDX, m_roadTexture, 0, qfs->nColEntries-1);
	DDV_MinMaxInt(pDX, m_sceneryTexture, 0, qfs->nColEntries-1);
}


BEGIN_MESSAGE_MAP(CClearAll, CDialog)
	//{{AFX_MSG_MAP(CClearAll)
	ON_BN_CLICKED(IDC_BROWSE6, OnBrowse6)
	ON_BN_CLICKED(IDC_BROWSE7, OnBrowse7)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_CHECK1_EXTRA, OnCheck1Extra)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	ON_BN_CLICKED(IDC_CHECK2_EXTRA, OnCheck2Extra)
	ON_CBN_SELCHANGE(IDC_COMBO_VECTOR_CALC, OnSelchangeComboVectorCalc)
	ON_BN_CLICKED(IDC_CHECK_MERGE_POINTS, OnCheckMergePoints)
	ON_BN_CLICKED(IDC_CHECK15, OnCheck15)
	ON_BN_CLICKED(IDC_CHECK16, OnCheck16)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClearAll message handlers

BOOL CClearAll::OnInitDialog() 
{
	CDialog::OnInitDialog();
	UpdateData(FALSE);
	
	UpdateView();	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CClearAll::OnBrowse6() 
{
	BOOL isok;
	int res;

	res=GetDlgItemInt(IDC_EDIT6,&isok,TRUE);
	if (!isok||(res<0)||(res>=qfs->nColEntries)) res=0;
	qfs->m_nBmp=res;
	qfs->m_flags=m_roadFlags;
	if (qfs->DoModal()!=IDOK) return;
	m_roadFlags=qfs->m_flags;
	SetDlgItemInt(IDC_EDIT6,qfs->m_nBmp,TRUE);
}

void CClearAll::OnBrowse7() 
{
	BOOL isok;
	int res;

	res=GetDlgItemInt(IDC_EDIT7,&isok,TRUE);
	if (!isok||(res<0)||(res>=qfs->nColEntries)) res=0;
	qfs->m_nBmp=res;
	qfs->m_flags=m_sceneryFlags;
	if (qfs->DoModal()!=IDOK) return;
	m_sceneryFlags=qfs->m_flags;
	SetDlgItemInt(IDC_EDIT7,qfs->m_nBmp,TRUE);
}


void CClearAll::UpdateView()
{
	UpdateData(true);
	if (m_trackXY)
	{
		GetDlgItem(IDC_EDIT_SHAPE_X)->EnableWindow(TRUE); 
		GetDlgItem(IDC_EDIT_SHAPE_Y)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK1_EXTRA)->EnableWindow(TRUE);

		GetDlgItem(IDC_EDIT_NUMC1)->EnableWindow(m_shape_extra);
		GetDlgItem(IDC_EDIT_NUMC2)->EnableWindow(m_shape_extra);
		GetDlgItem(IDC_EDIT_SIZEC1)->EnableWindow(m_shape_extra);
		GetDlgItem(IDC_EDIT_SIZEC2)->EnableWindow(m_shape_extra);
	}
	else
	{
		GetDlgItem(IDC_EDIT_SHAPE_X)->EnableWindow(FALSE); 
		GetDlgItem(IDC_EDIT_SHAPE_Y)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK1_EXTRA)->EnableWindow(FALSE);

		GetDlgItem(IDC_EDIT_NUMC1)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_NUMC2)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SIZEC1)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SIZEC2)->EnableWindow(FALSE);
	}
	UpdateData(FALSE);

	if (m_trackZ)
	{
		GetDlgItem(IDC_EDIT_HEIGHT)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK2_EXTRA)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_NUMZ1)->EnableWindow(m_elevation_extra);
		GetDlgItem(IDC_EDIT_NUMZ2)->EnableWindow(m_elevation_extra);
		GetDlgItem(IDC_EDIT_SIZEZ1)->EnableWindow(m_elevation_extra);
		GetDlgItem(IDC_EDIT_SIZEZ2)->EnableWindow(m_elevation_extra);
	}
	else
	{
		GetDlgItem(IDC_EDIT_HEIGHT)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK2_EXTRA)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_NUMZ1)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_NUMZ2)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SIZEZ1)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SIZEZ2)->EnableWindow(FALSE);
	}
	
	((CComboBox*)GetDlgItem(IDC_COMBO_VECTOR_CALC))->SetCurSel(m_Combo_Vector_Calc);  //Set current Vector Calc Selection
	UpdateSpeedfileView();
}

void CClearAll::OnCheck1() //Track Shape XY
{
	UpdateView();
}

void CClearAll::OnCheck1Extra() 
{
	UpdateView();
}

void CClearAll::OnCheck2() 
{
	UpdateView();
}

void CClearAll::OnCheck2Extra() 
{
	UpdateView();	
}

void CClearAll::OnSelchangeComboVectorCalc() 
{
	UpdateData(TRUE);
	CComboBox *pCombo_Vector_Calc = (CComboBox*) GetDlgItem(IDC_COMBO_VECTOR_CALC);
	m_Combo_Vector_Calc=pCombo_Vector_Calc->GetCurSel();	
}

void CClearAll::OnCheckMergePoints() 
{
	UpdateData(TRUE);
	GetDlgItem(IDC_EDIT_MERGE_DIST)->EnableWindow(m_merge_points);
}

void CClearAll::OnCheck15() 
{
	UpdateSpeedfileView();
}

void CClearAll::OnCheck16() 
{
	UpdateSpeedfileView();	
}

void CClearAll::UpdateSpeedfileView()
{
	UpdateData(TRUE);
	GetDlgItem(IDC_RADIO_SPEEDF1)->EnableWindow((m_fSpeedfile)|(m_bSpeedfile));
	GetDlgItem(IDC_RADIO_SPEEDF2)->EnableWindow((m_fSpeedfile)|(m_bSpeedfile));
	GetDlgItem(IDC_RADIO_SPEEDF3)->EnableWindow((m_fSpeedfile)|(m_bSpeedfile));
	GetDlgItem(IDC_EDIT_SPEED_START)->EnableWindow((m_fSpeedfile)|(m_bSpeedfile));
	GetDlgItem(IDC_EDIT_SPEED_END)->EnableWindow((m_fSpeedfile)|(m_bSpeedfile));
	//UpdateData(FALSE);
}

