// CameraProps.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "T3ED.h"
#include "UnknownData.h"
#include "CameraProps.h"
#include "T3EDDoc.h"
#include <math.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CCameraProps 


CCameraProps::CCameraProps(CWnd* pParent /*=NULL*/)
	: CDialog(CCameraProps::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCameraProps)
	m_pos_x = 0.0f;
	m_pos_y = 0.0f;
	m_pos_z = 0.0f;
	m_zoom = 0.0f;
	m_slice_render = 0;
	m_slice_start = 0;
	m_slice_stop = 0;
	m_unknown1 = 0.0f;
	m_unknown2 = 0.0f;
	m_unknown3 = 0.0f;
	m_unknown4 = 0.0f;
	m_unknown5 = 0.0f;
	m_unknown6 = 0.0f;
	m_unknown7 = 0.0f;
	m_unknown8 = 0.0f;
	m_unknown9 = 0.0f;
	m_text_slice = _T("");
	//}}AFX_DATA_INIT
}


void CCameraProps::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCameraProps)
	DDX_Text(pDX, IDC_EDIT_POSX, m_pos_x);
	DDX_Text(pDX, IDC_EDIT_POSY, m_pos_y);
	DDX_Text(pDX, IDC_EDIT_POSZ, m_pos_z);
	DDX_Text(pDX, IDC_EDIT_ZOOM, m_zoom);
	DDX_Text(pDX, IDC_EDIT_SLICE_RENDER, m_slice_render);
	DDX_Text(pDX, IDC_EDIT_SLICE_START, m_slice_start);
	DDX_Text(pDX, IDC_EDIT_SLICE_STOP, m_slice_stop);
	DDX_Text(pDX, IDC_EDIT_UNKNOWN_1, m_unknown1);
	DDX_Text(pDX, IDC_EDIT_UNKNOWN_2, m_unknown2);
	DDX_Text(pDX, IDC_EDIT_UNKNOWN_3, m_unknown3);
	DDX_Text(pDX, IDC_EDIT_UNKNOWN_4, m_unknown4);
	DDX_Text(pDX, IDC_EDIT_UNKNOWN_5, m_unknown5);
	DDX_Text(pDX, IDC_EDIT_UNKNOWN_6, m_unknown6);
	DDX_Text(pDX, IDC_EDIT_UNKNOWN_7, m_unknown7);
	DDX_Text(pDX, IDC_EDIT_UNKNOWN_8, m_unknown8);
	DDX_Text(pDX, IDC_EDIT_UNKNOWN_9, m_unknown9);
	DDX_Text(pDX, IDC_TEXT_SLICE, m_text_slice);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCameraProps, CDialog)
	//{{AFX_MSG_MAP(CCameraProps)
	ON_CBN_SELCHANGE(IDC_COMBO_SEL_CAM, OnSelchangeComboSelCam)
	ON_CBN_SELCHANGE(IDC_COMBO_CAMTYPE, OnSelchangeComboCamtype)
	ON_BN_CLICKED(IDC_BUTTON_RENDER, OnButtonRender)
	ON_BN_CLICKED(IDC_BUTTON_DEL_CAM, OnButtonDelCam)
	ON_BN_CLICKED(IDC_BUTTON_COPY_CAM, OnButtonCopyCam)
	ON_EN_KILLFOCUS(IDC_EDIT_SLICE_START, OnKillfocusEditSliceStart)
	ON_EN_KILLFOCUS(IDC_EDIT_SLICE_RENDER, OnKillfocusEditSliceRender)
	ON_EN_KILLFOCUS(IDC_EDIT_SLICE_STOP, OnKillfocusEditSliceStop)
	ON_BN_CLICKED(IDC_BUTTON_SHOW_UNKNOWN_VALUES, OnButtonShowUnknownValues)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CCameraProps 

BOOL CCameraProps::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	int i;
	CString sStr;
	sStr.Format("Slice Numbers (0-%d):", (col_nrec -1));	
	//GetDlgItem(IDC_TEXT_SLICE)->SetWindowText(sStr);
	m_text_slice=sStr;

	CComboBox *pCbCamtype = (CComboBox*) GetDlgItem(IDC_COMBO_CAMTYPE);
	pCbCamtype->AddString("0: Static position, fixed heading");
	pCbCamtype->AddString("1: Static position, tracking car");
	pCbCamtype->AddString("2: Static position, fixed heading, with zoom");
	pCbCamtype->AddString("3: Static position, tracking car, with zoom");
	pCbCamtype->AddString("4: Moving and tracking car");
	pCbCamtype->AddString("5: Bumper");
	pCbCamtype->AddString("6: Revolving around and facing car");
	pCbCamtype->AddString("7: Attached to the passenger side wing of car, facing forward");
	pCbCamtype->AddString("8: Angled view of car from the drivers side, facing forward");
	pCbCamtype->AddString("9: Angled view of car from the drivers side, facing backward");
	for (i=0;i<10;i++)
		pCbCamtype->SetItemData(i,i);

	UpdateView();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CCameraProps::UpdateView()
{
	InitCamList();
	CComboBox *pCbCamtype = (CComboBox*) GetDlgItem(IDC_COMBO_CAMTYPE);
	pCbCamtype->SetCurSel(pCamData[SelectedCam].CamType);
	m_pos_x=pCamData[SelectedCam].CamPosition.x;
	m_pos_y=pCamData[SelectedCam].CamPosition.y;
	m_pos_z=pCamData[SelectedCam].CamPosition.z;
	m_zoom=pCamData[SelectedCam].ZoomFactor;
	m_slice_render=pCamData[SelectedCam].Render;
	m_slice_start=pCamData[SelectedCam].Start;     
	m_slice_stop=pCamData[SelectedCam].Stop;      
	m_unknown1=pCamData[SelectedCam].floatData[0];
	m_unknown2=pCamData[SelectedCam].floatData[1];
	m_unknown3=pCamData[SelectedCam].floatData[2];
	m_unknown4=pCamData[SelectedCam].floatData[3];
	m_unknown5=pCamData[SelectedCam].floatData[4];
	m_unknown6=pCamData[SelectedCam].floatData[5];
	m_unknown7=pCamData[SelectedCam].floatData[6];
	m_unknown8=pCamData[SelectedCam].floatData[7];
	m_unknown9=pCamData[SelectedCam].floatData[8];
	UpdateData(FALSE);
}

void CCameraProps::InitCamList()
{
	int i;
	CString sStr = "";

	CComboBox *pCbSelCam = (CComboBox*) GetDlgItem(IDC_COMBO_SEL_CAM);
	pCbSelCam->ResetContent();
	for (i=0;i<nCams;i++)
	{
		sStr.Format("Camera %d, Type %d", i+1, pCamData[i].CamType);
		pCbSelCam->AddString(sStr);
		pCbSelCam->SetItemData(i,i);
	}
	pCbSelCam->SetCurSel(SelectedCam);
}

void CCameraProps::OnSelchangeComboSelCam() 
{
	SaveCamData();	//Save maybe changed data before selecting new cam
	//Select new Cam
	CComboBox *pCbSelCam = (CComboBox*) GetDlgItem(IDC_COMBO_SEL_CAM);
	SelectedCam=pCbSelCam->GetItemData(pCbSelCam->GetCurSel());
	UpdateView();
}

void CCameraProps::OnSelchangeComboCamtype() 
{
	int camtype;
	CComboBox *pCbCamtype = (CComboBox*) GetDlgItem(IDC_COMBO_CAMTYPE);
	camtype=pCbCamtype->GetItemData(pCbCamtype->GetCurSel());
	pCamData[SelectedCam].CamType=camtype;
}

void CCameraProps::SaveCamData()
{
	UpdateData(TRUE);
	pCamData[SelectedCam].CamPosition.x=	m_pos_x;
	pCamData[SelectedCam].CamPosition.y=	m_pos_y;
	pCamData[SelectedCam].CamPosition.z=	m_pos_z;
	if (m_zoom>0)	pCamData[SelectedCam].ZoomFactor   =	m_zoom;
	if ((m_slice_render>-1)&&(m_slice_render<col_nrec))	pCamData[SelectedCam].Render       =	m_slice_render;
	if ((m_slice_start>-1)&&(m_slice_start<col_nrec))	pCamData[SelectedCam].Start        =	m_slice_start;
	if ((m_slice_stop)&&(m_slice_stop<col_nrec))		pCamData[SelectedCam].Stop         =	m_slice_stop;
	pCamData[SelectedCam].floatData[0] =	m_unknown1;
	pCamData[SelectedCam].floatData[1] =	m_unknown2;
	pCamData[SelectedCam].floatData[2] =	m_unknown3;
	pCamData[SelectedCam].floatData[3] =	m_unknown4;
	pCamData[SelectedCam].floatData[4] =	m_unknown5;
	pCamData[SelectedCam].floatData[5] =	m_unknown6;
	pCamData[SelectedCam].floatData[6] =	m_unknown7;
	pCamData[SelectedCam].floatData[7] =	m_unknown8;
	pCamData[SelectedCam].floatData[8] =	m_unknown9;
}

void CCameraProps::OnOK() 
{
	SaveCamData();
	CDialog::OnOK();
}

void CCameraProps::OnButtonRender() 
{
	if (m_slice_render>=col_nrec) return;
	SaveCamData();
	m_pos_x=((float) vroad[m_slice_render].refPt.x)/65536;
	m_pos_y=((float) vroad[m_slice_render].refPt.y)/65536;
	m_pos_z=5 + ((float) vroad[m_slice_render].refPt.z)/65536;
	UpdateData(FALSE);
}

void CCameraProps::OnButtonDelCam() 
{
	int i;
	if (nCams<=1) return; //Don't delete last cam
	nCams--;
	for (i=SelectedCam;i<nCams;i++)
		memcpy(&pCamData[i],&pCamData[i+1],sizeof(struct CAMDATA));

	pCamData=(struct CAMDATA *) realloc (pCamData, nCams * sizeof(struct CAMDATA)); //Less memory to store cameras
	if (SelectedCam>=nCams) SelectedCam=0;
	InitCamList();
	UpdateView();
}

void CCameraProps::OnButtonCopyCam() 
{
	nCams++;
	pCamData=(struct CAMDATA *) realloc (pCamData, nCams * sizeof(struct CAMDATA)); //More memory to store cameras
	memcpy(&pCamData[nCams-1],&pCamData[SelectedCam],sizeof(struct CAMDATA));  //Copy selected cam to new last
	SelectedCam=nCams-1; //Show copied new last
	InitCamList();
	UpdateView();
}


void CCameraProps::OnKillfocusEditSliceStart() 
{
	UpdateData(TRUE);
	if (m_slice_start<0) m_slice_start=0;
	if	(m_slice_start>=col_nrec) m_slice_start=col_nrec-1;
	UpdateData(FALSE);

}

void CCameraProps::OnKillfocusEditSliceRender() 
{
	UpdateData(TRUE);
	if (m_slice_render<0) m_slice_render=0;
	if	(m_slice_render>=col_nrec) m_slice_render=col_nrec-1;
	UpdateData(FALSE);	
}

void CCameraProps::OnKillfocusEditSliceStop() 
{
	UpdateData(TRUE);
	if (m_slice_stop<0) m_slice_stop=0;
	if	(m_slice_stop>=col_nrec) m_slice_stop=col_nrec-1;
	UpdateData(FALSE);	
}

void CCameraProps::OnButtonShowUnknownValues() 
{
	CString sStr = "Each camera has 36 bytes 'Unknwon Rotate Values'.";
	CUnknownData UnknownData; // Create dialog
	UnknownData.m_nBytes=9 * sizeof(float);
	UnknownData.m_sTitle=sStr;
	UnknownData.data=(unsigned char *)malloc(UnknownData.m_nBytes);

	memcpy(&UnknownData.data[0], &pCamData[SelectedCam].floatData[0], UnknownData.m_nBytes);

	if (UnknownData.DoModal()==IDOK)
		memcpy(&pCamData[SelectedCam].floatData[0], &UnknownData.data[0], UnknownData.m_nBytes);

	UpdateView();
}
