// BlockProp.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "T3ED.h"
#include "T3EDDoc.h"
#include "BlockProp.h"
#include "VirtualRoadAdjust.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CBlockProp 


CBlockProp::CBlockProp(CWnd* pParent /*=NULL*/)
	: CDialog(CBlockProp::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBlockProp)
	m_float_ptCentreX = 0.0f;
	m_float_ptCentreY = 0.0f;
	m_float_ptCentreZ = 0.0f;
	m_nVertices = 0;
	m_nHiResVert = 0;
	m_nLoResVert = 0;
	m_nMedResVert = 0;
	m_nLightsrc = 0;
	m_nSoundsrc = 0;
	m_AdjustRoad_AdjustType = 0;
	m_AdjustRoad_Selected = false;
	m_RefBlock = 0;
	m_bool_c_shading = FALSE;
	m_bHSMode = FALSE;
	//}}AFX_DATA_INIT
}


void CBlockProp::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBlockProp)
	DDX_Text(pDX, IDC_EDIT_X, m_float_ptCentreX);
	DDX_Text(pDX, IDC_EDIT_Y, m_float_ptCentreY);
	DDX_Text(pDX, IDC_EDIT_Z, m_float_ptCentreZ);
	DDX_Text(pDX, IDC_EDIT_NVERTICES, m_nVertices);
	DDX_Text(pDX, IDC_EDIT_NHIGHVERT, m_nHiResVert);
	DDX_Text(pDX, IDC_EDIT_NLOWVERT, m_nLoResVert);
	DDX_Text(pDX, IDC_EDIT_NMEDVERT, m_nMedResVert);
	DDX_Text(pDX, IDC_EDIT_NLIGHTSRC, m_nLightsrc);
	DDX_Text(pDX, IDC_EDIT_NSOUNDSRC, m_nSoundsrc);
	DDX_Check(pDX, IDC_CHECK_C_SHADING, m_bool_c_shading);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBlockProp, CDialog)
	//{{AFX_MSG_MAP(CBlockProp)
	ON_BN_CLICKED(ID_ADJUSTRW, OnAdjustRW)
	ON_BN_CLICKED(IDC_BUTTON_DEL_LIGHT, OnButtonDelLight)
	ON_BN_CLICKED(IDC_BUTTON_DEL_SOUNDS, OnButtonDelSounds)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CBlockProp 

void CBlockProp::OnAdjustRW() 
{
	CVirtualRoadAdjust VRADlg;
	//Get settings
	VRADlg.m_AdjustType = m_AdjustRoad_AdjustType;
	VRADlg.m_StartBlock = m_RefBlock;
	VRADlg.m_EndBlock = m_RefBlock;
	//VRADlg.m_int_Size = m_AdjustRoad_Size;
	//VRADlg.m_Check_VR  = m_AdjustRoad_Check_VR;
	VRADlg.m_Check_Man_Set_Num_Lanes = m_AdjustRoad_Check_Man_Set_Num_Lanes;
	
	VRADlg.m_Check_Change_VR_Width = m_AdjustRoad_Check_Change_VR_Width;
	VRADlg.m_Check_Detect_lanes = m_AdjustRoad_Check_Detect_lanes;
	VRADlg.m_Check_Auto_Set_Lane_Bitcoded = m_AdjustRoad_Check_Auto_Set_Lane_Bitcoded;
	VRADlg.m_Check_Auto_Set_Lane_Polys = m_AdjustRoad_Check_Auto_Set_Lane_Polys;
	VRADlg.m_Check_Auto_Set_Lane_Width = m_AdjustRoad_Check_Auto_Set_Lane_Width;

	VRADlg.m_int_Size_VR_L       = m_AdjustRoad_Size[0];
	VRADlg.m_int_Size_VR_R       = m_AdjustRoad_Size[1];	
	VRADlg.m_nlanes_left     = m_AdjustRoad_Size[2];
	VRADlg.m_nlanes_right     = m_AdjustRoad_Size[3];
	VRADlg.m_bHSMode = m_bHSMode;
	VRADlg.m_DisableStartEnd = true;


	if (VRADlg.DoModal()!=IDOK) return;
	
	m_AdjustRoad_Selected=true;
	m_AdjustRoad_AdjustType=VRADlg.m_AdjustType;
	//m_AdjustRoad_Check_VR   = VRADlg.m_Check_VR  ;
	m_AdjustRoad_Check_Man_Set_Num_Lanes = VRADlg.m_Check_Man_Set_Num_Lanes;

	m_AdjustRoad_Check_Change_VR_Width = VRADlg.m_Check_Change_VR_Width;
	m_AdjustRoad_Check_Detect_lanes = VRADlg.m_Check_Detect_lanes;
	m_AdjustRoad_Check_Auto_Set_Lane_Bitcoded = VRADlg.m_Check_Auto_Set_Lane_Bitcoded;
	m_AdjustRoad_Check_Auto_Set_Lane_Polys = VRADlg.m_Check_Auto_Set_Lane_Polys;
	m_AdjustRoad_Check_Auto_Set_Lane_Width = VRADlg.m_Check_Auto_Set_Lane_Width;

	if (VRADlg.m_Check_Change_VR_Width && (VRADlg.m_AdjustType==3)) //Manual VRoad Size choosen
	{
		m_AdjustRoad_Size[0]=VRADlg.m_int_Size_VR_L  ;
		m_AdjustRoad_Size[1]=VRADlg.m_int_Size_VR_R  ;
	}
	if (VRADlg.m_Check_Man_Set_Num_Lanes) //Manual setting of nLanes choosen
	{
		m_AdjustRoad_Size[2]=VRADlg.m_nlanes_left;
		m_AdjustRoad_Size[3]=VRADlg.m_nlanes_right;
	}

}

void CBlockProp::UpdateView()
{
	m_nLightsrc=t->nLightsrc;
	m_nSoundsrc=t->nSoundsrc;

	if (m_nLightsrc==0) GetDlgItem(IDC_BUTTON_DEL_LIGHT)->ShowWindow(FALSE);
	else GetDlgItem(IDC_BUTTON_DEL_LIGHT)->ShowWindow(TRUE);

	if (m_nSoundsrc==0) GetDlgItem(IDC_BUTTON_DEL_SOUNDS)->ShowWindow(FALSE);
	else GetDlgItem(IDC_BUTTON_DEL_SOUNDS)->ShowWindow(TRUE);
	
	UpdateData(FALSE);

}

void CBlockProp::OnButtonDelLight() 
{
	dofree(t->lightsrc);
	t->lightsrc=NULL;
	t->nLightsrc=0;
	UpdateView();
}

void CBlockProp::OnButtonDelSounds() 
{
	dofree(t->soundsrc);
	t->nSoundsrc=NULL;
	t->nSoundsrc=0;
	UpdateView();
}

BOOL CBlockProp::OnInitDialog() 
{
	CDialog::OnInitDialog();

	UpdateView();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}
